/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.ViewActionBars;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.util.Util;

class ViewFactory {
    private ReferenceCounter counter;
    private HashMap mementoTable = new HashMap();
    private WorkbenchPage page;
    private IViewRegistry viewReg;
    static final String ID_SEP = ":";

    static String getKey(String id, String secondaryId) {
        return secondaryId == null ? id : id + ID_SEP + secondaryId;
    }

    static String getKey(IViewReference viewRef) {
        return ViewFactory.getKey(viewRef.getId(), viewRef.getSecondaryId());
    }

    static String extractPrimaryId(String compoundId) {
        int i = compoundId.lastIndexOf(ID_SEP);
        if (i == -1) {
            return compoundId;
        }
        return compoundId.substring(0, i);
    }

    static String extractSecondaryId(String compoundId) {
        int i = compoundId.lastIndexOf(ID_SEP);
        if (i == -1) {
            return null;
        }
        return compoundId.substring(i + 1);
    }

    static boolean hasWildcard(String viewId) {
        return viewId.indexOf(PartPlaceholder.WILD_CARD) >= 0;
    }

    public ViewFactory(WorkbenchPage page, IViewRegistry reg) {
        this.page = page;
        this.viewReg = reg;
        this.counter = new ReferenceCounter();
    }

    public IStatus busyRestoreView(final IViewReference ref) {
        if (ref.getPart(false) != null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        final String key = ViewFactory.getKey(ref);
        final IMemento stateMem = this.getViewState(key);
        this.mementoTable.remove(key);
        final boolean[] resetPart = new boolean[]{true};
        final IStatus[] result = new IStatus[]{new Status(0, "org.eclipse.ui", 0, "", null)};
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
                if (resetPart[0]) {
                    ViewReference viewRef = (ViewReference)ref;
                    viewRef.setPart(null);
                    if (viewRef.getPane() != null) {
                        ViewFactory.this.page.hideView(ref);
                    }
                }
                result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.exceptionRestoringView", new String[]{key}), e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IViewDescriptor desc = ViewFactory.this.viewReg.find(ref.getId());
                if (desc == null) {
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.couldNotCreate", new Object[]{key}), null);
                    return;
                }
                IViewPart view = null;
                String label = desc.getLabel();
                try {
                    try {
                        UIStats.start(UIStats.CREATE_PART, label);
                        view = desc.createView();
                    }
                    finally {
                        UIStats.end(UIStats.CREATE_PART, label);
                    }
                    ((ViewReference)ref).setPart(view);
                }
                catch (CoreException e) {
                    PartPane pane = ((ViewReference)ref).getPane();
                    if (pane != null) {
                        ViewFactory.this.page.getPerspectivePresentation().removePart(pane);
                        pane.dispose();
                    }
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.initException", new Object[]{desc.getID()}), (Throwable)e);
                    return;
                }
                ViewSite site = new ViewSite(ref, view, ViewFactory.this.page, desc);
                PartPane pane = ((ViewReference)ref).getPane();
                if (pane == null) {
                    pane = new ViewPane(ref, ViewFactory.this.page);
                    ((ViewReference)ref).setPane(pane);
                }
                site.setPane(pane);
                site.setActionBars(new ViewActionBars(ViewFactory.this.page.getActionBars(), (ViewPane)pane));
                try {
                    try {
                        UIStats.start(UIStats.INIT_PART, label);
                        view.init(site, stateMem);
                    }
                    finally {
                        UIStats.end(UIStats.INIT_PART, label);
                    }
                }
                catch (PartInitException e) {
                    ViewFactory.this.releaseView(ref);
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.exceptionRestoringView", new String[]{key}), (Throwable)((Object)e));
                    return;
                }
                if (view.getSite() != site) {
                    ViewFactory.this.releaseView(ref);
                    result[0] = new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.siteException", new Object[]{desc.getID()}), null);
                    return;
                }
                resetPart[0] = false;
                Control ctrl = pane.getControl();
                if (ctrl == null) {
                    pane.createControl(ViewFactory.this.page.getClientComposite());
                } else {
                    pane.createChildControl();
                }
                result[0] = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        });
        return result[0];
    }

    public IViewReference createView(String id) throws PartInitException {
        return this.createView(id, null);
    }

    public IViewReference createView(String id, String secondaryId) throws PartInitException {
        IViewDescriptor desc = this.viewReg.find(id);
        if (desc == null) {
            throw new PartInitException(WorkbenchMessages.format("ViewFactory.couldNotCreate", new Object[]{id}));
        }
        if (secondaryId != null && !desc.getAllowMultiple()) {
            throw new PartInitException(WorkbenchMessages.format("ViewFactory.noMultiple", new Object[]{id}));
        }
        String key = ViewFactory.getKey(id, secondaryId);
        IViewReference ref = (IViewReference)this.counter.get(key);
        if (ref == null) {
            IMemento memento = (IMemento)this.mementoTable.get(key);
            ref = new ViewReference(id, secondaryId, memento);
            this.counter.put(key, ref);
        } else {
            this.counter.addRef(key);
        }
        return ref;
    }

    private void destroyView(IViewPart view) {
        PartSite site = (PartSite)view.getSite();
        ViewActionBars actionBars = (ViewActionBars)site.getActionBars();
        actionBars.dispose();
        PartPane pane = site.getPane();
        pane.dispose();
        site.dispose();
    }

    public IViewReference getView(String id) {
        return this.getView(id, null);
    }

    public IViewReference getView(String id, String secondaryId) {
        String key = ViewFactory.getKey(id, secondaryId);
        return (IViewReference)this.counter.get(key);
    }

    public IViewRegistry getViewRegistry() {
        return this.viewReg;
    }

    public IViewReference[] getViews() {
        List list = this.counter.values();
        IViewReference[] array = new IViewReference[list.size()];
        list.toArray(array);
        return array;
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public boolean hasView(IViewReference viewRef) {
        return this.hasView(viewRef.getId(), viewRef.getSecondaryId());
    }

    public boolean hasView(String id) {
        return this.hasView(id, null);
    }

    public boolean hasView(String id, String secondaryId) {
        return this.getView(id, secondaryId) != null;
    }

    public void releaseView(IViewReference viewRef) {
        IViewPart view;
        String key = ViewFactory.getKey(viewRef);
        IViewReference ref = (IViewReference)this.counter.get(key);
        if (ref == null) {
            return;
        }
        int count = this.counter.removeRef(key);
        if (count <= 0 && (view = (IViewPart)ref.getPart(false)) != null) {
            this.destroyView(view);
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento[] mem = memento.getChildren("view");
        for (int i = 0; i < mem.length; ++i) {
            this.restoreViewState(mem[i]);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus restoreView(final IViewReference ref) {
        final IStatus[] result = new IStatus[1];
        BusyIndicator.showWhile((Display)this.page.getWorkbenchWindow().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                result[0] = ViewFactory.this.busyRestoreView(ref);
            }
        });
        return result[0];
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("ViewFactory.problemsSavingViews"), null);
        IViewReference[] refs = this.getViews();
        for (int i = 0; i < refs.length; ++i) {
            this.saveViewState(memento, refs[i], result);
        }
        return result;
    }

    public IMemento saveViewState(IMemento memento, IViewReference ref, MultiStatus res) {
        final MultiStatus result = res;
        final IMemento viewMemento = memento.createChild("view");
        viewMemento.putString("id", ViewFactory.getKey(ref));
        if (ref instanceof ViewReference) {
            viewMemento.putString("partName", ((ViewReference)ref).getPartName());
        }
        final IViewReference viewRef = ref;
        final IViewPart view = (IViewPart)ref.getPart(false);
        if (view != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    view.saveState(viewMemento.createChild("viewState"));
                }

                public void handleException(Throwable e) {
                    result.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("ViewFactory.couldNotSave", new String[]{viewRef.getTitle()}), e));
                }
            });
        } else {
            IMemento mem = this.getViewState(ViewFactory.getKey(ref));
            if (mem != null) {
                IMemento child = viewMemento.createChild("viewState");
                child.putMemento(mem);
            }
        }
        return viewMemento;
    }

    public void restoreViewState(IMemento memento) {
        String compoundId = memento.getString("id");
        this.mementoTable.put(compoundId, memento);
    }

    private IMemento getViewState(String key) {
        IMemento memento = (IMemento)this.mementoTable.get(key);
        if (memento == null) {
            return null;
        }
        return memento.getChild("viewState");
    }

    private class ViewReference
    extends WorkbenchPartReference
    implements IViewReference {
        private String secondaryId;
        private boolean create = true;

        public ViewReference(String id, IMemento memento) {
            this(id, null, memento);
        }

        public ViewReference(String id, String secondaryId, IMemento memento) {
            ViewDescriptor desc = (ViewDescriptor)ViewFactory.this.viewReg.find(id);
            ImageDescriptor iDesc = null;
            String title = null;
            if (desc != null) {
                iDesc = desc.getImageDescriptor();
                title = desc.getLabel();
            }
            String name = null;
            if (memento != null) {
                name = memento.getString("partName");
            }
            if (name == null) {
                name = title;
            }
            this.init(id, title, null, iDesc, name, null);
            this.secondaryId = secondaryId;
        }

        public void dispose() {
            super.dispose();
            this.create = false;
        }

        public IWorkbenchPage getPage() {
            return ViewFactory.this.page;
        }

        public IWorkbenchPart getPart(boolean restore) {
            if (this.part != null) {
                return this.part;
            }
            if (!this.create) {
                return null;
            }
            if (restore) {
                IStatus status = ViewFactory.this.restoreView(this);
                if (status.getSeverity() == 4) {
                    this.create = false;
                    Workbench workbench = (Workbench)PlatformUI.getWorkbench();
                    if (!workbench.isStarting()) {
                        ErrorDialog.openError((Shell)ViewFactory.this.page.getWorkbenchWindow().getShell(), (String)WorkbenchMessages.getString("ViewFactory.unableToRestoreViewTitle"), (String)WorkbenchMessages.format("ViewFactory.unableToRestoreViewMessage", new String[]{this.getTitle()}), (IStatus)status, (int)6);
                    }
                } else {
                    this.releaseReferences();
                }
            }
            return this.part;
        }

        public String getRegisteredName() {
            if (this.part != null && this.part.getSite() != null) {
                return this.part.getSite().getRegisteredName();
            }
            IViewRegistry reg = ViewFactory.this.viewReg;
            IViewDescriptor desc = reg.find(this.getId());
            if (desc != null) {
                return desc.getLabel();
            }
            return this.getTitle();
        }

        protected String computePartName() {
            if (this.part instanceof IWorkbenchPart2) {
                return super.computePartName();
            }
            return this.getRegisteredName();
        }

        protected String computeContentDescription() {
            if (this.part instanceof IWorkbenchPart2) {
                return super.computeContentDescription();
            }
            String rawTitle = this.getRawTitle();
            if (!Util.equals(rawTitle, this.getRegisteredName())) {
                return rawTitle;
            }
            return "";
        }

        public String getSecondaryId() {
            return this.secondaryId;
        }

        public IViewPart getView(boolean restore) {
            return (IViewPart)this.getPart(restore);
        }

        public boolean isFastView() {
            return ViewFactory.this.page.isFastView(this);
        }
    }
}

