/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class StringLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(class$org$eclipse$jdt$core$dom$StringLiteral == null ? (class$org$eclipse$jdt$core$dom$StringLiteral = StringLiteral.class$("org.eclipse.jdt.core.dom.StringLiteral")) : class$org$eclipse$jdt$core$dom$StringLiteral, "escapedValue", class$java$lang$String == null ? (class$java$lang$String = StringLiteral.class$("java.lang.String")) : class$java$lang$String, MANDATORY);
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "\"\"";
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$StringLiteral;
    static /* synthetic */ Class class$java$lang$String;

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    StringLiteral(AST ast) {
        super(ast);
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return StringLiteral.propertyDescriptors(apiLevel);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    final int getNodeType0() {
        return 45;
    }

    ASTNode clone0(AST target) {
        StringLiteral result = new StringLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.ast.scanner;
        char[] source = token.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 52: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
                }
            }
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public String getLiteralValue() {
        String s = this.getEscapedValue();
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] source = s.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 52: {
                    return new String(scanner.getCurrentTokenSourceString());
                }
            }
            throw new IllegalArgumentException();
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException();
        }
    }

    public void setLiteralValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        int len = value.length();
        StringBuffer b = new StringBuffer(len + 2);
        b.append("\"");
        block18: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    continue block18;
                }
                case '\t': {
                    b.append("\\t");
                    continue block18;
                }
                case '\n': {
                    b.append("\\n");
                    continue block18;
                }
                case '\f': {
                    b.append("\\f");
                    continue block18;
                }
                case '\r': {
                    b.append("\\r");
                    continue block18;
                }
                case '\"': {
                    b.append("\\\"");
                    continue block18;
                }
                case '\'': {
                    b.append("\\'");
                    continue block18;
                }
                case '\\': {
                    b.append("\\\\");
                    continue block18;
                }
                case '\u0000': {
                    b.append("\\0");
                    continue block18;
                }
                case '\u0001': {
                    b.append("\\1");
                    continue block18;
                }
                case '\u0002': {
                    b.append("\\2");
                    continue block18;
                }
                case '\u0003': {
                    b.append("\\3");
                    continue block18;
                }
                case '\u0004': {
                    b.append("\\4");
                    continue block18;
                }
                case '\u0005': {
                    b.append("\\5");
                    continue block18;
                }
                case '\u0006': {
                    b.append("\\6");
                    continue block18;
                }
                case '\u0007': {
                    b.append("\\7");
                    continue block18;
                }
                default: {
                    b.append(c);
                }
            }
        }
        b.append("\"");
        this.setEscapedValue(b.toString());
    }

    int memSize() {
        int size = 44 + StringLiteral.stringSize(this.escapedValue);
        return size;
    }

    int treeSize() {
        return this.memSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList propertyList = new ArrayList(2);
        StringLiteral.createPropertyList(class$org$eclipse$jdt$core$dom$StringLiteral == null ? (class$org$eclipse$jdt$core$dom$StringLiteral = StringLiteral.class$("org.eclipse.jdt.core.dom.StringLiteral")) : class$org$eclipse$jdt$core$dom$StringLiteral, propertyList);
        StringLiteral.addProperty(ESCAPED_VALUE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = StringLiteral.reapPropertyList(propertyList);
    }
}

