/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceContentProvider;
import org.eclipse.jface.preference.PreferenceLabelProvider;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class PreferenceDialog
extends Dialog
implements IPreferencePageContainer {
    private static String lastPreferenceId = null;
    private static int lastTreeWidth = 150;
    public static final String PREF_DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    public static final String PREF_DLG_TITLE_IMG = "preference_dialog_title_image";
    private IPreferencePage currentPage;
    private DialogMessageArea messageArea;
    private boolean isHelpAvailable = false;
    private Point lastShellSize;
    private IPreferenceNode lastSuccessfulNode;
    private Point minimumPageSize = new Point(400, 400);
    private Button okButton;
    private Composite pageContainer;
    private PreferenceManager preferenceManager;
    private boolean showingError = false;
    private IPreferenceStore preferenceStore;
    private Composite titleArea;
    private Label titleImage;
    private TreeViewer treeViewer;
    private final String ellipsis = "...";
    static /* synthetic */ Class class$org$eclipse$jface$preference$PreferenceDialog;

    public PreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.preferenceManager = manager;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                return;
            }
            case 1: {
                this.cancelPressed();
                return;
            }
            case 17: {
                this.helpPressed();
                return;
            }
        }
    }

    protected void cancelPressed() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            final IPreferenceNode node = (IPreferenceNode)nodes.next();
            if (node.getPage() == null) continue;
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    if (!node.getPage().performCancel()) {
                        return;
                    }
                }
            });
        }
        this.setReturnCode(1);
        this.close();
    }

    void clearSelectedNode() {
        this.setSelectedNodePreference(null);
    }

    public boolean close() {
        List nodes = this.preferenceManager.getElements(0);
        for (int i = 0; i < nodes.size(); ++i) {
            IPreferenceNode node = (IPreferenceNode)nodes.get(i);
            node.disposeResources();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JFaceResources.getString("PreferenceDialog.title"));
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (PreferenceDialog.this.lastShellSize == null) {
                    PreferenceDialog.this.lastShellSize = PreferenceDialog.this.getShell().getSize();
                }
            }
        });
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        if (this.lastShellSize == null) {
            this.lastShellSize = this.getShell().getSize();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getShell().setDefaultButton(this.okButton);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.isHelpAvailable) {
            this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
    }

    protected Control createContents(final Composite parent) {
        final Control[] control = new Control[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                control[0] = PreferenceDialog.super.createContents(parent);
                PreferenceDialog.this.selectSavedItem();
            }
        });
        return control[0];
    }

    protected Control createDialogArea(Composite parent) {
        final Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        final Control treeControl = this.createTreeAreaContents(composite);
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point currentSize;
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - sash.getBounds().x;
                GridData data = (GridData)treeControl.getLayoutData();
                int newWidthHint = data.widthHint + shift;
                if (newWidthHint < 20) {
                    return;
                }
                Point computedSize = PreferenceDialog.this.getShell().computeSize(-1, -1);
                boolean customSize = !computedSize.equals((Object)(currentSize = PreferenceDialog.this.getShell().getSize()));
                data.widthHint = newWidthHint;
                PreferenceDialog.this.setLastTreeWidth(newWidthHint);
                composite.layout(true);
                computedSize = PreferenceDialog.this.getShell().computeSize(-1, -1);
                if (customSize) {
                    computedSize.x = Math.max(computedSize.x, currentSize.x);
                }
                computedSize.y = Math.max(computedSize.y, currentSize.y);
                if (computedSize.equals((Object)currentSize)) {
                    return;
                }
                PreferenceDialog.this.setShellSize(computedSize.x, computedSize.y);
                PreferenceDialog.this.lastShellSize = PreferenceDialog.this.getShell().getSize();
            }
        });
        Composite pageAreaComposite = new Composite(composite, 0);
        pageAreaComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        pageAreaComposite.setLayout((Layout)layout);
        Composite titleComposite = new Composite(pageAreaComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        this.createTitleArea(titleComposite);
        this.pageContainer = this.createPageContainer(pageAreaComposite);
        this.pageContainer.setLayoutData((Object)new GridData(1808));
        Label separator = new Label(pageAreaComposite, 258);
        GridData gd = new GridData(768);
        separator.setLayoutData((Object)gd);
        return composite;
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new PageLayout());
        return result;
    }

    private Composite createTitleArea(Composite parent) {
        int margins = 2;
        this.titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = margins;
        layout.marginWidth = margins;
        this.titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground(display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = JFaceResources.getImage((String)PREF_DLG_TITLE_IMG).getBounds().height + margins * 3;
        this.titleArea.setLayoutData((Object)layoutData);
        this.titleArea.setBackground(background);
        this.titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(PreferenceDialog.this.titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = PreferenceDialog.this.titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        this.messageArea = new DialogMessageArea();
        this.messageArea.createContents(this.titleArea);
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    PreferenceDialog.this.updateMessage();
                }
                if ("org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                    PreferenceDialog.this.updateMessage();
                    Font dialogFont = JFaceResources.getDialogFont();
                    PreferenceDialog.this.updateTreeFont(dialogFont);
                    Control[] children = ((Composite)PreferenceDialog.this.buttonBar).getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        children[i].setFont(dialogFont);
                    }
                }
            }
        };
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        this.titleImage = new Label(this.titleArea, 16384);
        this.titleImage.setBackground(background);
        this.titleImage.setImage(JFaceResources.getImage(PREF_DLG_TITLE_IMG));
        FormData imageData = new FormData();
        imageData.right = new FormAttachment(100);
        imageData.top = new FormAttachment(0);
        imageData.bottom = new FormAttachment(100);
        this.titleImage.setLayoutData((Object)imageData);
        this.messageArea.setTitleLayoutData(this.createMessageAreaData());
        this.messageArea.setMessageLayoutData(this.createMessageAreaData());
        return this.titleArea;
    }

    private FormData createMessageAreaData() {
        FormData messageData = new FormData();
        messageData.top = new FormAttachment(0);
        messageData.bottom = new FormAttachment((Control)this.titleImage, 0, 1024);
        messageData.right = new FormAttachment((Control)this.titleImage, 0);
        messageData.left = new FormAttachment(0);
        return messageData;
    }

    protected Control createTreeAreaContents(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.treeViewer.setInput(this.getPreferenceManager());
        this.updateTreeFont(JFaceResources.getDialogFont());
        this.layoutTreeAreaControl(this.treeViewer.getControl());
        return this.treeViewer.getControl();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        final TreeViewer viewer = new TreeViewer(parent, 2048);
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleError() {
                try {
                    viewer.removePostSelectionChangedListener(this);
                    PreferenceDialog.this.showPageFlippingAbortDialog();
                    PreferenceDialog.this.selectCurrentPageAgain();
                    PreferenceDialog.this.clearSelectedNode();
                }
                finally {
                    viewer.addPostSelectionChangedListener(this);
                }
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IPreferenceNode selection = PreferenceDialog.this.getSingleSelection(event.getSelection());
                if (selection instanceof IPreferenceNode) {
                    if (!PreferenceDialog.this.isCurrentPageValid()) {
                        this.handleError();
                    } else if (!PreferenceDialog.this.showPage(selection)) {
                        this.handleError();
                    } else {
                        PreferenceDialog.this.lastSuccessfulNode = selection;
                    }
                    viewer.getControl().setFocus();
                }
            }
        });
        ((Tree)viewer.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                IPreferenceNode singleSelection;
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                boolean expanded = viewer.getExpandedState(singleSelection = PreferenceDialog.this.getSingleSelection(selection));
                viewer.setExpandedState(singleSelection, !expanded);
            }
        });
        viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (PreferenceDialog.this.currentPage != null) {
                    PreferenceDialog.this.currentPage.performHelp();
                }
            }
        });
        viewer.setLabelProvider(new PreferenceLabelProvider());
        viewer.setContentProvider(new PreferenceContentProvider());
        return viewer;
    }

    protected IPreferenceNode findNodeMatching(String nodeId) {
        List nodes = this.preferenceManager.getElements(1);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            IPreferenceNode node = (IPreferenceNode)i.next();
            if (!node.getId().equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    private int getLastTreeWidth() {
        return lastTreeWidth;
    }

    public PreferenceManager getPreferenceManager() {
        return this.preferenceManager;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    protected String getSelectedNodePreference() {
        return lastPreferenceId;
    }

    protected IPreferenceNode getSingleSelection(ISelection selection) {
        if (!selection.isEmpty()) {
            return (IPreferenceNode)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void handleSave() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceStore store;
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (!(page instanceof PreferencePage) || (store = ((PreferencePage)page).getPreferenceStore()) == null || !store.needsSaving() || !(store instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                MessageDialog.openError(this.getShell(), JFaceResources.getString("PreferenceDialog.saveErrorTitle"), JFaceResources.format("PreferenceDialog.saveErrorMessage", new Object[]{page.getTitle(), e.getMessage()}));
            }
        }
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected boolean isCurrentPageValid() {
        if (this.currentPage == null) {
            return true;
        }
        return this.currentPage.isValid();
    }

    protected void layoutTreeAreaControl(Control control) {
        GridData gd = new GridData(1040);
        gd.widthHint = this.getLastTreeWidth();
        gd.verticalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        Platform.run((ISafeRunnable)new SafeRunnable(){
            private boolean errorOccurred;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                PreferenceDialog.this.getButton(0).setEnabled(false);
                this.errorOccurred = false;
                try {
                    try {
                        Iterator nodes = PreferenceDialog.this.preferenceManager.getElements(0).iterator();
                        while (nodes.hasNext()) {
                            IPreferenceNode node = (IPreferenceNode)nodes.next();
                            IPreferencePage page = node.getPage();
                            if (page == null || page.performOk()) continue;
                            Object var5_5 = null;
                            if (!this.errorOccurred) {
                                PreferenceDialog.this.handleSave();
                            }
                            PreferenceDialog.this.close();
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.handleException(e);
                        Object var5_7 = null;
                        if (!this.errorOccurred) {
                            PreferenceDialog.this.handleSave();
                        }
                        PreferenceDialog.this.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (!this.errorOccurred) {
                        PreferenceDialog.this.handleSave();
                    }
                    PreferenceDialog.this.close();
                    throw throwable;
                }
                Object var5_6 = null;
                if (!this.errorOccurred) {
                    PreferenceDialog.this.handleSave();
                }
                PreferenceDialog.this.close();
            }

            public void handleException(Throwable e) {
                this.errorOccurred = true;
                if (Platform.isRunning()) {
                    String bundle = "org.eclipse.core.runtime";
                    Platform.getLog((Bundle)Platform.getBundle((String)bundle)).log((IStatus)new Status(4, bundle, 0, e.toString(), e));
                } else {
                    e.printStackTrace();
                }
                PreferenceDialog.this.clearSelectedNode();
                String message = JFaceResources.getString("SafeRunnable.errorMessage");
                MessageDialog.openError(PreferenceDialog.this.getShell(), JFaceResources.getString("Error"), message);
            }
        });
    }

    void selectCurrentPageAgain() {
        if (this.lastSuccessfulNode == null) {
            return;
        }
        this.getTreeViewer().setSelection(new StructuredSelection(this.lastSuccessfulNode));
        this.currentPage.setVisible(true);
    }

    protected void selectSavedItem() {
        IPreferenceNode[] nodes;
        IPreferenceNode node = this.findNodeMatching(this.getSelectedNodePreference());
        if (node == null && (nodes = this.preferenceManager.getRoot().getSubNodes()).length > 0) {
            node = nodes[0];
        }
        if (node != null) {
            this.getTreeViewer().setSelection(new StructuredSelection(node), true);
            this.getTreeViewer().getControl().setFocus();
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        if (newErrorMessage == null) {
            this.messageArea.clearErrorMessage();
        } else {
            this.messageArea.updateText(newErrorMessage, 3);
        }
    }

    private void setLastTreeWidth(int width) {
        lastTreeWidth = width;
    }

    public void setHelpAvailable(boolean b) {
        this.isHelpAvailable = b;
    }

    public void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    public void setMessage(String newMessage, int newType) {
        this.messageArea.updateText(newMessage, newType);
    }

    public void setMinimumPageSize(int minWidth, int minHeight) {
        this.minimumPageSize.x = minWidth;
        this.minimumPageSize.y = minHeight;
    }

    public void setMinimumPageSize(Point size) {
        this.minimumPageSize.x = size.x;
        this.minimumPageSize.y = size.y;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        Assert.isNotNull(store);
        this.preferenceStore = store;
    }

    private void setSelectedNode() {
        String storeValue = null;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection.size() == 1) {
            IPreferenceNode node = (IPreferenceNode)selection.getFirstElement();
            storeValue = node.getId();
        }
        this.setSelectedNodePreference(storeValue);
    }

    public void setSelectedNode(String pageId) {
        this.setSelectedNodePreference(pageId);
    }

    protected void setSelectedNodePreference(String pageId) {
        lastPreferenceId = pageId;
    }

    private void setShellSize(int width, int height) {
        Rectangle preferred = this.getShell().getBounds();
        preferred.width = width;
        preferred.height = height;
        this.getShell().setBounds(this.getConstrainedShellBounds(preferred));
    }

    protected boolean showPage(IPreferenceNode node) {
        if (node == null) {
            return false;
        }
        if (node.getPage() == null) {
            node.createPage();
        }
        if (node.getPage() == null) {
            return false;
        }
        IPreferencePage newPage = node.getPage();
        if (newPage == this.currentPage) {
            return true;
        }
        if (this.currentPage != null && !this.currentPage.okToLeave()) {
            return false;
        }
        IPreferencePage oldPage = this.currentPage;
        this.currentPage = newPage;
        this.currentPage.setContainer(this);
        if (this.currentPage.getControl() == null) {
            final boolean[] failed = new boolean[]{false};
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    failed[0] = true;
                }

                public void run() {
                    PreferenceDialog.this.currentPage.createControl(PreferenceDialog.this.pageContainer);
                }
            });
            if (failed[0]) {
                return false;
            }
            Assert.isNotNull(this.currentPage.getControl());
        }
        final Point[] size = new Point[1];
        final Point failed = new Point(-1, -1);
        Platform.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                size[0] = failed;
            }

            public void run() {
                size[0] = PreferenceDialog.this.currentPage.computeSize();
            }
        });
        if (size[0].equals((Object)failed)) {
            return false;
        }
        Point contentSize = size[0];
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (oldPage != null) {
            Rectangle rect = this.pageContainer.getClientArea();
            Point containerSize = new Point(rect.width, rect.height);
            int hdiff = contentSize.x - containerSize.x;
            int vdiff = contentSize.y - containerSize.y;
            if (hdiff > 0 || vdiff > 0) {
                if (shellSize.equals((Object)this.lastShellSize)) {
                    hdiff = Math.max(0, hdiff);
                    vdiff = Math.max(0, vdiff);
                    this.setShellSize(shellSize.x + hdiff, shellSize.y + vdiff);
                    this.lastShellSize = shell.getSize();
                } else {
                    this.currentPage.setSize(containerSize);
                }
            } else if (hdiff < 0 || vdiff < 0) {
                this.currentPage.setSize(containerSize);
            }
        }
        Control[] children = this.pageContainer.getChildren();
        Control currentControl = this.currentPage.getControl();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == currentControl) continue;
            children[i].setVisible(false);
        }
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.update();
        return true;
    }

    void showPageFlippingAbortDialog() {
        MessageDialog.openError(this.getShell(), JFaceResources.getString("AbortPageFlippingDialog.title"), JFaceResources.getString("AbortPageFlippingDialog.message"));
    }

    protected void update() {
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
        this.setSelectedNode();
    }

    public void updateButtons() {
        this.okButton.setEnabled(this.isCurrentPageValid());
    }

    public void updateMessage() {
        String errorMessage;
        String message = this.currentPage.getMessage();
        int messageType = 0;
        if (message != null && this.currentPage instanceof IMessageProvider) {
            messageType = ((IMessageProvider)((Object)this.currentPage)).getMessageType();
        }
        if ((errorMessage = this.currentPage.getErrorMessage()) != null) {
            message = errorMessage;
            messageType = 3;
            if (!this.showingError) {
                this.showingError = true;
                this.titleImage.setImage(null);
                this.titleImage.setBackground(JFaceColors.getErrorBackground(this.titleImage.getDisplay()));
                this.titleImage.setSize(0, 0);
                this.titleImage.getParent().layout();
            }
        } else if (this.showingError) {
            this.showingError = false;
            this.titleImage.setImage(JFaceResources.getImage(PREF_DLG_TITLE_IMG));
            this.titleImage.computeSize(0, 0);
            this.titleImage.getParent().layout();
        }
        this.messageArea.updateText(this.getShortenedString(message), messageType);
    }

    private String getShortenedString(String textValue) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        Display display = this.titleArea.getDisplay();
        GC gc = new GC((Drawable)display);
        int maxWidth = this.titleArea.getBounds().width - 28;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int ellipsisWidth = gc.textExtent((String)"...").x;
        int start = pivot = length / 2;
        for (int end = pivot + 1; start >= 0 && end < length; --start, ++end) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + ellipsisWidth + l2 >= maxWidth) continue;
            gc.dispose();
            return s1 + "..." + s2;
        }
        gc.dispose();
        return textValue;
    }

    public void updateTitle() {
        this.messageArea.showTitle(this.currentPage.getTitle(), this.currentPage.getImage());
    }

    protected void updateTreeFont(Font dialogFont) {
        this.getTreeViewer().getControl().setFont(dialogFont);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile(class$org$eclipse$jface$preference$PreferenceDialog == null ? (class$org$eclipse$jface$preference$PreferenceDialog = PreferenceDialog.class$("org.eclipse.jface.preference.PreferenceDialog")) : class$org$eclipse$jface$preference$PreferenceDialog, "images/pref_dialog_title.gif"));
    }

    private class PageLayout
    extends Layout {
        private PageLayout() {
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((PreferenceDialog)PreferenceDialog.this).minimumPageSize.x;
            int y = ((PreferenceDialog)PreferenceDialog.this).minimumPageSize.y;
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].setSize(rect.width, rect.height);
            }
        }
    }
}

