/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdapterFactory;
import org.eclipse.pde.internal.ui.editor.schema.SchemaAdapterFactory;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.launcher.LaunchListener;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.view.PluginsViewAdapterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditorPreferenceConstants;
import org.osgi.framework.BundleContext;

public class PDEPlugin
extends AbstractUIPlugin
implements IPDEUIConstants,
IPreferenceConstants {
    private static PDEPlugin inst;
    private ResourceBundle resourceBundle;
    private LaunchListener launchListener;
    private BundleContext context;
    private Hashtable counters;
    private FormColors formColors;
    private PDELabelProvider labelProvider;
    static /* synthetic */ Class class$org$eclipse$pde$internal$core$ischema$ISchemaObject;
    static /* synthetic */ Class class$org$eclipse$pde$internal$core$ischema$ISchemaObjectReference;
    static /* synthetic */ Class class$org$eclipse$pde$internal$core$ifeature$IFeatureObject;
    static /* synthetic */ Class class$org$eclipse$pde$internal$core$ModelEntry;
    static /* synthetic */ Class class$org$eclipse$pde$internal$core$FileAdapter;

    public PDEPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.pde.internal.ui.pderesources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static IWorkbenchPage getActivePage() {
        return PDEPlugin.getDefault().internalGetActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PDEPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PDEPlugin getDefault() {
        return inst;
    }

    public Hashtable getDefaultNameCounters() {
        if (this.counters == null) {
            this.counters = new Hashtable();
        }
        return this.counters;
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = PDEPlugin.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = PDEPlugin.getResourceString(key);
        return MessageFormat.format(text, arg);
    }

    static IPath getInstallLocation() {
        return new Path(PDEPlugin.getDefault().getDescriptor().getInstallURL().getFile());
    }

    public static String getPluginId() {
        return PDEPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDEPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        PDEPlugin.log((IStatus)new Status(4, PDEPlugin.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDEPlugin.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = SWTUtil.getStandardDisplay();
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        PDEPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), e);
        PDEPlugin.log(status);
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public void startup() throws CoreException {
        super.startup();
        IAdapterManager manager = Platform.getAdapterManager();
        SchemaAdapterFactory schemaFactory = new SchemaAdapterFactory();
        manager.registerAdapters((IAdapterFactory)schemaFactory, class$org$eclipse$pde$internal$core$ischema$ISchemaObject == null ? (class$org$eclipse$pde$internal$core$ischema$ISchemaObject = PDEPlugin.class$("org.eclipse.pde.internal.core.ischema.ISchemaObject")) : class$org$eclipse$pde$internal$core$ischema$ISchemaObject);
        manager.registerAdapters((IAdapterFactory)schemaFactory, class$org$eclipse$pde$internal$core$ischema$ISchemaObjectReference == null ? (class$org$eclipse$pde$internal$core$ischema$ISchemaObjectReference = PDEPlugin.class$("org.eclipse.pde.internal.core.ischema.ISchemaObjectReference")) : class$org$eclipse$pde$internal$core$ischema$ISchemaObjectReference);
        manager.registerAdapters((IAdapterFactory)new FeatureAdapterFactory(), class$org$eclipse$pde$internal$core$ifeature$IFeatureObject == null ? (class$org$eclipse$pde$internal$core$ifeature$IFeatureObject = PDEPlugin.class$("org.eclipse.pde.internal.core.ifeature.IFeatureObject")) : class$org$eclipse$pde$internal$core$ifeature$IFeatureObject);
        PluginsViewAdapterFactory factory = new PluginsViewAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, class$org$eclipse$pde$internal$core$ModelEntry == null ? (class$org$eclipse$pde$internal$core$ModelEntry = PDEPlugin.class$("org.eclipse.pde.internal.core.ModelEntry")) : class$org$eclipse$pde$internal$core$ModelEntry);
        manager.registerAdapters((IAdapterFactory)factory, class$org$eclipse$pde$internal$core$FileAdapter == null ? (class$org$eclipse$pde$internal$core$FileAdapter = PDEPlugin.class$("org.eclipse.pde.internal.core.FileAdapter")) : class$org$eclipse$pde$internal$core$FileAdapter);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void shutdown() throws CoreException {
        if (this.launchListener != null) {
            this.launchListener.shutdown();
        }
        if (this.formColors != null) {
            this.formColors.dispose();
            this.formColors = null;
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        super.shutdown();
    }

    public static File getFileInPlugin(IPath path) {
        try {
            URL installURL = new URL(PDEPlugin.getDefault().getDescriptor().getInstallURL(), path.toString());
            URL localURL = Platform.asLocalURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException e) {
            return null;
        }
    }

    public PDELabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new PDELabelProvider();
        }
        return this.labelProvider;
    }

    public LaunchListener getLaunchesListener() {
        if (this.launchListener == null) {
            this.launchListener = new LaunchListener();
        }
        return this.launchListener;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        ColorManager.initializeDefaults(store);
        store.setDefault("useSourcePage", false);
        store.setDefault("Preferences.MainPage.showObjects", "useIds");
        store.setDefault("javacDebugInfo", true);
        store.setDefault("javacFailOnError", false);
        store.setDefault("javacVerbose", true);
        AbstractDecoratedTextEditorPreferenceConstants.initializeDefaultValues((IPreferenceStore)store);
    }

    public static boolean isFullNameModeEnabled() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString("Preferences.MainPage.showObjects").equals("useNames");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

