/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.Category;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizardDialog;
import org.eclipse.ui.internal.ide.dialogs.NewProjectWizard;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;

public class CreateProjectAction
extends Action {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IWorkbenchWindow window;
    private String initialProjectName;
    private Capability[] initialProjectCapabilities;
    private Category[] initialSelectedCategories;

    public CreateProjectAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.getString("CreateProjectAction.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setToolTipText(IDEWorkbenchMessages.getString("CreateProjectAction.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.new_action_context");
    }

    protected IStructuredSelection getInitialSelection() {
        ISelection selection = this.window.getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        }
        return selectionToPass;
    }

    public void setInitialSelectedCategories(String[] ids) {
        if (ids == null || ids.length == 0) {
            this.initialSelectedCategories = null;
        } else {
            CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
            ArrayList<Category> results = new ArrayList<Category>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                Category cat = reg.findCategory(ids[i]);
                if (cat == null) continue;
                results.add(cat);
            }
            if (results.isEmpty()) {
                this.initialSelectedCategories = null;
            } else {
                this.initialSelectedCategories = new Category[results.size()];
                results.toArray(this.initialSelectedCategories);
            }
        }
    }

    public void setInitialProjectCapabilities(String[] ids) {
        if (ids == null || ids.length == 0) {
            this.initialProjectCapabilities = null;
        } else {
            CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
            ArrayList<Capability> results = new ArrayList<Capability>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                Capability cap = reg.findCapability(ids[i]);
                if (cap == null || !cap.isValid()) continue;
                results.add(cap);
            }
            if (results.isEmpty()) {
                this.initialProjectCapabilities = null;
            } else {
                this.initialProjectCapabilities = new Capability[results.size()];
                results.toArray(this.initialProjectCapabilities);
            }
        }
    }

    public void setInitialProjectName(String name) {
        this.initialProjectName = name == null ? null : name.trim();
    }

    public void run() {
        NewProjectWizard wizard = new NewProjectWizard();
        wizard.init(this.window.getWorkbench(), this.getInitialSelection());
        wizard.setInitialProjectName(this.initialProjectName);
        wizard.setInitialProjectCapabilities(this.initialProjectCapabilities);
        wizard.setInitialSelectedCategories(this.initialSelectedCategories);
        MultiStepWizardDialog dialog = new MultiStepWizardDialog(this.window.getShell(), wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), (String)"org.eclipse.ui.ide.new_project_wizard_context");
        dialog.open();
    }
}

