/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.internal.ui.util.ListContentProvider;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchDialog
extends ExtendedDialogWindow
implements ISearchPageContainer {
    private static final int SEARCH_ID = 1025;
    private static final int REPLACE_ID = 1026;
    private IWorkspace fWorkspace;
    private ISearchPage fCurrentPage;
    private String fInitialPageId;
    private int fCurrentIndex;
    private ISelection fSelection;
    private IEditorPart fEditorPart;
    private List fDescriptors;
    private Point fMinSize;
    private ScopePart[] fScopeParts;
    private boolean fPageStateIgnoringScopePart;
    private Button fCustomizeButton;
    private Button fReplaceButton;
    private Label fStatusLabel;

    public SearchDialog(Shell shell, IWorkspace workspace, ISelection selection, IEditorPart editor, String pageId) {
        super(shell);
        Assert.isNotNull((Object)workspace);
        this.fWorkspace = workspace;
        this.fSelection = selection;
        this.fEditorPart = editor;
        this.fDescriptors = this.filterByActivities(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(pageId));
        this.fInitialPageId = pageId;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SearchMessages.getString("SearchDialog.title"));
        shell.setImage(SearchPluginImages.get("org.eclipse.search.ui.search.gif"));
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.search.search_dialog_context");
    }

    public IWorkspace getWorkspace() {
        return this.fWorkspace;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public IEditorPart getEditorPart() {
        return this.fEditorPart;
    }

    public void create() {
        super.create();
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(true);
        }
    }

    private void handleCustomizePressed() {
        List input = SearchPlugin.getDefault().getSearchPageDescriptors();
        input = this.filterByActivities(input);
        final ArrayList createdImages = new ArrayList(input.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    String label = ((SearchPageDescriptor)element).getLabel();
                    int i = label.indexOf(38);
                    while (i >= 0) {
                        if (i < label.length()) {
                            label = label.substring(0, i) + label.substring(i + 1);
                        } else {
                            label.substring(0, i);
                        }
                        i = label.indexOf(38);
                    }
                    return label;
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    ImageDescriptor imageDesc = ((SearchPageDescriptor)element).getImage();
                    if (imageDesc == null) {
                        return null;
                    }
                    Image image = imageDesc.createImage();
                    if (image != null) {
                        createdImages.add(image);
                    }
                    return image;
                }
                return null;
            }
        };
        String message = SearchMessages.getString("SearchPageSelectionDialog.message");
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), input, new ListContentProvider(), (ILabelProvider)labelProvider, message){

            public void create() {
                super.create();
                CheckboxTableViewer viewer = this.getViewer();
                Button okButton = this.getOkButton();
                viewer.addCheckStateListener(new ICheckStateListener(this, okButton, viewer){
                    private final /* synthetic */ Button val$okButton;
                    private final /* synthetic */ CheckboxTableViewer val$viewer;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$okButton = val$okButton;
                        this.val$viewer = val$viewer;
                    }

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        this.val$okButton.setEnabled(this.val$viewer.getCheckedElements().length > 0);
                    }
                });
                SelectionAdapter listener = new SelectionAdapter(this, okButton, viewer){
                    private final /* synthetic */ Button val$okButton;
                    private final /* synthetic */ CheckboxTableViewer val$viewer;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$okButton = val$okButton;
                        this.val$viewer = val$viewer;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$okButton.setEnabled(this.val$viewer.getCheckedElements().length > 0);
                    }
                };
                this.getButton(18).addSelectionListener((SelectionListener)listener);
                this.getButton(19).addSelectionListener((SelectionListener)listener);
            }
        };
        dialog.setTitle(SearchMessages.getString("SearchPageSelectionDialog.title"));
        dialog.setInitialSelections(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(this.fInitialPageId).toArray());
        if (dialog.open() == 0) {
            SearchPageDescriptor.setEnabled(dialog.getResult());
            Display display = this.getShell().getDisplay();
            this.close();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        new OpenSearchDialogAction().run();
                    }
                });
            }
        }
        this.destroyImages(createdImages);
    }

    private List filterByActivities(List input) {
        ArrayList<SearchPageDescriptor> filteredList = new ArrayList<SearchPageDescriptor>(input.size());
        Iterator descriptors = input.iterator();
        while (descriptors.hasNext()) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)descriptors.next();
            if (WorkbenchActivityHelper.filterItem((Object)descriptor)) continue;
            filteredList.add(descriptor);
        }
        return filteredList;
    }

    private void destroyImages(List images) {
        Iterator iter = images.iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
    }

    protected Control createPageArea(Composite parent) {
        int numPages = this.fDescriptors.size();
        this.fScopeParts = new ScopePart[numPages];
        if (numPages == 0) {
            Label label = new Label(parent, 0x1000040);
            label.setText(SearchMessages.getString("SearchDialog.noSearchExtension"));
            return label;
        }
        this.fCurrentIndex = this.getPreferredPageIndex();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SearchDialog.this.fCurrentPage = SearchDialog.this.getDescriptorAt(SearchDialog.this.fCurrentIndex).createObject();
            }
        });
        this.fCurrentPage.setContainer(this);
        if (numPages == 1) {
            return this.getControl(this.fCurrentPage, parent, 0);
        }
        Composite border = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        border.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(border, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        for (int i = 0; i < numPages; ++i) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)this.fDescriptors.get(i);
            if (WorkbenchActivityHelper.filterItem((Object)descriptor)) continue;
            final TabItem item = new TabItem(folder, 0);
            item.setText(descriptor.getLabel());
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    item.setData(null);
                    if (item.getImage() != null) {
                        item.getImage().dispose();
                    }
                }
            });
            ImageDescriptor imageDesc = descriptor.getImage();
            if (imageDesc != null) {
                item.setImage(imageDesc.createImage());
            }
            item.setData((Object)descriptor);
            if (i != this.fCurrentIndex) continue;
            item.setControl(this.getControl(this.fCurrentPage, (Composite)folder, i));
            item.setData((Object)this.fCurrentPage);
        }
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchDialog.this.turnToPage(event);
            }
        });
        folder.setSelection(this.fCurrentIndex);
        return border;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fReplaceButton = this.createActionButton(parent, 1026, SearchMessages.getString("SearchDialog.replaceAction"), true);
        this.fReplaceButton.setVisible(this.fCurrentPage instanceof IReplacePage);
        this.createActionButton(parent, 1025, SearchMessages.getString("SearchDialog.searchAction"), true);
        super.createButtonsForButtonBar(parent);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fCustomizeButton = new Button(composite, 0);
        this.fCustomizeButton.setText(SearchMessages.getString("SearchDialog.customize"));
        GridData gd = new GridData();
        gd.horizontalIndent = 2 * new GridLayout().marginWidth;
        this.fCustomizeButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fCustomizeButton);
        this.fCustomizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.handleCustomizePressed();
            }
        });
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        Control result = super.createButtonBar(composite);
        this.getButton(1025).setEnabled(this.fDescriptors.size() > 0);
        SearchDialog.applyDialogFont((Control)composite);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performAction(int actionID) {
        boolean isAutoBuilding;
        block7: {
            boolean bl;
            if (this.fCurrentPage == null) {
                return true;
            }
            isAutoBuilding = SearchPlugin.getWorkspace().isAutoBuilding();
            if (isAutoBuilding) {
                SearchPlugin.setAutoBuilding(false);
            }
            try {
                this.fCustomizeButton.setEnabled(false);
                if (actionID != 1025) break block7;
                bl = this.fCurrentPage.performAction();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var5_7 = null;
                    this.fCustomizeButton.setEnabled(true);
                    if (!isAutoBuilding) break block8;
                    SearchPlugin.setAutoBuilding(true);
                }
                throw throwable;
            }
            this.fCustomizeButton.setEnabled(true);
            if (isAutoBuilding) {
                SearchPlugin.setAutoBuilding(true);
            }
            return bl;
        }
        boolean bl = ((IReplacePage)((Object)this.fCurrentPage)).performReplace();
        Object var5_6 = null;
        this.fCustomizeButton.setEnabled(true);
        if (isAutoBuilding) {
            SearchPlugin.setAutoBuilding(true);
        }
        return bl;
    }

    private SearchPageDescriptor getDescriptorAt(int index) {
        return (SearchPageDescriptor)this.fDescriptors.get(index);
    }

    private Point getMinSize() {
        if (this.fMinSize != null) {
            return this.fMinSize;
        }
        int x = 0;
        int y = 0;
        int length = this.fDescriptors.size();
        for (int i = 0; i < length; ++i) {
            Point size = this.getDescriptorAt(i).getPreferredSize();
            if (size.x != -1) {
                x = Math.max(x, size.x);
            }
            if (size.y == -1) continue;
            y = Math.max(y, size.y);
        }
        this.fMinSize = new Point(x, y);
        return this.fMinSize;
    }

    private void turnToPage(SelectionEvent event) {
        final TabItem item = (TabItem)event.item;
        TabFolder folder = item.getParent();
        Control oldControl = folder.getItem(this.fCurrentIndex).getControl();
        Point oldSize = oldControl.getSize();
        if (item.getControl() == null) {
            final SearchPageDescriptor descriptor = (SearchPageDescriptor)item.getData();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    item.setData((Object)descriptor.createObject());
                }
            });
            ISearchPage page = (ISearchPage)item.getData();
            page.setContainer(this);
            Control newControl = this.getControl(page, (Composite)event.widget, item.getParent().getSelectionIndex());
            item.setControl(newControl);
        }
        if (item.getData() instanceof ISearchPage) {
            this.fCurrentPage = (ISearchPage)item.getData();
            this.fReplaceButton.setVisible(this.fCurrentPage instanceof IReplacePage);
            this.fCurrentIndex = item.getParent().getSelectionIndex();
            this.fCurrentPage.setVisible(true);
        }
        Control newControl = item.getControl();
        this.resizeDialogIfNeeded(oldSize, newControl.computeSize(-1, -1, true));
    }

    private int getPreferredPageIndex() {
        Object element = null;
        if (this.fSelection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)this.fSelection).getFirstElement();
        }
        if (element == null && this.fEditorPart != null && (element = this.fEditorPart.getEditorInput()) instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        int result = 0;
        int level = 0;
        int size = this.fDescriptors.size();
        for (int i = 0; i < size; ++i) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)this.fDescriptors.get(i);
            if (this.fInitialPageId != null && this.fInitialPageId.equals(descriptor.getId())) {
                return i;
            }
            int newLevel = descriptor.computeScore(element);
            if (newLevel <= level) continue;
            level = newLevel;
            result = i;
        }
        return result;
    }

    public IRunnableContext getRunnableContext() {
        return this;
    }

    public int getSelectedScope() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return 0;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedScope();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return null;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedWorkingSets();
    }

    public void setSelectedScope(int scope) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedScope(scope);
        }
    }

    public boolean hasValidScope() {
        return this.getSelectedScope() != 2 || this.getSelectedWorkingSets() != null;
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedWorkingSets(workingSets);
        }
    }

    public void setPerformActionEnabled(boolean state) {
        super.setPerformActionEnabled(state);
        this.fPageStateIgnoringScopePart = state;
        this.setPerformActionEnabledFromScopePart(this.hasValidScope());
    }

    public void setPerformActionEnabledFromScopePart(boolean state) {
        if (this.fPageStateIgnoringScopePart) {
            super.setPerformActionEnabled(state);
        }
    }

    private Control getControl(ISearchPage page, Composite parent, int index) {
        Control control = page.getControl();
        if (control != null) {
            return control;
        }
        Composite pageWrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageWrapper.setLayout((Layout)layout);
        Dialog.applyDialogFont((Control)pageWrapper);
        page.createControl(pageWrapper);
        SearchPageDescriptor descriptor = this.getDescriptorAt(index);
        boolean showScope = descriptor.showScopeSection();
        if (showScope) {
            Composite c = new Composite(pageWrapper, 0);
            layout = new GridLayout();
            c.setLayoutData((Object)new GridData(768));
            c.setLayout((Layout)layout);
            this.fScopeParts[index] = new ScopePart(this, descriptor.canSearchInProjects());
            Composite part = this.fScopeParts[index].createPart(c);
            SearchDialog.applyDialogFont((Control)part);
            this.fScopeParts[index].setVisible(true);
        }
        return pageWrapper;
    }

    private void resizeDialogIfNeeded(Point oldSize, Point newSize) {
        if (oldSize == null || newSize == null) {
            return;
        }
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (this.mustResize(oldSize, newSize)) {
            if (newSize.x > oldSize.x) {
                shellSize.x += newSize.x - oldSize.x;
            }
            if (newSize.y > oldSize.y) {
                shellSize.y += newSize.y - oldSize.y;
            }
            shell.setSize(shellSize);
            shell.layout(true);
        }
    }

    private boolean mustResize(Point currentSize, Point newSize) {
        return currentSize.x < newSize.x || currentSize.y < newSize.y;
    }

    protected void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    private class TabFolderLayout
    extends Layout {
        private TabFolderLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = 0;
            int y = 0;
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Point size = children[i].computeSize(-1, -1, flushCache);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
            }
            Point minSize = SearchDialog.this.getMinSize();
            x = Math.max(x, minSize.x);
            y = Math.max(y, minSize.y);
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].setBounds(rect);
            }
        }
    }
}

