/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SourceContainerDialog
extends ElementTreeSelectionDialog {
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;

    private SourceContainerDialog(Shell shell) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)new StandardJavaElementContentProvider());
        this.setValidator(new PackageAndProjectSelectionValidator());
        this.setSorter(new JavaElementSorter());
        this.setTitle(NewWizardMessages.getString("NewContainerWizardPage.ChooseSourceContainerDialog.title"));
        this.setMessage(NewWizardMessages.getString("NewContainerWizardPage.ChooseSourceContainerDialog.description"));
        this.addFilter(new JavaTypedViewerFilter());
    }

    public static IPackageFragmentRoot getSourceContainer(Shell shell, IWorkspaceRoot workspaceRoot, IJavaElement initElement) {
        SourceContainerDialog dialog = new SourceContainerDialog(shell);
        dialog.setInput(JavaCore.create((IWorkspaceRoot)workspaceRoot));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JavaTypedViewerFilter
    extends TypedViewerFilter {
        public JavaTypedViewerFilter() {
            super(new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = SourceContainerDialog.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = SourceContainerDialog.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject});
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)element;
                try {
                    return fragmentRoot.getKind() == 1;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            return super.select(viewer, parent, element);
        }
    }

    private class PackageAndProjectSelectionValidator
    extends TypedElementSelectionValidator {
        public PackageAndProjectSelectionValidator() {
            super(new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = SourceContainerDialog.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot}, false);
        }

        public boolean isSelectedValid(Object element) {
            try {
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    IPath path = jproject.getProject().getFullPath();
                    return jproject.findPackageFragmentRoot(path) != null;
                }
                if (element instanceof IPackageFragmentRoot) {
                    return ((IPackageFragmentRoot)element).getKind() == 1;
                }
                return true;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
    }
}

