/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.JPEGVariableSizeSegment;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGHuffmanTable
extends JPEGVariableSizeSegment {
    JPEGHuffmanTable[] allTables;
    int tableClass;
    int tableIdentifier;
    int[] dhCodes;
    int[] dhCodeLengths;
    int[] dhMaxCodes;
    int[] dhMinCodes;
    int[] dhValPtrs;
    int[] dhValues;
    int[] ehCodes;
    byte[] ehCodeLengths;
    static byte[] DCLuminanceTable = new byte[]{-1, -60, 0, 31, 0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static byte[] DCChrominanceTable = new byte[]{-1, -60, 0, 31, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static byte[] ACLuminanceTable = new byte[]{-1, -60, 0, -75, 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    static byte[] ACChrominanceTable = new byte[]{-1, -60, 0, -75, 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};

    public JPEGHuffmanTable(byte[] reference) {
        super(reference);
    }

    public JPEGHuffmanTable(LEDataInputStream byteStream) {
        super(byteStream);
        this.initialize();
    }

    public JPEGHuffmanTable[] getAllTables() {
        return this.allTables;
    }

    public static JPEGHuffmanTable getDefaultACChrominanceTable() {
        JPEGHuffmanTable result = new JPEGHuffmanTable(ACChrominanceTable);
        result.initialize();
        return result;
    }

    public static JPEGHuffmanTable getDefaultACLuminanceTable() {
        JPEGHuffmanTable result = new JPEGHuffmanTable(ACLuminanceTable);
        result.initialize();
        return result;
    }

    public static JPEGHuffmanTable getDefaultDCChrominanceTable() {
        JPEGHuffmanTable result = new JPEGHuffmanTable(DCChrominanceTable);
        result.initialize();
        return result;
    }

    public static JPEGHuffmanTable getDefaultDCLuminanceTable() {
        JPEGHuffmanTable result = new JPEGHuffmanTable(DCLuminanceTable);
        result.initialize();
        return result;
    }

    public int[] getDhMaxCodes() {
        return this.dhMaxCodes;
    }

    public int[] getDhMinCodes() {
        return this.dhMinCodes;
    }

    public int[] getDhValPtrs() {
        return this.dhValPtrs;
    }

    public int[] getDhValues() {
        return this.dhValues;
    }

    public int getTableClass() {
        return this.tableClass;
    }

    public int getTableIdentifier() {
        return this.tableIdentifier;
    }

    void initialize() {
        int totalLength = this.getSegmentLength() - 2;
        int ofs = 4;
        int[] bits = new int[16];
        JPEGHuffmanTable[] huffTables = new JPEGHuffmanTable[8];
        int huffTableCount = 0;
        while (totalLength > 0) {
            int[] newHuffCodes;
            int tc = (this.reference[ofs] & 0xFF) / 16;
            int tid = (this.reference[ofs] & 0xFF) % 16;
            ++ofs;
            int count = 0;
            for (int i = 0; i < bits.length; ++i) {
                int bCount;
                bits[i] = bCount = this.reference[ofs + i] & 0xFF;
                count += bCount;
            }
            ofs += 16;
            totalLength -= 17;
            int[] huffVals = new int[count];
            for (int i = 0; i < count; ++i) {
                huffVals[i] = this.reference[ofs + i] & 0xFF;
            }
            ofs += count;
            totalLength -= count;
            int[] huffCodeLengths = new int[50];
            int huffCodeLengthsIndex = 0;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < bits[i]; ++j) {
                    if (huffCodeLengthsIndex >= huffCodeLengths.length) {
                        int[] newHuffCodeLengths = new int[huffCodeLengths.length + 50];
                        System.arraycopy(huffCodeLengths, 0, newHuffCodeLengths, 0, huffCodeLengths.length);
                        huffCodeLengths = newHuffCodeLengths;
                    }
                    huffCodeLengths[huffCodeLengthsIndex] = i + 1;
                    ++huffCodeLengthsIndex;
                }
            }
            if (huffCodeLengthsIndex < huffCodeLengths.length) {
                int[] newHuffCodeLengths = new int[huffCodeLengthsIndex];
                System.arraycopy(huffCodeLengths, 0, newHuffCodeLengths, 0, huffCodeLengthsIndex);
                huffCodeLengths = newHuffCodeLengths;
            }
            int[] huffCodes = new int[50];
            int huffCodesIndex = 0;
            int k = 1;
            int code = 0;
            int si = huffCodeLengths[0];
            int p = 0;
            while (p < huffCodeLengthsIndex) {
                while (p < huffCodeLengthsIndex && huffCodeLengths[p] == si) {
                    if (huffCodesIndex >= huffCodes.length) {
                        newHuffCodes = new int[huffCodes.length + 50];
                        System.arraycopy(huffCodes, 0, newHuffCodes, 0, huffCodes.length);
                        huffCodes = newHuffCodes;
                    }
                    huffCodes[huffCodesIndex] = code++;
                    ++huffCodesIndex;
                    ++p;
                }
                code *= 2;
                ++si;
            }
            if (huffCodesIndex < huffCodes.length) {
                newHuffCodes = new int[huffCodesIndex];
                System.arraycopy(huffCodes, 0, newHuffCodes, 0, huffCodesIndex);
                huffCodes = newHuffCodes;
            }
            k = 0;
            int[] maxCodes = new int[16];
            int[] minCodes = new int[16];
            int[] valPtrs = new int[16];
            for (int i = 0; i < 16; ++i) {
                int bSize = bits[i];
                if (bSize == 0) {
                    maxCodes[i] = -1;
                    continue;
                }
                valPtrs[i] = k;
                minCodes[i] = huffCodes[k];
                maxCodes[i] = huffCodes[(k += bSize) - 1];
            }
            int[] eHuffCodes = new int[256];
            byte[] eHuffSize = new byte[256];
            for (int i = 0; i < huffCodesIndex; ++i) {
                eHuffCodes[huffVals[i]] = huffCodes[i];
                eHuffSize[huffVals[i]] = (byte)huffCodeLengths[i];
            }
            JPEGHuffmanTable dhtTable = new JPEGHuffmanTable(this.reference);
            dhtTable.tableClass = tc;
            dhtTable.tableIdentifier = tid;
            dhtTable.dhValues = huffVals;
            dhtTable.dhCodes = huffCodes;
            dhtTable.dhCodeLengths = huffCodeLengths;
            dhtTable.dhMinCodes = minCodes;
            dhtTable.dhMaxCodes = maxCodes;
            dhtTable.dhValPtrs = valPtrs;
            dhtTable.ehCodes = eHuffCodes;
            dhtTable.ehCodeLengths = eHuffSize;
            huffTables[huffTableCount] = dhtTable;
            ++huffTableCount;
        }
        this.allTables = new JPEGHuffmanTable[huffTableCount];
        System.arraycopy(huffTables, 0, this.allTables, 0, huffTableCount);
    }

    public int signature() {
        return 65476;
    }
}

