/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardListSelectionPage;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TemplateListSelectionPage
extends WizardListSelectionPage
implements ISelectionChangedListener,
IExecutableExtension {
    private ContentPage fContentPage;
    private Button fUseTemplate;
    private String fInitialTemplateId;

    public TemplateListSelectionPage(ElementList wizardElements, ContentPage page, String message) {
        super(wizardElements, message);
        this.fContentPage = page;
        this.setTitle(PDEPlugin.getResourceString("WizardListSelectionPage.title"));
        this.setDescription(PDEPlugin.getResourceString("WizardListSelectionPage.desc"));
    }

    public void createAbove(Composite container, int span) {
        this.fUseTemplate = new Button(container, 32);
        this.fUseTemplate.setText(PDEPlugin.getResourceString("WizardListSelectionPage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        this.fUseTemplate.setLayoutData((Object)gd);
        this.fUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateListSelectionPage.this.wizardSelectionViewer.getControl().setEnabled(TemplateListSelectionPage.this.fUseTemplate.getSelection());
                if (!TemplateListSelectionPage.this.fUseTemplate.getSelection()) {
                    TemplateListSelectionPage.this.setDescription("");
                }
                TemplateListSelectionPage.this.setDescriptionEnabled(TemplateListSelectionPage.this.fUseTemplate.getSelection());
                TemplateListSelectionPage.this.getContainer().updateButtons();
            }
        });
        if (this.getInitialTemplateId() != null) {
            this.fUseTemplate.setSelection(true);
        }
    }

    protected void initializeViewer() {
        this.wizardSelectionViewer.addFilter((ViewerFilter)new WizardFilter());
        if (this.getInitialTemplateId() == null) {
            this.wizardSelectionViewer.getControl().setEnabled(false);
            this.setDescriptionEnabled(false);
        } else {
            this.selectInitialTemplate();
        }
    }

    private void selectInitialTemplate() {
        Object[] children = this.wizardElements.getChildren();
        for (int i = 0; i < children.length; ++i) {
            WizardElement welement = (WizardElement)children[i];
            if (!welement.getID().equals(this.getInitialTemplateId())) continue;
            this.wizardSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)welement), true);
            this.setSelectedNode(this.createWizardNode(welement));
            this.setDescriptionText(welement.getDescription());
            break;
        }
    }

    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            public IBasePluginWizard createWizard() throws CoreException {
                IPluginContentWizard wizard = (IPluginContentWizard)this.wizardElement.createExecutableExtension();
                wizard.init(TemplateListSelectionPage.this.fContentPage.getData());
                return wizard;
            }
        };
    }

    public IPluginContentWizard getSelectedWizard() {
        if (this.fUseTemplate.getSelection()) {
            return super.getSelectedWizard();
        }
        return null;
    }

    public boolean isPageComplete() {
        return !this.fUseTemplate.getSelection() || this.fUseTemplate.getSelection() && this.getSelectedNode() != null;
    }

    public boolean canFlipToNextPage() {
        IStructuredSelection ssel = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        return this.fUseTemplate.getSelection() && ssel != null && !ssel.isEmpty();
    }

    public String getInitialTemplateId() {
        return this.fInitialTemplateId;
    }

    public void setInitialTemplateId(String initialTemplateId) {
        this.fInitialTemplateId = initialTemplateId;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fContentPage.updateData();
            this.wizardSelectionViewer.refresh();
        }
        super.setVisible(visible);
    }

    class WizardFilter
    extends ViewerFilter {
        WizardFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IFieldData data = TemplateListSelectionPage.this.fContentPage.getData();
            boolean simple = data.isSimple();
            boolean generate = false;
            boolean ui = false;
            if (data instanceof PluginFieldData) {
                ui = ((PluginFieldData)data).isUIPlugin();
                generate = ((PluginFieldData)data).doGenerateClass();
            }
            WizardElement welement = (WizardElement)element;
            IConfigurationElement config = welement.getConfigurationElement();
            boolean uiFlag = this.getFlag(config, "ui-content");
            boolean javaFlag = this.getFlag(config, "java");
            if (simple && javaFlag) {
                return false;
            }
            return !uiFlag || !simple && (!generate || ui);
        }

        private boolean getFlag(IConfigurationElement config, String name) {
            String value = config.getAttribute(name);
            if (value == null) {
                return true;
            }
            return value.equalsIgnoreCase("true");
        }
    }
}

