/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class BinaryIndexer
extends AbstractIndexer
implements SuffixConstants {
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final char[] INIT = "<init>".toCharArray();

    public BinaryIndexer(SearchDocument document) {
        super(document);
    }

    public void addTypeReference(char[] typeName) {
        int length = typeName.length;
        if (length > 2 && typeName[length - 2] == '$') {
            switch (typeName[length - 1]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return;
                }
            }
        }
        if (CharOperation.indexOf('$', typeName) > 0) {
            char[] cArray = typeName;
            typeName = new char[length];
            System.arraycopy(cArray, 0, typeName, 0, length);
            CharOperation.replace(typeName, '$', '.');
        }
        super.addTypeReference(typeName);
    }

    private void convertToArrayType(char[][] parameterTypes, int counter, int arrayDim) {
        int length = parameterTypes[counter].length;
        char[] arrayType = new char[length + arrayDim * 2];
        System.arraycopy(parameterTypes[counter], 0, arrayType, 0, length);
        for (int i = 0; i < arrayDim; ++i) {
            arrayType[length + i * 2] = 91;
            arrayType[length + i * 2 + 1] = 93;
        }
        parameterTypes[counter] = arrayType;
    }

    private char[] convertToArrayType(char[] typeName, int arrayDim) {
        int length = typeName.length;
        char[] arrayType = new char[length + arrayDim * 2];
        System.arraycopy(typeName, 0, arrayType, 0, length);
        for (int i = 0; i < arrayDim; ++i) {
            arrayType[length + i * 2] = 91;
            arrayType[length + i * 2 + 1] = 93;
        }
        return arrayType;
    }

    private char[] decodeFieldType(char[] signature) throws ClassFormatException {
        if (signature == null) {
            return null;
        }
        int arrayDim = 0;
        int max = signature.length;
        block13: for (int i = 0; i < max; ++i) {
            switch (signature[i]) {
                case 'B': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BYTE, arrayDim);
                    }
                    return BYTE;
                }
                case 'C': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(CHAR, arrayDim);
                    }
                    return CHAR;
                }
                case 'D': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(DOUBLE, arrayDim);
                    }
                    return DOUBLE;
                }
                case 'F': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(FLOAT, arrayDim);
                    }
                    return FLOAT;
                }
                case 'I': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(INT, arrayDim);
                    }
                    return INT;
                }
                case 'J': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(LONG, arrayDim);
                    }
                    return LONG;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (arrayDim > 0) {
                        return this.convertToArrayType(this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon)), arrayDim);
                    }
                    return this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon));
                }
                case 'S': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(SHORT, arrayDim);
                    }
                    return SHORT;
                }
                case 'Z': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BOOLEAN, arrayDim);
                    }
                    return BOOLEAN;
                }
                case 'V': {
                    return VOID;
                }
                case '[': {
                    ++arrayDim;
                    continue block13;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
        }
        return null;
    }

    private char[][] decodeParameterTypes(char[] signature) throws ClassFormatException {
        if (signature == null) {
            return null;
        }
        int indexOfClosingParen = CharOperation.lastIndexOf(')', signature);
        if (indexOfClosingParen == 1) {
            return null;
        }
        if (indexOfClosingParen == -1) {
            throw new ClassFormatException(28);
        }
        char[][] parameterTypes = new char[3][];
        int parameterTypesCounter = 0;
        int arrayDim = 0;
        block12: for (int i = 1; i < indexOfClosingParen; ++i) {
            if (parameterTypesCounter == parameterTypes.length) {
                char[][] cArrayArray = parameterTypes;
                parameterTypes = new char[parameterTypesCounter * 2][];
                System.arraycopy(cArrayArray, 0, parameterTypes, 0, parameterTypesCounter);
            }
            switch (signature[i]) {
                case 'B': {
                    parameterTypes[parameterTypesCounter++] = BYTE;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'C': {
                    parameterTypes[parameterTypesCounter++] = CHAR;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'D': {
                    parameterTypes[parameterTypesCounter++] = DOUBLE;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'F': {
                    parameterTypes[parameterTypesCounter++] = FLOAT;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'I': {
                    parameterTypes[parameterTypesCounter++] = INT;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'J': {
                    parameterTypes[parameterTypesCounter++] = LONG;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    parameterTypes[parameterTypesCounter++] = this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon));
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    i = indexOfSemiColon;
                    arrayDim = 0;
                    continue block12;
                }
                case 'S': {
                    parameterTypes[parameterTypesCounter++] = SHORT;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case 'Z': {
                    parameterTypes[parameterTypesCounter++] = BOOLEAN;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    continue block12;
                }
                case '[': {
                    ++arrayDim;
                    continue block12;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
        }
        if (parameterTypes.length != parameterTypesCounter) {
            char[][] cArrayArray = parameterTypes;
            parameterTypes = new char[parameterTypesCounter][];
            System.arraycopy(cArrayArray, 0, parameterTypes, 0, parameterTypesCounter);
        }
        return parameterTypes;
    }

    private char[] decodeReturnType(char[] signature) throws ClassFormatException {
        if (signature == null) {
            return null;
        }
        int indexOfClosingParen = CharOperation.lastIndexOf(')', signature);
        if (indexOfClosingParen == -1) {
            throw new ClassFormatException(28);
        }
        int arrayDim = 0;
        int max = signature.length;
        block13: for (int i = indexOfClosingParen + 1; i < max; ++i) {
            switch (signature[i]) {
                case 'B': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BYTE, arrayDim);
                    }
                    return BYTE;
                }
                case 'C': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(CHAR, arrayDim);
                    }
                    return CHAR;
                }
                case 'D': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(DOUBLE, arrayDim);
                    }
                    return DOUBLE;
                }
                case 'F': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(FLOAT, arrayDim);
                    }
                    return FLOAT;
                }
                case 'I': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(INT, arrayDim);
                    }
                    return INT;
                }
                case 'J': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(LONG, arrayDim);
                    }
                    return LONG;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (arrayDim > 0) {
                        return this.convertToArrayType(this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon)), arrayDim);
                    }
                    return this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon));
                }
                case 'S': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(SHORT, arrayDim);
                    }
                    return SHORT;
                }
                case 'Z': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BOOLEAN, arrayDim);
                    }
                    return BOOLEAN;
                }
                case 'V': {
                    return VOID;
                }
                case '[': {
                    ++arrayDim;
                    continue block13;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
        }
        return null;
    }

    private int extractArgCount(char[] signature) throws ClassFormatException {
        int indexOfClosingParen = CharOperation.lastIndexOf(')', signature);
        if (indexOfClosingParen == 1) {
            return 0;
        }
        if (indexOfClosingParen == -1) {
            throw new ClassFormatException(28);
        }
        int parameterTypesCounter = 0;
        block5: for (int i = 1; i < indexOfClosingParen; ++i) {
            switch (signature[i]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++parameterTypesCounter;
                    continue block5;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    ++parameterTypesCounter;
                    i = indexOfSemiColon;
                    continue block5;
                }
                case '[': {
                    continue block5;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
        }
        return parameterTypesCounter;
    }

    private char[] extractClassName(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int class_index = reader.u2At(constantPoolOffsets[index] + 1);
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[class_index] + 1)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    private char[] extractName(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int nameAndTypeIndex = reader.u2At(constantPoolOffsets[index] + 3);
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[nameAndTypeIndex] + 1)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    private char[] extractClassReference(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[index] + 1)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    private void extractReferenceFromConstantPool(byte[] contents, ClassFileReader reader) throws ClassFormatException {
        int[] constantPoolOffsets = reader.getConstantPoolOffsets();
        int constantPoolCount = constantPoolOffsets.length;
        block5: for (int i = 1; i < constantPoolCount; ++i) {
            int tag = reader.u1At(constantPoolOffsets[i]);
            char[] name = null;
            char[] type = null;
            switch (tag) {
                case 9: {
                    name = this.extractName(constantPoolOffsets, reader, i);
                    this.addFieldReference(name);
                    continue block5;
                }
                case 10: 
                case 11: {
                    name = this.extractName(constantPoolOffsets, reader, i);
                    type = this.extractType(constantPoolOffsets, reader, i);
                    if (CharOperation.equals(INIT, name)) {
                        char[] className = this.replace('/', '.', this.extractClassName(constantPoolOffsets, reader, i));
                        this.addConstructorReference(className, this.extractArgCount(type));
                        continue block5;
                    }
                    this.addMethodReference(name, this.extractArgCount(type));
                    continue block5;
                }
                case 7: {
                    name = this.extractClassReference(constantPoolOffsets, reader, i);
                    if (name.length > 0 && name[0] == '[') continue block5;
                    name = this.replace('/', '.', name);
                    this.addTypeReference(name);
                    char[][] qualification = CharOperation.splitOn('.', name);
                    int length = qualification.length;
                    for (int j = 0; j < length; ++j) {
                        this.addNameReference(qualification[j]);
                    }
                    continue block5;
                }
            }
        }
    }

    private char[] extractType(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int constantPoolIndex = reader.u2At(constantPoolOffsets[index] + 3);
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[constantPoolIndex] + 3)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    public void indexDocument() {
        try {
            FieldInfo[] fields;
            Object object;
            byte[] contents = this.document.getByteContents();
            ClassFileReader reader = new ClassFileReader(contents, this.document.getPath().toCharArray());
            char[] className = this.replace('/', '.', reader.getName());
            int packageNameIndex = CharOperation.lastIndexOf('.', className);
            char[] packageName = null;
            char[] name = null;
            if (packageNameIndex >= 0) {
                packageName = CharOperation.subarray(className, 0, packageNameIndex);
                name = CharOperation.subarray(className, packageNameIndex + 1, className.length);
            } else {
                packageName = CharOperation.NO_CHAR;
                name = className;
            }
            char[] enclosingTypeName = null;
            if (reader.isNestedType()) {
                name = reader.isAnonymous() ? CharOperation.NO_CHAR : reader.getInnerSourceName();
                if (reader.isLocal() || reader.isAnonymous()) {
                    enclosingTypeName = IIndexConstants.ONE_ZERO;
                } else {
                    char[] fullEnclosingName = reader.getEnclosingTypeName();
                    int nameLength = fullEnclosingName.length - packageNameIndex - 1;
                    if (nameLength <= 0) {
                        return;
                    }
                    enclosingTypeName = new char[nameLength];
                    System.arraycopy(fullEnclosingName, packageNameIndex + 1, enclosingTypeName, 0, nameLength);
                }
            }
            if (name == null) {
                return;
            }
            char[][] superinterfaces = this.replace('/', '.', reader.getInterfaceNames());
            if (enclosingTypeName == null) {
                object = null;
            } else {
                char[][] cArrayArray = new char[1][];
                object = cArrayArray;
                cArrayArray[0] = enclosingTypeName;
            }
            Object enclosingTypeNames = object;
            if (reader.isInterface()) {
                this.addInterfaceDeclaration(reader.getModifiers(), packageName, name, (char[][])enclosingTypeNames, superinterfaces);
            } else {
                char[] superclass = this.replace('/', '.', reader.getSuperclassName());
                this.addClassDeclaration(reader.getModifiers(), packageName, name, (char[][])enclosingTypeNames, superclass, superinterfaces);
            }
            MethodInfo[] methods = (MethodInfo[])reader.getMethods();
            if (methods != null) {
                int max = methods.length;
                for (int i = 0; i < max; ++i) {
                    MethodInfo method = methods[i];
                    char[] descriptor = method.getMethodDescriptor();
                    char[][] parameterTypes = this.decodeParameterTypes(descriptor);
                    char[] returnType = this.decodeReturnType(descriptor);
                    char[][] exceptionTypes = this.replace('/', '.', method.getExceptionTypeNames());
                    if (method.isConstructor()) {
                        this.addConstructorDeclaration(className, parameterTypes, exceptionTypes);
                        continue;
                    }
                    if (method.isClinit()) continue;
                    this.addMethodDeclaration(method.getSelector(), parameterTypes, returnType, exceptionTypes);
                }
            }
            if ((fields = (FieldInfo[])reader.getFields()) != null) {
                int max = fields.length;
                for (int i = 0; i < max; ++i) {
                    FieldInfo field = fields[i];
                    char[] fieldName = field.getName();
                    char[] fieldType = this.decodeFieldType(this.replace('/', '.', field.getTypeName()));
                    this.addFieldDeclaration(fieldType, fieldName);
                }
            }
            this.extractReferenceFromConstantPool(contents, reader);
        }
        catch (ClassFormatException classFormatException) {
            // empty catch block
        }
    }

    private char[][] replace(char toBeReplaced, char newChar, char[][] array) {
        if (array == null) {
            return null;
        }
        int max = array.length;
        for (int i = 0; i < max; ++i) {
            this.replace(toBeReplaced, newChar, array[i]);
        }
        return array;
    }

    private char[] replace(char toBeReplaced, char newChar, char[] array) {
        if (array == null) {
            return null;
        }
        int max = array.length;
        for (int i = 0; i < max; ++i) {
            if (array[i] != toBeReplaced) continue;
            array[i] = newChar;
        }
        return array;
    }
}

