/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class MirrorSite
extends Site {
    private static final String INDENT = "   ";
    private SiteModelFactory factory;
    private Collection downloadedPluginEntries = new ArrayList();
    private Collection downloadedFeatureReferenceModels = new ArrayList();

    public MirrorSite(SiteModelFactory factory) {
        this.factory = factory;
    }

    public void mirrorAndExpose(ISite remoteSite, ISiteFeatureReference[] sourceFeatureRefs, IFeatureReference[] optionalfeatures, String mirrorSiteUrl) throws CoreException {
        this.mirrorAndExposeFeatures(remoteSite, sourceFeatureRefs, optionalfeatures);
        System.out.println("Installing features finished. Updating categories ...");
        this.updateCategories(remoteSite);
        System.out.println("Updating categories finished. Updating site description ...");
        this.updateDescription(remoteSite);
        System.out.println("Updating site description finished. Saving site.xml ...");
        this.save();
        if (mirrorSiteUrl != null) {
            this.generateUpdatePolicy(mirrorSiteUrl);
        }
    }

    private void mirrorAndExposeFeatures(ISite remoteSite, ISiteFeatureReference[] sourceFeatureRefs, IFeatureReference[] optionalfeatures) throws CoreException {
        int j;
        ICategory[] remoteCategories;
        SiteFeatureReferenceModel featureRef;
        IFeature sourceFeature;
        int i;
        ArrayList<ISiteFeatureReference> failedFeatures = new ArrayList<ISiteFeatureReference>();
        for (i = 0; i < sourceFeatureRefs.length; ++i) {
            try {
                sourceFeature = sourceFeatureRefs[i].getFeature((IProgressMonitor)new NullProgressMonitor());
                featureRef = this.mirrorFeature(remoteSite, sourceFeature, optionalfeatures, 1);
                remoteCategories = sourceFeatureRefs[i].getCategories();
                for (j = 0; j < remoteCategories.length; ++j) {
                    featureRef.addCategoryName(remoteCategories[j].getName());
                }
                this.addFeatureReferenceModel(remoteSite, featureRef);
                continue;
            }
            catch (CoreException ce) {
                failedFeatures.add(sourceFeatureRefs[i]);
            }
        }
        if (failedFeatures.size() <= 0) {
            return;
        }
        sourceFeatureRefs = failedFeatures.toArray(new ISiteFeatureReference[failedFeatures.size()]);
        for (i = 0; i < sourceFeatureRefs.length; ++i) {
            sourceFeature = sourceFeatureRefs[i].getFeature((IProgressMonitor)new NullProgressMonitor());
            featureRef = this.mirrorFeature(remoteSite, sourceFeature, optionalfeatures, 1);
            remoteCategories = sourceFeatureRefs[i].getCategories();
            for (j = 0; j < remoteCategories.length; ++j) {
                featureRef.addCategoryName(remoteCategories[j].getName());
            }
            this.addFeatureReferenceModel(remoteSite, featureRef);
        }
    }

    private SiteFeatureReferenceModel mirrorFeature(ISite remoteSite, IFeature sourceFeature, IFeatureReference[] optionalfeatures, int indent) throws CoreException {
        ContentReference[] references;
        int i;
        String tab = "";
        for (int i2 = 0; i2 < indent; ++i2) {
            tab = tab + " ";
        }
        System.out.println(tab + "Mirroring feature " + sourceFeature.getVersionedIdentifier() + " ...");
        SiteFeatureReferenceModel[] existingFeatures = this.getDownloadedFeatureReferenceModels();
        for (int e = 0; e < existingFeatures.length; ++e) {
            if (!existingFeatures[e].getVersionedIdentifier().equals(sourceFeature.getVersionedIdentifier())) continue;
            System.out.println(tab + "Feature " + sourceFeature.getVersionedIdentifier() + " already exists.  Skipping downloading.");
            return existingFeatures[e];
        }
        IFeatureContentProvider provider = sourceFeature.getFeatureContentProvider();
        System.out.println(tab + "Getting plugin entries for " + sourceFeature.getVersionedIdentifier() + " ...");
        IPluginEntry[] sourceFeaturePluginEntries = sourceFeature.getPluginEntries();
        IPluginEntry[] pluginsToInstall = UpdateManagerUtils.diff(sourceFeaturePluginEntries, this.getDownloadedPluginEntries());
        System.out.println(tab + "Getting non plugin entries for " + sourceFeature.getVersionedIdentifier() + " ...");
        INonPluginEntry[] nonPluginsToInstall = sourceFeature.getRawNonPluginEntries();
        System.out.println(tab + "Getting included features for " + sourceFeature.getVersionedIdentifier() + " ...");
        IFeatureReference[] children = sourceFeature.getRawIncludedFeatureReferences();
        if (optionalfeatures != null) {
            children = UpdateManagerUtils.optionalChildrenToInstall(children, optionalfeatures);
        }
        System.out.println(tab + "Downloading feature archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        provider.getFeatureEntryArchiveReferences(null);
        System.out.println(tab + "Downloading plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        for (i = 0; i < pluginsToInstall.length; ++i) {
            provider.getPluginEntryArchiveReferences(pluginsToInstall[i], null);
        }
        System.out.println(tab + "Downloading non plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        for (i = 0; i < nonPluginsToInstall.length; ++i) {
            provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i], null);
        }
        System.out.println(tab + "Installing child features for " + sourceFeature.getVersionedIdentifier() + " ...");
        for (i = 0; i < children.length; ++i) {
            IFeature childFeature = children[i].getFeature(null);
            this.mirrorFeature(remoteSite, childFeature, optionalfeatures, indent + 1);
        }
        System.out.println(tab + "Storing plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        for (i = 0; i < pluginsToInstall.length; ++i) {
            references = provider.getPluginEntryArchiveReferences(pluginsToInstall[i], null);
            this.storePluginArchive(references[0]);
            this.addDownloadedPluginEntry(pluginsToInstall[i]);
        }
        System.out.println(tab + "Storing non plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        for (i = 0; i < nonPluginsToInstall.length; ++i) {
            references = provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i], null);
            for (int r = 0; r < references.length; ++r) {
                this.storeNonPluginArchive(sourceFeature.getVersionedIdentifier(), references[r]);
            }
        }
        System.out.println(tab + "Storing feature archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        ContentReference[] references2 = provider.getFeatureEntryArchiveReferences(null);
        this.storeFeatureArchive(references2[0]);
        System.out.println(tab + "Adding feature " + sourceFeature.getVersionedIdentifier() + " to model ...");
        SiteFeatureReferenceModel featureRef = this.factory.createFeatureReferenceModel();
        featureRef.setSiteModel(this);
        featureRef.setType("org.eclipse.update.core.packaged");
        featureRef.setFeatureIdentifier(sourceFeature.getVersionedIdentifier().getIdentifier());
        featureRef.setFeatureVersion(sourceFeature.getVersionedIdentifier().getVersion().toString());
        this.addDownloadedFeatureReferenceModel(featureRef);
        System.out.println(tab + "Mirroring feature " + sourceFeature.getVersionedIdentifier() + " finished.");
        return featureRef;
    }

    public void addFeatureReferenceModel(ISite remoteSite, SiteFeatureReferenceModel featureReference) {
        ISiteFeatureReference[] remoteFeatures = remoteSite.getRawFeatureReferences();
        for (int i = 0; i < remoteFeatures.length; ++i) {
            ISiteFeatureReference remoteFeatureRef = remoteFeatures[i];
            try {
                if (!remoteFeatureRef.getVersionedIdentifier().equals(featureReference.getVersionedIdentifier())) continue;
                this.addFeatureReferenceModel(featureReference);
                continue;
            }
            catch (CoreException ce) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(ce);
            }
        }
        this.save();
        System.out.println("Feature " + featureReference.getVersionedIdentifier() + " added to site.xml.");
    }

    public void addFeatureReferenceModel(SiteFeatureReferenceModel featureReference) {
        SiteFeatureReferenceModel[] existingModels = this.getFeatureReferenceModels();
        for (int j = 0; j < existingModels.length; ++j) {
            if (!existingModels[j].getVersionedIdentifier().equals(featureReference.getVersionedIdentifier())) continue;
            super.removeFeatureReferenceModel(existingModels[j]);
        }
        super.addFeatureReferenceModel(featureReference);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeFeatureArchive(ContentReference contentReference) throws CoreException {
        InputStream inStream = null;
        String featurePath = null;
        try {
            try {
                URL newURL = new URL(this.getURL(), "features/" + contentReference.getIdentifier() + ".jar");
                featurePath = newURL.getFile();
                inStream = contentReference.getInputStream();
                UpdateManagerUtils.copyToLocal(inStream, featurePath, null);
            }
            catch (IOException e) {
                throw Utilities.newCoreException("Error occurred while creating " + featurePath + " file.", e);
            }
            Object var6_6 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        inStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storePluginArchive(ContentReference contentReference) throws CoreException {
        InputStream inStream = null;
        String pluginPath = null;
        try {
            try {
                URL newURL = new URL(this.getURL(), contentReference.getIdentifier());
                pluginPath = newURL.getFile();
                inStream = contentReference.getInputStream();
                UpdateManagerUtils.copyToLocal(inStream, pluginPath, null);
            }
            catch (IOException e) {
                throw Utilities.newCoreException("Error occurred while creating " + pluginPath + " file.", e);
            }
            Object var6_6 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        inStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeNonPluginArchive(VersionedIdentifier featureVersionedIdentifier, ContentReference contentReference) throws CoreException {
        InputStream inStream = null;
        File nonPluginArchivePath = null;
        try {
            try {
                URL newDirURL = new URL(this.getURL(), "features//" + featureVersionedIdentifier);
                File dir = new File(newDirURL.getFile());
                dir.mkdirs();
                inStream = contentReference.getInputStream();
                nonPluginArchivePath = new File(dir, contentReference.getIdentifier());
                UpdateManagerUtils.copyToLocal(inStream, nonPluginArchivePath.getAbsolutePath(), null);
            }
            catch (IOException e) {
                throw Utilities.newCoreException("Error occurred while creating " + nonPluginArchivePath.getAbsolutePath() + " file.", e);
            }
            Object var8_8 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        inStream.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save() {
        FileOutputStream fos = null;
        URL siteURL = new URL(this.getURL(), "site.xml");
        fos = new FileOutputStream(new File(siteURL.getFile()));
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        PrintWriter writer = new PrintWriter(outWriter);
        this.save(writer);
        writer.flush();
        Object var6_6 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("Site XML could not be saved.", ioe));
                Object var6_7 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void save(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeSite("", writer);
    }

    private void writeSite(String indent, PrintWriter writer) {
        writer.print(indent + "<site");
        String indent2 = indent + INDENT;
        writer.println(">");
        URLEntryModel description = this.getDescriptionModel();
        if (description != null) {
            writer.println();
            this.writeDescription(indent2, writer, description);
            writer.println();
        }
        this.writeFeatures(indent2, writer);
        this.writeCategories(indent2, writer);
        writer.println(indent + "</site>");
    }

    private void writeFeatures(String indent, PrintWriter writer) {
        SiteFeatureReferenceModel[] featureReferenceModels = this.getFeatureReferenceModels();
        for (int i = 0; i < featureReferenceModels.length; ++i) {
            writer.print(indent);
            writer.print("<feature");
            writer.print(" url=\"features/" + featureReferenceModels[i].getFeatureIdentifier() + "_" + featureReferenceModels[i].getFeatureVersion() + ".jar\"");
            writer.print(" id=\"" + featureReferenceModels[i].getFeatureIdentifier() + "\"");
            writer.print(" version=\"" + featureReferenceModels[i].getFeatureVersion() + "\"");
            writer.println(">");
            String[] categoryNames = featureReferenceModels[i].getCategoryNames();
            for (int cn = 0; cn < categoryNames.length; ++cn) {
                writer.print(indent + INDENT);
                writer.println("<category name=\"" + categoryNames[cn] + "\" />");
            }
            writer.print(indent);
            writer.println("</feature>");
            writer.println();
        }
    }

    private void writeCategories(String indent, PrintWriter writer) {
        CategoryModel[] categoryModels = this.getCategoryModels();
        if (categoryModels.length <= 0) {
            return;
        }
        for (int i = 0; i < categoryModels.length; ++i) {
            writer.print(indent);
            writer.print("<category-def");
            writer.print(" name=\"" + categoryModels[i].getName() + "\" label=\"" + categoryModels[i].getLabel() + "\"");
            writer.println(">");
            this.writeDescription(indent + INDENT, writer, categoryModels[i].getDescriptionModel());
            writer.print(indent);
            writer.println("</category-def>");
            writer.println();
        }
    }

    private void writeDescription(String indent, PrintWriter writer, URLEntryModel urlEntryModel) {
        String url = urlEntryModel.getURLString();
        String text = urlEntryModel.getAnnotationNonLocalized();
        if (url == null && text == null && text.length() <= 0) {
            return;
        }
        writer.print(indent);
        writer.print("<description");
        if (url != null) {
            writer.print(" url=\"" + url + "\"");
        }
        if (text == null || text.length() <= 0) {
            writer.println(" />");
        } else {
            writer.println(">");
            if (text != null) {
                writer.println(indent + INDENT + UpdateManagerUtils.Writer.xmlSafe(text));
            }
            writer.println(indent + "</description>");
        }
    }

    public void addDownloadedPluginEntry(IPluginEntry pluginEntry) {
        this.downloadedPluginEntries.add(pluginEntry);
    }

    private IPluginEntry[] getDownloadedPluginEntries() {
        return this.downloadedPluginEntries.toArray(new IPluginEntry[this.downloadedPluginEntries.size()]);
    }

    public void addDownloadedFeatureReferenceModel(SiteFeatureReferenceModel featureModel) {
        this.downloadedFeatureReferenceModels.add(featureModel);
    }

    private SiteFeatureReferenceModel[] getDownloadedFeatureReferenceModels() {
        return this.downloadedFeatureReferenceModels.toArray(new SiteFeatureReferenceModel[this.downloadedFeatureReferenceModels.size()]);
    }

    private void updateDescription(ISite remoteSite) {
        IURLEntry urlEntry = remoteSite.getDescription();
        if (urlEntry != null) {
            URLEntryModel newUrlEntryModel = new URLEntryModel();
            URL url = urlEntry.getURL();
            newUrlEntryModel.setAnnotation(urlEntry.getAnnotation());
            newUrlEntryModel.setURLString(url.toExternalForm());
            this.setDescriptionModel(newUrlEntryModel);
        }
    }

    private void updateCategories(ISite remoteSite) {
        HashSet<String> usedCategoryNames = new HashSet<String>();
        SiteFeatureReferenceModel[] featureRefModels = this.getFeatureReferenceModels();
        for (int f = 0; f < featureRefModels.length; ++f) {
            String[] featureCategoryNames = featureRefModels[f].getCategoryNames();
            for (int c = 0; c < featureCategoryNames.length; ++c) {
                usedCategoryNames.add(featureCategoryNames[c]);
            }
        }
        ArrayList<Object> newCategoryModels = new ArrayList<Object>();
        Iterator it = usedCategoryNames.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ICategory remoteCategory = remoteSite.getCategory(name);
            if (remoteCategory == null) {
                CategoryModel oldCategory = null;
                try {
                    oldCategory = (CategoryModel)((Object)this.getCategory(name));
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
                if (oldCategory == null) continue;
                newCategoryModels.add((Object)oldCategory);
                continue;
            }
            newCategoryModels.add(remoteCategory);
        }
        this.setCategoryModels(newCategoryModels.toArray(new CategoryModel[newCategoryModels.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateUpdatePolicy(String url) {
        FileOutputStream fos = null;
        URL siteURL = new URL(this.getURL(), "policy.xml");
        fos = new FileOutputStream(new File(siteURL.getFile()));
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        PrintWriter writer = new PrintWriter(outWriter);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<update-policy>");
        writer.println("<!-- You can paste the following fragment, containing url-map elements, into another policy file. -->");
        this.writeUrlMaps(writer, url);
        writer.println("<!-- End of fragment with url-map elements. -->");
        writer.println("</update-policy>");
        writer.flush();
        Object var7_7 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("policy.xml could not be saved", ioe));
                Object var7_8 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void writeUrlMaps(PrintWriter writer, String url) {
        SiteFeatureReferenceModel[] featureReferenceModels = this.getFeatureReferenceModels();
        for (int i = 0; i < featureReferenceModels.length; ++i) {
            writer.print("\t");
            writer.print("<url-map");
            writer.print(" pattern=\"" + featureReferenceModels[i].getFeatureIdentifier() + "\"");
            writer.print(" url=\"" + url + "\"");
            writer.println(" />");
        }
    }
}

