/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private Shell shell;
    private Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(ResourceNavigatorMessages.getString("PasteAction.title"));
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(ResourceNavigatorMessages.getString("PasteAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.resource_navigator_paste_action_context");
    }

    private IResource getTarget() {
        List selectedResources = this.getSelectedResources();
        for (int i = 0; i < selectedResources.size(); ++i) {
            IResource resource = (IResource)selectedResources.get(i);
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return null;
            }
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private boolean isLinked(IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].isLinked()) continue;
            return true;
        }
        return false;
    }

    public void run() {
        ResourceTransfer resTransfer = ResourceTransfer.getInstance();
        IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() == 4) {
                for (int i = 0; i < resourceData.length; ++i) {
                    CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                    operation.copyProject((IProject)resourceData[i]);
                }
            } else {
                IContainer container = this.getContainer();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
                operation.copyResources(resourceData, container);
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            IContainer container = this.getContainer();
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
            operation.copyFiles(fileData, container);
        }
    }

    private IContainer getContainer() {
        List selection = this.getSelectedResources();
        if (selection.get(0) instanceof IFile) {
            return ((IFile)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        int i;
        boolean isProjectRes;
        if (!super.updateSelection(selection)) {
            return false;
        }
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resTransfer);
            }
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            for (int i2 = 0; i2 < resourceData.length; ++i2) {
                if (resourceData[i2].getType() == 4 && ((IProject)resourceData[i2]).isOpen()) continue;
                return false;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource targetResource = this.getTarget();
        if (targetResource == null) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            for (i = 0; i < selectedResources.size(); ++i) {
                IResource resource = (IResource)selectedResources.get(i);
                if (resource.getType() != 1) {
                    return false;
                }
                if (targetResource.equals(resource.getParent())) continue;
                return false;
            }
        }
        if (resourceData != null) {
            if (this.isLinked(resourceData) && targetResource.getType() != 4) {
                return false;
            }
            if (targetResource.getType() == 2) {
                for (i = 0; i < resourceData.length; ++i) {
                    if (!targetResource.equals(resourceData[i])) continue;
                    return false;
                }
            }
            return true;
        }
        TransferData[] transfers = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        for (int i3 = 0; i3 < transfers.length; ++i3) {
            if (!fileTransfer.isSupportedType(transfers[i3])) continue;
            return true;
        }
        return false;
    }
}

