/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class ClipboardOperationAction
extends TextEditorAction {
    private static final ClipboardTransfer fgTransferInstance = new ClipboardTransfer();
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;
    static /* synthetic */ Class class$org$eclipse$jface$text$ITextOperationTarget;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public ClipboardOperationAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        if (operationCode == 3) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        } else if (operationCode == 4) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        } else if (operationCode == 5) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid operation code");
        }
        this.update();
    }

    private boolean isReadOnlyOperation() {
        return this.fOperationCode == 4;
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.isReadOnlyOperation() && !this.validateEditorInputState()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ClipboardOperationAction.this.internalDoOperation();
            }
        });
    }

    private Shell getShell() {
        IWorkbenchPartSite site;
        Shell shell;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (shell = (site = editor.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    protected final void internalDoOperation() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("importsOnPaste")) {
            if (this.fOperationCode == 5) {
                this.doPasteWithImportsOperation();
            } else {
                this.doCutCopyWithImportsOperation();
            }
        } else {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void update() {
        super.update();
        if (!this.isReadOnlyOperation() && !this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(class$org$eclipse$jface$text$ITextOperationTarget == null ? (class$org$eclipse$jface$text$ITextOperationTarget = ClipboardOperationAction.class$("org.eclipse.jface.text.ITextOperationTarget")) : class$org$eclipse$jface$text$ITextOperationTarget);
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCutCopyWithImportsOperation() {
        ITextSelection textSelection;
        ITextEditor editor = this.getTextEditor();
        IJavaElement inputElement = (IJavaElement)editor.getEditorInput().getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = ClipboardOperationAction.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        ISelection selection = editor.getSelectionProvider().getSelection();
        ClipboardData clipboardData = null;
        if (inputElement != null && selection instanceof ITextSelection && !selection.isEmpty() && this.isNonTrivialSelection(textSelection = (ITextSelection)selection)) {
            clipboardData = this.getClipboardData(inputElement, textSelection.getOffset(), textSelection.getLength());
        }
        this.fOperationTarget.doOperation(this.fOperationCode);
        if (clipboardData != null) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            try {
                Object textData = clipboard.getContents((Transfer)TextTransfer.getInstance());
                Object rtfData = clipboard.getContents((Transfer)RTFTransfer.getInstance());
                ArrayList<Object> datas = new ArrayList<Object>(3);
                ArrayList<Object> transfers = new ArrayList<Object>(3);
                if (textData != null) {
                    datas.add(textData);
                    transfers.add(TextTransfer.getInstance());
                }
                if (rtfData != null) {
                    datas.add(rtfData);
                    transfers.add(RTFTransfer.getInstance());
                }
                datas.add(clipboardData);
                transfers.add((Object)fgTransferInstance);
                Transfer[] dataTypes = transfers.toArray(new Transfer[transfers.size()]);
                Object[] data = datas.toArray();
                this.setClipboardContents(clipboard, data, dataTypes);
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private void setClipboardContents(Clipboard clipboard, Object[] datas, Transfer[] transfers) {
        try {
            clipboard.setContents(datas, transfers);
            return;
        }
        catch (SWTError e) {
            if (e.code != 2002) {
                throw e;
            }
            return;
        }
    }

    private boolean isNonTrivialSelection(ITextSelection selection) {
        if (selection.getLength() < 30) {
            String text = selection.getText();
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ClipboardData getClipboardData(IJavaElement inputElement, int offset, int length) {
        CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST(inputElement, true, null);
        if (astRoot == null) {
            return null;
        }
        List list = astRoot.imports();
        if (!list.isEmpty() ? offset < ((ASTNode)list.get(list.size() - 1)).getStartPosition() : astRoot.getPackage() != null && offset < astRoot.getPackage().getStartPosition()) {
            return null;
        }
        ArrayList res = new ArrayList();
        ImportReferencesCollector collector = new ImportReferencesCollector(new Region(offset, length), res);
        astRoot.accept((ASTVisitor)collector);
        HashSet<String> namesToImport = new HashSet<String>(res.size());
        for (int i = 0; i < res.size(); ++i) {
            String name;
            SimpleName curr = (SimpleName)res.get(i);
            IBinding binding = curr.resolveBinding();
            if (binding == null || binding.getKind() != 2) continue;
            ITypeBinding typeBinding = (ITypeBinding)binding;
            if (typeBinding.isArray()) {
                typeBinding = typeBinding.getElementType();
            }
            if (!typeBinding.isMember() && !typeBinding.isTopLevel() || (name = typeBinding.getQualifiedName()).length() <= 0) continue;
            namesToImport.add(name);
        }
        if (namesToImport.isEmpty()) {
            return null;
        }
        return new ClipboardData(inputElement, namesToImport.toArray(new String[namesToImport.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPasteWithImportsOperation() {
        ITextEditor editor = this.getTextEditor();
        IJavaElement inputElement = (IJavaElement)editor.getEditorInput().getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = ClipboardOperationAction.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        Clipboard clipboard = new Clipboard(this.getDisplay());
        ClipboardData importsData = (ClipboardData)clipboard.getContents((Transfer)fgTransferInstance);
        if (importsData != null && inputElement instanceof ICompilationUnit && !importsData.isFromSame(inputElement)) {
            IRewriteTarget target;
            IRewriteTarget iRewriteTarget = editor != null ? (IRewriteTarget)editor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = ClipboardOperationAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget) : (target = null);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                this.fOperationTarget.doOperation(this.fOperationCode);
                this.addImports((ICompilationUnit)inputElement, importsData);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        } else {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    private void addImports(ICompilationUnit unit, ClipboardData data) throws CoreException {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        ImportsStructure importsStructure = new ImportsStructure(unit, settings.importOrder, settings.importThreshold, true);
        importsStructure.setFindAmbiguousImports(false);
        String[] imports = data.getImports();
        for (int i = 0; i < imports.length; ++i) {
            importsStructure.addImport(imports[i]);
        }
        importsStructure.create(false, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClipboardTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "source-with-imports-transfer-format" + System.currentTimeMillis();
        private static final int TYPEID = ClipboardTransfer.registerType((String)TYPE_NAME);

        private ClipboardTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        protected void javaToNative(Object data, TransferData transferData) {
            if (data instanceof ClipboardData) {
                try {
                    super.javaToNative((Object)((ClipboardData)data).serialize(), transferData);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null) {
                try {
                    return new ClipboardData(bytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class ClipboardData {
        private String fOriginHandle;
        private String[] fImports;

        public ClipboardData(IJavaElement origin, String[] imports) {
            this.fImports = imports;
            this.fOriginHandle = origin.getHandleIdentifier();
        }

        public ClipboardData(byte[] bytes) throws IOException {
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));
            this.fOriginHandle = dataIn.readUTF();
            int count = dataIn.readInt();
            this.fImports = new String[count];
            for (int i = 0; i < count; ++i) {
                this.fImports[i] = dataIn.readUTF();
            }
            dataIn.close();
        }

        public String[] getImports() {
            return this.fImports;
        }

        public boolean isFromSame(IJavaElement elem) {
            return this.fOriginHandle.equals(elem.getHandleIdentifier());
        }

        public byte[] serialize() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeUTF(this.fOriginHandle);
            dataOut.writeInt(this.fImports.length);
            for (int i = 0; i < this.fImports.length; ++i) {
                dataOut.writeUTF(this.fImports[i]);
            }
            dataOut.close();
            out.close();
            return out.toByteArray();
        }
    }
}

