/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.ServerTools;
import org.languagetool.server.UserDictEntry;

class DatabaseAccess {
    private static DatabaseAccess instance;
    private static SqlSessionFactory sqlSessionFactory;

    private DatabaseAccess(HTTPServerConfig config) {
        if (config.getDatabaseDriver() != null) {
            try {
                ServerTools.print("Setting up database access, URL " + config.getDatabaseUrl() + ", driver: " + config.getDatabaseDriver() + ", user: " + config.getDatabaseUsername());
                InputStream inputStream = Resources.getResourceAsStream("org/languagetool/server/mybatis-config.xml");
                Properties properties = new Properties();
                properties.setProperty("driver", config.getDatabaseDriver());
                properties.setProperty("url", config.getDatabaseUrl());
                properties.setProperty("username", config.getDatabaseUsername());
                properties.setProperty("password", config.getDatabasePassword());
                sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            ServerTools.print("Not setting up database access, dbDriver is not configured");
        }
    }

    static synchronized void init(HTTPServerConfig config) {
        if (instance == null) {
            instance = new DatabaseAccess(config);
        }
    }

    static synchronized DatabaseAccess getInstance() {
        if (instance == null) {
            throw new IllegalStateException("DatabaseAccess.init() has not been called yet");
        }
        return instance;
    }

    List<String> getUserDictWords(Long userId) {
        ArrayList<String> dictEntries = new ArrayList<String>();
        if (sqlSessionFactory == null) {
            return dictEntries;
        }
        try (SqlSession session = sqlSessionFactory.openSession();){
            List dict = session.selectList("org.languagetool.server.UserDictMapper.selectWordList", userId);
            for (UserDictEntry userDictEntry : dict) {
                dictEntries.add(userDictEntry.getWord());
            }
        }
        return dictEntries;
    }

    boolean addWord(String word, Long userId) {
        this.validateWord(word);
        if (sqlSessionFactory == null) {
            return false;
        }
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("word", word);
            map.put("userId", userId);
            List existingWords = session.selectList("org.languagetool.server.UserDictMapper.selectWord", map);
            if (existingWords.size() >= 1) {
                ServerTools.print("Did not add '" + word + "' for user " + userId + " to list of ignored words, already exists");
                boolean bl = false;
                return bl;
            }
            Date now = new Date();
            map.put("created_at", now);
            map.put("updated_at", now);
            int affectedRows = session.insert("org.languagetool.server.UserDictMapper.addWord", map);
            ServerTools.print("Added '" + word + "' for user " + userId + " to list of ignored words, affectedRows: " + affectedRows);
            boolean bl = affectedRows == 1;
            return bl;
        }
    }

    Long getUserId(String username, String apiKey) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("username must be set");
        }
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("apikey must be set");
        }
        if (sqlSessionFactory == null) {
            throw new IllegalStateException("sqlSessionFactory not initialized - has the database been configured?");
        }
        try (SqlSession session = sqlSessionFactory.openSession();){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("username", username);
            map.put("apiKey", apiKey);
            Long id = (Long)session.selectOne("org.languagetool.server.UserDictMapper.getUserIdByApiKey", map);
            if (id == null) {
                throw new IllegalArgumentException("No user found for given username '" + username + "' and given api key");
            }
            Long l = id;
            return l;
        }
    }

    boolean deleteWord(String word, Long userId) {
        if (sqlSessionFactory == null) {
            return false;
        }
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("word", word);
            map.put("userId", userId);
            int count = session.delete("org.languagetool.server.UserDictMapper.selectWord", map);
            if (count == 0) {
                ServerTools.print("Did not delete '" + word + "' for user " + userId + " from list of ignored words, does not exist");
                boolean bl = false;
                return bl;
            }
            int affectedRows = session.delete("org.languagetool.server.UserDictMapper.deleteWord", map);
            ServerTools.print("Deleted '" + word + "' for user " + userId + " from list of ignored words, affectedRows: " + affectedRows);
            boolean bl = affectedRows >= 1;
            return bl;
        }
    }

    private void validateWord(String word) {
        if (word == null || word.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid word, cannot be empty or whitespace only");
        }
        if (word.matches(".*\\s.*")) {
            throw new IllegalArgumentException("Invalid word, you can only words that don't contain spaces: '" + word + "'");
        }
    }

    public static void createAndFillTestTables() {
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            System.out.println("Setting up tables and adding test user...");
            session.insert("org.languagetool.server.UserDictMapper.createUserTable");
            session.insert("org.languagetool.server.UserDictMapper.createIgnoreWordTable");
            session.insert("org.languagetool.server.UserDictMapper.createTestUser1");
            session.insert("org.languagetool.server.UserDictMapper.createTestUser2");
        }
    }

    public static void deleteTestTables() {
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            System.out.println("Deleting tables...");
            session.delete("org.languagetool.server.UserDictMapper.deleteUsersTable");
            session.delete("org.languagetool.server.UserDictMapper.deleteIgnoreWordsTable");
        }
    }
}

