/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

class DatabaseLogger {
    private static DatabaseLogger instance = null;
    private final BlockingQueue<DatabaseLogEntry> messages = new LinkedBlockingQueue<DatabaseLogEntry>();
    private SqlSessionFactory sessionFactory = null;
    private WorkerThread worker = null;
    private boolean disabled = true;

    public static DatabaseLogger getInstance() {
        if (instance == null) {
            instance = new DatabaseLogger();
        }
        return instance;
    }

    static void init(SqlSessionFactory factory) {
        DatabaseLogger.getInstance().start(factory);
    }

    private void start(SqlSessionFactory factory) {
        this.sessionFactory = factory;
        this.disabled = false;
        this.worker = new WorkerThread();
        this.worker.start();
    }

    private DatabaseLogger() {
    }

    public void disableLogging() {
        this.disabled = true;
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    public boolean isLogging() {
        return !this.disabled;
    }

    public void log(DatabaseLogEntry entry) {
        try {
            if (!this.disabled) {
                this.messages.put(entry);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void createTestTables() {
        try (SqlSession session = this.sessionFactory.openSession(true);){
            session.insert("org.languagetool.server.LogMapper.createRuleMatches");
            session.insert("org.languagetool.server.LogMapper.createCheckLog");
            session.insert("org.languagetool.server.LogMapper.createMiscLog");
            session.insert("org.languagetool.server.LogMapper.createAccessLimits");
            session.insert("org.languagetool.server.LogMapper.createCheckError");
            session.insert("org.languagetool.server.LogMapper.createCacheStats");
            session.insert("org.languagetool.server.LogMapper.createServers");
            session.insert("org.languagetool.server.LogMapper.createClients");
        }
    }

    void dropTestTables() {
        try (SqlSession session = this.sessionFactory.openSession(true);){
            session.delete("org.languagetool.server.LogMapper.dropRuleMatches");
            session.delete("org.languagetool.server.LogMapper.dropCheckLog");
            session.delete("org.languagetool.server.LogMapper.dropMiscLog");
            session.delete("org.languagetool.server.LogMapper.dropAccessLimits");
            session.delete("org.languagetool.server.LogMapper.dropCheckError");
            session.delete("org.languagetool.server.LogMapper.dropCacheStats");
            session.delete("org.languagetool.server.LogMapper.dropServers");
            session.delete("org.languagetool.server.LogMapper.dropClients");
        }
    }

    private class WorkerThread
    extends Thread {
        private WorkerThread() {
        }

        @Override
        public void run() {
            block16: {
                try (SqlSession session = DatabaseLogger.this.sessionFactory.openSession(true);){
                    while (!Thread.currentThread().isInterrupted()) {
                        if (DatabaseLogger.this.messages.size() > 10) {
                            ServerTools.print(String.format("Logging queue filling up: %d entries", DatabaseLogger.this.messages.size()));
                        }
                        DatabaseLogEntry entry = (DatabaseLogEntry)DatabaseLogger.this.messages.take();
                        Map<Object, Object> parameters = entry.getMapping();
                        session.insert(entry.getMappingIdentifier(), parameters);
                        entry.followup(parameters);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (Thread.currentThread().isInterrupted()) break block16;
                    new WorkerThread().start();
                }
            }
        }
    }
}

