/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;

public class CleanOverlappingFilter
implements RuleMatchFilter {
    private Language language;

    public CleanOverlappingFilter(Language lang) {
        this.language = lang;
    }

    @Override
    public final List<RuleMatch> filter(List<RuleMatch> ruleMatches) {
        ArrayList<RuleMatch> cleanList = new ArrayList<RuleMatch>();
        RuleMatch prevRuleMatch = null;
        for (RuleMatch ruleMatch : ruleMatches) {
            int prevPriority;
            if (prevRuleMatch == null) {
                prevRuleMatch = ruleMatch;
                continue;
            }
            if (ruleMatch.getFromPos() < prevRuleMatch.getFromPos()) {
                throw new RuntimeException("The list of rule matches is not ordered. Make sure it is sorted by start position.");
            }
            if (ruleMatch.getFromPos() >= prevRuleMatch.getToPos()) {
                cleanList.add(prevRuleMatch);
                prevRuleMatch = ruleMatch;
                continue;
            }
            int currentPriority = this.getMatchPriority(ruleMatch);
            if (currentPriority == (prevPriority = this.getMatchPriority(prevRuleMatch))) {
                currentPriority = ruleMatch.getToPos() - ruleMatch.getFromPos();
                prevPriority = prevRuleMatch.getToPos() - prevRuleMatch.getFromPos();
            }
            if (currentPriority == prevPriority) {
                ++currentPriority;
            }
            if (currentPriority <= prevPriority) continue;
            prevRuleMatch = ruleMatch;
        }
        if (prevRuleMatch != null) {
            cleanList.add(prevRuleMatch);
        }
        return cleanList;
    }

    private int getMatchPriority(RuleMatch r) {
        if (r.getRule().getCategory().getId() == null) {
            return 0;
        }
        int categoryPriority = this.language.getPriorityForId(r.getRule().getCategory().getId().toString());
        int rulePriority = this.language.getPriorityForId(r.getRule().getId());
        if (rulePriority != 0) {
            return rulePriority;
        }
        return categoryPriority;
    }
}

