/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bridj.NativeLibrary;
import org.bridj.demangling.Demangler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersReconstructor {
    public static void reconstructHeaders(Iterable<NativeLibrary> libraries, PrintWriter out) {
        ArrayList<Demangler.MemberRef> orphanMembers = new ArrayList<Demangler.MemberRef>();
        HashMap<Demangler.TypeRef, ArrayList<Demangler.MemberRef>> membersByClass = new HashMap<Demangler.TypeRef, ArrayList<Demangler.MemberRef>>();
        for (NativeLibrary nativeLibrary : libraries) {
            for (Demangler.Symbol symbol : nativeLibrary.getSymbols()) {
                Demangler.MemberRef mr = symbol.getParsedRef();
                if (mr == null) continue;
                Demangler.TypeRef et = mr.getEnclosingType();
                if (et == null) {
                    orphanMembers.add(mr);
                    continue;
                }
                ArrayList<Demangler.MemberRef> mrs = (ArrayList<Demangler.MemberRef>)membersByClass.get(et);
                if (mrs == null) {
                    mrs = new ArrayList<Demangler.MemberRef>();
                    membersByClass.put(et, mrs);
                }
                mrs.add(mr);
            }
        }
        for (Demangler.TypeRef typeRef : membersByClass.keySet()) {
            out.println("class " + typeRef + ";");
        }
        for (Demangler.MemberRef memberRef : orphanMembers) {
            out.println(memberRef + ";");
        }
        for (Map.Entry entry : membersByClass.entrySet()) {
            Demangler.TypeRef tr = (Demangler.TypeRef)entry.getKey();
            List mrs = (List)entry.getValue();
            out.println("class " + tr + " \n{");
            for (Demangler.MemberRef mr : mrs) {
                out.println("\t" + mr + ";");
            }
            out.println("}");
        }
    }
}

