/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch.dev;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.api.prospectivesearch.dev.QueryEngine;
import com.google.appengine.api.search.query.QueryLexer;
import com.google.appengine.api.search.query.QueryParser;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.api.search.query.QueryTreeWalker;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.CharStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.Token;
import com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream;
import com.google.appengine.repackaged.org.antlr.runtime.TokenSource;
import com.google.appengine.repackaged.org.antlr.runtime.TokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.tree.CommonTree;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryEvaluator
implements QueryTreeVisitor<AtomicBoolean> {
    static final Logger logger = Logger.getLogger(QueryEvaluator.class.getName());
    final Tree queryTree;
    final QueryTreeWalker<AtomicBoolean> walker;
    final Deque<Token> restriction;
    final StringBuffer debugIndentSpaces;
    final AtomicBoolean matches;
    Entity doc;
    Map<String, ProspectiveSearchPb.SchemaEntry> schema;
    String op = null;
    int debugIndentLevel = 0;

    QueryEvaluator(String query) throws RecognitionException {
        QueryParser parser = new QueryParser((TokenStream)new TokenRewriteStream((TokenSource)new QueryLexer((CharStream)new ANTLRStringStream(query))));
        this.queryTree = QueryTreeWalker.simplify((Tree)((Tree)parser.query().getTree()));
        Preconditions.checkArgument((boolean)this.queryTree.isNil());
        this.walker = new QueryTreeWalker((QueryTreeVisitor)this);
        this.restriction = new ArrayDeque<Token>();
        this.debugIndentSpaces = new StringBuffer();
        this.matches = new AtomicBoolean();
    }

    boolean eval(Entity doc, Map<String, ProspectiveSearchPb.SchemaEntry> schema) throws RecognitionException {
        this.doc = doc;
        this.schema = schema;
        this.walker.walk(this.queryTree.getChild(0), (Object)this.matches);
        this.restriction.clear();
        this.debugIndentSpaces.setLength(0);
        return this.matches.getAndSet(false);
    }

    void walkChildren(Tree tree, AtomicBoolean matches) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree child = tree.getChild(i);
            this.walker.walk(child, (Object)matches);
        }
    }

    public void visitSequence(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.visitConjunction(walker, node, matches);
    }

    public void visitConjunction(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Conjunction {", new Object[0]);
        boolean curBool = true;
        for (int i = 0; i < node.getChildCount(); ++i) {
            walker.walk(node.getChild(i), (Object)matches);
            curBool &= matches.get();
        }
        matches.set(curBool);
        this.debugOut("} = %s", matches);
    }

    public void visitDisjunction(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Disjunction {", new Object[0]);
        boolean curBool = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            walker.walk(node.getChild(i), (Object)matches);
            curBool |= matches.get();
        }
        matches.set(curBool);
        this.debugOut("} = %s", matches);
    }

    public void visitNegation(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Negation {", new Object[0]);
        Preconditions.checkArgument((node.getChildCount() == 1 ? 1 : 0) != 0);
        walker.walk(node.getChild(0), (Object)matches);
        matches.set(!matches.get());
        this.debugOut("} = %s", matches);
    }

    public void visitRestriction(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Restriction {", new Object[0]);
        Preconditions.checkArgument((node.getChildCount() == 2 ? 1 : 0) != 0);
        Token fieldToken = ((CommonTree)node.getChild(0)).getToken();
        this.restriction.push(fieldToken);
        walker.walk(node.getChild(1), (Object)matches);
        this.restriction.pop();
        this.debugOut("} = %s", matches);
    }

    public void visitFuzzy(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Fuzzy {", new Object[0]);
        this.op = "~";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitLiteral(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Literal {", new Object[0]);
        this.op = "+";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitLessThan(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("LessThan {", new Object[0]);
        this.op = "<";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitLessOrEqual(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("LessOrEqual {", new Object[0]);
        this.op = "<=";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitGreaterThan(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("GreaterThan {", new Object[0]);
        this.op = ">";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitGreaterOrEqual(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("GreaterOrEqual {", new Object[0]);
        this.op = ">=";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitEqual(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Equal {", new Object[0]);
        this.op = "=";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitContains(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Contains {", new Object[0]);
        this.op = ":";
        this.walkChildren(node, matches);
        this.op = null;
        this.debugOut("} = %s", matches);
    }

    public void visitValue(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        Preconditions.checkArgument((!this.restriction.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.op != null ? 1 : 0) != 0);
        Preconditions.checkArgument((node.getChildCount() == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((node.getType() == 17 ? 1 : 0) != 0);
        Token fieldToken = this.restriction.peek();
        String fieldName = "";
        if (fieldToken.getType() != 11) {
            fieldName = fieldToken.getText();
        }
        String fieldValue = node.getChild(1).getText();
        this.debug("  Entity[%s] %s %s", fieldName, this.op, fieldValue);
        matches.set(QueryEngine.query(this.doc, fieldName, this.op, fieldValue, this.schema));
    }

    public void visitOther(QueryTreeWalker<AtomicBoolean> walker, Tree node, AtomicBoolean matches) {
        this.debugIn("Other {", new Object[0]);
        this.walkChildren(node, matches);
        this.debugOut("} = %s", matches);
    }

    void debugIn(String template, Object ... args) {
        ++this.debugIndentLevel;
        this.debug(template, args);
    }

    void debugOut(String template, Object ... args) {
        this.debug(template, args);
        --this.debugIndentLevel;
    }

    void debug(String template, Object ... args) {
        while (this.debugIndentSpaces.length() < this.debugIndentLevel * 2) {
            this.debugIndentSpaces.append(" ");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.debugIndentSpaces.substring(0, this.debugIndentLevel * 2) + String.format(template, args));
        }
    }
}

