/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@GoogleInternal
public final class CharsetCache {
    private static final CharsetCache INSTANCE = new CharsetCache(new DefaultLookup(), 100);
    private final ConcurrentMap<String, SoftReference<Charset>> hitCache;
    private final Map<String, Boolean> missCache;
    private final Function<String, Charset> lookupFunction;

    public static Charset forName(String charsetName) {
        return INSTANCE.lookup(charsetName);
    }

    CharsetCache(Function<String, Charset> lookupFn, final int missCacheSize) {
        Preconditions.checkNotNull(lookupFn);
        Preconditions.checkArgument(missCacheSize > 1);
        this.lookupFunction = lookupFn;
        this.hitCache = new ConcurrentHashMap<String, SoftReference<Charset>>();
        LinkedHashMap<String, Boolean> temp = new LinkedHashMap<String, Boolean>(missCacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return this.size() > missCacheSize;
            }
        };
        this.missCache = Collections.synchronizedMap(temp);
    }

    Charset lookup(String name) {
        Preconditions.checkArgument(name != null, "Charset name may not be null");
        name = name.toLowerCase();
        SoftReference hit = (SoftReference)this.hitCache.get(name);
        if (hit != null) {
            Charset charset = (Charset)hit.get();
            if (charset != null) {
                return charset;
            }
        } else if (this.missCache.get(name) != null) {
            throw new UnsupportedCharsetException(name);
        }
        return this.lookupAndCache(name);
    }

    private Charset lookupAndCache(String name) {
        try {
            Charset charset = this.lookupFunction.apply(name);
            SoftReference<Charset> ref = new SoftReference<Charset>(charset);
            this.hitCache.put(name, ref);
            for (String alias : charset.aliases()) {
                this.hitCache.put(alias.toLowerCase(), ref);
            }
            return charset;
        }
        catch (UnsupportedCharsetException e) {
            this.missCache.put(name, Boolean.TRUE);
            throw e;
        }
    }

    private static class DefaultLookup
    implements Function<String, Charset> {
        private DefaultLookup() {
        }

        @Override
        public Charset apply(String charsetName) {
            return Charset.forName(charsetName);
        }
    }
}

