/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.StateManager;

class PersistentNew
extends LifeCycleState {
    protected PersistentNew() {
        this.isPersistent = true;
        this.isDirty = true;
        this.isNew = true;
        this.isDeleted = false;
        this.isTransactional = true;
        this.stateType = 1;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 7);
    }

    public LifeCycleState transitionMakeNontransactional(StateManager sm) {
        throw new NucleusUserException(LOCALISER.msg("027013"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (detachAllOnCommit) {
            return this.changeState(sm, 0);
        }
        throw new NucleusUserException(LOCALISER.msg("027014"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_NEW";
    }
}

