/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import java.util.HashMap;
import java.util.Map;

public final class FlagValues {
    private final Map<String, String> values = new HashMap<String, String>();

    public void addFlag(String flag, String value) {
        this.values.put(flag, value);
    }

    public String getFlagValue(String flag) {
        return this.values.get(flag);
    }

    public String[] getAllFlagsAsStringArray() {
        String[] flags = new String[this.values.size()];
        int i = 0;
        for (String flagName : this.values.keySet()) {
            String flagValue = this.values.get(flagName);
            flags[i] = "--" + flagName + ("".equals(flagValue) ? "" : "=" + flagValue);
            ++i;
        }
        return flags;
    }

    public String getAllFlagsAsString() {
        StringBuilder builder = new StringBuilder(32);
        String[] flags = this.getAllFlagsAsStringArray();
        for (int i = 0; i < flags.length; ++i) {
            builder.append(flags[i]);
            if (i >= flags.length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }
}

