/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateMidnight;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.Interval;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.TimeOfDay;
import com.google.appengine.repackaged.org.joda.time.base.BasePartial;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.field.AbstractPartialFieldProperty;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@Deprecated
public final class YearMonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 797544782896179L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
    public static final int YEAR = 0;
    public static final int MONTH_OF_YEAR = 1;
    public static final int DAY_OF_MONTH = 2;

    public static YearMonthDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonthDay(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static YearMonthDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonthDay(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public YearMonthDay() {
    }

    public YearMonthDay(DateTimeZone zone) {
        super(ISOChronology.getInstance(zone));
    }

    public YearMonthDay(Chronology chronology) {
        super(chronology);
    }

    public YearMonthDay(long instant) {
        super(instant);
    }

    public YearMonthDay(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public YearMonthDay(Object instant) {
        super(instant, null, ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(int year, int monthOfYear, int dayOfMonth) {
        this(year, monthOfYear, dayOfMonth, null);
    }

    public YearMonthDay(int year, int monthOfYear, int dayOfMonth, Chronology chronology) {
        super(new int[]{year, monthOfYear, dayOfMonth}, chronology);
    }

    YearMonthDay(YearMonthDay partial, int[] values) {
        super((BasePartial)partial, values);
    }

    YearMonthDay(YearMonthDay partial, Chronology chrono) {
        super((BasePartial)partial, chrono);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.year();
            }
            case 1: {
                return chrono.monthOfYear();
            }
            case 2: {
                return chrono.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException(new StringBuilder(26).append("Invalid index: ").append(index).toString());
    }

    @Override
    public DateTimeFieldType getFieldType(int index) {
        return FIELD_TYPES[index];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public YearMonthDay withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        YearMonthDay newYearMonthDay = new YearMonthDay(this, newChronology);
        newChronology.validate(newYearMonthDay, this.getValues());
        return newYearMonthDay;
    }

    public YearMonthDay withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add(this, index, newValues, amount);
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        for (int i = 0; i < period.size(); ++i) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index < 0) continue;
            newValues = this.getField(index).add(this, index, newValues, FieldUtils.safeMultiply(period.getValue(i), scalar));
        }
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public YearMonthDay plusYears(int years) {
        return this.withFieldAdded(DurationFieldType.years(), years);
    }

    public YearMonthDay plusMonths(int months) {
        return this.withFieldAdded(DurationFieldType.months(), months);
    }

    public YearMonthDay plusDays(int days) {
        return this.withFieldAdded(DurationFieldType.days(), days);
    }

    public YearMonthDay minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public YearMonthDay minusYears(int years) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(years));
    }

    public YearMonthDay minusMonths(int months) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(months));
    }

    public YearMonthDay minusDays(int days) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(days));
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public DateTime toDateTimeAtMidnight(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chrono);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instantMillis = DateTimeUtils.currentTimeMillis();
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public DateMidnight toDateMidnight(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chrono);
    }

    public DateTime toDateTime(TimeOfDay time) {
        return this.toDateTime(time, null);
    }

    public DateTime toDateTime(TimeOfDay time, DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instant = DateTimeUtils.currentTimeMillis();
        instant = chrono.set(this, instant);
        if (time != null) {
            instant = chrono.set(time, instant);
        }
        return new DateTime(instant, chrono);
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        return this.toDateMidnight(zone).toInterval();
    }

    public int getYear() {
        return this.getValue(0);
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public int getDayOfMonth() {
        return this.getValue(2);
    }

    public YearMonthDay withYear(int year) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().year().set(this, 0, newValues, year);
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay withMonthOfYear(int monthOfYear) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().monthOfYear().set(this, 1, newValues, monthOfYear);
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay withDayOfMonth(int dayOfMonth) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().dayOfMonth().set(this, 2, newValues, dayOfMonth);
        return new YearMonthDay(this, newValues);
    }

    public Property year() {
        return new Property(this, 0);
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    public Property dayOfMonth() {
        return new Property(this, 2);
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.yearMonthDay().print(this);
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final YearMonthDay iYearMonthDay;
        private final int iFieldIndex;

        Property(YearMonthDay partial, int fieldIndex) {
            this.iYearMonthDay = partial;
            this.iFieldIndex = fieldIndex;
        }

        @Override
        public DateTimeField getField() {
            return this.iYearMonthDay.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iYearMonthDay;
        }

        public YearMonthDay getYearMonthDay() {
            return this.iYearMonthDay;
        }

        @Override
        public int get() {
            return this.iYearMonthDay.getValue(this.iFieldIndex);
        }

        public YearMonthDay addToCopy(int valueToAdd) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().add(this.iYearMonthDay, this.iFieldIndex, newValues, valueToAdd);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().addWrapField(this.iYearMonthDay, this.iFieldIndex, newValues, valueToAdd);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay setCopy(int value) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().set(this.iYearMonthDay, this.iFieldIndex, newValues, value);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay setCopy(String text, Locale locale) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().set(this.iYearMonthDay, this.iFieldIndex, newValues, text, locale);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay setCopy(String text) {
            return this.setCopy(text, null);
        }

        public YearMonthDay withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public YearMonthDay withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

