/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@Immutable
@GwtCompatible(serializable=true, emulated=true)
public strictfp final class S2LatLng
implements Serializable {
    @Deprecated
    public static final double EARTH_RADIUS_METERS = 6367000.0;
    public static final S2LatLng CENTER = new S2LatLng(0.0, 0.0);
    private final double latRadians;
    private final double lngRadians;

    public static S2LatLng fromRadians(double latRadians, double lngRadians) {
        return new S2LatLng(latRadians, lngRadians);
    }

    public static S2LatLng fromDegrees(double latDegrees, double lngDegrees) {
        return new S2LatLng(S1Angle.degrees(latDegrees), S1Angle.degrees(lngDegrees));
    }

    public static S2LatLng fromE5(int latE5, int lngE5) {
        return new S2LatLng(S1Angle.e5(latE5), S1Angle.e5(lngE5));
    }

    public static S2LatLng fromE6(int latE6, int lngE6) {
        return new S2LatLng(S1Angle.e6(latE6), S1Angle.e6(lngE6));
    }

    public static S2LatLng fromE7(int latE7, int lngE7) {
        return new S2LatLng(S1Angle.e7(latE7), S1Angle.e7(lngE7));
    }

    public static S1Angle latitude(S2Point p) {
        return S1Angle.radians(Math.atan2(p.z, Math.sqrt(p.x * p.x + p.y * p.y)));
    }

    public static S1Angle longitude(S2Point p) {
        return S1Angle.radians(Math.atan2(p.y, p.x));
    }

    private S2LatLng(double latRadians, double lngRadians) {
        this.latRadians = latRadians;
        this.lngRadians = lngRadians;
    }

    public S2LatLng(S1Angle lat, S1Angle lng) {
        this(lat.radians(), lng.radians());
    }

    public S2LatLng() {
        this(0.0, 0.0);
    }

    public S2LatLng(S2Point p) {
        this(Math.atan2(p.z, Math.sqrt(p.x * p.x + p.y * p.y)), Math.atan2(p.y, p.x));
    }

    public S1Angle lat() {
        return S1Angle.radians(this.latRadians);
    }

    public double latRadians() {
        return this.latRadians;
    }

    public double latDegrees() {
        return 57.29577951308232 * this.latRadians;
    }

    public S1Angle lng() {
        return S1Angle.radians(this.lngRadians);
    }

    public double lngRadians() {
        return this.lngRadians;
    }

    public double lngDegrees() {
        return 57.29577951308232 * this.lngRadians;
    }

    public boolean isValid() {
        return Math.abs(this.latRadians) <= 1.5707963267948966 && Math.abs(this.lngRadians) <= Math.PI;
    }

    @CheckReturnValue
    public S2LatLng normalized() {
        return new S2LatLng(Math.max(-1.5707963267948966, Math.min(1.5707963267948966, this.latRadians)), Platform.IEEEremainder(this.lngRadians, Math.PI * 2));
    }

    public S2Point toPoint() {
        double phi = this.latRadians;
        double theta = this.lngRadians;
        double cosphi = Math.cos(phi);
        return new S2Point(Math.cos(theta) * cosphi, Math.sin(theta) * cosphi, Math.sin(phi));
    }

    public S1Angle getDistance(S2LatLng o) {
        double lat1 = this.latRadians;
        double lat2 = o.latRadians;
        double lng1 = this.lngRadians;
        double lng2 = o.lngRadians;
        double dlat = Math.sin(0.5 * (lat2 - lat1));
        double dlng = Math.sin(0.5 * (lng2 - lng1));
        double x = dlat * dlat + dlng * dlng * Math.cos(lat1) * Math.cos(lat2);
        return S1Angle.radians(2.0 * Math.asin(Math.sqrt(Math.min(1.0, x))));
    }

    public double getDistance(S2LatLng o, double radius) {
        return this.getDistance(o).distance(radius);
    }

    @Deprecated
    public double getEarthDistance(S2LatLng o) {
        return this.getDistance(o).earthDistance();
    }

    @CheckReturnValue
    public S2LatLng add(S2LatLng o) {
        return new S2LatLng(this.latRadians + o.latRadians, this.lngRadians + o.lngRadians);
    }

    @CheckReturnValue
    public S2LatLng sub(S2LatLng o) {
        return new S2LatLng(this.latRadians - o.latRadians, this.lngRadians - o.lngRadians);
    }

    @CheckReturnValue
    public S2LatLng mul(double m) {
        return new S2LatLng(this.latRadians * m, this.lngRadians * m);
    }

    public boolean equals(Object that) {
        if (that instanceof S2LatLng) {
            S2LatLng o = (S2LatLng)that;
            return this.latRadians == o.latRadians && this.lngRadians == o.lngRadians;
        }
        return false;
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(this.latRadians);
        value += 37L * value + Double.doubleToLongBits(this.lngRadians);
        return (int)(value ^ value >>> 32);
    }

    public boolean approxEquals(S2LatLng o, double maxError) {
        return Math.abs(this.latRadians - o.latRadians) < maxError && Math.abs(this.lngRadians - o.lngRadians) < maxError;
    }

    public boolean approxEquals(S2LatLng o) {
        return this.approxEquals(o, 1.0E-9);
    }

    public String toString() {
        double d = this.latRadians;
        double d2 = this.lngRadians;
        return new StringBuilder(52).append("(").append(d).append(", ").append(d2).append(")").toString();
    }

    public String toStringDegrees() {
        double d = this.latDegrees();
        double d2 = this.lngDegrees();
        return new StringBuilder(52).append("(").append(d).append(", ").append(d2).append(")").toString();
    }
}

