/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.apphosting.runtime.SessionData;
import com.google.apphosting.runtime.SessionStore;
import com.google.apphosting.runtime.jetty94.DeferredDatastoreSessionStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.server.session.UnwriteableSessionDataException;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;

class DatastoreSessionStore
implements SessionStore {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/apphosting/runtime/jetty94/DatastoreSessionStore");
    static final String SESSION_ENTITY_TYPE = "_ah_SESSION";
    private static final String EXPIRES_PROP = "_expires";
    private static final String VALUES_PROP = "_values";
    private final SessionDataStoreImpl impl;

    DatastoreSessionStore(boolean useTaskqueue, Optional<String> queueName) {
        this.impl = useTaskqueue ? new DeferredDatastoreSessionStore(queueName) : new SessionDataStoreImpl();
    }

    SessionDataStoreImpl getSessionDataStoreImpl() {
        return this.impl;
    }

    @Override
    public SessionData getSession(String key) {
        throw new RuntimeException("Not supported.");
    }

    @Override
    public void saveSession(String key, SessionData data) {
        throw new UnsupportedOperationException("saveSession is not supported.");
    }

    @Override
    public void deleteSession(String key) {
        try {
            this.impl.delete(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class SessionDataStoreImpl
    extends AbstractSessionDataStore {
        private static final int MAX_RETRIES = 10;
        private static final int INITIAL_BACKOFF_MS = 50;
        private final DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();

        SessionDataStoreImpl() {
        }

        public Set<String> doGetExpired(Set<String> candidates) {
            return Collections.emptySet();
        }

        public void doStore(String key, org.eclipse.jetty.server.session.SessionData data, long lastSaveTime) throws InterruptedException, IOException, UnwriteableSessionDataException, SessionStore.Retryable {
            Entity entity = this.entityFromSession(key, data);
            int backoff = 50;
            for (int attempts = 0; attempts < 10; ++attempts) {
                try {
                    this.datastore.put(entity);
                    return;
                }
                catch (DatastoreTimeoutException ex) {
                    Thread.sleep(backoff);
                    backoff *= 2;
                    continue;
                }
            }
            throw new UnwriteableSessionDataException(key, this._context, null);
        }

        public boolean isPassivating() {
            return false;
        }

        public boolean exists(String key) throws Exception {
            try {
                Entity entity = this.datastore.get(SessionDataStoreImpl.createKeyForSession(key));
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFinest()).withInjectedLogSite("com/google/apphosting/runtime/jetty94/DatastoreSessionStore$SessionDataStoreImpl", "exists", 129, "DatastoreSessionStore.java")).log("Session %s %s", (Object)key, (Object)(entity != null ? "exists" : "does not exist"));
                return true;
            }
            catch (EntityNotFoundException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty94/DatastoreSessionStore$SessionDataStoreImpl", "exists", 132, "DatastoreSessionStore.java")).log("Session %s does not exist", key);
                return false;
            }
        }

        public boolean delete(String key) throws IOException {
            this.datastore.delete(new Key[]{SessionDataStoreImpl.createKeyForSession(key)});
            return true;
        }

        public org.eclipse.jetty.server.session.SessionData doLoad(String key) throws Exception {
            try {
                Entity entity = this.datastore.get(SessionDataStoreImpl.createKeyForSession(key));
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFinest()).withInjectedLogSite("com/google/apphosting/runtime/jetty94/DatastoreSessionStore$SessionDataStoreImpl", "doLoad", 157, "DatastoreSessionStore.java")).log("Loaded session %s from datastore.", key);
                return this.sessionFromEntity(entity, key);
            }
            catch (EntityNotFoundException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty94/DatastoreSessionStore$SessionDataStoreImpl", "doLoad", 160, "DatastoreSessionStore.java")).log("Unable to find specified session %s", key);
                return null;
            }
        }

        static Key createKeyForSession(String key) {
            String originalNamespace = NamespaceManager.get();
            try {
                NamespaceManager.set((String)"");
                Key key2 = KeyFactory.createKey((String)DatastoreSessionStore.SESSION_ENTITY_TYPE, (String)key);
                return key2;
            }
            finally {
                NamespaceManager.set((String)originalNamespace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Entity entityFromSession(String id, org.eclipse.jetty.server.session.SessionData data) throws IOException {
            String originalNamespace = NamespaceManager.get();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(data.getAllAttributes());
                oos.flush();
                NamespaceManager.set((String)"");
                Entity entity = new Entity(DatastoreSessionStore.SESSION_ENTITY_TYPE, id);
                entity.setProperty(DatastoreSessionStore.EXPIRES_PROP, (Object)data.getExpiry());
                entity.setProperty(DatastoreSessionStore.VALUES_PROP, (Object)new Blob(baos.toByteArray()));
                Entity entity2 = entity;
                return entity2;
            }
            finally {
                NamespaceManager.set((String)originalNamespace);
            }
        }

        org.eclipse.jetty.server.session.SessionData sessionFromEntity(Entity entity, String id) throws Exception {
            if (entity == null) {
                return null;
            }
            long time = System.currentTimeMillis();
            AtomicReference reference = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            Runnable load = () -> {
                try {
                    org.eclipse.jetty.server.session.SessionData session = this.createSessionData(entity, id, time);
                    reference.set(session);
                }
                catch (UnreadableSessionDataException ex) {
                    exception.set(ex);
                }
            };
            this._context.run(load);
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
            return (org.eclipse.jetty.server.session.SessionData)reference.get();
        }

        private org.eclipse.jetty.server.session.SessionData createSessionData(Entity entity, String id, long time) throws UnreadableSessionDataException {
            long expiry = (Long)entity.getProperty(DatastoreSessionStore.EXPIRES_PROP);
            Blob blob = (Blob)entity.getProperty(DatastoreSessionStore.VALUES_PROP);
            org.eclipse.jetty.server.session.SessionData session = this.newSessionData(id, time, time, time, 1000L * (long)this._context.getSessionHandler().getMaxInactiveInterval());
            session.setExpiry(expiry);
            try (ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream((InputStream)new ByteArrayInputStream(blob.getBytes()));){
                Map map = (Map)ois.readObject();
                session.putAllAttributes(map);
            }
            catch (Exception ex) {
                throw new UnreadableSessionDataException(id, this._context, (Throwable)ex);
            }
            return session;
        }
    }
}

