/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.query.DatastoreQuery;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.VariableExpression;

final class QueryData {
    QueryType type = QueryType.NORMAL;
    final Map parameters;
    final AbstractClassMetaData acmd;
    final DatastoreTable table;
    final QueryCompilation compilation;
    final Query primaryDatastoreQuery;
    final DatastoreQuery.ResultType resultType;
    final Utils.Function<Entity, Object> resultTransformer;
    final LinkedHashMap<String, List<Object>> inFilters = new LinkedHashMap();
    Set<Key> batchGetKeys;
    VariableExpression joinVariableExpression;
    OrderExpression joinOrderExpression;
    Query joinQuery;
    String currentOrProperty;
    boolean isOrExpression = false;

    QueryData(Map parameters, AbstractClassMetaData acmd, DatastoreTable table, QueryCompilation compilation, Query primaryDatastoreQuery, DatastoreQuery.ResultType resultType, Utils.Function<Entity, Object> resultTransformer) {
        this.parameters = parameters;
        this.acmd = acmd;
        this.table = table;
        this.compilation = compilation;
        this.primaryDatastoreQuery = primaryDatastoreQuery;
        this.resultType = resultType;
        this.resultTransformer = resultTransformer;
    }

    public String getDatastoreQueryAsString() {
        List sortPreds;
        List filterPreds;
        StringBuilder str = new StringBuilder();
        str.append("Kind=" + this.table);
        if (this.primaryDatastoreQuery.isKeysOnly()) {
            str.append(" KEYS-ONLY");
        }
        if (this.primaryDatastoreQuery.getAncestor() != null) {
            str.append(" ANCESTOR=" + this.primaryDatastoreQuery.getAncestor());
        }
        if ((filterPreds = this.primaryDatastoreQuery.getFilterPredicates()).size() > 0) {
            str.append(" Filter : ");
            Iterator filterIter = filterPreds.iterator();
            while (filterIter.hasNext()) {
                Query.FilterPredicate pred = (Query.FilterPredicate)filterIter.next();
                str.append(pred.getPropertyName() + pred.getOperator() + pred.getValue());
                if (!filterIter.hasNext()) continue;
                str.append(" AND ");
            }
        }
        if ((sortPreds = this.primaryDatastoreQuery.getSortPredicates()).size() > 0) {
            str.append(" Sort : ");
            Iterator sortIter = sortPreds.iterator();
            while (sortIter.hasNext()) {
                Query.SortPredicate pred = (Query.SortPredicate)sortIter.next();
                str.append(pred.getPropertyName() + " " + pred.getDirection());
                if (!sortIter.hasNext()) continue;
                str.append(",");
            }
        }
        str.append(" [QUERY-TYPE=" + (Object)((Object)this.type) + "]");
        return str.toString();
    }

    public static enum QueryType {
        BATCH_GET,
        JOIN,
        NORMAL;

    }
}

