/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.query.LazyResult;
import com.google.appengine.datanucleus.query.RuntimeExceptionWrappingIterable;
import java.util.Iterator;
import java.util.ListIterator;
import javax.jdo.JDOUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

class StreamingQueryResult
extends AbstractQueryResult {
    private final LazyResult<Object> lazyResult;
    private boolean loadResultsAtCommit = true;
    private final Cursor endCursor;
    private boolean hasError;
    private RuntimeExceptionWrappingIterable inputIterable;

    public StreamingQueryResult(Query query, Iterable<Entity> lazyEntities, Utils.Function<Entity, Object> entityToPojoFunc, Cursor endCursor) {
        super(query);
        if (lazyEntities instanceof RuntimeExceptionWrappingIterable) {
            this.inputIterable = (RuntimeExceptionWrappingIterable)lazyEntities;
        }
        this.lazyResult = new LazyResult<Object>(lazyEntities, entityToPojoFunc, query.useResultsCaching());
        this.endCursor = endCursor;
    }

    public void disconnect() {
        if (this.inputIterable != null) {
            this.hasError = this.inputIterable.hasError();
        }
        super.disconnect();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen()) {
            if (this.hasError) {
                NucleusLogger.QUERY.info((Object)"Skipping resolution of remaining results due to earlier error.");
            } else {
                try {
                    this.lazyResult.resolveAll();
                }
                catch (NucleusUserException jpue) {
                    NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + jpue.getMessage()));
                }
                catch (JDOUserException ue) {
                    NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + ue.getMessage()));
                }
            }
            this.cacheQueryResults();
        }
    }

    protected void closeResults() {
        this.cacheQueryResults();
    }

    protected void cacheQueryResults() {
        if (this.query != null && this.query.useResultsCaching()) {
            this.lazyResult.resolveAll();
            this.query.getQueryManager().addDatastoreQueryResult(this.query, this.query.getInputParameters(), this.lazyResult.getEntityKeys());
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object get(int index) {
        return this.lazyResult.get(index);
    }

    void resolveNext() {
        this.lazyResult.resolveNext();
    }

    public Iterator<Object> iterator() {
        return this.lazyResult.listIterator();
    }

    public ListIterator<Object> listIterator() {
        return this.lazyResult.listIterator();
    }

    public int size() {
        return this.lazyResult.size();
    }

    Cursor getEndCursor() {
        return this.endCursor;
    }
}

