/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.onestore;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public enum PropertyType {
    NULL(new OnestoreEntity.PropertyValue(), new OnestoreEntity.PropertyValue()),
    INT64(new OnestoreEntity.PropertyValue().setInt64Value(Long.MIN_VALUE), new OnestoreEntity.PropertyValue().setInt64Value(0L)),
    BOOLEAN(new OnestoreEntity.PropertyValue().setBooleanValue(false), new OnestoreEntity.PropertyValue().setBooleanValue(false)),
    STRING(new OnestoreEntity.PropertyValue().setStringValue(""), new OnestoreEntity.PropertyValue().setStringValue("none")),
    DOUBLE(new OnestoreEntity.PropertyValue().setDoubleValue(Double.NEGATIVE_INFINITY), new OnestoreEntity.PropertyValue().setDoubleValue(0.0)),
    POINT(new OnestoreEntity.PropertyValue().setPointValue(new OnestoreEntity.PropertyValue.PointValue().setX(Double.NEGATIVE_INFINITY).setY(Double.NEGATIVE_INFINITY)), new OnestoreEntity.PropertyValue().setPointValue(new OnestoreEntity.PropertyValue.PointValue().setX(0.0).setY(0.0))),
    USER(new OnestoreEntity.PropertyValue().setUserValue(new OnestoreEntity.PropertyValue.UserValue().setEmail("").setAuthDomain("").setGaiaid(Long.MIN_VALUE)), new OnestoreEntity.PropertyValue().setUserValue(new OnestoreEntity.PropertyValue.UserValue().setEmail("none").setAuthDomain("none").setGaiaid(0L))),
    REFERENCE(new OnestoreEntity.PropertyValue().setReferenceValue(new OnestoreEntity.PropertyValue.ReferenceValue()), new OnestoreEntity.PropertyValue().setReferenceValue(new OnestoreEntity.PropertyValue.ReferenceValue()));

    private static SortedMap<Integer, PropertyType> types;
    public final OnestoreEntity.PropertyValue minValue;
    public final OnestoreEntity.PropertyValue placeholderValue;
    public final int tag;

    private PropertyType(OnestoreEntity.PropertyValue minValue, OnestoreEntity.PropertyValue placeholderValue) {
        this.minValue = minValue;
        this.placeholderValue = placeholderValue;
        this.tag = PropertyType.findOnlyTag(minValue);
        Preconditions.checkArgument(this.tag == PropertyType.findOnlyTag(placeholderValue));
    }

    public static PropertyType getType(OnestoreEntity.PropertyValue value) {
        return (PropertyType)((Object)types.get(PropertyType.findOnlyTag(value)));
    }

    public PropertyType next() {
        SortedMap<Integer, PropertyType> rest = types.tailMap(this.tag + 1);
        if (rest.isEmpty()) {
            return null;
        }
        return (PropertyType)((Object)rest.get(rest.firstKey()));
    }

    private static int findOnlyTag(OnestoreEntity.PropertyValue value) {
        List<Integer> tags = PropertyType.findTags(value);
        if (tags.isEmpty()) {
            return -1;
        }
        Preconditions.checkArgument(tags.size() == 1);
        return tags.get(0);
    }

    private static List<Integer> findTags(OnestoreEntity.PropertyValue value) {
        ArrayList<Integer> tags = Lists.newArrayList();
        for (ProtocolType.FieldType field : ProtocolType.getTags(value)) {
            if (field.size(value) != 1) continue;
            tags.add(field.getTag());
        }
        return tags;
    }

    static {
        types = new TreeMap<Integer, PropertyType>();
        for (PropertyType type : EnumSet.allOf(PropertyType.class)) {
            types.put(type.tag, type);
        }
        PropertyType.REFERENCE.minValue.getMutableReferenceValue().setApp("");
        PropertyType.REFERENCE.placeholderValue.getMutableReferenceValue().setApp("none").addPathElement().setType("none").setName("none");
    }
}

