/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.FileReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

@Deprecated
public class BufferedFileReadChannelImpl
implements FileReadChannel {
    private final FileReadChannel readChannel;
    private final int bufferSize;
    private final ByteBuffer buffer;
    private boolean encounteredEof;
    private final Object lock = new Object();

    public BufferedFileReadChannelImpl(FileReadChannel readChannel, int bufferSize) {
        this.readChannel = readChannel;
        this.bufferSize = bufferSize;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.makeEmpty();
        this.encounteredEof = false;
    }

    private void makeEmpty() {
        this.buffer.position(this.buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int bytesRead;
            if (this.encounteredEof && this.buffer.remaining() == 0) {
                return -1;
            }
            if (dst.remaining() == 0) {
                if (this.buffer.remaining() == 0) {
                    this.refillBuffer();
                    if (this.encounteredEof) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
            if (this.bufferHasMoreThanNeeded(dst)) {
                bytesRead = this.readIntoShortBuffer(dst);
            } else {
                bytesRead = this.buffer.remaining();
                dst.put(this.buffer);
                assert (this.buffer.remaining() == 0);
                while (dst.remaining() > this.bufferSize && !this.encounteredEof) {
                    int bytesFromChannel = this.readChannel.read(dst);
                    if (bytesFromChannel == -1) {
                        this.encounteredEof = true;
                        continue;
                    }
                    bytesRead += bytesFromChannel;
                }
                if (dst.remaining() > 0 && dst.remaining() <= this.bufferSize && !this.encounteredEof) {
                    this.refillBuffer();
                    bytesRead += this.readIntoShortBuffer(dst);
                }
            }
            return bytesRead == 0 && this.encounteredEof ? -1 : bytesRead;
        }
    }

    private boolean bufferHasMoreThanNeeded(ByteBuffer dst) {
        return dst.remaining() <= this.buffer.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readIntoShortBuffer(ByteBuffer dst) {
        int oldLimit = this.buffer.limit();
        int newLimit = Math.min(oldLimit, this.buffer.position() + dst.remaining());
        int bytesRead = Math.min(dst.remaining(), this.buffer.remaining());
        this.buffer.limit(newLimit);
        try {
            dst.put(this.buffer);
        }
        finally {
            this.buffer.limit(oldLimit);
        }
        return bytesRead;
    }

    private void refillBuffer() throws IOException {
        assert (this.buffer.remaining() == 0);
        this.buffer.clear();
        int read = this.readChannel.read(this.buffer);
        this.buffer.flip();
        if (read == -1) {
            this.encounteredEof = true;
        }
    }

    @Override
    public boolean isOpen() {
        return this.readChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.readChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long position = this.readChannel.position();
            return position - (long)this.buffer.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileReadChannel position(long newPosition) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long startingPosition = this.position();
            int relativePos = (int)(newPosition - startingPosition);
            if (relativePos < this.buffer.remaining() && relativePos >= 0) {
                this.buffer.position(this.buffer.position() + relativePos);
            } else {
                this.buffer.clear();
                this.makeEmpty();
                this.readChannel.position(newPosition);
            }
            return this;
        }
    }

    public String toString() {
        String string = String.valueOf(this.readChannel);
        return new StringBuilder(28 + String.valueOf(string).length()).append("BufferedFileReadChannel [ ").append(string).append(" ]").toString();
    }
}

