/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.jetty9;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.quickstart.QuickStartWebApp;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.objectweb.asm.Opcodes;

public class QuickStartGenerator {
    public static void main(String[] args) {
        String string;
        if (args.length != 2) {
            System.out.println("Usage: pass 2 arguments:");
            System.out.println("       first argument contains the path to a web application");
            System.out.println("       second argument contains the path to a webdefault.xml file.");
            System.exit(1);
        }
        String path = args[0];
        String webDefault = args[1];
        File fpath = new File(path);
        if (!fpath.exists()) {
            String string2 = String.valueOf(fpath);
            System.out.println(new StringBuilder(49 + String.valueOf(string2).length()).append("Error: Web Application directory does not exist: ").append(string2).toString());
            System.exit(1);
        }
        QuickStartGenerator.hackAsmVersion();
        File fWebDefault = new File(webDefault);
        if (!fWebDefault.exists()) {
            string = String.valueOf(fWebDefault);
            System.out.println(new StringBuilder(43 + String.valueOf(string).length()).append("Error: webdefault.xml file does not exist: ").append(string).toString());
            System.exit(1);
        }
        if (!(fpath = new File(fpath, "WEB-INF")).exists()) {
            string = String.valueOf(fpath);
            System.out.println(new StringBuilder(28 + String.valueOf(string).length()).append("Error: Path does not exist: ").append(string).toString());
            System.exit(1);
        }
        System.setProperty("org.eclipse.jetty.server.LEVEL", "WARN");
        System.setProperty("org.eclipse.jetty.quickstart.LEVEL", "WARN");
        boolean success = QuickStartGenerator.generate(path, fWebDefault);
        System.exit(success ? 0 : 1);
    }

    public static boolean generate(String appDir, File webDefault) {
        boolean deleted;
        File qs = new File(appDir, "WEB-INF/quickstart-web.xml");
        if (qs.exists() && !(deleted = IO.delete((File)qs))) {
            String string = String.valueOf(qs);
            System.err.println(new StringBuilder(42 + String.valueOf(string).length()).append("Error: File exists and cannot be deleted: ").append(string).toString());
            return false;
        }
        try {
            Server server = new Server();
            QuickStartWebApp webapp = new QuickStartWebApp();
            webapp.setResourceBase(appDir);
            webapp.setPreconfigure(true);
            try {
                Method setGenerateOrigin = QuickStartWebApp.class.getMethod("setGenerateOrigin", Boolean.TYPE);
                setGenerateOrigin.invoke((Object)webapp, true);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            webapp.setDefaultsDescriptor(webDefault.getCanonicalPath());
            server.setHandler((Handler)webapp);
            server.start();
            server.stop();
            if (qs.exists()) {
                return true;
            }
            String string = String.valueOf(qs);
            System.out.println(new StringBuilder(19 + String.valueOf(string).length()).append("Failed to generate ").append(string).toString());
            return false;
        }
        catch (Exception e) {
            String string = String.valueOf(e);
            System.out.println(new StringBuilder(37 + String.valueOf(string).length()).append("Error during quick start generation: ").append(string).toString());
            return false;
        }
    }

    private static void hackAsmVersion() {
        int asm6ApiValue;
        try {
            Field asm6ApiField = Opcodes.class.getField("ASM6");
            asm6ApiValue = (Integer)asm6ApiField.get(null);
        }
        catch (ReflectiveOperationException e) {
            return;
        }
        try {
            Field asmVersionField = AnnotationParser.class.getDeclaredField("ASM_OPCODE_VERSION");
            asmVersionField.setAccessible(true);
            int asmVersion = (Integer)asmVersionField.get(null);
            if (asmVersion < asm6ApiValue) {
                asmVersionField.set(null, asm6ApiValue);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

