/**********************************************************************
Copyright (c) 2004 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
2005 Andy Jefferson - cater for JDOHelper.getObjectId being used in result
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.api.ApiAdapter;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;

/**
 * Representation of JDOHelper in JDOQL
 */
public class JDOHelperExpression extends ScalarExpression
{
    /**
     * Constructor.
     * @param qs The query expression
     */
    public JDOHelperExpression(QueryExpression qs)
    {
        super(qs);
    }

    /**
     * Returns an object expression for the argument.
     * @param expr the expression
     * @return the returned value for an object expression argument is the
     * argument itself. The returned for a literal argument is a
     * ObjectLiteral or NullLiteral
     */
    public ScalarExpression getObjectIdMethod(ScalarExpression expr)
    {
        if (expr == null)
        {
            return new NullLiteral(qs);
        }
        if (expr instanceof Literal)
        {
            ApiAdapter api = qs.getStoreManager().getApiAdapter();
            Object id = api.getIdForObject(((Literal)expr).getValue());
            if (id == null)
            {
                return new NullLiteral(qs);
            }
            else
            {                
                JavaTypeMapping m = qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(
                    id.getClass(), false, false, qs.getClassLoaderResolver());
                return new ObjectLiteral(qs, m, id);
            }
        }
        else if (ObjectExpression.class.isAssignableFrom(expr.getClass()))
        {
            if (((ObjectExpression)expr).getMapping() instanceof PersistenceCapableMapping)
            {
                // JDOHelper.getObjectId only requires the identity, whereas a PCMapping by default will
                // represent the object so we change it to be an identity representation.
                ((ObjectExpression)expr).useIdentityFormOfPCMapping();
            }
            return expr;
        }

        throw new IllegalOperationException(this, "getObjectId", expr);
    }
}