/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.map.XQItemValueMap;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.util.hash.TokenObjectMap;

public final class XQStrValueMap
extends XQHashMap {
    private static final MapType TYPE = MapType.get(AtomType.STRING, SeqType.ITEM_ZM);
    private final TokenObjectMap<Value> map;

    XQStrValueMap(int capacity) {
        super(TYPE);
        this.map = new TokenObjectMap(capacity);
    }

    @Override
    public long structSize() {
        return this.map.size();
    }

    @Override
    public Value getOrNull(Item key) throws QueryException {
        int i;
        if (key.type.isStringOrUntyped() && (i = this.map.index(key.string(null))) != 0) {
            return this.valueAt(i - 1);
        }
        return null;
    }

    @Override
    public Value keys() {
        return StrSeq.get(this.map.keys());
    }

    @Override
    public Str keyAt(int index) {
        return Str.get(this.map.key(index + 1));
    }

    @Override
    public Value valueAt(int index) {
        return this.map.value(index + 1);
    }

    @Override
    void valueAt(int index, Value value) {
        this.map.value(index + 1, value);
    }

    @Override
    XQHashMap build(Item key, Value value) throws QueryException {
        byte[] k = XQStrValueMap.toStr(key);
        if (k != null) {
            this.map.put(k, value);
            return this;
        }
        return new XQItemValueMap(this.map.capacity() - 2).build(this).build(key, value);
    }

    @Override
    public Item shrink(QueryContext qc) throws QueryException {
        this.shrinkValues(qc);
        this.refineType();
        SeqType vt = ((MapType)this.type).valueType();
        return vt.one() && vt.type.oneOf(AtomType.INTEGER, AtomType.STRING) ? this.rebuild(qc) : this;
    }
}

