/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.list.ElementList;

public final class BoolList
extends ElementList {
    private boolean[] list;

    public BoolList() {
        this(-1L);
    }

    public BoolList(long capacity) {
        this.list = new boolean[Array.initialCapacity(capacity)];
    }

    public BoolList add(boolean element) {
        int s = this.size;
        boolean[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.size = s + 1;
        return this;
    }

    public BoolList add(boolean ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        boolean[] lst = this.list;
        if (ns > lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.size = ns;
        return this;
    }

    public boolean get(int index) {
        return this.list[index];
    }

    public void set(int index, boolean element) {
        if (index >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newCapacity(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public boolean pop() {
        return this.list[--this.size];
    }

    public void push(boolean element) {
        this.add(element);
    }

    public boolean peek() {
        return this.list[this.size - 1];
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public boolean[] next() {
        boolean[] lst = Arrays.copyOf(this.list, this.size);
        this.reset();
        return lst;
    }

    public boolean[] finish() {
        boolean[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof BoolList)) return false;
        BoolList l = (BoolList)obj;
        if (!Arrays.equals(this.list, 0, this.size, l.list, 0, l.size)) return false;
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

