(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.  The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.  The type signatures in this interface
 * are an edited version of those generated automatically by running 
 * "bin\fsc.exe -i" on the implementation file.
 *=========================================================================*)

/// Sys: Basic system operations (for ML compatibility)
///
/// This module is only included to make it possible to cross-compile 
/// code with other ML compilers.  It may be deprecated and/or removed in 
/// a future release. You may wish to use .NET functions directly instead. 
module Microsoft.FSharp.Compatibility.OCaml.Sys
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

/// The usual argv command line array. Gives the command line arguments
/// as returned by System.Environment.GetCommandLineArgs().
val argv: string array

/// Returns true if a file currently exists, using System.IO.File.Exists(s).
val file_exists: string -> bool

/// System.Environment.GetEnvironmentVariable, raising
/// [[Not_found]] if the variable is not defined.
val getenv: string -> string

/// Deletes a file using System.IO.File.Delete(s).
val remove: string -> unit

/// Eename a file on disk using System.IO.File.Move  
val rename: string -> string -> unit

/// Sets the current working directory for the process using [[System.IO.Directory.SetCurrentDirectory]] 
val chdir: string -> unit

/// Returns the current working directory for the process using [[System.IO.Directory.GetCurrentDirectory]]
val getcwd: unit -> string

/// Run the command and return it's exit code.
///
/// Warning: 'command' currently attempts to execute the string using 
/// the 'cmd.exe' shell processor.  If it is not present on the system 
/// then the operation will fail.  Use System.Diagnostics.Process 
/// directly to run commands in a portable way, which involves specifying 
/// the program to run and the arguments independently.
val command: string -> int
 
/// Path of the current executable, using
/// <pre>
/// System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory,
///                           System.AppDomain.CurrentDomain.FriendlyName)  
/// </pre>
val executable_name: string

/// The number of bits in the "int" type.
val word_size: int

/// Time consumed by the main thread. (for approximate timings).
/// Generally returns only the processor time used by the main 
/// thread of the application.
val time: unit -> float
