/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonBuilder;
import java.util.HashMap;
import java.util.Map;

public class JsonObject
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public JsonObject() {
    }

    public JsonObject(Map<? extends String, ? extends Object> map) {
        super(map);
    }

    public JsonObject(int n) {
        super(n);
    }

    public JsonObject(int n, float f) {
        super(n, f);
    }

    public static JsonBuilder<JsonObject> builder() {
        return new JsonBuilder<JsonObject>(new JsonObject());
    }

    public JsonArray getArray(String string) {
        return this.getArray(string, null);
    }

    public JsonArray getArray(String string, JsonArray jsonArray) {
        Object v = this.get(string);
        if (v instanceof JsonArray) {
            return (JsonArray)this.get(string);
        }
        return jsonArray;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, Boolean bl) {
        Object v = this.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return bl;
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        Object v = this.get(string);
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        return d;
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        Object v = this.get(string);
        if (v instanceof Number) {
            return ((Number)v).floatValue();
        }
        return f;
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n) {
        Object v = this.get(string);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        return n;
    }

    public Number getNumber(String string) {
        return this.getNumber(string, null);
    }

    public Number getNumber(String string, Number number) {
        Object v = this.get(string);
        if (v instanceof Number) {
            return (Number)v;
        }
        return number;
    }

    public JsonObject getObject(String string) {
        return this.getObject(string, null);
    }

    public JsonObject getObject(String string, JsonObject jsonObject) {
        Object v = this.get(string);
        if (v instanceof JsonObject) {
            return (JsonObject)this.get(string);
        }
        return jsonObject;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Object v = this.get(string);
        if (v instanceof String) {
            return (String)this.get(string);
        }
        return string2;
    }

    public boolean has(String string) {
        return super.containsKey(string);
    }

    public boolean isBoolean(String string) {
        return this.get(string) instanceof Boolean;
    }

    public boolean isNull(String string) {
        return super.containsKey(string) && this.get(string) == null;
    }

    public boolean isNumber(String string) {
        return this.get(string) instanceof Number;
    }

    public boolean isString(String string) {
        return this.get(string) instanceof String;
    }
}

