/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.Core;
import com.bfo.json.SerializerState;
import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;

class INumber
extends Core {
    private final Number value;
    private final byte flags;

    INumber(Number value, byte flags) {
        Float n;
        this.value = value;
        this.flags = flags;
        if (value instanceof Float ? (n = (Float)value).isNaN() || n.isInfinite() : value instanceof Double && ((n = (Double)value).isNaN() || n.isInfinite())) {
            throw new IllegalArgumentException("Infinite or NaN");
        }
    }

    @Override
    Object value() {
        return this.value;
    }

    @Override
    String type() {
        return "number";
    }

    @Override
    boolean booleanValue() {
        if ((this.flags & 1) != 0) {
            throw new ClassCastException("Cannot convert number " + this.value + " to boolean in strict mode");
        }
        return this.value.intValue() != 0;
    }

    @Override
    Number numberValue() {
        return this.value;
    }

    @Override
    void write(Appendable sb, SerializerState state) throws IOException {
        Number n;
        StringBuilder tsb = new StringBuilder();
        if (this.value instanceof Float) {
            n = (Float)this.value;
            if ((((Float)n).isNaN() || ((Float)n).isInfinite()) && !state.options.isAllowNaN()) {
                throw new IllegalArgumentException("Infinite or NaN");
            }
            new Formatter(tsb, Locale.ENGLISH).format(state.options.floatFormat(), n);
        } else if (this.value instanceof Double) {
            n = (Double)this.value;
            if ((((Double)n).isNaN() || ((Double)n).isInfinite()) && !state.options.isAllowNaN()) {
                throw new IllegalArgumentException("Infinite or NaN");
            }
            new Formatter(tsb, Locale.ENGLISH).format(state.options.doubleFormat(), n);
        } else {
            sb.append(this.value.toString());
            return;
        }
        int l = tsb.length() - 1;
        while (tsb.charAt(l) == '0') {
            --l;
        }
        if (tsb.charAt(l) == '.') {
            sb.append(tsb, 0, --l + 1);
        } else {
            sb.append(this.value.toString());
        }
    }
}

