/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.Core;
import com.bfo.json.SerializerState;
import java.io.IOException;
import java.io.Reader;
import java.text.Normalizer;

class IString
extends Core {
    private static final byte FLAG_SIMPLE = 64;
    private final String value;
    private byte flags;
    private static final boolean[] literal = new boolean[128];

    IString(String value, byte flags) {
        this.value = value;
        this.flags = flags;
    }

    @Override
    Object value() {
        return this.value;
    }

    @Override
    String type() {
        return "string";
    }

    @Override
    String stringValue() {
        return this.value;
    }

    private boolean flagTest(String type) {
        if ((this.flags & 1) != 0) {
            throw new ClassCastException("Cannot convert string \"" + this.value + "\" to " + type + " in strict mode");
        }
        if (this.value.trim().toString().length() == 0) {
            if ((this.flags & 2) == 0) {
                throw new ClassCastException("Cannot convert empty string to " + type + " in strict mode");
            }
            return true;
        }
        return false;
    }

    @Override
    boolean booleanValue() {
        if (this.flagTest("boolean")) {
            return false;
        }
        return !"false".equals(this.value) && this.floatValue() != 0.0f;
    }

    @Override
    int intValue() {
        if (this.flagTest("integer")) {
            return 0;
        }
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("Cannot convert ");
                IString.write(this.value, sb);
                sb.append(" to int");
                throw new ClassCastException(sb.toString());
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    long longValue() {
        if (this.flagTest("long")) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("Cannot convert ");
                IString.write(this.value, sb);
                sb.append(" to long");
                throw new ClassCastException(sb.toString());
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    Number numberValue() {
        if (this.flagTest("number")) {
            return 0;
        }
        SimplestReader r = new SimplestReader(this.value);
        boolean valid = true;
        boolean real = false;
        int c = r.read();
        if (c == 45) {
            c = r.read();
        }
        if (c >= 49 && c <= 57) {
            while ((c = r.read()) >= 48 && c <= 57) {
            }
        } else if (c == 48) {
            c = r.read();
        } else {
            valid = false;
        }
        if (valid && c == 46) {
            real = true;
            c = r.read();
            if (c >= 48 && c <= 57) {
                while ((c = r.read()) >= 48 && c <= 57) {
                }
            } else {
                valid = false;
            }
        }
        if (valid && (c == 101 || c == 69)) {
            real = true;
            c = r.read();
            if (c == 45 || c == 43) {
                c = r.read();
            }
            if (c >= 48 && c <= 57) {
                while ((c = r.read()) >= 48 && c <= 57) {
                }
            } else {
                valid = false;
            }
        }
        if (valid && c == -1) {
            try {
                if (!real && this.value.length() < 10) {
                    return Integer.valueOf(this.value);
                }
                if (!real && this.value.length() < 19) {
                    return Long.valueOf(this.value);
                }
                return Double.valueOf(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot convert ");
            IString.write(this.value, sb);
            sb.append(" to number");
            throw new ClassCastException(sb.toString());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    void write(Appendable sb, SerializerState state) throws IOException {
        if (state.options.isNFC()) {
            String v = Normalizer.normalize(this.value, Normalizer.Form.NFC);
            if (IString.write(v, sb) && v.equals(this.value)) {
                this.flags = (byte)(this.flags | 0x40);
            }
        } else if ((this.flags & 0x40) != 0) {
            sb.append('\"');
            sb.append(this.value);
            sb.append('\"');
        } else if (IString.write(this.value, sb)) {
            this.flags = (byte)(this.flags | 0x40);
        }
    }

    static boolean write(String value, Appendable sb) throws IOException {
        sb.append('\"');
        int len = value.length();
        boolean testsimple = true;
        block13: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c < '\u0080') {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    testsimple = false;
                    continue block13;
                }
                case '\b': {
                    sb.append("\\b");
                    testsimple = false;
                    continue block13;
                }
                case '\t': {
                    sb.append("\\t");
                    testsimple = false;
                    continue block13;
                }
                case '\n': {
                    sb.append("\\n");
                    testsimple = false;
                    continue block13;
                }
                case '\f': {
                    sb.append("\\f");
                    testsimple = false;
                    continue block13;
                }
                case '\r': {
                    sb.append("\\r");
                    testsimple = false;
                    continue block13;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c == '\u2028' || c == '\u2029') {
                        String t = Integer.toHexString(c);
                        sb.append("\\u");
                        switch (t.length()) {
                            case 1: {
                                sb.append('0');
                            }
                            case 2: {
                                sb.append('0');
                            }
                            case 3: {
                                sb.append('0');
                            }
                        }
                        sb.append(t);
                        testsimple = false;
                        continue block13;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return testsimple;
    }

    private static int hexnibble(int c) {
        if (c >= 48 & c <= 57) {
            return c - 48;
        }
        if (c <= 70 & c >= 65) {
            return c - 65 + 10;
        }
        if (c <= 102 & c >= 97) {
            return c - 97 + 10;
        }
        if (c < 0) {
            throw new IllegalArgumentException("Unexpected EOF in hex string");
        }
        throw new IllegalArgumentException("Invalid hex digit 0x" + Integer.toHexString(c));
    }

    static int parseString(char quote, Reader reader, StringBuilder sb) throws IOException {
        int c;
        boolean inquotes = true;
        int count = 0;
        while ((c = reader.read()) >= 0) {
            ++count;
            if (c < 128 && literal[c]) {
                sb.append((char)c);
                continue;
            }
            if (c == quote) {
                inquotes = false;
                break;
            }
            if (c == 92) {
                c = reader.read();
                ++count;
                if (c == 92 || c == 34 || c == 47) {
                    sb.append((char)c);
                    continue;
                }
                if (c == 98) {
                    sb.append('\b');
                    continue;
                }
                if (c == 102) {
                    sb.append('\f');
                    continue;
                }
                if (c == 110) {
                    sb.append('\n');
                    continue;
                }
                if (c == 114) {
                    sb.append('\r');
                    continue;
                }
                if (c == 116) {
                    sb.append('\t');
                    continue;
                }
                if (c == 118) {
                    sb.append('\u000b');
                    continue;
                }
                if (c == 117) {
                    int v = IString.hexnibble(reader.read()) << 12 | IString.hexnibble(reader.read()) << 8 | IString.hexnibble(reader.read()) << 4 | IString.hexnibble(reader.read());
                    count += 4;
                    sb.append((char)v);
                    continue;
                }
                throw new IllegalArgumentException("Invalid trailing backslash in string");
            }
            if (!Character.isISOControl(c)) {
                sb.append((char)c);
                continue;
            }
            throw new IllegalArgumentException("Invalid string character 0x" + Integer.toHexString(c));
        }
        if (inquotes) {
            throw new IllegalArgumentException("Unterminated string \"" + sb + "\"");
        }
        return count;
    }

    static {
        for (int c = 0; c < 128; ++c) {
            IString.literal[c] = c == 127 || !Character.isISOControl(c) && c != 92 && c != 34 && c != 39;
        }
    }

    private static class SimplestReader {
        private final CharSequence s;
        private int i;

        SimplestReader(CharSequence s) {
            this.s = s;
        }

        int read() {
            return this.i == this.s.length() ? -1 : (int)this.s.charAt(this.i++);
        }
    }
}

