/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.IBoolean;
import com.bfo.json.IList;
import com.bfo.json.IMap;
import com.bfo.json.INumber;
import com.bfo.json.IString;
import com.bfo.json.Json;
import com.bfo.json.JsonReadOptions;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Normalizer;

class JsonReader {
    private static final Object ENDARRAY = new Object(){

        public String toString() {
            return "]";
        }
    };
    private static final Object ENDMAP = new Object(){

        public String toString() {
            return "}";
        }
    };
    private static final Object COMMA = new Object(){

        public String toString() {
            return ",";
        }
    };
    private static final Object COLON = new Object(){

        public String toString() {
            return ":";
        }
    };

    JsonReader() {
    }

    static Object read(Reader reader, JsonReadOptions options) throws IOException {
        Object o = JsonReader.readToken(reader, null, false, options);
        int c = JsonReader.stripBlanks(reader, options);
        if (c != -1) {
            throw new IllegalArgumentException("Unexpected trailing character '" + (char)c + "'");
        }
        return o;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object readToken(Reader reader, Object additional, boolean iskey, JsonReadOptions options) throws IOException {
        Object out;
        block52: {
            int exp;
            boolean real;
            StringBuilder sb;
            long v;
            int c;
            block50: {
                long q;
                block58: {
                    block49: {
                        Object o;
                        block54: {
                            Object o2;
                            block53: {
                                block55: {
                                    block57: {
                                        block56: {
                                            out = null;
                                            c = JsonReader.stripBlanks(reader, options);
                                            if (c < 0) {
                                                throw new EOFException();
                                            }
                                            if (c == 91) break block53;
                                            if (c == 123) break block54;
                                            if ((c > 57 || c < 48) && c != 45) break block55;
                                            v = 0L;
                                            sb = null;
                                            real = false;
                                            exp = 0;
                                            if (c != 48) break block56;
                                            reader.mark(1);
                                            c = reader.read();
                                            break block50;
                                        }
                                        if (c != 45) break block57;
                                        c = reader.read();
                                        if (c == 48) {
                                            reader.mark(1);
                                            c = reader.read();
                                            break block50;
                                        } else if (c <= 57 && c >= 48) {
                                            reader.mark(1);
                                            v = 48 - c;
                                            break block49;
                                        } else {
                                            reader.reset();
                                            throw new IllegalArgumentException("Invalid token \"-\" at " + reader);
                                        }
                                    }
                                    if (c > 57 || c < 48) break block50;
                                    reader.mark(1);
                                    v = c - 48;
                                    break block58;
                                }
                                if (c == 34) {
                                    if (out == null) {
                                        try {
                                            StringBuilder sb2 = new StringBuilder();
                                            IString.parseString((char)c, reader, sb2);
                                            out = sb2.toString();
                                        }
                                        catch (IllegalArgumentException e) {
                                            throw new IllegalArgumentException(e.getMessage() + " at " + reader);
                                        }
                                    }
                                    if (iskey) return out;
                                    if (!options.isNFC()) return new Json(new IString((String)out, options.storeOptions()));
                                    out = Normalizer.normalize((String)out, Normalizer.Form.NFC);
                                    return new Json(new IString((String)out, options.storeOptions()));
                                }
                                if (!(c != 116 && c != 102 && c != 110 || iskey)) {
                                    StringBuilder sb3 = new StringBuilder();
                                    sb3.append((char)c);
                                    reader.mark(1);
                                    while ((c = reader.read()) >= 0 && c >= 97 && c <= 122 && sb3.length() < 5) {
                                        sb3.append((char)c);
                                        reader.mark(1);
                                    }
                                    reader.reset();
                                    String q2 = sb3.toString();
                                    if (q2.equals("true")) {
                                        return new Json(new IBoolean(true, options.storeOptions()));
                                    }
                                    if (q2.equals("false")) {
                                        return new Json(new IBoolean(false, options.storeOptions()));
                                    }
                                    if (!q2.equals("null")) throw new IllegalArgumentException("Invalid token \"" + q2 + "\" at " + reader);
                                    return new Json(null);
                                }
                                if (c == 93 && additional == ENDARRAY) {
                                    return ENDARRAY;
                                }
                                if (c == 125 && additional == ENDMAP) {
                                    return ENDMAP;
                                }
                                if (!iskey) throw new IllegalArgumentException("Unexpected token '" + (char)c + "' at " + reader);
                                if (!options.isAllowUnquotedKey()) throw new IllegalArgumentException("Unexpected token '" + (char)c + "' at " + reader);
                                StringBuilder sb4 = new StringBuilder();
                                sb4.append((char)c);
                                reader.mark(1);
                                while ((c = reader.read()) >= 0 && (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 45 || c == 46)) {
                                    reader.mark(1);
                                    sb4.append((char)c);
                                }
                                reader.reset();
                                return sb4.toString();
                            }
                            Json list = new Json(new IList());
                            do {
                                if ((o2 = JsonReader.readToken(reader, ENDARRAY, false, options)) == ENDARRAY) {
                                    if (list.size() == 0) return list;
                                    if (!options.isAllowTrailingComma()) throw new IllegalArgumentException("Unexpected token " + o2 + " at " + reader);
                                    return list;
                                }
                                if (!(o2 instanceof Json)) throw new IllegalArgumentException("Unexpected response " + o2);
                                Json child = (Json)o2;
                                int size = list.size();
                                list._listValue().add(child);
                                Json.notify(list, size, null, child);
                                o2 = JsonReader.readEnd(reader, options);
                                if (o2 == ENDARRAY) return list;
                            } while (o2 == COMMA);
                            throw new IllegalArgumentException("Unexpected token " + o2 + " at " + reader);
                        }
                        Json map = new Json(new IMap());
                        do {
                            Object key;
                            if ((key = JsonReader.readToken(reader, ENDMAP, true, options)) == ENDMAP) {
                                if (map.size() == 0) return map;
                                if (!options.isAllowTrailingComma()) throw new IllegalArgumentException("Unexpected token " + key + " at " + reader);
                                return map;
                            }
                            if (!(key instanceof String)) {
                                throw new IllegalArgumentException("Invalid object key " + key + " at " + reader);
                            }
                            o = JsonReader.readEnd(reader, options);
                            if (o != COLON) {
                                throw new IllegalArgumentException("Unexpected token " + o + " at " + reader);
                            }
                            Json child = (Json)JsonReader.readToken(reader, null, false, options);
                            if (options.isNFC()) {
                                key = Normalizer.normalize((String)key, Normalizer.Form.NFC);
                            }
                            map._mapValue().put((String)key, child);
                            Json.notify(map, key, null, child);
                            o = JsonReader.readEnd(reader, options);
                            if (o == ENDMAP) return map;
                        } while (o == COMMA);
                        throw new IllegalArgumentException("Unexpected token " + o + " at " + reader);
                    }
                    while ((c = reader.read()) <= 57 && c >= 48) {
                        reader.mark(1);
                        q = v * 10L - (long)(c - 48);
                        if (q >= 0L) {
                            sb = new StringBuilder();
                            sb.append(v);
                            sb.append((char)c);
                            while ((c = reader.read()) <= 57 && c >= 48) {
                                reader.mark(1);
                                sb.append((char)c);
                            }
                            break block50;
                        }
                        v = q;
                    }
                    break block50;
                }
                while ((c = reader.read()) <= 57 && c >= 48) {
                    reader.mark(1);
                    q = v * 10L + (long)(c - 48);
                    if (q < 0L) {
                        sb = new StringBuilder();
                        sb.append(v);
                        sb.append((char)c);
                        while ((c = reader.read()) <= 57 && c >= 48) {
                            reader.mark(1);
                            sb.append((char)c);
                        }
                        break;
                    }
                    v = q;
                }
            }
            if (c == 46) {
                real = true;
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(v);
                }
                sb.append((char)c);
                reader.mark(1);
                c = reader.read();
                if (c >= 48 && c <= 57) {
                    sb.append((char)c);
                    reader.mark(1);
                    while ((c = reader.read()) <= 57 && c >= 48) {
                        reader.mark(1);
                        sb.append((char)c);
                    }
                } else {
                    reader.reset();
                    throw new IllegalArgumentException("Invalid number \"" + sb + "\" at " + reader);
                }
            }
            if (c == 101 || c == 69) {
                exp = 1;
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(v);
                }
                sb.append('E');
                reader.mark(1);
                c = reader.read();
                if (c == 43) {
                    reader.mark(1);
                    c = reader.read();
                } else if (c == 45) {
                    sb.append((char)c);
                    reader.mark(1);
                    real = true;
                    c = reader.read();
                }
                if (c < 48) throw new IllegalArgumentException("Invalid number \"" + sb + "\" at " + reader);
                if (c > 57) throw new IllegalArgumentException("Invalid number \"" + sb + "\" at " + reader);
                reader.mark(1);
                sb.append((char)c);
                while ((c = reader.read()) <= 57 && c >= 48) {
                    reader.mark(1);
                    sb.append((char)c);
                    exp = (short)(exp + 1);
                }
            }
            if (sb == null) {
                int iv = (int)v;
                out = v == (long)iv ? new Json(new INumber(iv, options.storeOptions())) : new Json(new INumber(v, options.storeOptions()));
            } else {
                String s = sb.toString();
                try {
                    if (real) {
                        BigDecimal bd;
                        double d2;
                        Double d;
                        block51: {
                            d = null;
                            try {
                                if (exp >= 2) break block51;
                                d = Double.valueOf(s);
                                if (d.isInfinite()) {
                                    d = null;
                                    break block51;
                                }
                                if (!options.isBigDecimal() && !d.toString().equals(s)) {
                                    d = null;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        out = d == null ? (Double.isFinite(d2 = (bd = new BigDecimal(s)).doubleValue()) && bd.equals(new BigDecimal(d2)) ? new Json(new INumber(d, options.storeOptions())) : new Json(new INumber(bd, options.storeOptions()))) : new Json(new INumber(d, options.storeOptions()));
                        break block52;
                    }
                    out = exp != 0 ? new Json(new INumber(new BigDecimal(s).toBigInteger(), options.storeOptions())) : new Json(new INumber(new BigInteger(s), options.storeOptions()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid number \"" + s + "\" at " + reader, e);
                }
            }
        }
        reader.reset();
        return out;
    }

    private static Object readEnd(Reader reader, JsonReadOptions options) throws IOException, IllegalArgumentException {
        Object out;
        int c = JsonReader.stripBlanks(reader, options);
        if (c == 93) {
            out = ENDARRAY;
        } else if (c == 125) {
            out = ENDMAP;
        } else if (c == 44) {
            out = COMMA;
        } else if (c == 58) {
            out = COLON;
        } else {
            if (c == -1) {
                throw new EOFException();
            }
            throw new IllegalArgumentException("Unexpected character '" + (char)c + "' at " + reader);
        }
        return out;
    }

    private static int stripBlanks(Reader reader, JsonReadOptions options) throws IOException {
        int c;
        while ((c = reader.read()) >= 0 && (c == 32 || c == 10 || c == 9 || c == 13)) {
        }
        if (c == 47) {
            reader.mark(1);
            c = reader.read();
            if (c == 42) {
                if (!options.isAllowComments()) {
                    reader.reset();
                    throw new IllegalArgumentException("Comments disallowed");
                }
                StringBuilder comment = new StringBuilder();
                comment.append("/*");
                int lastc = reader.read();
                while ((c = reader.read()) >= 0 && (c != 47 || lastc != 42)) {
                    comment.append((char)lastc);
                    lastc = c;
                }
                if (lastc < 0) {
                    throw new IllegalArgumentException("Unterminated comment");
                }
                comment.append("*/");
                return JsonReader.stripBlanks(reader, options);
            }
            if (c < 0) {
                throw new EOFException("Trailing /");
            }
            reader.reset();
        }
        return c;
    }
}

