static int testdarray_from_lit(void);
static int testdarray_append_lit(void);
static int testdarray_prepend_lit(void);

static void testLits(void) {
	testing(darray_from_lit);
	ok1(testdarray_from_lit());
	
	testing(testdarray_append_lit);
	ok1(testdarray_append_lit());
	
	testing(testdarray_prepend_lit);
	ok1(testdarray_prepend_lit());
}

static int testdarray_from_lit(void) {
	darray_char a = darray_new();
	size_t testsPassed = 0;
	size_t len = 0;
	
		/* Test 0 */
		darray_from_lit(a, "\xC0\x19\xDE\x94\xC9\xB1_\xDF\xBEr[\xBB\x43\x65\xC7\xD8\x93\xB7\x16u\x1D\x8C\x64\x91\xF5\xDE*GC\xECp\xCA!\x15\xF0\x07(b(\x87\xE0nDP\xC5\x1C\xC5\xB4\x38\xC3i\xA6\xEE\x81\xB0p\x9C\x94\xA2w\xA2$\xF5%rS\xF3\\f\x1A\xF4\xFC\x93\xDD'\xE8\xA7\x11\xF4\xF7\xC9\xCE\x92I\xF6\x94p");
		len = strlen("\xC0\x19\xDE\x94\xC9\xB1_\xDF\xBEr[\xBB\x43\x65\xC7\xD8\x93\xB7\x16u\x1D\x8C\x64\x91\xF5\xDE*GC\xECp\xCA!\x15\xF0\x07(b(\x87\xE0nDP\xC5\x1C\xC5\xB4\x38\xC3i\xA6\xEE\x81\xB0p\x9C\x94\xA2w\xA2$\xF5%rS\xF3\\f\x1A\xF4\xFC\x93\xDD'\xE8\xA7\x11\xF4\xF7\xC9\xCE\x92I\xF6\x94p");
		if (len != sizeof("\xC0\x19\xDE\x94\xC9\xB1_\xDF\xBEr[\xBB\x43\x65\xC7\xD8\x93\xB7\x16u\x1D\x8C\x64\x91\xF5\xDE*GC\xECp\xCA!\x15\xF0\x07(b(\x87\xE0nDP\xC5\x1C\xC5\xB4\x38\xC3i\xA6\xEE\x81\xB0p\x9C\x94\xA2w\xA2$\xF5%rS\xF3\\f\x1A\xF4\xFC\x93\xDD'\xE8\xA7\x11\xF4\xF7\xC9\xCE\x92I\xF6\x94p")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "\xC0\x19\xDE\x94\xC9\xB1_\xDF\xBEr[\xBB\x43\x65\xC7\xD8\x93\xB7\x16u\x1D\x8C\x64\x91\xF5\xDE*GC\xECp\xCA!\x15\xF0\x07(b(\x87\xE0nDP\xC5\x1C\xC5\xB4\x38\xC3i\xA6\xEE\x81\xB0p\x9C\x94\xA2w\xA2$\xF5%rS\xF3\\f\x1A\xF4\xFC\x93\xDD'\xE8\xA7\x11\xF4\xF7\xC9\xCE\x92I\xF6\x94p"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 1 */
		darray_from_lit(a, "\xEC\x08\xC5\xB9\x97m\xA4\xBF\x12\x0E\xC6\xB4\x1FN\x13\xB0^\xBB\x32(*\xD5\x8DQ\x87o7\xBB\x01\x96z\xF0\xC3!\x04\x80\xD8\xDA\x18\xDB\xCA\x94\x1A\xD4\xBF\xE8\x83\xE2\xF6\x91yk\xA6\xE1\x96\x39\xFF)\xB2\xB3\xFC\xA6\xA7\xD8\xAE\xF8U\xCD)\xDD\x9Al\xFB\xDEw?\xD8\xD8\xBC\"z\xC9\x7F\x92r\tUm\x95\x17\xAD\x96=\xBE\xF5\xDD\x13\x8A\x62\x01\xB7\x0E\x06\xC2\xA1\xEE\x8Cje3O6\x9C_)v\xCD/\xB8z%\xA2> \xDF\x1B\xC1\x62\x8E\x14\x61\xA0\xCAl\xD3\x8D\xBA}C\x7F}~\xD9\xEB]\x8C\x9B\x9Cq\xB5\x38\xC4O\xC9\x17\xE6\xEF\xF7\x9E\x12\x1D\xA1\x13\x8F<\x9D\xEF\x92\x93w\x1F=\xFF\x8F\xDDJ\xBB\xD2}\x98\x1D)\xB3\x98\xE2n6/\xB0\x38\x44");
		len = strlen("\xEC\x08\xC5\xB9\x97m\xA4\xBF\x12\x0E\xC6\xB4\x1FN\x13\xB0^\xBB\x32(*\xD5\x8DQ\x87o7\xBB\x01\x96z\xF0\xC3!\x04\x80\xD8\xDA\x18\xDB\xCA\x94\x1A\xD4\xBF\xE8\x83\xE2\xF6\x91yk\xA6\xE1\x96\x39\xFF)\xB2\xB3\xFC\xA6\xA7\xD8\xAE\xF8U\xCD)\xDD\x9Al\xFB\xDEw?\xD8\xD8\xBC\"z\xC9\x7F\x92r\tUm\x95\x17\xAD\x96=\xBE\xF5\xDD\x13\x8A\x62\x01\xB7\x0E\x06\xC2\xA1\xEE\x8Cje3O6\x9C_)v\xCD/\xB8z%\xA2> \xDF\x1B\xC1\x62\x8E\x14\x61\xA0\xCAl\xD3\x8D\xBA}C\x7F}~\xD9\xEB]\x8C\x9B\x9Cq\xB5\x38\xC4O\xC9\x17\xE6\xEF\xF7\x9E\x12\x1D\xA1\x13\x8F<\x9D\xEF\x92\x93w\x1F=\xFF\x8F\xDDJ\xBB\xD2}\x98\x1D)\xB3\x98\xE2n6/\xB0\x38\x44");
		if (len != sizeof("\xEC\x08\xC5\xB9\x97m\xA4\xBF\x12\x0E\xC6\xB4\x1FN\x13\xB0^\xBB\x32(*\xD5\x8DQ\x87o7\xBB\x01\x96z\xF0\xC3!\x04\x80\xD8\xDA\x18\xDB\xCA\x94\x1A\xD4\xBF\xE8\x83\xE2\xF6\x91yk\xA6\xE1\x96\x39\xFF)\xB2\xB3\xFC\xA6\xA7\xD8\xAE\xF8U\xCD)\xDD\x9Al\xFB\xDEw?\xD8\xD8\xBC\"z\xC9\x7F\x92r\tUm\x95\x17\xAD\x96=\xBE\xF5\xDD\x13\x8A\x62\x01\xB7\x0E\x06\xC2\xA1\xEE\x8Cje3O6\x9C_)v\xCD/\xB8z%\xA2> \xDF\x1B\xC1\x62\x8E\x14\x61\xA0\xCAl\xD3\x8D\xBA}C\x7F}~\xD9\xEB]\x8C\x9B\x9Cq\xB5\x38\xC4O\xC9\x17\xE6\xEF\xF7\x9E\x12\x1D\xA1\x13\x8F<\x9D\xEF\x92\x93w\x1F=\xFF\x8F\xDDJ\xBB\xD2}\x98\x1D)\xB3\x98\xE2n6/\xB0\x38\x44")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "\xEC\x08\xC5\xB9\x97m\xA4\xBF\x12\x0E\xC6\xB4\x1FN\x13\xB0^\xBB\x32(*\xD5\x8DQ\x87o7\xBB\x01\x96z\xF0\xC3!\x04\x80\xD8\xDA\x18\xDB\xCA\x94\x1A\xD4\xBF\xE8\x83\xE2\xF6\x91yk\xA6\xE1\x96\x39\xFF)\xB2\xB3\xFC\xA6\xA7\xD8\xAE\xF8U\xCD)\xDD\x9Al\xFB\xDEw?\xD8\xD8\xBC\"z\xC9\x7F\x92r\tUm\x95\x17\xAD\x96=\xBE\xF5\xDD\x13\x8A\x62\x01\xB7\x0E\x06\xC2\xA1\xEE\x8Cje3O6\x9C_)v\xCD/\xB8z%\xA2> \xDF\x1B\xC1\x62\x8E\x14\x61\xA0\xCAl\xD3\x8D\xBA}C\x7F}~\xD9\xEB]\x8C\x9B\x9Cq\xB5\x38\xC4O\xC9\x17\xE6\xEF\xF7\x9E\x12\x1D\xA1\x13\x8F<\x9D\xEF\x92\x93w\x1F=\xFF\x8F\xDDJ\xBB\xD2}\x98\x1D)\xB3\x98\xE2n6/\xB0\x38\x44"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 2 */
		darray_from_lit(a, "~Er=L\xA6\xC0\xB1m\xC2\x66`\xA4\x89\xE6\xA8\xEE\x03,\xA5\xC4\xAD\xC5\xC1\xE5\x38\xA3\x99\x9F^\x13\x41]|\x81J=\xA9\xE5\xAC\f\xD6\x92/\x07z\x90+\x9C\xA4O\xF4\xC4\xA3\x12\"\xC2{\xB7\x1E\xA4\x66\xB5\xC8\xB4\x45\xC8#G\x15\x37\x33\x9E\x9B\x8D\x91 \x13\xE2(\x91QV5\xAD\v\v\xD1\x11\xB5i\xE3\xF0\x01Z\xF0\xFD\\\xFA\x07W\xD8p\xB4\x92\x1B/>\xAF\xFC\x83\xE6x");
		len = strlen("~Er=L\xA6\xC0\xB1m\xC2\x66`\xA4\x89\xE6\xA8\xEE\x03,\xA5\xC4\xAD\xC5\xC1\xE5\x38\xA3\x99\x9F^\x13\x41]|\x81J=\xA9\xE5\xAC\f\xD6\x92/\x07z\x90+\x9C\xA4O\xF4\xC4\xA3\x12\"\xC2{\xB7\x1E\xA4\x66\xB5\xC8\xB4\x45\xC8#G\x15\x37\x33\x9E\x9B\x8D\x91 \x13\xE2(\x91QV5\xAD\v\v\xD1\x11\xB5i\xE3\xF0\x01Z\xF0\xFD\\\xFA\x07W\xD8p\xB4\x92\x1B/>\xAF\xFC\x83\xE6x");
		if (len != sizeof("~Er=L\xA6\xC0\xB1m\xC2\x66`\xA4\x89\xE6\xA8\xEE\x03,\xA5\xC4\xAD\xC5\xC1\xE5\x38\xA3\x99\x9F^\x13\x41]|\x81J=\xA9\xE5\xAC\f\xD6\x92/\x07z\x90+\x9C\xA4O\xF4\xC4\xA3\x12\"\xC2{\xB7\x1E\xA4\x66\xB5\xC8\xB4\x45\xC8#G\x15\x37\x33\x9E\x9B\x8D\x91 \x13\xE2(\x91QV5\xAD\v\v\xD1\x11\xB5i\xE3\xF0\x01Z\xF0\xFD\\\xFA\x07W\xD8p\xB4\x92\x1B/>\xAF\xFC\x83\xE6x")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "~Er=L\xA6\xC0\xB1m\xC2\x66`\xA4\x89\xE6\xA8\xEE\x03,\xA5\xC4\xAD\xC5\xC1\xE5\x38\xA3\x99\x9F^\x13\x41]|\x81J=\xA9\xE5\xAC\f\xD6\x92/\x07z\x90+\x9C\xA4O\xF4\xC4\xA3\x12\"\xC2{\xB7\x1E\xA4\x66\xB5\xC8\xB4\x45\xC8#G\x15\x37\x33\x9E\x9B\x8D\x91 \x13\xE2(\x91QV5\xAD\v\v\xD1\x11\xB5i\xE3\xF0\x01Z\xF0\xFD\\\xFA\x07W\xD8p\xB4\x92\x1B/>\xAF\xFC\x83\xE6x"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 3 */
		darray_from_lit(a, "h\xC2\x1E&\xB3\x43\x88\x11&i\x16\xA3\x05>\x94*D\x14&\x17%x\xB9z\x8F\x7F\x15LLU\x16\x1A\x34\x1C-\xD6\xD3\xEC\x89y\xB3\x82\xC4\xFBw\xAC\xE4\xDA\xC1\xB7\x17\xCC`u]\xC6\x99\x0F \x8F\xA8\x11\x86\xD8)\x01\xE6\x38\x30\xF7\xD1\xB6\x96\xAE\xC6<8`\xD3*\x9D p\x01\x85v\xB0\th\x81H\xFF]_\xF3\x15\x9D\xCB[\xF8/n\xC9\x1E\x89>\x9E\xC7/~\xEFQ\\\x1A_\xE4\xE5\xFC\x1C'\xEF\xC8\xE0\x43!\x8AYc_y\xBB\xEE\x7Fy\xF4Ms\xD2\x62\xBAY\xA9\xDC\xAA\xCE\xEDSz\x92m\xF2\x17mO\xB3[\x89\x1E\xBC\xED$\xF1\x07g4\x1B\nhr\xAF\x42\xCF\x1A\xA6\x83\x80(\xA2\x1C\x37\xE3\xFC\x05\xDC\x1F#\x92\"\xDD\x8BrRn\xF7\xCF\xB8\xD8\xEE\x1EwdaA#\xA0\x9E}\x85\xC8Gm\x1C<\xE7\x95\xD0\xC8\xB5X\xEF\x35\xB9\xD6XTW\x88\x8E\x05u\x80\x41\x83?\x9CL\xEA\x92L|%");
		len = strlen("h\xC2\x1E&\xB3\x43\x88\x11&i\x16\xA3\x05>\x94*D\x14&\x17%x\xB9z\x8F\x7F\x15LLU\x16\x1A\x34\x1C-\xD6\xD3\xEC\x89y\xB3\x82\xC4\xFBw\xAC\xE4\xDA\xC1\xB7\x17\xCC`u]\xC6\x99\x0F \x8F\xA8\x11\x86\xD8)\x01\xE6\x38\x30\xF7\xD1\xB6\x96\xAE\xC6<8`\xD3*\x9D p\x01\x85v\xB0\th\x81H\xFF]_\xF3\x15\x9D\xCB[\xF8/n\xC9\x1E\x89>\x9E\xC7/~\xEFQ\\\x1A_\xE4\xE5\xFC\x1C'\xEF\xC8\xE0\x43!\x8AYc_y\xBB\xEE\x7Fy\xF4Ms\xD2\x62\xBAY\xA9\xDC\xAA\xCE\xEDSz\x92m\xF2\x17mO\xB3[\x89\x1E\xBC\xED$\xF1\x07g4\x1B\nhr\xAF\x42\xCF\x1A\xA6\x83\x80(\xA2\x1C\x37\xE3\xFC\x05\xDC\x1F#\x92\"\xDD\x8BrRn\xF7\xCF\xB8\xD8\xEE\x1EwdaA#\xA0\x9E}\x85\xC8Gm\x1C<\xE7\x95\xD0\xC8\xB5X\xEF\x35\xB9\xD6XTW\x88\x8E\x05u\x80\x41\x83?\x9CL\xEA\x92L|%");
		if (len != sizeof("h\xC2\x1E&\xB3\x43\x88\x11&i\x16\xA3\x05>\x94*D\x14&\x17%x\xB9z\x8F\x7F\x15LLU\x16\x1A\x34\x1C-\xD6\xD3\xEC\x89y\xB3\x82\xC4\xFBw\xAC\xE4\xDA\xC1\xB7\x17\xCC`u]\xC6\x99\x0F \x8F\xA8\x11\x86\xD8)\x01\xE6\x38\x30\xF7\xD1\xB6\x96\xAE\xC6<8`\xD3*\x9D p\x01\x85v\xB0\th\x81H\xFF]_\xF3\x15\x9D\xCB[\xF8/n\xC9\x1E\x89>\x9E\xC7/~\xEFQ\\\x1A_\xE4\xE5\xFC\x1C'\xEF\xC8\xE0\x43!\x8AYc_y\xBB\xEE\x7Fy\xF4Ms\xD2\x62\xBAY\xA9\xDC\xAA\xCE\xEDSz\x92m\xF2\x17mO\xB3[\x89\x1E\xBC\xED$\xF1\x07g4\x1B\nhr\xAF\x42\xCF\x1A\xA6\x83\x80(\xA2\x1C\x37\xE3\xFC\x05\xDC\x1F#\x92\"\xDD\x8BrRn\xF7\xCF\xB8\xD8\xEE\x1EwdaA#\xA0\x9E}\x85\xC8Gm\x1C<\xE7\x95\xD0\xC8\xB5X\xEF\x35\xB9\xD6XTW\x88\x8E\x05u\x80\x41\x83?\x9CL\xEA\x92L|%")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "h\xC2\x1E&\xB3\x43\x88\x11&i\x16\xA3\x05>\x94*D\x14&\x17%x\xB9z\x8F\x7F\x15LLU\x16\x1A\x34\x1C-\xD6\xD3\xEC\x89y\xB3\x82\xC4\xFBw\xAC\xE4\xDA\xC1\xB7\x17\xCC`u]\xC6\x99\x0F \x8F\xA8\x11\x86\xD8)\x01\xE6\x38\x30\xF7\xD1\xB6\x96\xAE\xC6<8`\xD3*\x9D p\x01\x85v\xB0\th\x81H\xFF]_\xF3\x15\x9D\xCB[\xF8/n\xC9\x1E\x89>\x9E\xC7/~\xEFQ\\\x1A_\xE4\xE5\xFC\x1C'\xEF\xC8\xE0\x43!\x8AYc_y\xBB\xEE\x7Fy\xF4Ms\xD2\x62\xBAY\xA9\xDC\xAA\xCE\xEDSz\x92m\xF2\x17mO\xB3[\x89\x1E\xBC\xED$\xF1\x07g4\x1B\nhr\xAF\x42\xCF\x1A\xA6\x83\x80(\xA2\x1C\x37\xE3\xFC\x05\xDC\x1F#\x92\"\xDD\x8BrRn\xF7\xCF\xB8\xD8\xEE\x1EwdaA#\xA0\x9E}\x85\xC8Gm\x1C<\xE7\x95\xD0\xC8\xB5X\xEF\x35\xB9\xD6XTW\x88\x8E\x05u\x80\x41\x83?\x9CL\xEA\x92L|%"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 4 */
		darray_from_lit(a, "\"\xD3\x84h)\xB7{\xB8\xDB\xD6y\xE9\x16+\xAD\xC4\xE9n\xDBZ\xAB\x38}3ic\xDE\x64\xC4\x91`\xE7\xD9I\xDC\xF8\xC3*/\x85P\xFB\xB7\x95lk5\xF4\xE2\x02\x15K\xDE\xF9\xA4l\xDEQ\xFE\x14G\xD5\t\xC3\x62;\rU\xF9\xBF\x99\x9F\x9D\x92U\x9D\x66\xBC\x06\x63\x9D\x99\xF0\xCA\xD2\xD2\x9EO\xD2\f2\x96.p\x81\x82wP*\xC0m\x93\xD9\xCB \xED\x94r\xA9:\vU\x19i\xAD\x88\x12\xD1\x1CP\xE5&*\xD7\x06\xFE\x90\x96N\"\xF4\x1A \x89\x64\x38\x65\x32\xF5\x8B\xB5V\xD3\x8A\xC6\n\xF0\xC7u\xEC!\x10\xE5\x42\xE5\x61\x05\x94\x9B\x11v\xC8n%5\xEA\xBC\x41K(\xF6\xD8.\xADS+\xCB\xAD\xAE@;\xAFP^\xD9\xDD\xC1\x1F:\xFA\v\x99\x85g3\xAC\x84\xC8xA\x1F\xA2\x9E\x89\x1F\x41\x08\x61\x41\x9C\x06\x07\x46\xF1\xBE\x83\x42\xF9\xAA\xD5\r\x8AUZ\x1E-\xF7\xD4\x9D\xAC\x04\xFF#\no\xBF\xC5\x9E\n0\x12\x64\x96\xFF\xF5'\xD6j\x10'\xE7\xB2rB2X\xBCY\xD9\x44\x9E\x1E\xBB-\t\x84+\xA8[z\x87\xF8\xE3K\xD1R'\xB0\xBA\x13\xBF\x64\xFA\x85g\x81{\xC6\xDC\xBA\xCF\x85wd\xC3u\xDC\x33\xF0t\\.&<\x92~\xC4_\xCF\xBC\xB9\xE9\x31\x65\x1B\x1F+\xEF\x32\xD3\xEB,\xE6\x36\x06*3\xB0");
		len = strlen("\"\xD3\x84h)\xB7{\xB8\xDB\xD6y\xE9\x16+\xAD\xC4\xE9n\xDBZ\xAB\x38}3ic\xDE\x64\xC4\x91`\xE7\xD9I\xDC\xF8\xC3*/\x85P\xFB\xB7\x95lk5\xF4\xE2\x02\x15K\xDE\xF9\xA4l\xDEQ\xFE\x14G\xD5\t\xC3\x62;\rU\xF9\xBF\x99\x9F\x9D\x92U\x9D\x66\xBC\x06\x63\x9D\x99\xF0\xCA\xD2\xD2\x9EO\xD2\f2\x96.p\x81\x82wP*\xC0m\x93\xD9\xCB \xED\x94r\xA9:\vU\x19i\xAD\x88\x12\xD1\x1CP\xE5&*\xD7\x06\xFE\x90\x96N\"\xF4\x1A \x89\x64\x38\x65\x32\xF5\x8B\xB5V\xD3\x8A\xC6\n\xF0\xC7u\xEC!\x10\xE5\x42\xE5\x61\x05\x94\x9B\x11v\xC8n%5\xEA\xBC\x41K(\xF6\xD8.\xADS+\xCB\xAD\xAE@;\xAFP^\xD9\xDD\xC1\x1F:\xFA\v\x99\x85g3\xAC\x84\xC8xA\x1F\xA2\x9E\x89\x1F\x41\x08\x61\x41\x9C\x06\x07\x46\xF1\xBE\x83\x42\xF9\xAA\xD5\r\x8AUZ\x1E-\xF7\xD4\x9D\xAC\x04\xFF#\no\xBF\xC5\x9E\n0\x12\x64\x96\xFF\xF5'\xD6j\x10'\xE7\xB2rB2X\xBCY\xD9\x44\x9E\x1E\xBB-\t\x84+\xA8[z\x87\xF8\xE3K\xD1R'\xB0\xBA\x13\xBF\x64\xFA\x85g\x81{\xC6\xDC\xBA\xCF\x85wd\xC3u\xDC\x33\xF0t\\.&<\x92~\xC4_\xCF\xBC\xB9\xE9\x31\x65\x1B\x1F+\xEF\x32\xD3\xEB,\xE6\x36\x06*3\xB0");
		if (len != sizeof("\"\xD3\x84h)\xB7{\xB8\xDB\xD6y\xE9\x16+\xAD\xC4\xE9n\xDBZ\xAB\x38}3ic\xDE\x64\xC4\x91`\xE7\xD9I\xDC\xF8\xC3*/\x85P\xFB\xB7\x95lk5\xF4\xE2\x02\x15K\xDE\xF9\xA4l\xDEQ\xFE\x14G\xD5\t\xC3\x62;\rU\xF9\xBF\x99\x9F\x9D\x92U\x9D\x66\xBC\x06\x63\x9D\x99\xF0\xCA\xD2\xD2\x9EO\xD2\f2\x96.p\x81\x82wP*\xC0m\x93\xD9\xCB \xED\x94r\xA9:\vU\x19i\xAD\x88\x12\xD1\x1CP\xE5&*\xD7\x06\xFE\x90\x96N\"\xF4\x1A \x89\x64\x38\x65\x32\xF5\x8B\xB5V\xD3\x8A\xC6\n\xF0\xC7u\xEC!\x10\xE5\x42\xE5\x61\x05\x94\x9B\x11v\xC8n%5\xEA\xBC\x41K(\xF6\xD8.\xADS+\xCB\xAD\xAE@;\xAFP^\xD9\xDD\xC1\x1F:\xFA\v\x99\x85g3\xAC\x84\xC8xA\x1F\xA2\x9E\x89\x1F\x41\x08\x61\x41\x9C\x06\x07\x46\xF1\xBE\x83\x42\xF9\xAA\xD5\r\x8AUZ\x1E-\xF7\xD4\x9D\xAC\x04\xFF#\no\xBF\xC5\x9E\n0\x12\x64\x96\xFF\xF5'\xD6j\x10'\xE7\xB2rB2X\xBCY\xD9\x44\x9E\x1E\xBB-\t\x84+\xA8[z\x87\xF8\xE3K\xD1R'\xB0\xBA\x13\xBF\x64\xFA\x85g\x81{\xC6\xDC\xBA\xCF\x85wd\xC3u\xDC\x33\xF0t\\.&<\x92~\xC4_\xCF\xBC\xB9\xE9\x31\x65\x1B\x1F+\xEF\x32\xD3\xEB,\xE6\x36\x06*3\xB0")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "\"\xD3\x84h)\xB7{\xB8\xDB\xD6y\xE9\x16+\xAD\xC4\xE9n\xDBZ\xAB\x38}3ic\xDE\x64\xC4\x91`\xE7\xD9I\xDC\xF8\xC3*/\x85P\xFB\xB7\x95lk5\xF4\xE2\x02\x15K\xDE\xF9\xA4l\xDEQ\xFE\x14G\xD5\t\xC3\x62;\rU\xF9\xBF\x99\x9F\x9D\x92U\x9D\x66\xBC\x06\x63\x9D\x99\xF0\xCA\xD2\xD2\x9EO\xD2\f2\x96.p\x81\x82wP*\xC0m\x93\xD9\xCB \xED\x94r\xA9:\vU\x19i\xAD\x88\x12\xD1\x1CP\xE5&*\xD7\x06\xFE\x90\x96N\"\xF4\x1A \x89\x64\x38\x65\x32\xF5\x8B\xB5V\xD3\x8A\xC6\n\xF0\xC7u\xEC!\x10\xE5\x42\xE5\x61\x05\x94\x9B\x11v\xC8n%5\xEA\xBC\x41K(\xF6\xD8.\xADS+\xCB\xAD\xAE@;\xAFP^\xD9\xDD\xC1\x1F:\xFA\v\x99\x85g3\xAC\x84\xC8xA\x1F\xA2\x9E\x89\x1F\x41\x08\x61\x41\x9C\x06\x07\x46\xF1\xBE\x83\x42\xF9\xAA\xD5\r\x8AUZ\x1E-\xF7\xD4\x9D\xAC\x04\xFF#\no\xBF\xC5\x9E\n0\x12\x64\x96\xFF\xF5'\xD6j\x10'\xE7\xB2rB2X\xBCY\xD9\x44\x9E\x1E\xBB-\t\x84+\xA8[z\x87\xF8\xE3K\xD1R'\xB0\xBA\x13\xBF\x64\xFA\x85g\x81{\xC6\xDC\xBA\xCF\x85wd\xC3u\xDC\x33\xF0t\\.&<\x92~\xC4_\xCF\xBC\xB9\xE9\x31\x65\x1B\x1F+\xEF\x32\xD3\xEB,\xE6\x36\x06*3\xB0"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 5 */
		darray_from_lit(a, "\x16\x33\xBB\xD6\xAB\xCC\n\xBC{\xD3\xC0\xC2>Gc\xAC\xAB\xC8T\xBA\x17\x30`\x8E\x8D\xACs\x93]\xF8\x96\xDE\x07\n\xBF\x35\\[\xA7\xDF\x38\xFC\xCC\na\xFFx\x96\x05\xFD'\r&\xFE\x35\xB5\xBAY\x14=\xE2\x1D\x9B_S^\x1C\ne\xC4\xED\x89\x88\x07\x1En\x1A\x32vV\xE2m\x93\x94`]'\x07\xFE*\x1F\xAB\x96\xBAQZtfOa\xE5\x19\xDB\x13@/\x9F\x96\x37u\x9C\xEE\x0Fh\x80w\xBB\xE4\xB5\x12\x83\x83\x0F\xC0\x1BK\xE9\xDD_\x07\xB3\r\x95\xF1\xDAs\x91\xCE\x9EI\x88\xC7\x15\xC6@\xD1W\x15/c\x97\xDD\x41:P\x93\xF0\xB7\x42\x16\xFA\x84Zv[\xCC\x39\xA1*xcV\x90\xB3\xC4!\x03\xB1\xC3\x43$U\xC5;\xE5\xA2\x92Y]\xB5\x14U'\x12\x44oE\xCB^\x06\x89\x14\xCC\x97<\xFFi\xC8\x8D\xDB\x10\xD2\xA0\vtw>\xD7Q\xA8\xA1\xEA\xA6\x84\xED\xB6\x8C\x84za,|\x1Ahm\x98\x34j\x92k\xE3\x39\xAC\xCE\x96\xF8\x81\xD2\x9C\xB1)\xA2\xF8Y\xA7\x88G\r\xECN\x8D`\x1Bl\x80\xAB\xB6\x61/\xE4\xE9(\xE0\x1C]\x02\xE2\xB1\xD8O\xB4\xFFp{\xE5\x96\x8D\x16\xFC]+J\xC5\xFD\x89j\xB0\x82\xA3\xD8\xDB\xE5Y\xCA\x96\x39\x88<z\x01RP\x7Fz\x94\xDFRK\x15x0\x8B\xF0\xAA\xD1\x32\xBF\xED\x34\xFC\x63S\xCC\x38y9\x91\xB6*\xD7?\xBD|\x84\x93\xE3\xBD\xC3\xEFyP\xC8\xF5\x64|\xB0\x62\t*\x9C\x39\n\x93\xBA\xF8\xD9\xE1\x97r\xCE\xF2\xFE\r\xB6\xE1\xAA~\xEE\x33\x08u\x12\xC8\x17\x90\xBF\xC1\xFE;YF\x9F\xD9\xE4y\xD9I`\xC6\x93j\x94\x02\x34\x65OB\x9F\x99Z\v\x8A\x1AJ@\xFE\xCB\xFCly+f\xC7\x8F\x1A\xFD\xBDJ\xAFhnk\x15G\xCC\x9DPI?B\xDD\xBC\x9B\x12\xE8\x42y8");
		len = strlen("\x16\x33\xBB\xD6\xAB\xCC\n\xBC{\xD3\xC0\xC2>Gc\xAC\xAB\xC8T\xBA\x17\x30`\x8E\x8D\xACs\x93]\xF8\x96\xDE\x07\n\xBF\x35\\[\xA7\xDF\x38\xFC\xCC\na\xFFx\x96\x05\xFD'\r&\xFE\x35\xB5\xBAY\x14=\xE2\x1D\x9B_S^\x1C\ne\xC4\xED\x89\x88\x07\x1En\x1A\x32vV\xE2m\x93\x94`]'\x07\xFE*\x1F\xAB\x96\xBAQZtfOa\xE5\x19\xDB\x13@/\x9F\x96\x37u\x9C\xEE\x0Fh\x80w\xBB\xE4\xB5\x12\x83\x83\x0F\xC0\x1BK\xE9\xDD_\x07\xB3\r\x95\xF1\xDAs\x91\xCE\x9EI\x88\xC7\x15\xC6@\xD1W\x15/c\x97\xDD\x41:P\x93\xF0\xB7\x42\x16\xFA\x84Zv[\xCC\x39\xA1*xcV\x90\xB3\xC4!\x03\xB1\xC3\x43$U\xC5;\xE5\xA2\x92Y]\xB5\x14U'\x12\x44oE\xCB^\x06\x89\x14\xCC\x97<\xFFi\xC8\x8D\xDB\x10\xD2\xA0\vtw>\xD7Q\xA8\xA1\xEA\xA6\x84\xED\xB6\x8C\x84za,|\x1Ahm\x98\x34j\x92k\xE3\x39\xAC\xCE\x96\xF8\x81\xD2\x9C\xB1)\xA2\xF8Y\xA7\x88G\r\xECN\x8D`\x1Bl\x80\xAB\xB6\x61/\xE4\xE9(\xE0\x1C]\x02\xE2\xB1\xD8O\xB4\xFFp{\xE5\x96\x8D\x16\xFC]+J\xC5\xFD\x89j\xB0\x82\xA3\xD8\xDB\xE5Y\xCA\x96\x39\x88<z\x01RP\x7Fz\x94\xDFRK\x15x0\x8B\xF0\xAA\xD1\x32\xBF\xED\x34\xFC\x63S\xCC\x38y9\x91\xB6*\xD7?\xBD|\x84\x93\xE3\xBD\xC3\xEFyP\xC8\xF5\x64|\xB0\x62\t*\x9C\x39\n\x93\xBA\xF8\xD9\xE1\x97r\xCE\xF2\xFE\r\xB6\xE1\xAA~\xEE\x33\x08u\x12\xC8\x17\x90\xBF\xC1\xFE;YF\x9F\xD9\xE4y\xD9I`\xC6\x93j\x94\x02\x34\x65OB\x9F\x99Z\v\x8A\x1AJ@\xFE\xCB\xFCly+f\xC7\x8F\x1A\xFD\xBDJ\xAFhnk\x15G\xCC\x9DPI?B\xDD\xBC\x9B\x12\xE8\x42y8");
		if (len != sizeof("\x16\x33\xBB\xD6\xAB\xCC\n\xBC{\xD3\xC0\xC2>Gc\xAC\xAB\xC8T\xBA\x17\x30`\x8E\x8D\xACs\x93]\xF8\x96\xDE\x07\n\xBF\x35\\[\xA7\xDF\x38\xFC\xCC\na\xFFx\x96\x05\xFD'\r&\xFE\x35\xB5\xBAY\x14=\xE2\x1D\x9B_S^\x1C\ne\xC4\xED\x89\x88\x07\x1En\x1A\x32vV\xE2m\x93\x94`]'\x07\xFE*\x1F\xAB\x96\xBAQZtfOa\xE5\x19\xDB\x13@/\x9F\x96\x37u\x9C\xEE\x0Fh\x80w\xBB\xE4\xB5\x12\x83\x83\x0F\xC0\x1BK\xE9\xDD_\x07\xB3\r\x95\xF1\xDAs\x91\xCE\x9EI\x88\xC7\x15\xC6@\xD1W\x15/c\x97\xDD\x41:P\x93\xF0\xB7\x42\x16\xFA\x84Zv[\xCC\x39\xA1*xcV\x90\xB3\xC4!\x03\xB1\xC3\x43$U\xC5;\xE5\xA2\x92Y]\xB5\x14U'\x12\x44oE\xCB^\x06\x89\x14\xCC\x97<\xFFi\xC8\x8D\xDB\x10\xD2\xA0\vtw>\xD7Q\xA8\xA1\xEA\xA6\x84\xED\xB6\x8C\x84za,|\x1Ahm\x98\x34j\x92k\xE3\x39\xAC\xCE\x96\xF8\x81\xD2\x9C\xB1)\xA2\xF8Y\xA7\x88G\r\xECN\x8D`\x1Bl\x80\xAB\xB6\x61/\xE4\xE9(\xE0\x1C]\x02\xE2\xB1\xD8O\xB4\xFFp{\xE5\x96\x8D\x16\xFC]+J\xC5\xFD\x89j\xB0\x82\xA3\xD8\xDB\xE5Y\xCA\x96\x39\x88<z\x01RP\x7Fz\x94\xDFRK\x15x0\x8B\xF0\xAA\xD1\x32\xBF\xED\x34\xFC\x63S\xCC\x38y9\x91\xB6*\xD7?\xBD|\x84\x93\xE3\xBD\xC3\xEFyP\xC8\xF5\x64|\xB0\x62\t*\x9C\x39\n\x93\xBA\xF8\xD9\xE1\x97r\xCE\xF2\xFE\r\xB6\xE1\xAA~\xEE\x33\x08u\x12\xC8\x17\x90\xBF\xC1\xFE;YF\x9F\xD9\xE4y\xD9I`\xC6\x93j\x94\x02\x34\x65OB\x9F\x99Z\v\x8A\x1AJ@\xFE\xCB\xFCly+f\xC7\x8F\x1A\xFD\xBDJ\xAFhnk\x15G\xCC\x9DPI?B\xDD\xBC\x9B\x12\xE8\x42y8")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "\x16\x33\xBB\xD6\xAB\xCC\n\xBC{\xD3\xC0\xC2>Gc\xAC\xAB\xC8T\xBA\x17\x30`\x8E\x8D\xACs\x93]\xF8\x96\xDE\x07\n\xBF\x35\\[\xA7\xDF\x38\xFC\xCC\na\xFFx\x96\x05\xFD'\r&\xFE\x35\xB5\xBAY\x14=\xE2\x1D\x9B_S^\x1C\ne\xC4\xED\x89\x88\x07\x1En\x1A\x32vV\xE2m\x93\x94`]'\x07\xFE*\x1F\xAB\x96\xBAQZtfOa\xE5\x19\xDB\x13@/\x9F\x96\x37u\x9C\xEE\x0Fh\x80w\xBB\xE4\xB5\x12\x83\x83\x0F\xC0\x1BK\xE9\xDD_\x07\xB3\r\x95\xF1\xDAs\x91\xCE\x9EI\x88\xC7\x15\xC6@\xD1W\x15/c\x97\xDD\x41:P\x93\xF0\xB7\x42\x16\xFA\x84Zv[\xCC\x39\xA1*xcV\x90\xB3\xC4!\x03\xB1\xC3\x43$U\xC5;\xE5\xA2\x92Y]\xB5\x14U'\x12\x44oE\xCB^\x06\x89\x14\xCC\x97<\xFFi\xC8\x8D\xDB\x10\xD2\xA0\vtw>\xD7Q\xA8\xA1\xEA\xA6\x84\xED\xB6\x8C\x84za,|\x1Ahm\x98\x34j\x92k\xE3\x39\xAC\xCE\x96\xF8\x81\xD2\x9C\xB1)\xA2\xF8Y\xA7\x88G\r\xECN\x8D`\x1Bl\x80\xAB\xB6\x61/\xE4\xE9(\xE0\x1C]\x02\xE2\xB1\xD8O\xB4\xFFp{\xE5\x96\x8D\x16\xFC]+J\xC5\xFD\x89j\xB0\x82\xA3\xD8\xDB\xE5Y\xCA\x96\x39\x88<z\x01RP\x7Fz\x94\xDFRK\x15x0\x8B\xF0\xAA\xD1\x32\xBF\xED\x34\xFC\x63S\xCC\x38y9\x91\xB6*\xD7?\xBD|\x84\x93\xE3\xBD\xC3\xEFyP\xC8\xF5\x64|\xB0\x62\t*\x9C\x39\n\x93\xBA\xF8\xD9\xE1\x97r\xCE\xF2\xFE\r\xB6\xE1\xAA~\xEE\x33\x08u\x12\xC8\x17\x90\xBF\xC1\xFE;YF\x9F\xD9\xE4y\xD9I`\xC6\x93j\x94\x02\x34\x65OB\x9F\x99Z\v\x8A\x1AJ@\xFE\xCB\xFCly+f\xC7\x8F\x1A\xFD\xBDJ\xAFhnk\x15G\xCC\x9DPI?B\xDD\xBC\x9B\x12\xE8\x42y8"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 6 */
		darray_from_lit(a, "ZE\x16p\xE4ni/\xD6\x35\x81L\x8E\xF8\x1B$\xC9\xA7\x88\xEE,\x02\xA1\x31\x97.\x9AYn\x9E\x8C\xDC\x9E{<\x0F\xF5\x15\"{`&|\x1Fk\xFE\x44z\xABq\xB9.\xE2O\x07\xB4\x1B~\x87\xBBO\xBB\xC6\xA5\xA5Z\x1F\x8Ezu9\xC6\x46\x96\x94\xCA$\x88>\x14I\xEA\xF7\x31\xF3\x95H\x8E\"x.\xEC\xEF\xCA\x0Eu=\xDA\x99\xA8Y\x1C\xEE\x39\xBD!\xE8\xDD\xF8\xD1\xE1S\x8E-W\xE4\xF3r\xEB\xAB\xE8\xC2M\xD8\xAA\xD8\x34\xE6\xE1\xA3\nb3\x16|\x91G\xCB\xF7.ajy'\xC8\xC4\xC5?\x8D$\xA1\v\x02\x7F\xDBN\xBB\xBBu\x96\xCB\xDF\xB2\x15\xEF\xD4\xE8\x11\xEB\x65\xCA\xBD\x31(l\x95\x17\xF7_\xAE\xC6w\x88\xF5\xF9\xE7\xB8\x98\x18\xDF)?\xDF\x8D\x16\xE1\xC3\xC1\xE1\xAFr\xE6M\xB0Gm\x18\x15\xF1\xA9\xF5\x35\xDA\xA9\xCA\xC4;\x15\xC5h\x12\xAC\xE1\xFC\xF1\xA0\xDB\x12\x17\t4\t\x11Z?\xCA\x42JUULji\xADN\xBD\x06\x93\xAB\xA2\xD6\x8F\x45\xF8~,\xE0\x95\xAD\xE6\xD5\x1BJ\x80\x0E\xC8L\x01\xC2\xE4\x39\xD4\xCE%5\xC3\xA4\xC6\x04{}\x89\n\xFF\x46\x16\xAF\x63\x0E\xE1\x99S\xAB\x63\x41(\xE8\xA8\xC0\x8F\xB2\xC8z\xDA\xA5\xF5\xC2\x13\x38\xA7K\xC9\xBD\xC0\xFD\xA2\xA5\xF5h\x08\xAD\xD0x&\xA7\xB1\v\xE6lTc$\x16\x81\x12Qs\xAA\xFE\xF6\xCD\xC9\xF5\xAD\x1A*lm\xB2\xDB\xC7\x08m;\xCE\x1C\xC9\xD7&VG\x07\xE9\x93\xE7\x04\x86\xF3\xD1[\xAE\x87:Ce\xE5\x61@\x9DV\x89+\xEA(\xF7\xB2\xB5g\xF4\xFF\x61\xDF\x92\xD8\x97\x96|}kb\xED\xB5\x04@\xC3\xF9=\xF1\x39\x03I\x87\xEF\xC5\x37t\xCC\x80;\x1A\xCE\x34\x37\x96\xDBHq\x1D\xF0\xE8\x92\x8B\xC4\x61\xF3\xD6\xA2\x35\x33\x34\x90\xB6Jbr\x7F\x8FI\xF4\x18\xCE\x04\v\xA0\x33K\x1D\xC2\x9F\xA9\x1A\xFDi\xFCn\x18\xD0\xBE-$2\x9BK\xD9\xBF\xD7Q.\xFD\x80\x0F");
		len = strlen("ZE\x16p\xE4ni/\xD6\x35\x81L\x8E\xF8\x1B$\xC9\xA7\x88\xEE,\x02\xA1\x31\x97.\x9AYn\x9E\x8C\xDC\x9E{<\x0F\xF5\x15\"{`&|\x1Fk\xFE\x44z\xABq\xB9.\xE2O\x07\xB4\x1B~\x87\xBBO\xBB\xC6\xA5\xA5Z\x1F\x8Ezu9\xC6\x46\x96\x94\xCA$\x88>\x14I\xEA\xF7\x31\xF3\x95H\x8E\"x.\xEC\xEF\xCA\x0Eu=\xDA\x99\xA8Y\x1C\xEE\x39\xBD!\xE8\xDD\xF8\xD1\xE1S\x8E-W\xE4\xF3r\xEB\xAB\xE8\xC2M\xD8\xAA\xD8\x34\xE6\xE1\xA3\nb3\x16|\x91G\xCB\xF7.ajy'\xC8\xC4\xC5?\x8D$\xA1\v\x02\x7F\xDBN\xBB\xBBu\x96\xCB\xDF\xB2\x15\xEF\xD4\xE8\x11\xEB\x65\xCA\xBD\x31(l\x95\x17\xF7_\xAE\xC6w\x88\xF5\xF9\xE7\xB8\x98\x18\xDF)?\xDF\x8D\x16\xE1\xC3\xC1\xE1\xAFr\xE6M\xB0Gm\x18\x15\xF1\xA9\xF5\x35\xDA\xA9\xCA\xC4;\x15\xC5h\x12\xAC\xE1\xFC\xF1\xA0\xDB\x12\x17\t4\t\x11Z?\xCA\x42JUULji\xADN\xBD\x06\x93\xAB\xA2\xD6\x8F\x45\xF8~,\xE0\x95\xAD\xE6\xD5\x1BJ\x80\x0E\xC8L\x01\xC2\xE4\x39\xD4\xCE%5\xC3\xA4\xC6\x04{}\x89\n\xFF\x46\x16\xAF\x63\x0E\xE1\x99S\xAB\x63\x41(\xE8\xA8\xC0\x8F\xB2\xC8z\xDA\xA5\xF5\xC2\x13\x38\xA7K\xC9\xBD\xC0\xFD\xA2\xA5\xF5h\x08\xAD\xD0x&\xA7\xB1\v\xE6lTc$\x16\x81\x12Qs\xAA\xFE\xF6\xCD\xC9\xF5\xAD\x1A*lm\xB2\xDB\xC7\x08m;\xCE\x1C\xC9\xD7&VG\x07\xE9\x93\xE7\x04\x86\xF3\xD1[\xAE\x87:Ce\xE5\x61@\x9DV\x89+\xEA(\xF7\xB2\xB5g\xF4\xFF\x61\xDF\x92\xD8\x97\x96|}kb\xED\xB5\x04@\xC3\xF9=\xF1\x39\x03I\x87\xEF\xC5\x37t\xCC\x80;\x1A\xCE\x34\x37\x96\xDBHq\x1D\xF0\xE8\x92\x8B\xC4\x61\xF3\xD6\xA2\x35\x33\x34\x90\xB6Jbr\x7F\x8FI\xF4\x18\xCE\x04\v\xA0\x33K\x1D\xC2\x9F\xA9\x1A\xFDi\xFCn\x18\xD0\xBE-$2\x9BK\xD9\xBF\xD7Q.\xFD\x80\x0F");
		if (len != sizeof("ZE\x16p\xE4ni/\xD6\x35\x81L\x8E\xF8\x1B$\xC9\xA7\x88\xEE,\x02\xA1\x31\x97.\x9AYn\x9E\x8C\xDC\x9E{<\x0F\xF5\x15\"{`&|\x1Fk\xFE\x44z\xABq\xB9.\xE2O\x07\xB4\x1B~\x87\xBBO\xBB\xC6\xA5\xA5Z\x1F\x8Ezu9\xC6\x46\x96\x94\xCA$\x88>\x14I\xEA\xF7\x31\xF3\x95H\x8E\"x.\xEC\xEF\xCA\x0Eu=\xDA\x99\xA8Y\x1C\xEE\x39\xBD!\xE8\xDD\xF8\xD1\xE1S\x8E-W\xE4\xF3r\xEB\xAB\xE8\xC2M\xD8\xAA\xD8\x34\xE6\xE1\xA3\nb3\x16|\x91G\xCB\xF7.ajy'\xC8\xC4\xC5?\x8D$\xA1\v\x02\x7F\xDBN\xBB\xBBu\x96\xCB\xDF\xB2\x15\xEF\xD4\xE8\x11\xEB\x65\xCA\xBD\x31(l\x95\x17\xF7_\xAE\xC6w\x88\xF5\xF9\xE7\xB8\x98\x18\xDF)?\xDF\x8D\x16\xE1\xC3\xC1\xE1\xAFr\xE6M\xB0Gm\x18\x15\xF1\xA9\xF5\x35\xDA\xA9\xCA\xC4;\x15\xC5h\x12\xAC\xE1\xFC\xF1\xA0\xDB\x12\x17\t4\t\x11Z?\xCA\x42JUULji\xADN\xBD\x06\x93\xAB\xA2\xD6\x8F\x45\xF8~,\xE0\x95\xAD\xE6\xD5\x1BJ\x80\x0E\xC8L\x01\xC2\xE4\x39\xD4\xCE%5\xC3\xA4\xC6\x04{}\x89\n\xFF\x46\x16\xAF\x63\x0E\xE1\x99S\xAB\x63\x41(\xE8\xA8\xC0\x8F\xB2\xC8z\xDA\xA5\xF5\xC2\x13\x38\xA7K\xC9\xBD\xC0\xFD\xA2\xA5\xF5h\x08\xAD\xD0x&\xA7\xB1\v\xE6lTc$\x16\x81\x12Qs\xAA\xFE\xF6\xCD\xC9\xF5\xAD\x1A*lm\xB2\xDB\xC7\x08m;\xCE\x1C\xC9\xD7&VG\x07\xE9\x93\xE7\x04\x86\xF3\xD1[\xAE\x87:Ce\xE5\x61@\x9DV\x89+\xEA(\xF7\xB2\xB5g\xF4\xFF\x61\xDF\x92\xD8\x97\x96|}kb\xED\xB5\x04@\xC3\xF9=\xF1\x39\x03I\x87\xEF\xC5\x37t\xCC\x80;\x1A\xCE\x34\x37\x96\xDBHq\x1D\xF0\xE8\x92\x8B\xC4\x61\xF3\xD6\xA2\x35\x33\x34\x90\xB6Jbr\x7F\x8FI\xF4\x18\xCE\x04\v\xA0\x33K\x1D\xC2\x9F\xA9\x1A\xFDi\xFCn\x18\xD0\xBE-$2\x9BK\xD9\xBF\xD7Q.\xFD\x80\x0F")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "ZE\x16p\xE4ni/\xD6\x35\x81L\x8E\xF8\x1B$\xC9\xA7\x88\xEE,\x02\xA1\x31\x97.\x9AYn\x9E\x8C\xDC\x9E{<\x0F\xF5\x15\"{`&|\x1Fk\xFE\x44z\xABq\xB9.\xE2O\x07\xB4\x1B~\x87\xBBO\xBB\xC6\xA5\xA5Z\x1F\x8Ezu9\xC6\x46\x96\x94\xCA$\x88>\x14I\xEA\xF7\x31\xF3\x95H\x8E\"x.\xEC\xEF\xCA\x0Eu=\xDA\x99\xA8Y\x1C\xEE\x39\xBD!\xE8\xDD\xF8\xD1\xE1S\x8E-W\xE4\xF3r\xEB\xAB\xE8\xC2M\xD8\xAA\xD8\x34\xE6\xE1\xA3\nb3\x16|\x91G\xCB\xF7.ajy'\xC8\xC4\xC5?\x8D$\xA1\v\x02\x7F\xDBN\xBB\xBBu\x96\xCB\xDF\xB2\x15\xEF\xD4\xE8\x11\xEB\x65\xCA\xBD\x31(l\x95\x17\xF7_\xAE\xC6w\x88\xF5\xF9\xE7\xB8\x98\x18\xDF)?\xDF\x8D\x16\xE1\xC3\xC1\xE1\xAFr\xE6M\xB0Gm\x18\x15\xF1\xA9\xF5\x35\xDA\xA9\xCA\xC4;\x15\xC5h\x12\xAC\xE1\xFC\xF1\xA0\xDB\x12\x17\t4\t\x11Z?\xCA\x42JUULji\xADN\xBD\x06\x93\xAB\xA2\xD6\x8F\x45\xF8~,\xE0\x95\xAD\xE6\xD5\x1BJ\x80\x0E\xC8L\x01\xC2\xE4\x39\xD4\xCE%5\xC3\xA4\xC6\x04{}\x89\n\xFF\x46\x16\xAF\x63\x0E\xE1\x99S\xAB\x63\x41(\xE8\xA8\xC0\x8F\xB2\xC8z\xDA\xA5\xF5\xC2\x13\x38\xA7K\xC9\xBD\xC0\xFD\xA2\xA5\xF5h\x08\xAD\xD0x&\xA7\xB1\v\xE6lTc$\x16\x81\x12Qs\xAA\xFE\xF6\xCD\xC9\xF5\xAD\x1A*lm\xB2\xDB\xC7\x08m;\xCE\x1C\xC9\xD7&VG\x07\xE9\x93\xE7\x04\x86\xF3\xD1[\xAE\x87:Ce\xE5\x61@\x9DV\x89+\xEA(\xF7\xB2\xB5g\xF4\xFF\x61\xDF\x92\xD8\x97\x96|}kb\xED\xB5\x04@\xC3\xF9=\xF1\x39\x03I\x87\xEF\xC5\x37t\xCC\x80;\x1A\xCE\x34\x37\x96\xDBHq\x1D\xF0\xE8\x92\x8B\xC4\x61\xF3\xD6\xA2\x35\x33\x34\x90\xB6Jbr\x7F\x8FI\xF4\x18\xCE\x04\v\xA0\x33K\x1D\xC2\x9F\xA9\x1A\xFDi\xFCn\x18\xD0\xBE-$2\x9BK\xD9\xBF\xD7Q.\xFD\x80\x0F"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 7 */
		darray_from_lit(a, ")~\x96\x02\xE7h9\xB1\x65\x35\x8B\xF8\r\x81\x07\xCD\x9F\xD8-\xE2LB\xA1\xEA\n\x7F\xB1\xBFP15\x88\x32\x9C\x34\xCF\x02\xF8\x64\x8F\x43+\x1B\xB1\x8B\xAC\xB4\x96\xB3\xCB\xDB\x64\xF8\x91\xC0o$\f\x9A\xF6!\x97=jmU\xFD\x9C\xDB}\x15\x81\xAF\xE4q\x8C\xD7\xB8>\x9B\n\x96\f\xE0/Z\x1B\xB9\xE6|;/\xD2\x93\xC9\xC3\x63\x0FP#-\xF5\xDF\xF5\xFB@$\xB9\xEDG\xBF\xC1\xE2\xBF\xF8\x30\xC5p\xFB\xFF\xA9\xA6\xF7\xBD\xFD@\xC2\xFD\x92 \xA0\x91H\xA5\xD1\xC4\xCF\xB7\xD9T\xA9v\xF8q \xBA?\x9B\xA9@\xC8.\xBC\x89\xC0\x62\xD1\x38\x98\x83V\xB6\xB8\x85\x66\x1C\xC9Y\xCE\x8D\xF4\xCA\xCC\xDF\xB4\x06\xE1\xFC|\xA5i\xE2\x85\x02T\xEE\x35P\xDE\xDE\xE8\xE7Y\xB1\xDC:\x8A\xF6=a\xD8\x7F");
		len = strlen(")~\x96\x02\xE7h9\xB1\x65\x35\x8B\xF8\r\x81\x07\xCD\x9F\xD8-\xE2LB\xA1\xEA\n\x7F\xB1\xBFP15\x88\x32\x9C\x34\xCF\x02\xF8\x64\x8F\x43+\x1B\xB1\x8B\xAC\xB4\x96\xB3\xCB\xDB\x64\xF8\x91\xC0o$\f\x9A\xF6!\x97=jmU\xFD\x9C\xDB}\x15\x81\xAF\xE4q\x8C\xD7\xB8>\x9B\n\x96\f\xE0/Z\x1B\xB9\xE6|;/\xD2\x93\xC9\xC3\x63\x0FP#-\xF5\xDF\xF5\xFB@$\xB9\xEDG\xBF\xC1\xE2\xBF\xF8\x30\xC5p\xFB\xFF\xA9\xA6\xF7\xBD\xFD@\xC2\xFD\x92 \xA0\x91H\xA5\xD1\xC4\xCF\xB7\xD9T\xA9v\xF8q \xBA?\x9B\xA9@\xC8.\xBC\x89\xC0\x62\xD1\x38\x98\x83V\xB6\xB8\x85\x66\x1C\xC9Y\xCE\x8D\xF4\xCA\xCC\xDF\xB4\x06\xE1\xFC|\xA5i\xE2\x85\x02T\xEE\x35P\xDE\xDE\xE8\xE7Y\xB1\xDC:\x8A\xF6=a\xD8\x7F");
		if (len != sizeof(")~\x96\x02\xE7h9\xB1\x65\x35\x8B\xF8\r\x81\x07\xCD\x9F\xD8-\xE2LB\xA1\xEA\n\x7F\xB1\xBFP15\x88\x32\x9C\x34\xCF\x02\xF8\x64\x8F\x43+\x1B\xB1\x8B\xAC\xB4\x96\xB3\xCB\xDB\x64\xF8\x91\xC0o$\f\x9A\xF6!\x97=jmU\xFD\x9C\xDB}\x15\x81\xAF\xE4q\x8C\xD7\xB8>\x9B\n\x96\f\xE0/Z\x1B\xB9\xE6|;/\xD2\x93\xC9\xC3\x63\x0FP#-\xF5\xDF\xF5\xFB@$\xB9\xEDG\xBF\xC1\xE2\xBF\xF8\x30\xC5p\xFB\xFF\xA9\xA6\xF7\xBD\xFD@\xC2\xFD\x92 \xA0\x91H\xA5\xD1\xC4\xCF\xB7\xD9T\xA9v\xF8q \xBA?\x9B\xA9@\xC8.\xBC\x89\xC0\x62\xD1\x38\x98\x83V\xB6\xB8\x85\x66\x1C\xC9Y\xCE\x8D\xF4\xCA\xCC\xDF\xB4\x06\xE1\xFC|\xA5i\xE2\x85\x02T\xEE\x35P\xDE\xDE\xE8\xE7Y\xB1\xDC:\x8A\xF6=a\xD8\x7F")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, ")~\x96\x02\xE7h9\xB1\x65\x35\x8B\xF8\r\x81\x07\xCD\x9F\xD8-\xE2LB\xA1\xEA\n\x7F\xB1\xBFP15\x88\x32\x9C\x34\xCF\x02\xF8\x64\x8F\x43+\x1B\xB1\x8B\xAC\xB4\x96\xB3\xCB\xDB\x64\xF8\x91\xC0o$\f\x9A\xF6!\x97=jmU\xFD\x9C\xDB}\x15\x81\xAF\xE4q\x8C\xD7\xB8>\x9B\n\x96\f\xE0/Z\x1B\xB9\xE6|;/\xD2\x93\xC9\xC3\x63\x0FP#-\xF5\xDF\xF5\xFB@$\xB9\xEDG\xBF\xC1\xE2\xBF\xF8\x30\xC5p\xFB\xFF\xA9\xA6\xF7\xBD\xFD@\xC2\xFD\x92 \xA0\x91H\xA5\xD1\xC4\xCF\xB7\xD9T\xA9v\xF8q \xBA?\x9B\xA9@\xC8.\xBC\x89\xC0\x62\xD1\x38\x98\x83V\xB6\xB8\x85\x66\x1C\xC9Y\xCE\x8D\xF4\xCA\xCC\xDF\xB4\x06\xE1\xFC|\xA5i\xE2\x85\x02T\xEE\x35P\xDE\xDE\xE8\xE7Y\xB1\xDC:\x8A\xF6=a\xD8\x7F"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 8 */
		darray_from_lit(a, "!\xB5\xEB\xC0[\xE5\x35\x1F\x44\x84.\r\xE7\x44\xD3\nJ\xD8`\xFA\x85\x03\xE1_rm\xDD\x04yn\x90S\x8DH\x01\x0F\n(:\xD5\x14\x1C\x42\x81#&%;Y\xC7\xBA\x91\xEFhA\x12\x92\x04\x41\x96j\xB3R\x8D\xDF\x87\x16^\xBE\x42$0\xF9j\x13y\xB3\x61I\x8A\x8C+m\x9B\xD4=\x8A/q\fR@^\x97H2Gb\x1D\vA\v\r\xE1\xC5\x88rd\x88\x8B\xF0\xC0[\x8C\x45\x37\xC1\x45\xC8\x1F\\3\xB7\xD5\xAA\x98\xCD\x19\xE4*\xCDk\x95\xFE\x04\x33\x38\x14\x11\xA2p");
		len = strlen("!\xB5\xEB\xC0[\xE5\x35\x1F\x44\x84.\r\xE7\x44\xD3\nJ\xD8`\xFA\x85\x03\xE1_rm\xDD\x04yn\x90S\x8DH\x01\x0F\n(:\xD5\x14\x1C\x42\x81#&%;Y\xC7\xBA\x91\xEFhA\x12\x92\x04\x41\x96j\xB3R\x8D\xDF\x87\x16^\xBE\x42$0\xF9j\x13y\xB3\x61I\x8A\x8C+m\x9B\xD4=\x8A/q\fR@^\x97H2Gb\x1D\vA\v\r\xE1\xC5\x88rd\x88\x8B\xF0\xC0[\x8C\x45\x37\xC1\x45\xC8\x1F\\3\xB7\xD5\xAA\x98\xCD\x19\xE4*\xCDk\x95\xFE\x04\x33\x38\x14\x11\xA2p");
		if (len != sizeof("!\xB5\xEB\xC0[\xE5\x35\x1F\x44\x84.\r\xE7\x44\xD3\nJ\xD8`\xFA\x85\x03\xE1_rm\xDD\x04yn\x90S\x8DH\x01\x0F\n(:\xD5\x14\x1C\x42\x81#&%;Y\xC7\xBA\x91\xEFhA\x12\x92\x04\x41\x96j\xB3R\x8D\xDF\x87\x16^\xBE\x42$0\xF9j\x13y\xB3\x61I\x8A\x8C+m\x9B\xD4=\x8A/q\fR@^\x97H2Gb\x1D\vA\v\r\xE1\xC5\x88rd\x88\x8B\xF0\xC0[\x8C\x45\x37\xC1\x45\xC8\x1F\\3\xB7\xD5\xAA\x98\xCD\x19\xE4*\xCDk\x95\xFE\x04\x33\x38\x14\x11\xA2p")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "!\xB5\xEB\xC0[\xE5\x35\x1F\x44\x84.\r\xE7\x44\xD3\nJ\xD8`\xFA\x85\x03\xE1_rm\xDD\x04yn\x90S\x8DH\x01\x0F\n(:\xD5\x14\x1C\x42\x81#&%;Y\xC7\xBA\x91\xEFhA\x12\x92\x04\x41\x96j\xB3R\x8D\xDF\x87\x16^\xBE\x42$0\xF9j\x13y\xB3\x61I\x8A\x8C+m\x9B\xD4=\x8A/q\fR@^\x97H2Gb\x1D\vA\v\r\xE1\xC5\x88rd\x88\x8B\xF0\xC0[\x8C\x45\x37\xC1\x45\xC8\x1F\\3\xB7\xD5\xAA\x98\xCD\x19\xE4*\xCDk\x95\xFE\x04\x33\x38\x14\x11\xA2p"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

		/* Test 9 */
		darray_from_lit(a, "\xB7<\x14\x01\xC2\x91K\xC8O\xAD\xD2L\x83\\\x8B\xAE\x11\x1B\xB9\x44GR\xC7\xDD\xAD\x18\x0F\x14\x02\xE2R\r\x13I\xE0#\x9E$\x19\x89\x9C&t\x0F\xDF-w\xD0\x96yg\x86\x1B\x1E\xDF\x13\x0Er|\xB6\x38.,k\x11\xB9\xE5\xF2\xEC\xBD]\xB3\xAF\xD8\xA7\xF6\xFB\x0Ek\xA0\xC8\xD3\x46\xC2%\xE9t[\x05\xF9\x96g\x82.S;ZX\xED\x34Z\xF2'YD\x89o\xA1\xBB\xCB\xBE\xB3\x1B'M\n\xCESc(\xECT9\xA5\x83\x30\x80\x44\x08\x90\x33\xAE\x08\x62\"\xE6\x82G\xFDN\x95\xC1\x01\xFE/LS\x1A'Z3L\xF5\xC8\xE0>(_\x17\xDA\xCC\xED\xB6\xED\x84K7\x1B\x95-t\xE0<\xE4V\xE2\x94\x8F%\x83W\xDB\x99_\x9D-\xF9\x45\x18\xB8\x38\xE7\xD9\xDD\xAF\xE6\x62\x07\x95\x01\xB1\x8C_\x02\x80\xC1\xD8\\\x87\xBF\xEB\xF5\xFB \x9Cm\xE2n\x1Fm\xA8\x33\x1CY\";\x8F\x17\xE8\xD7\x9Aj\n\xF9\\\xC7\xEB\xF3\x88\xCDHXoJ\xD2\n\xECZ\x9AK\xD3-\xC3\xA9)pa%\x1E\x8A\x64\x8E$k0\xD3\x86p\x9A\x9A\x32\xF1x!\xA7\xB1HV\xCB\x94z\xB1\x33.W\xF6Vtp\x9C$`\x93\x8A\xC9S]\x99\x07\xB3\xD7?\xE8j\x08\xEA#\x9E\x65{.}IJ\x0E\x99\xB5\xCCS=jk-2\xB2\x94q\xAE\x35\xC3\x61\x1E\xF1\xBDvs/\xC2\xC9\xD9\x96\xA0t\x19\xC1\xA7\x04\xA8\x7F\xC4\xEC-\x1B\xD2\xE3\xF6\x9D\x12\xD2\xC2");
		len = strlen("\xB7<\x14\x01\xC2\x91K\xC8O\xAD\xD2L\x83\\\x8B\xAE\x11\x1B\xB9\x44GR\xC7\xDD\xAD\x18\x0F\x14\x02\xE2R\r\x13I\xE0#\x9E$\x19\x89\x9C&t\x0F\xDF-w\xD0\x96yg\x86\x1B\x1E\xDF\x13\x0Er|\xB6\x38.,k\x11\xB9\xE5\xF2\xEC\xBD]\xB3\xAF\xD8\xA7\xF6\xFB\x0Ek\xA0\xC8\xD3\x46\xC2%\xE9t[\x05\xF9\x96g\x82.S;ZX\xED\x34Z\xF2'YD\x89o\xA1\xBB\xCB\xBE\xB3\x1B'M\n\xCESc(\xECT9\xA5\x83\x30\x80\x44\x08\x90\x33\xAE\x08\x62\"\xE6\x82G\xFDN\x95\xC1\x01\xFE/LS\x1A'Z3L\xF5\xC8\xE0>(_\x17\xDA\xCC\xED\xB6\xED\x84K7\x1B\x95-t\xE0<\xE4V\xE2\x94\x8F%\x83W\xDB\x99_\x9D-\xF9\x45\x18\xB8\x38\xE7\xD9\xDD\xAF\xE6\x62\x07\x95\x01\xB1\x8C_\x02\x80\xC1\xD8\\\x87\xBF\xEB\xF5\xFB \x9Cm\xE2n\x1Fm\xA8\x33\x1CY\";\x8F\x17\xE8\xD7\x9Aj\n\xF9\\\xC7\xEB\xF3\x88\xCDHXoJ\xD2\n\xECZ\x9AK\xD3-\xC3\xA9)pa%\x1E\x8A\x64\x8E$k0\xD3\x86p\x9A\x9A\x32\xF1x!\xA7\xB1HV\xCB\x94z\xB1\x33.W\xF6Vtp\x9C$`\x93\x8A\xC9S]\x99\x07\xB3\xD7?\xE8j\x08\xEA#\x9E\x65{.}IJ\x0E\x99\xB5\xCCS=jk-2\xB2\x94q\xAE\x35\xC3\x61\x1E\xF1\xBDvs/\xC2\xC9\xD9\x96\xA0t\x19\xC1\xA7\x04\xA8\x7F\xC4\xEC-\x1B\xD2\xE3\xF6\x9D\x12\xD2\xC2");
		if (len != sizeof("\xB7<\x14\x01\xC2\x91K\xC8O\xAD\xD2L\x83\\\x8B\xAE\x11\x1B\xB9\x44GR\xC7\xDD\xAD\x18\x0F\x14\x02\xE2R\r\x13I\xE0#\x9E$\x19\x89\x9C&t\x0F\xDF-w\xD0\x96yg\x86\x1B\x1E\xDF\x13\x0Er|\xB6\x38.,k\x11\xB9\xE5\xF2\xEC\xBD]\xB3\xAF\xD8\xA7\xF6\xFB\x0Ek\xA0\xC8\xD3\x46\xC2%\xE9t[\x05\xF9\x96g\x82.S;ZX\xED\x34Z\xF2'YD\x89o\xA1\xBB\xCB\xBE\xB3\x1B'M\n\xCESc(\xECT9\xA5\x83\x30\x80\x44\x08\x90\x33\xAE\x08\x62\"\xE6\x82G\xFDN\x95\xC1\x01\xFE/LS\x1A'Z3L\xF5\xC8\xE0>(_\x17\xDA\xCC\xED\xB6\xED\x84K7\x1B\x95-t\xE0<\xE4V\xE2\x94\x8F%\x83W\xDB\x99_\x9D-\xF9\x45\x18\xB8\x38\xE7\xD9\xDD\xAF\xE6\x62\x07\x95\x01\xB1\x8C_\x02\x80\xC1\xD8\\\x87\xBF\xEB\xF5\xFB \x9Cm\xE2n\x1Fm\xA8\x33\x1CY\";\x8F\x17\xE8\xD7\x9Aj\n\xF9\\\xC7\xEB\xF3\x88\xCDHXoJ\xD2\n\xECZ\x9AK\xD3-\xC3\xA9)pa%\x1E\x8A\x64\x8E$k0\xD3\x86p\x9A\x9A\x32\xF1x!\xA7\xB1HV\xCB\x94z\xB1\x33.W\xF6Vtp\x9C$`\x93\x8A\xC9S]\x99\x07\xB3\xD7?\xE8j\x08\xEA#\x9E\x65{.}IJ\x0E\x99\xB5\xCCS=jk-2\xB2\x94q\xAE\x35\xC3\x61\x1E\xF1\xBDvs/\xC2\xC9\xD9\x96\xA0t\x19\xC1\xA7\x04\xA8\x7F\xC4\xEC-\x1B\xD2\xE3\xF6\x9D\x12\xD2\xC2")-1)
			goto end;
		if (a.size != len)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (strcmp(a.item, "\xB7<\x14\x01\xC2\x91K\xC8O\xAD\xD2L\x83\\\x8B\xAE\x11\x1B\xB9\x44GR\xC7\xDD\xAD\x18\x0F\x14\x02\xE2R\r\x13I\xE0#\x9E$\x19\x89\x9C&t\x0F\xDF-w\xD0\x96yg\x86\x1B\x1E\xDF\x13\x0Er|\xB6\x38.,k\x11\xB9\xE5\xF2\xEC\xBD]\xB3\xAF\xD8\xA7\xF6\xFB\x0Ek\xA0\xC8\xD3\x46\xC2%\xE9t[\x05\xF9\x96g\x82.S;ZX\xED\x34Z\xF2'YD\x89o\xA1\xBB\xCB\xBE\xB3\x1B'M\n\xCESc(\xECT9\xA5\x83\x30\x80\x44\x08\x90\x33\xAE\x08\x62\"\xE6\x82G\xFDN\x95\xC1\x01\xFE/LS\x1A'Z3L\xF5\xC8\xE0>(_\x17\xDA\xCC\xED\xB6\xED\x84K7\x1B\x95-t\xE0<\xE4V\xE2\x94\x8F%\x83W\xDB\x99_\x9D-\xF9\x45\x18\xB8\x38\xE7\xD9\xDD\xAF\xE6\x62\x07\x95\x01\xB1\x8C_\x02\x80\xC1\xD8\\\x87\xBF\xEB\xF5\xFB \x9Cm\xE2n\x1Fm\xA8\x33\x1CY\";\x8F\x17\xE8\xD7\x9Aj\n\xF9\\\xC7\xEB\xF3\x88\xCDHXoJ\xD2\n\xECZ\x9AK\xD3-\xC3\xA9)pa%\x1E\x8A\x64\x8E$k0\xD3\x86p\x9A\x9A\x32\xF1x!\xA7\xB1HV\xCB\x94z\xB1\x33.W\xF6Vtp\x9C$`\x93\x8A\xC9S]\x99\x07\xB3\xD7?\xE8j\x08\xEA#\x9E\x65{.}IJ\x0E\x99\xB5\xCCS=jk-2\xB2\x94q\xAE\x35\xC3\x61\x1E\xF1\xBDvs/\xC2\xC9\xD9\x96\xA0t\x19\xC1\xA7\x04\xA8\x7F\xC4\xEC-\x1B\xD2\xE3\xF6\x9D\x12\xD2\xC2"))
			goto end;
		darray_free(a);
		darray_init(a);
		testsPassed++;

	
end:
	darray_free(a);
	return testsPassed == 10;
}

typedef struct {
	char *item;
	size_t size;
} testLits_string;

static int testdarray_append_lit(void) {
	darray_char a = darray_new();
	darray(testLits_string) strings = darray_new();
	testLits_string *i;
	size_t testsPassed = 0;
	size_t oldSize;
	testLits_string append;
	size_t offs = 0;
	
		/* Test 0 */
		append.size = sizeof("v\xF8\xFE\xC6\x9D^5\xF4=kK\xD1(Mz\x9D\xA3\r\x12\x7F(D\xFC?\x89\x7F\xD2\x97\x0E]\f\xB4\x9F\x45n\x99h\xDE\x36\xBF>\xA7\xEF\x94\\>wVa\xFF\xBD\x08\xF1;\xF3\nx\xBFV*\x9C\xFC@\x1D\x02:\xD7\x9Bxvr}\xD6\xAC\x86I\xACN\x14\x06|\x7FSP\x8C\xB3\xFB~\xC9\t\xB3\xA4\x1EMO\x1C\xA3n\xA0\xB3\xC2n\x8B\xC6\x9CHi\x7F\tX9\x01\xDC\xED\x11I\xC4\f\x16\x14\xBC\x12\\\xB2\xCE\xAB\xE4\x1E-kZ\t\x13\xEF\xA6\xA2\x1B\xCC\x19\x86\xD4\x80#\x95\xB6\xC6zssc\xB4(\xBE\x9D\x9C\x98:\xB2\xEA\x45\xA8\xBB\x08\xC0J\x17^H\xBFL\xF8\xE1\xF4P\x1Ay5\xF6S0i\x1Fn\xB7Y\xD8\x98\x85\x01\x90\x8E\x1A/&\xEF")-1;
		oldSize = a.size;
		darray_append_lit(a, "v\xF8\xFE\xC6\x9D^5\xF4=kK\xD1(Mz\x9D\xA3\r\x12\x7F(D\xFC?\x89\x7F\xD2\x97\x0E]\f\xB4\x9F\x45n\x99h\xDE\x36\xBF>\xA7\xEF\x94\\>wVa\xFF\xBD\x08\xF1;\xF3\nx\xBFV*\x9C\xFC@\x1D\x02:\xD7\x9Bxvr}\xD6\xAC\x86I\xACN\x14\x06|\x7FSP\x8C\xB3\xFB~\xC9\t\xB3\xA4\x1EMO\x1C\xA3n\xA0\xB3\xC2n\x8B\xC6\x9CHi\x7F\tX9\x01\xDC\xED\x11I\xC4\f\x16\x14\xBC\x12\\\xB2\xCE\xAB\xE4\x1E-kZ\t\x13\xEF\xA6\xA2\x1B\xCC\x19\x86\xD4\x80#\x95\xB6\xC6zssc\xB4(\xBE\x9D\x9C\x98:\xB2\xEA\x45\xA8\xBB\x08\xC0J\x17^H\xBFL\xF8\xE1\xF4P\x1Ay5\xF6S0i\x1Fn\xB7Y\xD8\x98\x85\x01\x90\x8E\x1A/&\xEF");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "v\xF8\xFE\xC6\x9D^5\xF4=kK\xD1(Mz\x9D\xA3\r\x12\x7F(D\xFC?\x89\x7F\xD2\x97\x0E]\f\xB4\x9F\x45n\x99h\xDE\x36\xBF>\xA7\xEF\x94\\>wVa\xFF\xBD\x08\xF1;\xF3\nx\xBFV*\x9C\xFC@\x1D\x02:\xD7\x9Bxvr}\xD6\xAC\x86I\xACN\x14\x06|\x7FSP\x8C\xB3\xFB~\xC9\t\xB3\xA4\x1EMO\x1C\xA3n\xA0\xB3\xC2n\x8B\xC6\x9CHi\x7F\tX9\x01\xDC\xED\x11I\xC4\f\x16\x14\xBC\x12\\\xB2\xCE\xAB\xE4\x1E-kZ\t\x13\xEF\xA6\xA2\x1B\xCC\x19\x86\xD4\x80#\x95\xB6\xC6zssc\xB4(\xBE\x9D\x9C\x98:\xB2\xEA\x45\xA8\xBB\x08\xC0J\x17^H\xBFL\xF8\xE1\xF4P\x1Ay5\xF6S0i\x1Fn\xB7Y\xD8\x98\x85\x01\x90\x8E\x1A/&\xEF", a.size-oldSize))
			goto end;
		append.item = strdup("v\xF8\xFE\xC6\x9D^5\xF4=kK\xD1(Mz\x9D\xA3\r\x12\x7F(D\xFC?\x89\x7F\xD2\x97\x0E]\f\xB4\x9F\x45n\x99h\xDE\x36\xBF>\xA7\xEF\x94\\>wVa\xFF\xBD\x08\xF1;\xF3\nx\xBFV*\x9C\xFC@\x1D\x02:\xD7\x9Bxvr}\xD6\xAC\x86I\xACN\x14\x06|\x7FSP\x8C\xB3\xFB~\xC9\t\xB3\xA4\x1EMO\x1C\xA3n\xA0\xB3\xC2n\x8B\xC6\x9CHi\x7F\tX9\x01\xDC\xED\x11I\xC4\f\x16\x14\xBC\x12\\\xB2\xCE\xAB\xE4\x1E-kZ\t\x13\xEF\xA6\xA2\x1B\xCC\x19\x86\xD4\x80#\x95\xB6\xC6zssc\xB4(\xBE\x9D\x9C\x98:\xB2\xEA\x45\xA8\xBB\x08\xC0J\x17^H\xBFL\xF8\xE1\xF4P\x1Ay5\xF6S0i\x1Fn\xB7Y\xD8\x98\x85\x01\x90\x8E\x1A/&\xEF");
		darray_append(strings, append);
		testsPassed++;

		/* Test 1 */
		append.size = sizeof("\f\x8F[w\xD4\xAE\xBC\x1Dn\xF7\xE0jD\xA4p\x0E\n<\x9C\xF0Z\xC1I\x86~\xD1G\xB3\x01\xA6\x86)q1\x12\xD5\x08\x0E\x08\x7F+/pp\x14\xF0\xCF\x97%\xE0Q\x06\xCE)\xDF\x92\xBD\x06Z\xC2\x80\x94\xE3V%*\x18\xE1\xF4\xFA\xBD\x14MCjZ\xB2(\x91\x19\x8A\xB1\x34\xD3\x45\xC4\x1F\x39Q\xCB`\x0F\x9C\x81J\x0F\x86%\xA2\xEA>\x04\x7F\x94\x9F\xC7\xD2\xD9`\xEB\x30\xE7\xCDp\xBC\xD5\xD7\xDD!j|\xC1T\xE1 NB;A\xF7\xA2\x9C\xA6!\xDF\xB5\x9D\x64\x86\xD8\xFD\xD1\x99\xA3\xD0\\Q\xE1|\r\x18\xD9;\xE0\x95\xD8h\xF0\xC2V\xD7\\\x01\x91\xBEg\xC6\x44\x97U\xF8s/\xF7\x8C\xF4y\xDA\xC3\x38$\x8Fr\x86\x9D\xB4u\xAF\x0Et\xEC\xDD\xB0\"~x\x8F\x9B\x7F\xABl\x05\xAC\"\xA0\t\xCEL+\xDD\xB1V!\xAF\xFA\xD3\x03\xFB\xC2g\xEB\xA8\xDB\xF8\x16r\xB1\x41\xD9\x14\x06O\\O\xEB\x92\xF4\x39\xB1\x18s\x9B\x41#Q\xC3\x66\xCC\xA6\x33\xD4n\x12\v")-1;
		oldSize = a.size;
		darray_append_lit(a, "\f\x8F[w\xD4\xAE\xBC\x1Dn\xF7\xE0jD\xA4p\x0E\n<\x9C\xF0Z\xC1I\x86~\xD1G\xB3\x01\xA6\x86)q1\x12\xD5\x08\x0E\x08\x7F+/pp\x14\xF0\xCF\x97%\xE0Q\x06\xCE)\xDF\x92\xBD\x06Z\xC2\x80\x94\xE3V%*\x18\xE1\xF4\xFA\xBD\x14MCjZ\xB2(\x91\x19\x8A\xB1\x34\xD3\x45\xC4\x1F\x39Q\xCB`\x0F\x9C\x81J\x0F\x86%\xA2\xEA>\x04\x7F\x94\x9F\xC7\xD2\xD9`\xEB\x30\xE7\xCDp\xBC\xD5\xD7\xDD!j|\xC1T\xE1 NB;A\xF7\xA2\x9C\xA6!\xDF\xB5\x9D\x64\x86\xD8\xFD\xD1\x99\xA3\xD0\\Q\xE1|\r\x18\xD9;\xE0\x95\xD8h\xF0\xC2V\xD7\\\x01\x91\xBEg\xC6\x44\x97U\xF8s/\xF7\x8C\xF4y\xDA\xC3\x38$\x8Fr\x86\x9D\xB4u\xAF\x0Et\xEC\xDD\xB0\"~x\x8F\x9B\x7F\xABl\x05\xAC\"\xA0\t\xCEL+\xDD\xB1V!\xAF\xFA\xD3\x03\xFB\xC2g\xEB\xA8\xDB\xF8\x16r\xB1\x41\xD9\x14\x06O\\O\xEB\x92\xF4\x39\xB1\x18s\x9B\x41#Q\xC3\x66\xCC\xA6\x33\xD4n\x12\v");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\f\x8F[w\xD4\xAE\xBC\x1Dn\xF7\xE0jD\xA4p\x0E\n<\x9C\xF0Z\xC1I\x86~\xD1G\xB3\x01\xA6\x86)q1\x12\xD5\x08\x0E\x08\x7F+/pp\x14\xF0\xCF\x97%\xE0Q\x06\xCE)\xDF\x92\xBD\x06Z\xC2\x80\x94\xE3V%*\x18\xE1\xF4\xFA\xBD\x14MCjZ\xB2(\x91\x19\x8A\xB1\x34\xD3\x45\xC4\x1F\x39Q\xCB`\x0F\x9C\x81J\x0F\x86%\xA2\xEA>\x04\x7F\x94\x9F\xC7\xD2\xD9`\xEB\x30\xE7\xCDp\xBC\xD5\xD7\xDD!j|\xC1T\xE1 NB;A\xF7\xA2\x9C\xA6!\xDF\xB5\x9D\x64\x86\xD8\xFD\xD1\x99\xA3\xD0\\Q\xE1|\r\x18\xD9;\xE0\x95\xD8h\xF0\xC2V\xD7\\\x01\x91\xBEg\xC6\x44\x97U\xF8s/\xF7\x8C\xF4y\xDA\xC3\x38$\x8Fr\x86\x9D\xB4u\xAF\x0Et\xEC\xDD\xB0\"~x\x8F\x9B\x7F\xABl\x05\xAC\"\xA0\t\xCEL+\xDD\xB1V!\xAF\xFA\xD3\x03\xFB\xC2g\xEB\xA8\xDB\xF8\x16r\xB1\x41\xD9\x14\x06O\\O\xEB\x92\xF4\x39\xB1\x18s\x9B\x41#Q\xC3\x66\xCC\xA6\x33\xD4n\x12\v", a.size-oldSize))
			goto end;
		append.item = strdup("\f\x8F[w\xD4\xAE\xBC\x1Dn\xF7\xE0jD\xA4p\x0E\n<\x9C\xF0Z\xC1I\x86~\xD1G\xB3\x01\xA6\x86)q1\x12\xD5\x08\x0E\x08\x7F+/pp\x14\xF0\xCF\x97%\xE0Q\x06\xCE)\xDF\x92\xBD\x06Z\xC2\x80\x94\xE3V%*\x18\xE1\xF4\xFA\xBD\x14MCjZ\xB2(\x91\x19\x8A\xB1\x34\xD3\x45\xC4\x1F\x39Q\xCB`\x0F\x9C\x81J\x0F\x86%\xA2\xEA>\x04\x7F\x94\x9F\xC7\xD2\xD9`\xEB\x30\xE7\xCDp\xBC\xD5\xD7\xDD!j|\xC1T\xE1 NB;A\xF7\xA2\x9C\xA6!\xDF\xB5\x9D\x64\x86\xD8\xFD\xD1\x99\xA3\xD0\\Q\xE1|\r\x18\xD9;\xE0\x95\xD8h\xF0\xC2V\xD7\\\x01\x91\xBEg\xC6\x44\x97U\xF8s/\xF7\x8C\xF4y\xDA\xC3\x38$\x8Fr\x86\x9D\xB4u\xAF\x0Et\xEC\xDD\xB0\"~x\x8F\x9B\x7F\xABl\x05\xAC\"\xA0\t\xCEL+\xDD\xB1V!\xAF\xFA\xD3\x03\xFB\xC2g\xEB\xA8\xDB\xF8\x16r\xB1\x41\xD9\x14\x06O\\O\xEB\x92\xF4\x39\xB1\x18s\x9B\x41#Q\xC3\x66\xCC\xA6\x33\xD4n\x12\v");
		darray_append(strings, append);
		testsPassed++;

		/* Test 2 */
		append.size = sizeof("\xE1\xAF\x8F\xA8\xDBXq\xF3Mv\xEDK\xA6\xE3\xBCh\xFDq\xFC\xC5\xE0\x99\x41\xCD\xF8\fx\x98 +d}\x8B\xF8\xA0\xAA\x01\x86\xAD\xAB\f \x81\x63*\xF3)\xAE\x8Eu]\xC0j\"c\xA0W\xC0`\x1F\x44\xB7\x96R\x05+\xF9\x98\x87z\xFB/83\xC4P\xADnV?\xF2Y\x05\xC3\x42\xE3\xEA\x84\xEB\xF3).\xEE\xC7&>\x14&rr\xC8\x41\x04*\x95\x32\x63q\x13\xEC*\x9C\x1A\x15\xF4\xB2\xEA\xF5m\xA3wp\xD1NR\x8D\xF4z\x93\xC8\x38{\x93\x43\xE8\xA6( \xF8\xEA\x45\x18\xE2\xAF\xE7\x08\x66\xEE\x12.\xBD\xF3\xBEg\x9D\xDB\xFF`\xAF\x64\x0EQ\xAD~%8\xB2\xFDHd\xAD\x65\x9A\x10O\xAA\xD8|\xA4\xD4\xFE\x81\xE7\xE3\xFA\x96u\x9B\x0F\xA8x\xC2\x10&\xCC\xB4\xB5\x1C|n\x06P\x03\x94i\xF6}\xCB\xA5\xE7\x95+\xD6\xB1\x43\x06\xDDH\xAFL\xB8\x31=\x1A\xBD\xA4\x89\xCE\x12\xB4\x08\xECr\xBA\x36\xF4\x44-dff]\x9A\xE4-\xC7\x17\x1E\xB4\xAA\xBE\xBB\xDD\x65G\x92\"`\xBB\x9B\xBD\x18\x16\x9E\x41\x35\xD7Vj\xB0\xF9\xC1\xB2\xBF)\xCAW\xCBT,0\x03\x44\xD8\xF4\xF3\x81\xEC\xBC\x61\x16\xD1#\xC3$\x89KW\xFF\x9E\xD9%@H8%\xAE\x8A\x1CS\xEB\xE1<6\x07P\xEC\x62\xF0\v\xC6\xD7\x93yW\xB5\xF2\xF4\x66\xAA\xA3Q\x9A\n\xD0\x85X\xFF:\x9A%P*\x0E\x80-S\x1Cx\xFE\xE1\x85\xC3\xC7\xF3z\xE0\x18\x63\xF7&\xA5\x99U\xAF\x95Kz:qd\x8A\xC2\xAB\xBAm\xF5\x91\x39\xA1G\xC6L\xDA\xB9\x33\xBB\xC7\x11\xEA\x31\xB9\xEEG\xBB\x81\x36\xB7L\xBB\xDC`\x04\x30x(\xB0\x7F!b4\xC6\xAE\xA8\xEE\xA1\xBB\x37:\xA8k<\xF7\xE9\xEB\xC7\xAF\x62\x31\xCDJ\xE6\xAB\xC3%2\xD9\x0F.\xB8\\\xE0\xB7\x91\x36\xBE\x95[\"\xA4\f\xAD\x96k\x14\xDD]\xE4\xD8\xC5\x87q\xF0\xE5\x02\xAA\xC1{6&\x1C\xB2\xD0]\x1F\xBA\xA1\xE4#N\t\x94\xAE\xBBZ\xF1\xD5\xE8\xCA\x43\xE6\x8A\xA7\xFEl\x81=v\xC5\x06\x8C")-1;
		oldSize = a.size;
		darray_append_lit(a, "\xE1\xAF\x8F\xA8\xDBXq\xF3Mv\xEDK\xA6\xE3\xBCh\xFDq\xFC\xC5\xE0\x99\x41\xCD\xF8\fx\x98 +d}\x8B\xF8\xA0\xAA\x01\x86\xAD\xAB\f \x81\x63*\xF3)\xAE\x8Eu]\xC0j\"c\xA0W\xC0`\x1F\x44\xB7\x96R\x05+\xF9\x98\x87z\xFB/83\xC4P\xADnV?\xF2Y\x05\xC3\x42\xE3\xEA\x84\xEB\xF3).\xEE\xC7&>\x14&rr\xC8\x41\x04*\x95\x32\x63q\x13\xEC*\x9C\x1A\x15\xF4\xB2\xEA\xF5m\xA3wp\xD1NR\x8D\xF4z\x93\xC8\x38{\x93\x43\xE8\xA6( \xF8\xEA\x45\x18\xE2\xAF\xE7\x08\x66\xEE\x12.\xBD\xF3\xBEg\x9D\xDB\xFF`\xAF\x64\x0EQ\xAD~%8\xB2\xFDHd\xAD\x65\x9A\x10O\xAA\xD8|\xA4\xD4\xFE\x81\xE7\xE3\xFA\x96u\x9B\x0F\xA8x\xC2\x10&\xCC\xB4\xB5\x1C|n\x06P\x03\x94i\xF6}\xCB\xA5\xE7\x95+\xD6\xB1\x43\x06\xDDH\xAFL\xB8\x31=\x1A\xBD\xA4\x89\xCE\x12\xB4\x08\xECr\xBA\x36\xF4\x44-dff]\x9A\xE4-\xC7\x17\x1E\xB4\xAA\xBE\xBB\xDD\x65G\x92\"`\xBB\x9B\xBD\x18\x16\x9E\x41\x35\xD7Vj\xB0\xF9\xC1\xB2\xBF)\xCAW\xCBT,0\x03\x44\xD8\xF4\xF3\x81\xEC\xBC\x61\x16\xD1#\xC3$\x89KW\xFF\x9E\xD9%@H8%\xAE\x8A\x1CS\xEB\xE1<6\x07P\xEC\x62\xF0\v\xC6\xD7\x93yW\xB5\xF2\xF4\x66\xAA\xA3Q\x9A\n\xD0\x85X\xFF:\x9A%P*\x0E\x80-S\x1Cx\xFE\xE1\x85\xC3\xC7\xF3z\xE0\x18\x63\xF7&\xA5\x99U\xAF\x95Kz:qd\x8A\xC2\xAB\xBAm\xF5\x91\x39\xA1G\xC6L\xDA\xB9\x33\xBB\xC7\x11\xEA\x31\xB9\xEEG\xBB\x81\x36\xB7L\xBB\xDC`\x04\x30x(\xB0\x7F!b4\xC6\xAE\xA8\xEE\xA1\xBB\x37:\xA8k<\xF7\xE9\xEB\xC7\xAF\x62\x31\xCDJ\xE6\xAB\xC3%2\xD9\x0F.\xB8\\\xE0\xB7\x91\x36\xBE\x95[\"\xA4\f\xAD\x96k\x14\xDD]\xE4\xD8\xC5\x87q\xF0\xE5\x02\xAA\xC1{6&\x1C\xB2\xD0]\x1F\xBA\xA1\xE4#N\t\x94\xAE\xBBZ\xF1\xD5\xE8\xCA\x43\xE6\x8A\xA7\xFEl\x81=v\xC5\x06\x8C");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\xE1\xAF\x8F\xA8\xDBXq\xF3Mv\xEDK\xA6\xE3\xBCh\xFDq\xFC\xC5\xE0\x99\x41\xCD\xF8\fx\x98 +d}\x8B\xF8\xA0\xAA\x01\x86\xAD\xAB\f \x81\x63*\xF3)\xAE\x8Eu]\xC0j\"c\xA0W\xC0`\x1F\x44\xB7\x96R\x05+\xF9\x98\x87z\xFB/83\xC4P\xADnV?\xF2Y\x05\xC3\x42\xE3\xEA\x84\xEB\xF3).\xEE\xC7&>\x14&rr\xC8\x41\x04*\x95\x32\x63q\x13\xEC*\x9C\x1A\x15\xF4\xB2\xEA\xF5m\xA3wp\xD1NR\x8D\xF4z\x93\xC8\x38{\x93\x43\xE8\xA6( \xF8\xEA\x45\x18\xE2\xAF\xE7\x08\x66\xEE\x12.\xBD\xF3\xBEg\x9D\xDB\xFF`\xAF\x64\x0EQ\xAD~%8\xB2\xFDHd\xAD\x65\x9A\x10O\xAA\xD8|\xA4\xD4\xFE\x81\xE7\xE3\xFA\x96u\x9B\x0F\xA8x\xC2\x10&\xCC\xB4\xB5\x1C|n\x06P\x03\x94i\xF6}\xCB\xA5\xE7\x95+\xD6\xB1\x43\x06\xDDH\xAFL\xB8\x31=\x1A\xBD\xA4\x89\xCE\x12\xB4\x08\xECr\xBA\x36\xF4\x44-dff]\x9A\xE4-\xC7\x17\x1E\xB4\xAA\xBE\xBB\xDD\x65G\x92\"`\xBB\x9B\xBD\x18\x16\x9E\x41\x35\xD7Vj\xB0\xF9\xC1\xB2\xBF)\xCAW\xCBT,0\x03\x44\xD8\xF4\xF3\x81\xEC\xBC\x61\x16\xD1#\xC3$\x89KW\xFF\x9E\xD9%@H8%\xAE\x8A\x1CS\xEB\xE1<6\x07P\xEC\x62\xF0\v\xC6\xD7\x93yW\xB5\xF2\xF4\x66\xAA\xA3Q\x9A\n\xD0\x85X\xFF:\x9A%P*\x0E\x80-S\x1Cx\xFE\xE1\x85\xC3\xC7\xF3z\xE0\x18\x63\xF7&\xA5\x99U\xAF\x95Kz:qd\x8A\xC2\xAB\xBAm\xF5\x91\x39\xA1G\xC6L\xDA\xB9\x33\xBB\xC7\x11\xEA\x31\xB9\xEEG\xBB\x81\x36\xB7L\xBB\xDC`\x04\x30x(\xB0\x7F!b4\xC6\xAE\xA8\xEE\xA1\xBB\x37:\xA8k<\xF7\xE9\xEB\xC7\xAF\x62\x31\xCDJ\xE6\xAB\xC3%2\xD9\x0F.\xB8\\\xE0\xB7\x91\x36\xBE\x95[\"\xA4\f\xAD\x96k\x14\xDD]\xE4\xD8\xC5\x87q\xF0\xE5\x02\xAA\xC1{6&\x1C\xB2\xD0]\x1F\xBA\xA1\xE4#N\t\x94\xAE\xBBZ\xF1\xD5\xE8\xCA\x43\xE6\x8A\xA7\xFEl\x81=v\xC5\x06\x8C", a.size-oldSize))
			goto end;
		append.item = strdup("\xE1\xAF\x8F\xA8\xDBXq\xF3Mv\xEDK\xA6\xE3\xBCh\xFDq\xFC\xC5\xE0\x99\x41\xCD\xF8\fx\x98 +d}\x8B\xF8\xA0\xAA\x01\x86\xAD\xAB\f \x81\x63*\xF3)\xAE\x8Eu]\xC0j\"c\xA0W\xC0`\x1F\x44\xB7\x96R\x05+\xF9\x98\x87z\xFB/83\xC4P\xADnV?\xF2Y\x05\xC3\x42\xE3\xEA\x84\xEB\xF3).\xEE\xC7&>\x14&rr\xC8\x41\x04*\x95\x32\x63q\x13\xEC*\x9C\x1A\x15\xF4\xB2\xEA\xF5m\xA3wp\xD1NR\x8D\xF4z\x93\xC8\x38{\x93\x43\xE8\xA6( \xF8\xEA\x45\x18\xE2\xAF\xE7\x08\x66\xEE\x12.\xBD\xF3\xBEg\x9D\xDB\xFF`\xAF\x64\x0EQ\xAD~%8\xB2\xFDHd\xAD\x65\x9A\x10O\xAA\xD8|\xA4\xD4\xFE\x81\xE7\xE3\xFA\x96u\x9B\x0F\xA8x\xC2\x10&\xCC\xB4\xB5\x1C|n\x06P\x03\x94i\xF6}\xCB\xA5\xE7\x95+\xD6\xB1\x43\x06\xDDH\xAFL\xB8\x31=\x1A\xBD\xA4\x89\xCE\x12\xB4\x08\xECr\xBA\x36\xF4\x44-dff]\x9A\xE4-\xC7\x17\x1E\xB4\xAA\xBE\xBB\xDD\x65G\x92\"`\xBB\x9B\xBD\x18\x16\x9E\x41\x35\xD7Vj\xB0\xF9\xC1\xB2\xBF)\xCAW\xCBT,0\x03\x44\xD8\xF4\xF3\x81\xEC\xBC\x61\x16\xD1#\xC3$\x89KW\xFF\x9E\xD9%@H8%\xAE\x8A\x1CS\xEB\xE1<6\x07P\xEC\x62\xF0\v\xC6\xD7\x93yW\xB5\xF2\xF4\x66\xAA\xA3Q\x9A\n\xD0\x85X\xFF:\x9A%P*\x0E\x80-S\x1Cx\xFE\xE1\x85\xC3\xC7\xF3z\xE0\x18\x63\xF7&\xA5\x99U\xAF\x95Kz:qd\x8A\xC2\xAB\xBAm\xF5\x91\x39\xA1G\xC6L\xDA\xB9\x33\xBB\xC7\x11\xEA\x31\xB9\xEEG\xBB\x81\x36\xB7L\xBB\xDC`\x04\x30x(\xB0\x7F!b4\xC6\xAE\xA8\xEE\xA1\xBB\x37:\xA8k<\xF7\xE9\xEB\xC7\xAF\x62\x31\xCDJ\xE6\xAB\xC3%2\xD9\x0F.\xB8\\\xE0\xB7\x91\x36\xBE\x95[\"\xA4\f\xAD\x96k\x14\xDD]\xE4\xD8\xC5\x87q\xF0\xE5\x02\xAA\xC1{6&\x1C\xB2\xD0]\x1F\xBA\xA1\xE4#N\t\x94\xAE\xBBZ\xF1\xD5\xE8\xCA\x43\xE6\x8A\xA7\xFEl\x81=v\xC5\x06\x8C");
		darray_append(strings, append);
		testsPassed++;

		/* Test 3 */
		append.size = sizeof("y\xC8}P\x83\xD3\xD3>\xC4\xED\x84o\x92\xC0\x33\x34\x87_\x8Cm\x91(Z;+\xC9\xBF\xD4\xCF\x90L \xBB\xA6\xE0Y\xF7\\3%\xDC\x63\x1A\xF0/}\xE0\xDE\xCF\xD0\x31\xEA\xF1|F\xA8\x94\xCDp\xEF@\xAEi\x95\xCA\x45\xC4\x8F\xA4\x65\xE7\xFD*\x90\xEC\xA8\xA6\xFF\x96N\xDF\xEBG\xE8\n^\x9C\xFD\x37\x1F\x43T\x08\xBA\x37H\f\xDC\x99\xAAQ,\x96z\x97=3ib4*u\xFE\x98\xFB\f\xE7jqL\xE5\xAD\x30\x19\xB8*\x94\xC0\x03\x46\x01\x8C\xCD>\xFE\xBEL\xBB[>;\x15\xD4\xDC\xE2\xC0\x1E\xC7\xF2\x96IOPt.\xB1\x63\xC4\xDE\xC1\vL\xE0\x9A\xBA\x99\n\xF5i\xB6{L\xA6\t\xFF\x1B\x64N\xF4\xDD\xDD\xFDG]\x8Dk\xAF\x0E\xB5\x38\x39:\xA2l\xA6tHN\xC6\xC9\x01{r:h\xD0\xA3\x62\x05\xD0~o\xBB")-1;
		oldSize = a.size;
		darray_append_lit(a, "y\xC8}P\x83\xD3\xD3>\xC4\xED\x84o\x92\xC0\x33\x34\x87_\x8Cm\x91(Z;+\xC9\xBF\xD4\xCF\x90L \xBB\xA6\xE0Y\xF7\\3%\xDC\x63\x1A\xF0/}\xE0\xDE\xCF\xD0\x31\xEA\xF1|F\xA8\x94\xCDp\xEF@\xAEi\x95\xCA\x45\xC4\x8F\xA4\x65\xE7\xFD*\x90\xEC\xA8\xA6\xFF\x96N\xDF\xEBG\xE8\n^\x9C\xFD\x37\x1F\x43T\x08\xBA\x37H\f\xDC\x99\xAAQ,\x96z\x97=3ib4*u\xFE\x98\xFB\f\xE7jqL\xE5\xAD\x30\x19\xB8*\x94\xC0\x03\x46\x01\x8C\xCD>\xFE\xBEL\xBB[>;\x15\xD4\xDC\xE2\xC0\x1E\xC7\xF2\x96IOPt.\xB1\x63\xC4\xDE\xC1\vL\xE0\x9A\xBA\x99\n\xF5i\xB6{L\xA6\t\xFF\x1B\x64N\xF4\xDD\xDD\xFDG]\x8Dk\xAF\x0E\xB5\x38\x39:\xA2l\xA6tHN\xC6\xC9\x01{r:h\xD0\xA3\x62\x05\xD0~o\xBB");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "y\xC8}P\x83\xD3\xD3>\xC4\xED\x84o\x92\xC0\x33\x34\x87_\x8Cm\x91(Z;+\xC9\xBF\xD4\xCF\x90L \xBB\xA6\xE0Y\xF7\\3%\xDC\x63\x1A\xF0/}\xE0\xDE\xCF\xD0\x31\xEA\xF1|F\xA8\x94\xCDp\xEF@\xAEi\x95\xCA\x45\xC4\x8F\xA4\x65\xE7\xFD*\x90\xEC\xA8\xA6\xFF\x96N\xDF\xEBG\xE8\n^\x9C\xFD\x37\x1F\x43T\x08\xBA\x37H\f\xDC\x99\xAAQ,\x96z\x97=3ib4*u\xFE\x98\xFB\f\xE7jqL\xE5\xAD\x30\x19\xB8*\x94\xC0\x03\x46\x01\x8C\xCD>\xFE\xBEL\xBB[>;\x15\xD4\xDC\xE2\xC0\x1E\xC7\xF2\x96IOPt.\xB1\x63\xC4\xDE\xC1\vL\xE0\x9A\xBA\x99\n\xF5i\xB6{L\xA6\t\xFF\x1B\x64N\xF4\xDD\xDD\xFDG]\x8Dk\xAF\x0E\xB5\x38\x39:\xA2l\xA6tHN\xC6\xC9\x01{r:h\xD0\xA3\x62\x05\xD0~o\xBB", a.size-oldSize))
			goto end;
		append.item = strdup("y\xC8}P\x83\xD3\xD3>\xC4\xED\x84o\x92\xC0\x33\x34\x87_\x8Cm\x91(Z;+\xC9\xBF\xD4\xCF\x90L \xBB\xA6\xE0Y\xF7\\3%\xDC\x63\x1A\xF0/}\xE0\xDE\xCF\xD0\x31\xEA\xF1|F\xA8\x94\xCDp\xEF@\xAEi\x95\xCA\x45\xC4\x8F\xA4\x65\xE7\xFD*\x90\xEC\xA8\xA6\xFF\x96N\xDF\xEBG\xE8\n^\x9C\xFD\x37\x1F\x43T\x08\xBA\x37H\f\xDC\x99\xAAQ,\x96z\x97=3ib4*u\xFE\x98\xFB\f\xE7jqL\xE5\xAD\x30\x19\xB8*\x94\xC0\x03\x46\x01\x8C\xCD>\xFE\xBEL\xBB[>;\x15\xD4\xDC\xE2\xC0\x1E\xC7\xF2\x96IOPt.\xB1\x63\xC4\xDE\xC1\vL\xE0\x9A\xBA\x99\n\xF5i\xB6{L\xA6\t\xFF\x1B\x64N\xF4\xDD\xDD\xFDG]\x8Dk\xAF\x0E\xB5\x38\x39:\xA2l\xA6tHN\xC6\xC9\x01{r:h\xD0\xA3\x62\x05\xD0~o\xBB");
		darray_append(strings, append);
		testsPassed++;

		/* Test 4 */
		append.size = sizeof("\x93\x8A\x19^\x10\\\xD9\x8D\x9D\x7F\xCA\x8F\x1B\x85\x42\x1F\xCFG\xBD\x63M\x81\x44\xA3\xA9\x8F\xCA_\x80)\xBBqjo\xCD\x01\x8A\x17\xA4\x07:[\xFF+X\xEB\x19\xAC\xA2\xAB\xC7\xC8\x65H?\xE7\xE2H\xF0$\x01\x08\vrR\x1AI\xE0&\xBF~\xD1\x9AUDZX8<\x92\x64\x9CP\v\xBE(\xD7\n\v\x99\xEC\x18\x93\x36V\x01\f\xA7M\xA3 \xD8\x98%\"\xCA\xBD\x63\xA8\x8Bg\x13\x8A>f'\"w\xD4\xF6U\xA8Jy\x07\x85v5\xA2\t\x94\x17W\x96\xE2<RSl-\xB1\x87L\xBC\xFD\xC5i`s\x81\x06\xB9\n\xE8\xD6\x64\xEE\xFA\xC2\x8A\x32n\x9B\x90.\xC9G\xAEW\xEAv.\"\x9D&\x91 \xDF\xC4y\xC3\x42\x97\xB8\xAAV\xAC+\x8A\xF9{\x82\xD5\xD7\xDC q\x80\xB0\xB1na\x85\x42\xF2\x32\xAD\x32\x41\x90V\xFF\xA5\x10\x66\x0E,C\x87\xD4\x8C\x84\xF0uD[\x03\x13\xB2\xE5J\xB6\x8B\x99\xB9\xF4\x8A\x1B\xF7\x85")-1;
		oldSize = a.size;
		darray_append_lit(a, "\x93\x8A\x19^\x10\\\xD9\x8D\x9D\x7F\xCA\x8F\x1B\x85\x42\x1F\xCFG\xBD\x63M\x81\x44\xA3\xA9\x8F\xCA_\x80)\xBBqjo\xCD\x01\x8A\x17\xA4\x07:[\xFF+X\xEB\x19\xAC\xA2\xAB\xC7\xC8\x65H?\xE7\xE2H\xF0$\x01\x08\vrR\x1AI\xE0&\xBF~\xD1\x9AUDZX8<\x92\x64\x9CP\v\xBE(\xD7\n\v\x99\xEC\x18\x93\x36V\x01\f\xA7M\xA3 \xD8\x98%\"\xCA\xBD\x63\xA8\x8Bg\x13\x8A>f'\"w\xD4\xF6U\xA8Jy\x07\x85v5\xA2\t\x94\x17W\x96\xE2<RSl-\xB1\x87L\xBC\xFD\xC5i`s\x81\x06\xB9\n\xE8\xD6\x64\xEE\xFA\xC2\x8A\x32n\x9B\x90.\xC9G\xAEW\xEAv.\"\x9D&\x91 \xDF\xC4y\xC3\x42\x97\xB8\xAAV\xAC+\x8A\xF9{\x82\xD5\xD7\xDC q\x80\xB0\xB1na\x85\x42\xF2\x32\xAD\x32\x41\x90V\xFF\xA5\x10\x66\x0E,C\x87\xD4\x8C\x84\xF0uD[\x03\x13\xB2\xE5J\xB6\x8B\x99\xB9\xF4\x8A\x1B\xF7\x85");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\x93\x8A\x19^\x10\\\xD9\x8D\x9D\x7F\xCA\x8F\x1B\x85\x42\x1F\xCFG\xBD\x63M\x81\x44\xA3\xA9\x8F\xCA_\x80)\xBBqjo\xCD\x01\x8A\x17\xA4\x07:[\xFF+X\xEB\x19\xAC\xA2\xAB\xC7\xC8\x65H?\xE7\xE2H\xF0$\x01\x08\vrR\x1AI\xE0&\xBF~\xD1\x9AUDZX8<\x92\x64\x9CP\v\xBE(\xD7\n\v\x99\xEC\x18\x93\x36V\x01\f\xA7M\xA3 \xD8\x98%\"\xCA\xBD\x63\xA8\x8Bg\x13\x8A>f'\"w\xD4\xF6U\xA8Jy\x07\x85v5\xA2\t\x94\x17W\x96\xE2<RSl-\xB1\x87L\xBC\xFD\xC5i`s\x81\x06\xB9\n\xE8\xD6\x64\xEE\xFA\xC2\x8A\x32n\x9B\x90.\xC9G\xAEW\xEAv.\"\x9D&\x91 \xDF\xC4y\xC3\x42\x97\xB8\xAAV\xAC+\x8A\xF9{\x82\xD5\xD7\xDC q\x80\xB0\xB1na\x85\x42\xF2\x32\xAD\x32\x41\x90V\xFF\xA5\x10\x66\x0E,C\x87\xD4\x8C\x84\xF0uD[\x03\x13\xB2\xE5J\xB6\x8B\x99\xB9\xF4\x8A\x1B\xF7\x85", a.size-oldSize))
			goto end;
		append.item = strdup("\x93\x8A\x19^\x10\\\xD9\x8D\x9D\x7F\xCA\x8F\x1B\x85\x42\x1F\xCFG\xBD\x63M\x81\x44\xA3\xA9\x8F\xCA_\x80)\xBBqjo\xCD\x01\x8A\x17\xA4\x07:[\xFF+X\xEB\x19\xAC\xA2\xAB\xC7\xC8\x65H?\xE7\xE2H\xF0$\x01\x08\vrR\x1AI\xE0&\xBF~\xD1\x9AUDZX8<\x92\x64\x9CP\v\xBE(\xD7\n\v\x99\xEC\x18\x93\x36V\x01\f\xA7M\xA3 \xD8\x98%\"\xCA\xBD\x63\xA8\x8Bg\x13\x8A>f'\"w\xD4\xF6U\xA8Jy\x07\x85v5\xA2\t\x94\x17W\x96\xE2<RSl-\xB1\x87L\xBC\xFD\xC5i`s\x81\x06\xB9\n\xE8\xD6\x64\xEE\xFA\xC2\x8A\x32n\x9B\x90.\xC9G\xAEW\xEAv.\"\x9D&\x91 \xDF\xC4y\xC3\x42\x97\xB8\xAAV\xAC+\x8A\xF9{\x82\xD5\xD7\xDC q\x80\xB0\xB1na\x85\x42\xF2\x32\xAD\x32\x41\x90V\xFF\xA5\x10\x66\x0E,C\x87\xD4\x8C\x84\xF0uD[\x03\x13\xB2\xE5J\xB6\x8B\x99\xB9\xF4\x8A\x1B\xF7\x85");
		darray_append(strings, append);
		testsPassed++;

		/* Test 5 */
		append.size = sizeof("\xF5\x08$:\xCC\xD7\x8A\xB8%\xF4P6\x18")-1;
		oldSize = a.size;
		darray_append_lit(a, "\xF5\x08$:\xCC\xD7\x8A\xB8%\xF4P6\x18");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\xF5\x08$:\xCC\xD7\x8A\xB8%\xF4P6\x18", a.size-oldSize))
			goto end;
		append.item = strdup("\xF5\x08$:\xCC\xD7\x8A\xB8%\xF4P6\x18");
		darray_append(strings, append);
		testsPassed++;

		/* Test 6 */
		append.size = sizeof("2\x9A\x86\x94H\xA8\xD4\x8F\xE4\xD5\x10\xB3\xC3~\xF7\xB5g:n(\xA7x\xFD\xB7\xD5{\xED\xD7\xDDZ\xA2\x81\xD7\xD1m\x8E\xD3\x07\xA5\x9C\xFCl$4\xC1k\xE2X\xCF\x84\xB2\xEB];p\x9A)\x02q\xC1\x1E\xB6\vKud\xE7ttR\xB8@\x1C\xF9\xB6\xCE>s\xF9\x9F\x07\x99O\xAD\xB1\x7F\xC2I7\xA3O\x9D^-\xD9\xDE\xE0\x9CqY\\:0[\xD8\x95\x82.\xCE\xD1>\x06KQ\r_\xCEmy\xA9\xACv\xE8\x35\x8BWy\xBD_\x16\x33\\\xC8\xE1p\xFBIm\xCBvP\x11U\x94\x88(\xC1\xAD\xCC\x90\x03\xB2\xCEU\xDC\t]\xF7\x89\x90z\xE2\xB8\x17\xE7\xB4\xCD\xC4\x65\xC2\xCC\x36[Y\x95\xA1\x82\xB6\x07_o\xD7\x31\xE0\xC8p\x92\xFA\x31\xCD\xD5\xC6\xA9\xEA\xCF\x85\x96)\xF6\x15N\xB0xh\xA1_\xFC\xEB\t\x86Zc\xFA\xCD\xB9\xB7\t\xE8\x42P\x10<Y\xD5\x30\xE7\n\xE0i\x0F\x9Ew\xF2@\xF5\x17\xC1mp\x9E\xA6\xE6+\x14\x98\x8C\x1E\xBCL\xFC\x17\x89nW\xE8\x9E\xBE\x9El\xEB\x88\xD0\xD1\xD4\x94Gt\v\r\x0F\xDC\xBAZ J8\xC7\xF4\x9A\x81\xC3=\xC8\x8C\x18\xC5\xE8{Y\xBA\xCB>\xD9\x35\x90\xEF\xB2\x99\xC0\x0F\xBE\xCF\xB0\x65\xC4\x99L)e\x99\x86-\xDBVJ\xA6\xCA\t\xA2m\xF9\xD9H\xF7\x04\x1C \x9C\xD2\x05 K\x1C\xA3,\x96\x61jH\xC0\xC3\xEC\xB3\n*\xDA\xFD\xDF\n\x9B\xB6\xF4yDzs")-1;
		oldSize = a.size;
		darray_append_lit(a, "2\x9A\x86\x94H\xA8\xD4\x8F\xE4\xD5\x10\xB3\xC3~\xF7\xB5g:n(\xA7x\xFD\xB7\xD5{\xED\xD7\xDDZ\xA2\x81\xD7\xD1m\x8E\xD3\x07\xA5\x9C\xFCl$4\xC1k\xE2X\xCF\x84\xB2\xEB];p\x9A)\x02q\xC1\x1E\xB6\vKud\xE7ttR\xB8@\x1C\xF9\xB6\xCE>s\xF9\x9F\x07\x99O\xAD\xB1\x7F\xC2I7\xA3O\x9D^-\xD9\xDE\xE0\x9CqY\\:0[\xD8\x95\x82.\xCE\xD1>\x06KQ\r_\xCEmy\xA9\xACv\xE8\x35\x8BWy\xBD_\x16\x33\\\xC8\xE1p\xFBIm\xCBvP\x11U\x94\x88(\xC1\xAD\xCC\x90\x03\xB2\xCEU\xDC\t]\xF7\x89\x90z\xE2\xB8\x17\xE7\xB4\xCD\xC4\x65\xC2\xCC\x36[Y\x95\xA1\x82\xB6\x07_o\xD7\x31\xE0\xC8p\x92\xFA\x31\xCD\xD5\xC6\xA9\xEA\xCF\x85\x96)\xF6\x15N\xB0xh\xA1_\xFC\xEB\t\x86Zc\xFA\xCD\xB9\xB7\t\xE8\x42P\x10<Y\xD5\x30\xE7\n\xE0i\x0F\x9Ew\xF2@\xF5\x17\xC1mp\x9E\xA6\xE6+\x14\x98\x8C\x1E\xBCL\xFC\x17\x89nW\xE8\x9E\xBE\x9El\xEB\x88\xD0\xD1\xD4\x94Gt\v\r\x0F\xDC\xBAZ J8\xC7\xF4\x9A\x81\xC3=\xC8\x8C\x18\xC5\xE8{Y\xBA\xCB>\xD9\x35\x90\xEF\xB2\x99\xC0\x0F\xBE\xCF\xB0\x65\xC4\x99L)e\x99\x86-\xDBVJ\xA6\xCA\t\xA2m\xF9\xD9H\xF7\x04\x1C \x9C\xD2\x05 K\x1C\xA3,\x96\x61jH\xC0\xC3\xEC\xB3\n*\xDA\xFD\xDF\n\x9B\xB6\xF4yDzs");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "2\x9A\x86\x94H\xA8\xD4\x8F\xE4\xD5\x10\xB3\xC3~\xF7\xB5g:n(\xA7x\xFD\xB7\xD5{\xED\xD7\xDDZ\xA2\x81\xD7\xD1m\x8E\xD3\x07\xA5\x9C\xFCl$4\xC1k\xE2X\xCF\x84\xB2\xEB];p\x9A)\x02q\xC1\x1E\xB6\vKud\xE7ttR\xB8@\x1C\xF9\xB6\xCE>s\xF9\x9F\x07\x99O\xAD\xB1\x7F\xC2I7\xA3O\x9D^-\xD9\xDE\xE0\x9CqY\\:0[\xD8\x95\x82.\xCE\xD1>\x06KQ\r_\xCEmy\xA9\xACv\xE8\x35\x8BWy\xBD_\x16\x33\\\xC8\xE1p\xFBIm\xCBvP\x11U\x94\x88(\xC1\xAD\xCC\x90\x03\xB2\xCEU\xDC\t]\xF7\x89\x90z\xE2\xB8\x17\xE7\xB4\xCD\xC4\x65\xC2\xCC\x36[Y\x95\xA1\x82\xB6\x07_o\xD7\x31\xE0\xC8p\x92\xFA\x31\xCD\xD5\xC6\xA9\xEA\xCF\x85\x96)\xF6\x15N\xB0xh\xA1_\xFC\xEB\t\x86Zc\xFA\xCD\xB9\xB7\t\xE8\x42P\x10<Y\xD5\x30\xE7\n\xE0i\x0F\x9Ew\xF2@\xF5\x17\xC1mp\x9E\xA6\xE6+\x14\x98\x8C\x1E\xBCL\xFC\x17\x89nW\xE8\x9E\xBE\x9El\xEB\x88\xD0\xD1\xD4\x94Gt\v\r\x0F\xDC\xBAZ J8\xC7\xF4\x9A\x81\xC3=\xC8\x8C\x18\xC5\xE8{Y\xBA\xCB>\xD9\x35\x90\xEF\xB2\x99\xC0\x0F\xBE\xCF\xB0\x65\xC4\x99L)e\x99\x86-\xDBVJ\xA6\xCA\t\xA2m\xF9\xD9H\xF7\x04\x1C \x9C\xD2\x05 K\x1C\xA3,\x96\x61jH\xC0\xC3\xEC\xB3\n*\xDA\xFD\xDF\n\x9B\xB6\xF4yDzs", a.size-oldSize))
			goto end;
		append.item = strdup("2\x9A\x86\x94H\xA8\xD4\x8F\xE4\xD5\x10\xB3\xC3~\xF7\xB5g:n(\xA7x\xFD\xB7\xD5{\xED\xD7\xDDZ\xA2\x81\xD7\xD1m\x8E\xD3\x07\xA5\x9C\xFCl$4\xC1k\xE2X\xCF\x84\xB2\xEB];p\x9A)\x02q\xC1\x1E\xB6\vKud\xE7ttR\xB8@\x1C\xF9\xB6\xCE>s\xF9\x9F\x07\x99O\xAD\xB1\x7F\xC2I7\xA3O\x9D^-\xD9\xDE\xE0\x9CqY\\:0[\xD8\x95\x82.\xCE\xD1>\x06KQ\r_\xCEmy\xA9\xACv\xE8\x35\x8BWy\xBD_\x16\x33\\\xC8\xE1p\xFBIm\xCBvP\x11U\x94\x88(\xC1\xAD\xCC\x90\x03\xB2\xCEU\xDC\t]\xF7\x89\x90z\xE2\xB8\x17\xE7\xB4\xCD\xC4\x65\xC2\xCC\x36[Y\x95\xA1\x82\xB6\x07_o\xD7\x31\xE0\xC8p\x92\xFA\x31\xCD\xD5\xC6\xA9\xEA\xCF\x85\x96)\xF6\x15N\xB0xh\xA1_\xFC\xEB\t\x86Zc\xFA\xCD\xB9\xB7\t\xE8\x42P\x10<Y\xD5\x30\xE7\n\xE0i\x0F\x9Ew\xF2@\xF5\x17\xC1mp\x9E\xA6\xE6+\x14\x98\x8C\x1E\xBCL\xFC\x17\x89nW\xE8\x9E\xBE\x9El\xEB\x88\xD0\xD1\xD4\x94Gt\v\r\x0F\xDC\xBAZ J8\xC7\xF4\x9A\x81\xC3=\xC8\x8C\x18\xC5\xE8{Y\xBA\xCB>\xD9\x35\x90\xEF\xB2\x99\xC0\x0F\xBE\xCF\xB0\x65\xC4\x99L)e\x99\x86-\xDBVJ\xA6\xCA\t\xA2m\xF9\xD9H\xF7\x04\x1C \x9C\xD2\x05 K\x1C\xA3,\x96\x61jH\xC0\xC3\xEC\xB3\n*\xDA\xFD\xDF\n\x9B\xB6\xF4yDzs");
		darray_append(strings, append);
		testsPassed++;

		/* Test 7 */
		append.size = sizeof("\xBD\x8EJ\xA8\x91\xFC;\x11_\x0F\xB8=\xDC\x8AjL0=\x9F\xF2\xA8\xEF)\x97j\x1F\x06\x32\xD5\xC5j\xDE\xDE\xF5\x44\"\xA2\xD5\xA9\xB2\xD7\x14\x9D\xA8W\xA9\xF7?\x91W\xC9\xD7Q\x9F\xD7,5Q\xAF\xEA\x8DU\f\xEB\x8A\xF8\x41\xD4L\xF9Q@\x1A\xD6\x63w7\x8B\x9F\xF5\x18\x9AU\"\x13\xC9\xFD\xD1\x43\xF7\xD9~M>\x8B@\xC0\xEE\xB6H\x8D\x89\x8C\x04@\x83\xBC\x35\x16\xC7\xB8\x44\xC0;\xA7\x31\xDE\xC2\x11{\xF3\xC1\xAF\xC4HP\xA3\xAA\xA7Wl\xA5\xC3\x44\x92\xB6\x65\xE4\x1A\xDE\xFC\x02\xA6[Z\xC8\xE8\x8A\xE8\xD8kE\xB5\xCE\x31=\x9C\f\x8F\xD0\xB7\xFB\xD6G\xF8\x9C\xD7\xC4\x33O:\x9F\x06\x9Dz\xCF\xA7\xDD-\x05L:\x1B\xEA\xD1\x35\x61\xFC\x99\x44\xF3\xE1\x65O\xBD\xA5x\x99\xF8\x10\x91\xDE\xA2\x0E\xE8j\xCE\x1E/G)\x9F\x32\xE9\x90\xED\x95\x1B\xA3Y4\xE1\x46!\xC4\x82\x99,0\xF8\xBD\x9B\xED\x8Fxh\xF4\xA9MNS,\xECj\x10>\x98\xE9]\xEE\xB4\xD5%]\x1E\xB4\xB3\xD6\x44\x66\x64$\xB2\xAC\xA0\xB3@P\xF7\fu\"(\xA9\x1E#l_.\x9D\xF6\x34\xCF\xD1:T\x06V\xF2\xA7g\x1A'f\xD2\xD6\xF5\x39\x02\x8F\x93\v\x11Tyf:\xDD\xB0Z\xA5\"\xE8ns{P\xCD\x38\x45\xC6\xA8+\xB3)\xF0\xCD\x83IUTQ~8\xDFj\xA1\xA2]d\x8D\x34\xA6\xD6\n\x9EP}y\xAC\xD5\x14\x92\xE6\xBA\x9FJ%][\xC4\xFB\xCBi2\xE6\xF7\x98\x87@\x11\xA0")-1;
		oldSize = a.size;
		darray_append_lit(a, "\xBD\x8EJ\xA8\x91\xFC;\x11_\x0F\xB8=\xDC\x8AjL0=\x9F\xF2\xA8\xEF)\x97j\x1F\x06\x32\xD5\xC5j\xDE\xDE\xF5\x44\"\xA2\xD5\xA9\xB2\xD7\x14\x9D\xA8W\xA9\xF7?\x91W\xC9\xD7Q\x9F\xD7,5Q\xAF\xEA\x8DU\f\xEB\x8A\xF8\x41\xD4L\xF9Q@\x1A\xD6\x63w7\x8B\x9F\xF5\x18\x9AU\"\x13\xC9\xFD\xD1\x43\xF7\xD9~M>\x8B@\xC0\xEE\xB6H\x8D\x89\x8C\x04@\x83\xBC\x35\x16\xC7\xB8\x44\xC0;\xA7\x31\xDE\xC2\x11{\xF3\xC1\xAF\xC4HP\xA3\xAA\xA7Wl\xA5\xC3\x44\x92\xB6\x65\xE4\x1A\xDE\xFC\x02\xA6[Z\xC8\xE8\x8A\xE8\xD8kE\xB5\xCE\x31=\x9C\f\x8F\xD0\xB7\xFB\xD6G\xF8\x9C\xD7\xC4\x33O:\x9F\x06\x9Dz\xCF\xA7\xDD-\x05L:\x1B\xEA\xD1\x35\x61\xFC\x99\x44\xF3\xE1\x65O\xBD\xA5x\x99\xF8\x10\x91\xDE\xA2\x0E\xE8j\xCE\x1E/G)\x9F\x32\xE9\x90\xED\x95\x1B\xA3Y4\xE1\x46!\xC4\x82\x99,0\xF8\xBD\x9B\xED\x8Fxh\xF4\xA9MNS,\xECj\x10>\x98\xE9]\xEE\xB4\xD5%]\x1E\xB4\xB3\xD6\x44\x66\x64$\xB2\xAC\xA0\xB3@P\xF7\fu\"(\xA9\x1E#l_.\x9D\xF6\x34\xCF\xD1:T\x06V\xF2\xA7g\x1A'f\xD2\xD6\xF5\x39\x02\x8F\x93\v\x11Tyf:\xDD\xB0Z\xA5\"\xE8ns{P\xCD\x38\x45\xC6\xA8+\xB3)\xF0\xCD\x83IUTQ~8\xDFj\xA1\xA2]d\x8D\x34\xA6\xD6\n\x9EP}y\xAC\xD5\x14\x92\xE6\xBA\x9FJ%][\xC4\xFB\xCBi2\xE6\xF7\x98\x87@\x11\xA0");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\xBD\x8EJ\xA8\x91\xFC;\x11_\x0F\xB8=\xDC\x8AjL0=\x9F\xF2\xA8\xEF)\x97j\x1F\x06\x32\xD5\xC5j\xDE\xDE\xF5\x44\"\xA2\xD5\xA9\xB2\xD7\x14\x9D\xA8W\xA9\xF7?\x91W\xC9\xD7Q\x9F\xD7,5Q\xAF\xEA\x8DU\f\xEB\x8A\xF8\x41\xD4L\xF9Q@\x1A\xD6\x63w7\x8B\x9F\xF5\x18\x9AU\"\x13\xC9\xFD\xD1\x43\xF7\xD9~M>\x8B@\xC0\xEE\xB6H\x8D\x89\x8C\x04@\x83\xBC\x35\x16\xC7\xB8\x44\xC0;\xA7\x31\xDE\xC2\x11{\xF3\xC1\xAF\xC4HP\xA3\xAA\xA7Wl\xA5\xC3\x44\x92\xB6\x65\xE4\x1A\xDE\xFC\x02\xA6[Z\xC8\xE8\x8A\xE8\xD8kE\xB5\xCE\x31=\x9C\f\x8F\xD0\xB7\xFB\xD6G\xF8\x9C\xD7\xC4\x33O:\x9F\x06\x9Dz\xCF\xA7\xDD-\x05L:\x1B\xEA\xD1\x35\x61\xFC\x99\x44\xF3\xE1\x65O\xBD\xA5x\x99\xF8\x10\x91\xDE\xA2\x0E\xE8j\xCE\x1E/G)\x9F\x32\xE9\x90\xED\x95\x1B\xA3Y4\xE1\x46!\xC4\x82\x99,0\xF8\xBD\x9B\xED\x8Fxh\xF4\xA9MNS,\xECj\x10>\x98\xE9]\xEE\xB4\xD5%]\x1E\xB4\xB3\xD6\x44\x66\x64$\xB2\xAC\xA0\xB3@P\xF7\fu\"(\xA9\x1E#l_.\x9D\xF6\x34\xCF\xD1:T\x06V\xF2\xA7g\x1A'f\xD2\xD6\xF5\x39\x02\x8F\x93\v\x11Tyf:\xDD\xB0Z\xA5\"\xE8ns{P\xCD\x38\x45\xC6\xA8+\xB3)\xF0\xCD\x83IUTQ~8\xDFj\xA1\xA2]d\x8D\x34\xA6\xD6\n\x9EP}y\xAC\xD5\x14\x92\xE6\xBA\x9FJ%][\xC4\xFB\xCBi2\xE6\xF7\x98\x87@\x11\xA0", a.size-oldSize))
			goto end;
		append.item = strdup("\xBD\x8EJ\xA8\x91\xFC;\x11_\x0F\xB8=\xDC\x8AjL0=\x9F\xF2\xA8\xEF)\x97j\x1F\x06\x32\xD5\xC5j\xDE\xDE\xF5\x44\"\xA2\xD5\xA9\xB2\xD7\x14\x9D\xA8W\xA9\xF7?\x91W\xC9\xD7Q\x9F\xD7,5Q\xAF\xEA\x8DU\f\xEB\x8A\xF8\x41\xD4L\xF9Q@\x1A\xD6\x63w7\x8B\x9F\xF5\x18\x9AU\"\x13\xC9\xFD\xD1\x43\xF7\xD9~M>\x8B@\xC0\xEE\xB6H\x8D\x89\x8C\x04@\x83\xBC\x35\x16\xC7\xB8\x44\xC0;\xA7\x31\xDE\xC2\x11{\xF3\xC1\xAF\xC4HP\xA3\xAA\xA7Wl\xA5\xC3\x44\x92\xB6\x65\xE4\x1A\xDE\xFC\x02\xA6[Z\xC8\xE8\x8A\xE8\xD8kE\xB5\xCE\x31=\x9C\f\x8F\xD0\xB7\xFB\xD6G\xF8\x9C\xD7\xC4\x33O:\x9F\x06\x9Dz\xCF\xA7\xDD-\x05L:\x1B\xEA\xD1\x35\x61\xFC\x99\x44\xF3\xE1\x65O\xBD\xA5x\x99\xF8\x10\x91\xDE\xA2\x0E\xE8j\xCE\x1E/G)\x9F\x32\xE9\x90\xED\x95\x1B\xA3Y4\xE1\x46!\xC4\x82\x99,0\xF8\xBD\x9B\xED\x8Fxh\xF4\xA9MNS,\xECj\x10>\x98\xE9]\xEE\xB4\xD5%]\x1E\xB4\xB3\xD6\x44\x66\x64$\xB2\xAC\xA0\xB3@P\xF7\fu\"(\xA9\x1E#l_.\x9D\xF6\x34\xCF\xD1:T\x06V\xF2\xA7g\x1A'f\xD2\xD6\xF5\x39\x02\x8F\x93\v\x11Tyf:\xDD\xB0Z\xA5\"\xE8ns{P\xCD\x38\x45\xC6\xA8+\xB3)\xF0\xCD\x83IUTQ~8\xDFj\xA1\xA2]d\x8D\x34\xA6\xD6\n\x9EP}y\xAC\xD5\x14\x92\xE6\xBA\x9FJ%][\xC4\xFB\xCBi2\xE6\xF7\x98\x87@\x11\xA0");
		darray_append(strings, append);
		testsPassed++;

		/* Test 8 */
		append.size = sizeof("\x8E}z\x05\xDF\xD6\xF1\xD2\xBC\x15\xC1\xED\xF7\xF6\xFC\x83\xA8\x32\x33=\xB8K\x14\x86\xCCX1nD\x99\xBD\x44IB\xF6+\x97\xF2\x15\x86\xFA\xD9\xA5\xB8\xE9\x01;\x92\xC3\xF0\xD8\xA8]\xBF\xB7\xB8\x03\x38.\xF0KMW\xF1\xBAU]1\xC5\x61\x38zvR\xAD\xB0\x66\x03\x08\xFB\x86\xCFY\xB0\v\xBE+d\xF2\x84\x41\xC5\x84pUy\xE8\xAF\x94=\xE3\x33v+e\xFCi\xFB\x97\xB8\x32\xD4:9:\xE8\x15\x84\xF9\xE0\xAA\x11\xFF\xB9\x94\x13\xE4\xD3J\x88\x37\xD6\xE7\xF2\xAB\x36\xDC\xA5l38F\xDB\xD8\x95\x14\x1C\x1B\x36\xE0-\x93\x1E\x07\x94l\x03x\x16\x11\x94\xCD\"8\xD8\xED+\x10\xB5\xDCznl\xCD\x99SA\x12Y0\xAB\x81\f\xAC\xCB\xFE\x8A\x46\x8E\x7F\x8F\x97\x14\xF5\x38v~#\xB4")-1;
		oldSize = a.size;
		darray_append_lit(a, "\x8E}z\x05\xDF\xD6\xF1\xD2\xBC\x15\xC1\xED\xF7\xF6\xFC\x83\xA8\x32\x33=\xB8K\x14\x86\xCCX1nD\x99\xBD\x44IB\xF6+\x97\xF2\x15\x86\xFA\xD9\xA5\xB8\xE9\x01;\x92\xC3\xF0\xD8\xA8]\xBF\xB7\xB8\x03\x38.\xF0KMW\xF1\xBAU]1\xC5\x61\x38zvR\xAD\xB0\x66\x03\x08\xFB\x86\xCFY\xB0\v\xBE+d\xF2\x84\x41\xC5\x84pUy\xE8\xAF\x94=\xE3\x33v+e\xFCi\xFB\x97\xB8\x32\xD4:9:\xE8\x15\x84\xF9\xE0\xAA\x11\xFF\xB9\x94\x13\xE4\xD3J\x88\x37\xD6\xE7\xF2\xAB\x36\xDC\xA5l38F\xDB\xD8\x95\x14\x1C\x1B\x36\xE0-\x93\x1E\x07\x94l\x03x\x16\x11\x94\xCD\"8\xD8\xED+\x10\xB5\xDCznl\xCD\x99SA\x12Y0\xAB\x81\f\xAC\xCB\xFE\x8A\x46\x8E\x7F\x8F\x97\x14\xF5\x38v~#\xB4");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\x8E}z\x05\xDF\xD6\xF1\xD2\xBC\x15\xC1\xED\xF7\xF6\xFC\x83\xA8\x32\x33=\xB8K\x14\x86\xCCX1nD\x99\xBD\x44IB\xF6+\x97\xF2\x15\x86\xFA\xD9\xA5\xB8\xE9\x01;\x92\xC3\xF0\xD8\xA8]\xBF\xB7\xB8\x03\x38.\xF0KMW\xF1\xBAU]1\xC5\x61\x38zvR\xAD\xB0\x66\x03\x08\xFB\x86\xCFY\xB0\v\xBE+d\xF2\x84\x41\xC5\x84pUy\xE8\xAF\x94=\xE3\x33v+e\xFCi\xFB\x97\xB8\x32\xD4:9:\xE8\x15\x84\xF9\xE0\xAA\x11\xFF\xB9\x94\x13\xE4\xD3J\x88\x37\xD6\xE7\xF2\xAB\x36\xDC\xA5l38F\xDB\xD8\x95\x14\x1C\x1B\x36\xE0-\x93\x1E\x07\x94l\x03x\x16\x11\x94\xCD\"8\xD8\xED+\x10\xB5\xDCznl\xCD\x99SA\x12Y0\xAB\x81\f\xAC\xCB\xFE\x8A\x46\x8E\x7F\x8F\x97\x14\xF5\x38v~#\xB4", a.size-oldSize))
			goto end;
		append.item = strdup("\x8E}z\x05\xDF\xD6\xF1\xD2\xBC\x15\xC1\xED\xF7\xF6\xFC\x83\xA8\x32\x33=\xB8K\x14\x86\xCCX1nD\x99\xBD\x44IB\xF6+\x97\xF2\x15\x86\xFA\xD9\xA5\xB8\xE9\x01;\x92\xC3\xF0\xD8\xA8]\xBF\xB7\xB8\x03\x38.\xF0KMW\xF1\xBAU]1\xC5\x61\x38zvR\xAD\xB0\x66\x03\x08\xFB\x86\xCFY\xB0\v\xBE+d\xF2\x84\x41\xC5\x84pUy\xE8\xAF\x94=\xE3\x33v+e\xFCi\xFB\x97\xB8\x32\xD4:9:\xE8\x15\x84\xF9\xE0\xAA\x11\xFF\xB9\x94\x13\xE4\xD3J\x88\x37\xD6\xE7\xF2\xAB\x36\xDC\xA5l38F\xDB\xD8\x95\x14\x1C\x1B\x36\xE0-\x93\x1E\x07\x94l\x03x\x16\x11\x94\xCD\"8\xD8\xED+\x10\xB5\xDCznl\xCD\x99SA\x12Y0\xAB\x81\f\xAC\xCB\xFE\x8A\x46\x8E\x7F\x8F\x97\x14\xF5\x38v~#\xB4");
		darray_append(strings, append);
		testsPassed++;

		/* Test 9 */
		append.size = sizeof("\x18`\v\xC8\xC5N\xEEM!\x9D\x06@\x98#l\xCEOW(*\f\x92\xF2\xEA\x08\xA6\xCF\x06\xA9Z0\xA3.\xF6\x99\xE0\f@\xA8\x8E\xE7\xD8\xF1.R)\xF4%Y;\xD5h1\x9BW\x81\x8B\xA7Y$\x9A\xD8\xA6L\x85\x43J\xD9\x33\x81\x9A\xEBt/\x0Fs\xFE\x19\xEBg\x93\xDD\x1Dn\xDEzd&\x85\xB8\xAE\x92\xF4\x42\xFA\x45\x94\x0F[Z\x17\xFA\x41Zq\xFF\xD1z\x05}\xFFK\xE9r\xAF\xAB\x61\x86\x98j$\xB0\x9C:\xD8\x1D\xE8\xFD\xE9\x84\xEA\xFE\x63\x99\xC0Y\xCC\xDE\xF7\x1E\xE5\xA7\x96\xE0\xC2M\fA-\x90#\x9F[x\x13#\x8Ev\xBF\xAF\x87\xE1\x8E\xD8>\xF8\xC4'g\xE3L\xC0\xE0\xDC\x15Z\x98\xC4%\xE1\x91\xE9\xEA\xE3\xF6V\x90NK5_K\xE0\x1E\x35")-1;
		oldSize = a.size;
		darray_append_lit(a, "\x18`\v\xC8\xC5N\xEEM!\x9D\x06@\x98#l\xCEOW(*\f\x92\xF2\xEA\x08\xA6\xCF\x06\xA9Z0\xA3.\xF6\x99\xE0\f@\xA8\x8E\xE7\xD8\xF1.R)\xF4%Y;\xD5h1\x9BW\x81\x8B\xA7Y$\x9A\xD8\xA6L\x85\x43J\xD9\x33\x81\x9A\xEBt/\x0Fs\xFE\x19\xEBg\x93\xDD\x1Dn\xDEzd&\x85\xB8\xAE\x92\xF4\x42\xFA\x45\x94\x0F[Z\x17\xFA\x41Zq\xFF\xD1z\x05}\xFFK\xE9r\xAF\xAB\x61\x86\x98j$\xB0\x9C:\xD8\x1D\xE8\xFD\xE9\x84\xEA\xFE\x63\x99\xC0Y\xCC\xDE\xF7\x1E\xE5\xA7\x96\xE0\xC2M\fA-\x90#\x9F[x\x13#\x8Ev\xBF\xAF\x87\xE1\x8E\xD8>\xF8\xC4'g\xE3L\xC0\xE0\xDC\x15Z\x98\xC4%\xE1\x91\xE9\xEA\xE3\xF6V\x90NK5_K\xE0\x1E\x35");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item+oldSize, "\x18`\v\xC8\xC5N\xEEM!\x9D\x06@\x98#l\xCEOW(*\f\x92\xF2\xEA\x08\xA6\xCF\x06\xA9Z0\xA3.\xF6\x99\xE0\f@\xA8\x8E\xE7\xD8\xF1.R)\xF4%Y;\xD5h1\x9BW\x81\x8B\xA7Y$\x9A\xD8\xA6L\x85\x43J\xD9\x33\x81\x9A\xEBt/\x0Fs\xFE\x19\xEBg\x93\xDD\x1Dn\xDEzd&\x85\xB8\xAE\x92\xF4\x42\xFA\x45\x94\x0F[Z\x17\xFA\x41Zq\xFF\xD1z\x05}\xFFK\xE9r\xAF\xAB\x61\x86\x98j$\xB0\x9C:\xD8\x1D\xE8\xFD\xE9\x84\xEA\xFE\x63\x99\xC0Y\xCC\xDE\xF7\x1E\xE5\xA7\x96\xE0\xC2M\fA-\x90#\x9F[x\x13#\x8Ev\xBF\xAF\x87\xE1\x8E\xD8>\xF8\xC4'g\xE3L\xC0\xE0\xDC\x15Z\x98\xC4%\xE1\x91\xE9\xEA\xE3\xF6V\x90NK5_K\xE0\x1E\x35", a.size-oldSize))
			goto end;
		append.item = strdup("\x18`\v\xC8\xC5N\xEEM!\x9D\x06@\x98#l\xCEOW(*\f\x92\xF2\xEA\x08\xA6\xCF\x06\xA9Z0\xA3.\xF6\x99\xE0\f@\xA8\x8E\xE7\xD8\xF1.R)\xF4%Y;\xD5h1\x9BW\x81\x8B\xA7Y$\x9A\xD8\xA6L\x85\x43J\xD9\x33\x81\x9A\xEBt/\x0Fs\xFE\x19\xEBg\x93\xDD\x1Dn\xDEzd&\x85\xB8\xAE\x92\xF4\x42\xFA\x45\x94\x0F[Z\x17\xFA\x41Zq\xFF\xD1z\x05}\xFFK\xE9r\xAF\xAB\x61\x86\x98j$\xB0\x9C:\xD8\x1D\xE8\xFD\xE9\x84\xEA\xFE\x63\x99\xC0Y\xCC\xDE\xF7\x1E\xE5\xA7\x96\xE0\xC2M\fA-\x90#\x9F[x\x13#\x8Ev\xBF\xAF\x87\xE1\x8E\xD8>\xF8\xC4'g\xE3L\xC0\xE0\xDC\x15Z\x98\xC4%\xE1\x91\xE9\xEA\xE3\xF6V\x90NK5_K\xE0\x1E\x35");
		darray_append(strings, append);
		testsPassed++;

	
	if (strings.size != 10)
		goto end;
	
	darray_foreach(i, strings) {
		if (a.size-offs < i->size)
			goto end;
		if (memcmp(a.item+offs, i->item, i->size))
			goto end;
		offs += i->size;
	};
	
	if (offs != a.size)
		goto end;
	if (a.item[offs])
		goto end;
	testsPassed++;
	
end:
	darray_free(a);
	darray_foreach(i, strings)
		free(i->item);
	darray_free(strings);
	return testsPassed == 10+1;
}

static int testdarray_prepend_lit(void) {
	darray_char a = darray_new();
	darray(testLits_string) strings = darray_new();
	testLits_string *i;
	size_t testsPassed = 0;
	size_t oldSize;
	testLits_string append;
	size_t offs;
	
		/* Test 0 */
		append.size = sizeof("*g\xC2;\x98\x92\xD3\x84\xF4\x64\xB4\xC8\x83@\xA6s\xE5\xEF,\xB4\xAB\x12\x36\xE9\x8F\x88\xF8\x9C\v\x08\xE6M\x98\xA0\x1D\x9B\xF5\xD9\xEC \xC2\xFFK;'\xFE?\xF0\xAB\xA3>\x97\xB4n\x11\x65\xA1\xFC\r\x13\x8BU\xC4;\xC3\xD2\xA8l\xE6\xA7\xE0\xCA\xB7@\xA2\xD2\x89\x14\x8A\x05\x33\xB9\xF7\x45yp\x17\xDC\x9C\xBF,\xB6Z(\xE9\xD9\x34g\x0E`\x80\x8Ag\xD0%I\xC1?Y\x16\xFA\xE2.\xB9\x36\xEA\xC1\x06Kj\x9Bx\xF9\xD0\x84\x89\x91\xF4\x87\x14\x93h(\xF1\x98\x38\x9Cq\xC6,\x13\x04\x61\xDA\xC2\xA1\xFE\xF3\xEAz\x9F\xCAyS\xEF\xBB\xF9\\\x16M\xEC\xAB\xC1\x34\x80~\xCE\r:K\xB4\x19\x99\xE1\x82/\x96\x87\xCD\xDD")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "*g\xC2;\x98\x92\xD3\x84\xF4\x64\xB4\xC8\x83@\xA6s\xE5\xEF,\xB4\xAB\x12\x36\xE9\x8F\x88\xF8\x9C\v\x08\xE6M\x98\xA0\x1D\x9B\xF5\xD9\xEC \xC2\xFFK;'\xFE?\xF0\xAB\xA3>\x97\xB4n\x11\x65\xA1\xFC\r\x13\x8BU\xC4;\xC3\xD2\xA8l\xE6\xA7\xE0\xCA\xB7@\xA2\xD2\x89\x14\x8A\x05\x33\xB9\xF7\x45yp\x17\xDC\x9C\xBF,\xB6Z(\xE9\xD9\x34g\x0E`\x80\x8Ag\xD0%I\xC1?Y\x16\xFA\xE2.\xB9\x36\xEA\xC1\x06Kj\x9Bx\xF9\xD0\x84\x89\x91\xF4\x87\x14\x93h(\xF1\x98\x38\x9Cq\xC6,\x13\x04\x61\xDA\xC2\xA1\xFE\xF3\xEAz\x9F\xCAyS\xEF\xBB\xF9\\\x16M\xEC\xAB\xC1\x34\x80~\xCE\r:K\xB4\x19\x99\xE1\x82/\x96\x87\xCD\xDD");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "*g\xC2;\x98\x92\xD3\x84\xF4\x64\xB4\xC8\x83@\xA6s\xE5\xEF,\xB4\xAB\x12\x36\xE9\x8F\x88\xF8\x9C\v\x08\xE6M\x98\xA0\x1D\x9B\xF5\xD9\xEC \xC2\xFFK;'\xFE?\xF0\xAB\xA3>\x97\xB4n\x11\x65\xA1\xFC\r\x13\x8BU\xC4;\xC3\xD2\xA8l\xE6\xA7\xE0\xCA\xB7@\xA2\xD2\x89\x14\x8A\x05\x33\xB9\xF7\x45yp\x17\xDC\x9C\xBF,\xB6Z(\xE9\xD9\x34g\x0E`\x80\x8Ag\xD0%I\xC1?Y\x16\xFA\xE2.\xB9\x36\xEA\xC1\x06Kj\x9Bx\xF9\xD0\x84\x89\x91\xF4\x87\x14\x93h(\xF1\x98\x38\x9Cq\xC6,\x13\x04\x61\xDA\xC2\xA1\xFE\xF3\xEAz\x9F\xCAyS\xEF\xBB\xF9\\\x16M\xEC\xAB\xC1\x34\x80~\xCE\r:K\xB4\x19\x99\xE1\x82/\x96\x87\xCD\xDD", a.size-oldSize))
			goto end;
		append.item = strdup("*g\xC2;\x98\x92\xD3\x84\xF4\x64\xB4\xC8\x83@\xA6s\xE5\xEF,\xB4\xAB\x12\x36\xE9\x8F\x88\xF8\x9C\v\x08\xE6M\x98\xA0\x1D\x9B\xF5\xD9\xEC \xC2\xFFK;'\xFE?\xF0\xAB\xA3>\x97\xB4n\x11\x65\xA1\xFC\r\x13\x8BU\xC4;\xC3\xD2\xA8l\xE6\xA7\xE0\xCA\xB7@\xA2\xD2\x89\x14\x8A\x05\x33\xB9\xF7\x45yp\x17\xDC\x9C\xBF,\xB6Z(\xE9\xD9\x34g\x0E`\x80\x8Ag\xD0%I\xC1?Y\x16\xFA\xE2.\xB9\x36\xEA\xC1\x06Kj\x9Bx\xF9\xD0\x84\x89\x91\xF4\x87\x14\x93h(\xF1\x98\x38\x9Cq\xC6,\x13\x04\x61\xDA\xC2\xA1\xFE\xF3\xEAz\x9F\xCAyS\xEF\xBB\xF9\\\x16M\xEC\xAB\xC1\x34\x80~\xCE\r:K\xB4\x19\x99\xE1\x82/\x96\x87\xCD\xDD");
		darray_append(strings, append);
		testsPassed++;

		/* Test 1 */
		append.size = sizeof("B\xFD\xE5\xB0\xAC]`\n><\xFF\xDC\x38k\x03!\xE5\xFF\xC1\x31\x94\xC8\x1C\xAE\x83\x39\xA2K\xC5u\xA4\xD3\x9C\x07\xB0\xCE\xDF\x33\xE6\x02\xE3P\xE0\x83\xD8\x97<\x95\xF1\xFF\x34I\x89\xD2\x17\xD9\x17\xACH\x01-1-\xBB\x86\xFE\xED\x01\xBA\x01\tvf\x95Wm\xE0\xCBX%\x0E<\xC9\x9D\x19\x06\xD6\x36\xD9\x1C\tI\xB5IE\x80\x87oM;\x1D\xC3\x9D\xB6\t\x89\x37\xE9\xC2\x34\x94\xE3\xEC].I\x86\xD5\x9C\xAE\x87\xB0m\x11=\xDF\xB1\xFE\xD2\xF6`z3\xE7\xC6\xE8\xEEl\x15\x9D>3\xF8\x8D\xC2\x65(`\xE6I\x9B\x15\xFD\xED \f\xC3_\xC5\xBA\x38\xCB\xF7\x9B\xD9\x14VQM\xAD\x98\xDEJ\xCC#\xA8\x92\xB7\x14\xC1\nX\xD9\xB4\x96$\xB1\x12\xAF\x06\x07TmmTM\xAC\x33\xD4:\x8A\x94M:Srcr\x17\x95pKE\xC1\t\xC0\xB1\x84\x11\xF5\x97\x15\x62\x11\x33\x05\xB5\x9A.@\xBF\x13\xD7\xCAn\xBE\x34\xB5\xA6\x15\xB6\x88\x13\xDE\xA3\xE9\xC3/\xF9\x36L\\\x0E\x1Fg\xDD\xC0\x01\xD0\x90\x9ENq*\xBD\x31/ttV\xAC\xA4\x12?s\xC1\xFF\x35\xBB~\xDC\x05\x06\xFF\xF8\xFA\x1B\x65\x11T\x8Fz\xF3W0\x98\x1D\x7F\x03\x9AQ3\te\xAB]\x93\xD6xfS\xE5\xB2$(\xFA\xE4\xD1\xCC\xA9\x80\xF0\xC3\x36uK\xF0\xD2(B`\x11\x04\x9Bx")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "B\xFD\xE5\xB0\xAC]`\n><\xFF\xDC\x38k\x03!\xE5\xFF\xC1\x31\x94\xC8\x1C\xAE\x83\x39\xA2K\xC5u\xA4\xD3\x9C\x07\xB0\xCE\xDF\x33\xE6\x02\xE3P\xE0\x83\xD8\x97<\x95\xF1\xFF\x34I\x89\xD2\x17\xD9\x17\xACH\x01-1-\xBB\x86\xFE\xED\x01\xBA\x01\tvf\x95Wm\xE0\xCBX%\x0E<\xC9\x9D\x19\x06\xD6\x36\xD9\x1C\tI\xB5IE\x80\x87oM;\x1D\xC3\x9D\xB6\t\x89\x37\xE9\xC2\x34\x94\xE3\xEC].I\x86\xD5\x9C\xAE\x87\xB0m\x11=\xDF\xB1\xFE\xD2\xF6`z3\xE7\xC6\xE8\xEEl\x15\x9D>3\xF8\x8D\xC2\x65(`\xE6I\x9B\x15\xFD\xED \f\xC3_\xC5\xBA\x38\xCB\xF7\x9B\xD9\x14VQM\xAD\x98\xDEJ\xCC#\xA8\x92\xB7\x14\xC1\nX\xD9\xB4\x96$\xB1\x12\xAF\x06\x07TmmTM\xAC\x33\xD4:\x8A\x94M:Srcr\x17\x95pKE\xC1\t\xC0\xB1\x84\x11\xF5\x97\x15\x62\x11\x33\x05\xB5\x9A.@\xBF\x13\xD7\xCAn\xBE\x34\xB5\xA6\x15\xB6\x88\x13\xDE\xA3\xE9\xC3/\xF9\x36L\\\x0E\x1Fg\xDD\xC0\x01\xD0\x90\x9ENq*\xBD\x31/ttV\xAC\xA4\x12?s\xC1\xFF\x35\xBB~\xDC\x05\x06\xFF\xF8\xFA\x1B\x65\x11T\x8Fz\xF3W0\x98\x1D\x7F\x03\x9AQ3\te\xAB]\x93\xD6xfS\xE5\xB2$(\xFA\xE4\xD1\xCC\xA9\x80\xF0\xC3\x36uK\xF0\xD2(B`\x11\x04\x9Bx");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "B\xFD\xE5\xB0\xAC]`\n><\xFF\xDC\x38k\x03!\xE5\xFF\xC1\x31\x94\xC8\x1C\xAE\x83\x39\xA2K\xC5u\xA4\xD3\x9C\x07\xB0\xCE\xDF\x33\xE6\x02\xE3P\xE0\x83\xD8\x97<\x95\xF1\xFF\x34I\x89\xD2\x17\xD9\x17\xACH\x01-1-\xBB\x86\xFE\xED\x01\xBA\x01\tvf\x95Wm\xE0\xCBX%\x0E<\xC9\x9D\x19\x06\xD6\x36\xD9\x1C\tI\xB5IE\x80\x87oM;\x1D\xC3\x9D\xB6\t\x89\x37\xE9\xC2\x34\x94\xE3\xEC].I\x86\xD5\x9C\xAE\x87\xB0m\x11=\xDF\xB1\xFE\xD2\xF6`z3\xE7\xC6\xE8\xEEl\x15\x9D>3\xF8\x8D\xC2\x65(`\xE6I\x9B\x15\xFD\xED \f\xC3_\xC5\xBA\x38\xCB\xF7\x9B\xD9\x14VQM\xAD\x98\xDEJ\xCC#\xA8\x92\xB7\x14\xC1\nX\xD9\xB4\x96$\xB1\x12\xAF\x06\x07TmmTM\xAC\x33\xD4:\x8A\x94M:Srcr\x17\x95pKE\xC1\t\xC0\xB1\x84\x11\xF5\x97\x15\x62\x11\x33\x05\xB5\x9A.@\xBF\x13\xD7\xCAn\xBE\x34\xB5\xA6\x15\xB6\x88\x13\xDE\xA3\xE9\xC3/\xF9\x36L\\\x0E\x1Fg\xDD\xC0\x01\xD0\x90\x9ENq*\xBD\x31/ttV\xAC\xA4\x12?s\xC1\xFF\x35\xBB~\xDC\x05\x06\xFF\xF8\xFA\x1B\x65\x11T\x8Fz\xF3W0\x98\x1D\x7F\x03\x9AQ3\te\xAB]\x93\xD6xfS\xE5\xB2$(\xFA\xE4\xD1\xCC\xA9\x80\xF0\xC3\x36uK\xF0\xD2(B`\x11\x04\x9Bx", a.size-oldSize))
			goto end;
		append.item = strdup("B\xFD\xE5\xB0\xAC]`\n><\xFF\xDC\x38k\x03!\xE5\xFF\xC1\x31\x94\xC8\x1C\xAE\x83\x39\xA2K\xC5u\xA4\xD3\x9C\x07\xB0\xCE\xDF\x33\xE6\x02\xE3P\xE0\x83\xD8\x97<\x95\xF1\xFF\x34I\x89\xD2\x17\xD9\x17\xACH\x01-1-\xBB\x86\xFE\xED\x01\xBA\x01\tvf\x95Wm\xE0\xCBX%\x0E<\xC9\x9D\x19\x06\xD6\x36\xD9\x1C\tI\xB5IE\x80\x87oM;\x1D\xC3\x9D\xB6\t\x89\x37\xE9\xC2\x34\x94\xE3\xEC].I\x86\xD5\x9C\xAE\x87\xB0m\x11=\xDF\xB1\xFE\xD2\xF6`z3\xE7\xC6\xE8\xEEl\x15\x9D>3\xF8\x8D\xC2\x65(`\xE6I\x9B\x15\xFD\xED \f\xC3_\xC5\xBA\x38\xCB\xF7\x9B\xD9\x14VQM\xAD\x98\xDEJ\xCC#\xA8\x92\xB7\x14\xC1\nX\xD9\xB4\x96$\xB1\x12\xAF\x06\x07TmmTM\xAC\x33\xD4:\x8A\x94M:Srcr\x17\x95pKE\xC1\t\xC0\xB1\x84\x11\xF5\x97\x15\x62\x11\x33\x05\xB5\x9A.@\xBF\x13\xD7\xCAn\xBE\x34\xB5\xA6\x15\xB6\x88\x13\xDE\xA3\xE9\xC3/\xF9\x36L\\\x0E\x1Fg\xDD\xC0\x01\xD0\x90\x9ENq*\xBD\x31/ttV\xAC\xA4\x12?s\xC1\xFF\x35\xBB~\xDC\x05\x06\xFF\xF8\xFA\x1B\x65\x11T\x8Fz\xF3W0\x98\x1D\x7F\x03\x9AQ3\te\xAB]\x93\xD6xfS\xE5\xB2$(\xFA\xE4\xD1\xCC\xA9\x80\xF0\xC3\x36uK\xF0\xD2(B`\x11\x04\x9Bx");
		darray_append(strings, append);
		testsPassed++;

		/* Test 2 */
		append.size = sizeof("\x1C\xBA\x07\x30\xD4|%e'yY\x7F\xE2\xD4~\xAB<\xEC%#\x80\xDC\x46\x65\xCA\x9D~\x86\xD6\x84\xF3\x38^\x90\x9A~F\x8F\xF7JH\xFC\xAB\x8Eo\x10W\x97\r\xDB\x36.\xEC\x92\xFBV\x11j\x98\xDAs\x1B&M\xB5\x1D\r\xCD\x14\x34\xA1\x96\xD5\xAD\x05)\xD0\xD9\xA5\xFA\xF3\xD9\x83n\x9A\x95\xDA\xB4\xF5\x1C\"6\x02\x36\x9B)\xA1\x35t+\xA9\xDBS\xD1\x42\x91\xCAr\x8Bq\xE9\x86\x18\xC2\xBE\xDC\xA3\xC4!\xCF\x33\xFE\x81^\x82\x35\x46\x31jG\xB3\x93\x8A\xB5\xD6\xC5\xE5IIVL.u\xD1\x91\"9\xB0\xAF\x86#\x8E\x81>\xC6\xC8\xF5\xAC\xD3\xA5\xC5O\x95\xCA\xAA\x93\x35\x9C\xE8\xB6R\x1F\xE4\xD8\r\xB5\x84K:\xBE\xF3\xDE\x9A\x83\xC8J\xD4\xD7\xBF\x84\x46\xE7\x05;\xFF}\xAAML\xF3\x65,\xA0\x8A\xBF\xA4\"\x9D\x0E*\xAE\x89NA \x12\xCD\xFC\x9A\xE2\xD9\xF0\x62\x08jA\xC3\x44}%\xD1O:\xBAs\xD1\x66I\x10r\x8C\x41\xBFY\r\xA5VP\xD0\x1E\xB6iC\xC9\x65 \xFF\xA9\x8E\x01\xEF\xAE@u\x14\x03\xE9\x34\x83\xBC\xED\x83\xBCW\xB8\xF0\xD9\x65\x41\x07\xA1\xB1 \x03\x39\xC6\x8C\xEF\x92\x81u\x10\x91\xB8\x38\x38*\"\x96m\xEB\fh\xFD%Z\xD7\x64GID^\xA4\x97Q\x8D\xB3\x1B\xE4O:\xC8\x9D\xD0\x89\xAF\xC4)6'\xD5\xB2.\xDD,kZ\xF0n|\x86kU\xB2V\x01\x65\x0F\xA4\xF1\xEC\xD8\xF6\x89\x7F\x14\xCD\v\x14\xAD\x19\xA0`\x9F)\nW\xB6\x9C\x39\xEB;\xBEJ\xD8\x11\xB8.\xB9\xCF\x81N{m\xE9\x65L\xD2?7\x19\x03\xB8\xB5\x95\x9C!\xDA\x82\x43\x45\x42<\xF3\x8B\xA7\xAB\xE1\x41\x06\x88\x31\x8D\xC8\x7F\xF2\x99\f\xEF\xC5%\x80\x9E\xAC\x93S\x07\x46\xE1l\xC7\x7F\x86\xAA\x05\x83%\xA1\xD9\x34\xAE\xF8\x04\xBCh\xAE")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "\x1C\xBA\x07\x30\xD4|%e'yY\x7F\xE2\xD4~\xAB<\xEC%#\x80\xDC\x46\x65\xCA\x9D~\x86\xD6\x84\xF3\x38^\x90\x9A~F\x8F\xF7JH\xFC\xAB\x8Eo\x10W\x97\r\xDB\x36.\xEC\x92\xFBV\x11j\x98\xDAs\x1B&M\xB5\x1D\r\xCD\x14\x34\xA1\x96\xD5\xAD\x05)\xD0\xD9\xA5\xFA\xF3\xD9\x83n\x9A\x95\xDA\xB4\xF5\x1C\"6\x02\x36\x9B)\xA1\x35t+\xA9\xDBS\xD1\x42\x91\xCAr\x8Bq\xE9\x86\x18\xC2\xBE\xDC\xA3\xC4!\xCF\x33\xFE\x81^\x82\x35\x46\x31jG\xB3\x93\x8A\xB5\xD6\xC5\xE5IIVL.u\xD1\x91\"9\xB0\xAF\x86#\x8E\x81>\xC6\xC8\xF5\xAC\xD3\xA5\xC5O\x95\xCA\xAA\x93\x35\x9C\xE8\xB6R\x1F\xE4\xD8\r\xB5\x84K:\xBE\xF3\xDE\x9A\x83\xC8J\xD4\xD7\xBF\x84\x46\xE7\x05;\xFF}\xAAML\xF3\x65,\xA0\x8A\xBF\xA4\"\x9D\x0E*\xAE\x89NA \x12\xCD\xFC\x9A\xE2\xD9\xF0\x62\x08jA\xC3\x44}%\xD1O:\xBAs\xD1\x66I\x10r\x8C\x41\xBFY\r\xA5VP\xD0\x1E\xB6iC\xC9\x65 \xFF\xA9\x8E\x01\xEF\xAE@u\x14\x03\xE9\x34\x83\xBC\xED\x83\xBCW\xB8\xF0\xD9\x65\x41\x07\xA1\xB1 \x03\x39\xC6\x8C\xEF\x92\x81u\x10\x91\xB8\x38\x38*\"\x96m\xEB\fh\xFD%Z\xD7\x64GID^\xA4\x97Q\x8D\xB3\x1B\xE4O:\xC8\x9D\xD0\x89\xAF\xC4)6'\xD5\xB2.\xDD,kZ\xF0n|\x86kU\xB2V\x01\x65\x0F\xA4\xF1\xEC\xD8\xF6\x89\x7F\x14\xCD\v\x14\xAD\x19\xA0`\x9F)\nW\xB6\x9C\x39\xEB;\xBEJ\xD8\x11\xB8.\xB9\xCF\x81N{m\xE9\x65L\xD2?7\x19\x03\xB8\xB5\x95\x9C!\xDA\x82\x43\x45\x42<\xF3\x8B\xA7\xAB\xE1\x41\x06\x88\x31\x8D\xC8\x7F\xF2\x99\f\xEF\xC5%\x80\x9E\xAC\x93S\x07\x46\xE1l\xC7\x7F\x86\xAA\x05\x83%\xA1\xD9\x34\xAE\xF8\x04\xBCh\xAE");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "\x1C\xBA\x07\x30\xD4|%e'yY\x7F\xE2\xD4~\xAB<\xEC%#\x80\xDC\x46\x65\xCA\x9D~\x86\xD6\x84\xF3\x38^\x90\x9A~F\x8F\xF7JH\xFC\xAB\x8Eo\x10W\x97\r\xDB\x36.\xEC\x92\xFBV\x11j\x98\xDAs\x1B&M\xB5\x1D\r\xCD\x14\x34\xA1\x96\xD5\xAD\x05)\xD0\xD9\xA5\xFA\xF3\xD9\x83n\x9A\x95\xDA\xB4\xF5\x1C\"6\x02\x36\x9B)\xA1\x35t+\xA9\xDBS\xD1\x42\x91\xCAr\x8Bq\xE9\x86\x18\xC2\xBE\xDC\xA3\xC4!\xCF\x33\xFE\x81^\x82\x35\x46\x31jG\xB3\x93\x8A\xB5\xD6\xC5\xE5IIVL.u\xD1\x91\"9\xB0\xAF\x86#\x8E\x81>\xC6\xC8\xF5\xAC\xD3\xA5\xC5O\x95\xCA\xAA\x93\x35\x9C\xE8\xB6R\x1F\xE4\xD8\r\xB5\x84K:\xBE\xF3\xDE\x9A\x83\xC8J\xD4\xD7\xBF\x84\x46\xE7\x05;\xFF}\xAAML\xF3\x65,\xA0\x8A\xBF\xA4\"\x9D\x0E*\xAE\x89NA \x12\xCD\xFC\x9A\xE2\xD9\xF0\x62\x08jA\xC3\x44}%\xD1O:\xBAs\xD1\x66I\x10r\x8C\x41\xBFY\r\xA5VP\xD0\x1E\xB6iC\xC9\x65 \xFF\xA9\x8E\x01\xEF\xAE@u\x14\x03\xE9\x34\x83\xBC\xED\x83\xBCW\xB8\xF0\xD9\x65\x41\x07\xA1\xB1 \x03\x39\xC6\x8C\xEF\x92\x81u\x10\x91\xB8\x38\x38*\"\x96m\xEB\fh\xFD%Z\xD7\x64GID^\xA4\x97Q\x8D\xB3\x1B\xE4O:\xC8\x9D\xD0\x89\xAF\xC4)6'\xD5\xB2.\xDD,kZ\xF0n|\x86kU\xB2V\x01\x65\x0F\xA4\xF1\xEC\xD8\xF6\x89\x7F\x14\xCD\v\x14\xAD\x19\xA0`\x9F)\nW\xB6\x9C\x39\xEB;\xBEJ\xD8\x11\xB8.\xB9\xCF\x81N{m\xE9\x65L\xD2?7\x19\x03\xB8\xB5\x95\x9C!\xDA\x82\x43\x45\x42<\xF3\x8B\xA7\xAB\xE1\x41\x06\x88\x31\x8D\xC8\x7F\xF2\x99\f\xEF\xC5%\x80\x9E\xAC\x93S\x07\x46\xE1l\xC7\x7F\x86\xAA\x05\x83%\xA1\xD9\x34\xAE\xF8\x04\xBCh\xAE", a.size-oldSize))
			goto end;
		append.item = strdup("\x1C\xBA\x07\x30\xD4|%e'yY\x7F\xE2\xD4~\xAB<\xEC%#\x80\xDC\x46\x65\xCA\x9D~\x86\xD6\x84\xF3\x38^\x90\x9A~F\x8F\xF7JH\xFC\xAB\x8Eo\x10W\x97\r\xDB\x36.\xEC\x92\xFBV\x11j\x98\xDAs\x1B&M\xB5\x1D\r\xCD\x14\x34\xA1\x96\xD5\xAD\x05)\xD0\xD9\xA5\xFA\xF3\xD9\x83n\x9A\x95\xDA\xB4\xF5\x1C\"6\x02\x36\x9B)\xA1\x35t+\xA9\xDBS\xD1\x42\x91\xCAr\x8Bq\xE9\x86\x18\xC2\xBE\xDC\xA3\xC4!\xCF\x33\xFE\x81^\x82\x35\x46\x31jG\xB3\x93\x8A\xB5\xD6\xC5\xE5IIVL.u\xD1\x91\"9\xB0\xAF\x86#\x8E\x81>\xC6\xC8\xF5\xAC\xD3\xA5\xC5O\x95\xCA\xAA\x93\x35\x9C\xE8\xB6R\x1F\xE4\xD8\r\xB5\x84K:\xBE\xF3\xDE\x9A\x83\xC8J\xD4\xD7\xBF\x84\x46\xE7\x05;\xFF}\xAAML\xF3\x65,\xA0\x8A\xBF\xA4\"\x9D\x0E*\xAE\x89NA \x12\xCD\xFC\x9A\xE2\xD9\xF0\x62\x08jA\xC3\x44}%\xD1O:\xBAs\xD1\x66I\x10r\x8C\x41\xBFY\r\xA5VP\xD0\x1E\xB6iC\xC9\x65 \xFF\xA9\x8E\x01\xEF\xAE@u\x14\x03\xE9\x34\x83\xBC\xED\x83\xBCW\xB8\xF0\xD9\x65\x41\x07\xA1\xB1 \x03\x39\xC6\x8C\xEF\x92\x81u\x10\x91\xB8\x38\x38*\"\x96m\xEB\fh\xFD%Z\xD7\x64GID^\xA4\x97Q\x8D\xB3\x1B\xE4O:\xC8\x9D\xD0\x89\xAF\xC4)6'\xD5\xB2.\xDD,kZ\xF0n|\x86kU\xB2V\x01\x65\x0F\xA4\xF1\xEC\xD8\xF6\x89\x7F\x14\xCD\v\x14\xAD\x19\xA0`\x9F)\nW\xB6\x9C\x39\xEB;\xBEJ\xD8\x11\xB8.\xB9\xCF\x81N{m\xE9\x65L\xD2?7\x19\x03\xB8\xB5\x95\x9C!\xDA\x82\x43\x45\x42<\xF3\x8B\xA7\xAB\xE1\x41\x06\x88\x31\x8D\xC8\x7F\xF2\x99\f\xEF\xC5%\x80\x9E\xAC\x93S\x07\x46\xE1l\xC7\x7F\x86\xAA\x05\x83%\xA1\xD9\x34\xAE\xF8\x04\xBCh\xAE");
		darray_append(strings, append);
		testsPassed++;

		/* Test 3 */
		append.size = sizeof("\xE8\xD1\x31")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "\xE8\xD1\x31");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "\xE8\xD1\x31", a.size-oldSize))
			goto end;
		append.item = strdup("\xE8\xD1\x31");
		darray_append(strings, append);
		testsPassed++;

		/* Test 4 */
		append.size = sizeof("\\\x99{A\xC4\x86\xEA\xC4\x41]\xACi\x8C\x08\xFC?\x17\x9E\x90\x83<a\xB9n\xE7g\x04\xF8;\x97\x63=\x7FPy\xDB\xBCJ=\xDA\x13V{pg\xD4/\xB5\x1B\xDD&io\x9D?\xA7\x18,\xE4h\xE3\xB1]\xE4\xB5Iq\xDE\x02%\xBD\x9Al\x8Co\xEC")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "\\\x99{A\xC4\x86\xEA\xC4\x41]\xACi\x8C\x08\xFC?\x17\x9E\x90\x83<a\xB9n\xE7g\x04\xF8;\x97\x63=\x7FPy\xDB\xBCJ=\xDA\x13V{pg\xD4/\xB5\x1B\xDD&io\x9D?\xA7\x18,\xE4h\xE3\xB1]\xE4\xB5Iq\xDE\x02%\xBD\x9Al\x8Co\xEC");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "\\\x99{A\xC4\x86\xEA\xC4\x41]\xACi\x8C\x08\xFC?\x17\x9E\x90\x83<a\xB9n\xE7g\x04\xF8;\x97\x63=\x7FPy\xDB\xBCJ=\xDA\x13V{pg\xD4/\xB5\x1B\xDD&io\x9D?\xA7\x18,\xE4h\xE3\xB1]\xE4\xB5Iq\xDE\x02%\xBD\x9Al\x8Co\xEC", a.size-oldSize))
			goto end;
		append.item = strdup("\\\x99{A\xC4\x86\xEA\xC4\x41]\xACi\x8C\x08\xFC?\x17\x9E\x90\x83<a\xB9n\xE7g\x04\xF8;\x97\x63=\x7FPy\xDB\xBCJ=\xDA\x13V{pg\xD4/\xB5\x1B\xDD&io\x9D?\xA7\x18,\xE4h\xE3\xB1]\xE4\xB5Iq\xDE\x02%\xBD\x9Al\x8Co\xEC");
		darray_append(strings, append);
		testsPassed++;

		/* Test 5 */
		append.size = sizeof("\x1A\xDD\xD2\xAE\xA7H\xB1\xD4J\xA0\xC5Y\x08\xC7Q\xD4\x41\x46\xA5\x1F\xE1\xEE\x14\x0EP\xFE\x14o\xEF\xB8\x33\x93\x43\xB5YEV3L\xF4\x9F=\x19P\x9B&\xE5\xA7\xF9\x63s\xCB\xCF\x87M^\x92\xB6TnT")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "\x1A\xDD\xD2\xAE\xA7H\xB1\xD4J\xA0\xC5Y\x08\xC7Q\xD4\x41\x46\xA5\x1F\xE1\xEE\x14\x0EP\xFE\x14o\xEF\xB8\x33\x93\x43\xB5YEV3L\xF4\x9F=\x19P\x9B&\xE5\xA7\xF9\x63s\xCB\xCF\x87M^\x92\xB6TnT");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "\x1A\xDD\xD2\xAE\xA7H\xB1\xD4J\xA0\xC5Y\x08\xC7Q\xD4\x41\x46\xA5\x1F\xE1\xEE\x14\x0EP\xFE\x14o\xEF\xB8\x33\x93\x43\xB5YEV3L\xF4\x9F=\x19P\x9B&\xE5\xA7\xF9\x63s\xCB\xCF\x87M^\x92\xB6TnT", a.size-oldSize))
			goto end;
		append.item = strdup("\x1A\xDD\xD2\xAE\xA7H\xB1\xD4J\xA0\xC5Y\x08\xC7Q\xD4\x41\x46\xA5\x1F\xE1\xEE\x14\x0EP\xFE\x14o\xEF\xB8\x33\x93\x43\xB5YEV3L\xF4\x9F=\x19P\x9B&\xE5\xA7\xF9\x63s\xCB\xCF\x87M^\x92\xB6TnT");
		darray_append(strings, append);
		testsPassed++;

		/* Test 6 */
		append.size = sizeof("\xAF\x37\xE2\x8Bl\xD3\xB9]\x8E\xF9N\xB2@\xE7\x45\xF8\x99\x9E\x66\xB8\xD6\xE4\x82\x44\x89\xD7\x93\xCF\xDF\xA2\x32\x42\xC2\x66\xF6\xA4\x83\x19\x95\x90ts\x99/\xA7\x33\xCC\xA5ka\xC2\x1E\x39\x36\x63\x99\xF7\x10\\\r\xE4\\\xE3\xAD+\xB9\xFC\xB8\xAC\x82K\xD5\x17\x45\xE8\x85\x12\v\xD5\xC2\r\x10\xEF@\xCF\x8B\x7F[w\xFD\x98\xBB\xB0\x30\xEBo~\xE9\x61\x18\xB7(\x1E\x93\xC7\x42J\x9F\x99\xE2\x9B@P\x16\xF8\x19\x9Ak\x17*\xF4\x9C\xFD\xFE\xDF\x95\xC2\x8C/\xBC\xB9\x8B\xB5`\xABt]\xEAl\xB7\xAD\\kn_K\xAER\v\xA7\x8E\xEF\x45\xEAw\x1D\xC7\x85\xA3\xAC\x99tcd\\n\xFA\x8B.\xD7\x91\xEB\x8D\tkkJ\xDD\xD6\"\xC0\x44\x46\xD2\xDD\xDDzn\xA6\x8A\xE2\xE1\xA7Q\xE5\x39\xC0\xC9\xBB=1K\xEC\x9A\xC2\xF0\x1CjS}q\f\xE1\x41\xD6,\x05\xB4\x16R\x05\xD4H\x9Bv\x93\xB4\xD8\xF2}\x1F\x64\xD6r\xFF\x14\x13I'b\x99[\x92\x1E\x9B\xB2\x35\x02\xE9=8\xB9\xD9\xBB\xEB*\x97\x8A\xC8\xEB\xF4!\xE2<\x05\xC3g\x1Dx\xEA\xF5\x99\x83lT\x1E/\xB4\x37})z\xA3\xBE\xF0?\x1FsM1\x81\xC3\x8B\xEA\xF6\x8C\xC3\x11\x9E\xC0\x89\xFA}\x95|tW\x1B+\xBE\xFD\xE9\x44\x38\x1D\xD4\x01\x03\xCD<a\xC7l\xE3w")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "\xAF\x37\xE2\x8Bl\xD3\xB9]\x8E\xF9N\xB2@\xE7\x45\xF8\x99\x9E\x66\xB8\xD6\xE4\x82\x44\x89\xD7\x93\xCF\xDF\xA2\x32\x42\xC2\x66\xF6\xA4\x83\x19\x95\x90ts\x99/\xA7\x33\xCC\xA5ka\xC2\x1E\x39\x36\x63\x99\xF7\x10\\\r\xE4\\\xE3\xAD+\xB9\xFC\xB8\xAC\x82K\xD5\x17\x45\xE8\x85\x12\v\xD5\xC2\r\x10\xEF@\xCF\x8B\x7F[w\xFD\x98\xBB\xB0\x30\xEBo~\xE9\x61\x18\xB7(\x1E\x93\xC7\x42J\x9F\x99\xE2\x9B@P\x16\xF8\x19\x9Ak\x17*\xF4\x9C\xFD\xFE\xDF\x95\xC2\x8C/\xBC\xB9\x8B\xB5`\xABt]\xEAl\xB7\xAD\\kn_K\xAER\v\xA7\x8E\xEF\x45\xEAw\x1D\xC7\x85\xA3\xAC\x99tcd\\n\xFA\x8B.\xD7\x91\xEB\x8D\tkkJ\xDD\xD6\"\xC0\x44\x46\xD2\xDD\xDDzn\xA6\x8A\xE2\xE1\xA7Q\xE5\x39\xC0\xC9\xBB=1K\xEC\x9A\xC2\xF0\x1CjS}q\f\xE1\x41\xD6,\x05\xB4\x16R\x05\xD4H\x9Bv\x93\xB4\xD8\xF2}\x1F\x64\xD6r\xFF\x14\x13I'b\x99[\x92\x1E\x9B\xB2\x35\x02\xE9=8\xB9\xD9\xBB\xEB*\x97\x8A\xC8\xEB\xF4!\xE2<\x05\xC3g\x1Dx\xEA\xF5\x99\x83lT\x1E/\xB4\x37})z\xA3\xBE\xF0?\x1FsM1\x81\xC3\x8B\xEA\xF6\x8C\xC3\x11\x9E\xC0\x89\xFA}\x95|tW\x1B+\xBE\xFD\xE9\x44\x38\x1D\xD4\x01\x03\xCD<a\xC7l\xE3w");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "\xAF\x37\xE2\x8Bl\xD3\xB9]\x8E\xF9N\xB2@\xE7\x45\xF8\x99\x9E\x66\xB8\xD6\xE4\x82\x44\x89\xD7\x93\xCF\xDF\xA2\x32\x42\xC2\x66\xF6\xA4\x83\x19\x95\x90ts\x99/\xA7\x33\xCC\xA5ka\xC2\x1E\x39\x36\x63\x99\xF7\x10\\\r\xE4\\\xE3\xAD+\xB9\xFC\xB8\xAC\x82K\xD5\x17\x45\xE8\x85\x12\v\xD5\xC2\r\x10\xEF@\xCF\x8B\x7F[w\xFD\x98\xBB\xB0\x30\xEBo~\xE9\x61\x18\xB7(\x1E\x93\xC7\x42J\x9F\x99\xE2\x9B@P\x16\xF8\x19\x9Ak\x17*\xF4\x9C\xFD\xFE\xDF\x95\xC2\x8C/\xBC\xB9\x8B\xB5`\xABt]\xEAl\xB7\xAD\\kn_K\xAER\v\xA7\x8E\xEF\x45\xEAw\x1D\xC7\x85\xA3\xAC\x99tcd\\n\xFA\x8B.\xD7\x91\xEB\x8D\tkkJ\xDD\xD6\"\xC0\x44\x46\xD2\xDD\xDDzn\xA6\x8A\xE2\xE1\xA7Q\xE5\x39\xC0\xC9\xBB=1K\xEC\x9A\xC2\xF0\x1CjS}q\f\xE1\x41\xD6,\x05\xB4\x16R\x05\xD4H\x9Bv\x93\xB4\xD8\xF2}\x1F\x64\xD6r\xFF\x14\x13I'b\x99[\x92\x1E\x9B\xB2\x35\x02\xE9=8\xB9\xD9\xBB\xEB*\x97\x8A\xC8\xEB\xF4!\xE2<\x05\xC3g\x1Dx\xEA\xF5\x99\x83lT\x1E/\xB4\x37})z\xA3\xBE\xF0?\x1FsM1\x81\xC3\x8B\xEA\xF6\x8C\xC3\x11\x9E\xC0\x89\xFA}\x95|tW\x1B+\xBE\xFD\xE9\x44\x38\x1D\xD4\x01\x03\xCD<a\xC7l\xE3w", a.size-oldSize))
			goto end;
		append.item = strdup("\xAF\x37\xE2\x8Bl\xD3\xB9]\x8E\xF9N\xB2@\xE7\x45\xF8\x99\x9E\x66\xB8\xD6\xE4\x82\x44\x89\xD7\x93\xCF\xDF\xA2\x32\x42\xC2\x66\xF6\xA4\x83\x19\x95\x90ts\x99/\xA7\x33\xCC\xA5ka\xC2\x1E\x39\x36\x63\x99\xF7\x10\\\r\xE4\\\xE3\xAD+\xB9\xFC\xB8\xAC\x82K\xD5\x17\x45\xE8\x85\x12\v\xD5\xC2\r\x10\xEF@\xCF\x8B\x7F[w\xFD\x98\xBB\xB0\x30\xEBo~\xE9\x61\x18\xB7(\x1E\x93\xC7\x42J\x9F\x99\xE2\x9B@P\x16\xF8\x19\x9Ak\x17*\xF4\x9C\xFD\xFE\xDF\x95\xC2\x8C/\xBC\xB9\x8B\xB5`\xABt]\xEAl\xB7\xAD\\kn_K\xAER\v\xA7\x8E\xEF\x45\xEAw\x1D\xC7\x85\xA3\xAC\x99tcd\\n\xFA\x8B.\xD7\x91\xEB\x8D\tkkJ\xDD\xD6\"\xC0\x44\x46\xD2\xDD\xDDzn\xA6\x8A\xE2\xE1\xA7Q\xE5\x39\xC0\xC9\xBB=1K\xEC\x9A\xC2\xF0\x1CjS}q\f\xE1\x41\xD6,\x05\xB4\x16R\x05\xD4H\x9Bv\x93\xB4\xD8\xF2}\x1F\x64\xD6r\xFF\x14\x13I'b\x99[\x92\x1E\x9B\xB2\x35\x02\xE9=8\xB9\xD9\xBB\xEB*\x97\x8A\xC8\xEB\xF4!\xE2<\x05\xC3g\x1Dx\xEA\xF5\x99\x83lT\x1E/\xB4\x37})z\xA3\xBE\xF0?\x1FsM1\x81\xC3\x8B\xEA\xF6\x8C\xC3\x11\x9E\xC0\x89\xFA}\x95|tW\x1B+\xBE\xFD\xE9\x44\x38\x1D\xD4\x01\x03\xCD<a\xC7l\xE3w");
		darray_append(strings, append);
		testsPassed++;

		/* Test 7 */
		append.size = sizeof("J\x8E\x1A\xBB\x35\xF4\xEDQ\xE5\xE6|Z[\x04\x37\xC7\xCB\xAB~\x07P\xFE\r9\xF4\x9A\x07\x02P\xB1{\xF9\x42\x1E\x91\x9A\xFC\x8E?\x17\x61Y\xDFIq\x9E\x03\xC7\xB4\xBC\xAA\x1E\xE6\xA4y\x15\x8D\x06\x42\x39\x1D\xDB\xC8\xC2O\xA4\xEA\xF9\xAC\x08\xF6\x1E\xD6\v\t\x14<u\xCC\x0E\xBA.f\xADQga)\x8B\x87\x65(%\xF1M\x88,C\x7FVx\x99\xCBp\xC8\xD3Pk\xC8;\r\xF7\xCE A\x11\xCA\x9A\xA6GW\x8E\x16\xAC\x30\xA8R\x12>\xC8\xCF\x30\x17\x1C\x16\x99\v\xA2\xC3Q{\x17\xB5|4\xC4On\x11\xBC\x46SL\xE1\x61\x1A\xE5W\xFF:\xA0\xDA\xBD\x95\xCBG\xAD(\xAE)-\\\x8F\x64\x95\v\xCB\xE1")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "J\x8E\x1A\xBB\x35\xF4\xEDQ\xE5\xE6|Z[\x04\x37\xC7\xCB\xAB~\x07P\xFE\r9\xF4\x9A\x07\x02P\xB1{\xF9\x42\x1E\x91\x9A\xFC\x8E?\x17\x61Y\xDFIq\x9E\x03\xC7\xB4\xBC\xAA\x1E\xE6\xA4y\x15\x8D\x06\x42\x39\x1D\xDB\xC8\xC2O\xA4\xEA\xF9\xAC\x08\xF6\x1E\xD6\v\t\x14<u\xCC\x0E\xBA.f\xADQga)\x8B\x87\x65(%\xF1M\x88,C\x7FVx\x99\xCBp\xC8\xD3Pk\xC8;\r\xF7\xCE A\x11\xCA\x9A\xA6GW\x8E\x16\xAC\x30\xA8R\x12>\xC8\xCF\x30\x17\x1C\x16\x99\v\xA2\xC3Q{\x17\xB5|4\xC4On\x11\xBC\x46SL\xE1\x61\x1A\xE5W\xFF:\xA0\xDA\xBD\x95\xCBG\xAD(\xAE)-\\\x8F\x64\x95\v\xCB\xE1");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "J\x8E\x1A\xBB\x35\xF4\xEDQ\xE5\xE6|Z[\x04\x37\xC7\xCB\xAB~\x07P\xFE\r9\xF4\x9A\x07\x02P\xB1{\xF9\x42\x1E\x91\x9A\xFC\x8E?\x17\x61Y\xDFIq\x9E\x03\xC7\xB4\xBC\xAA\x1E\xE6\xA4y\x15\x8D\x06\x42\x39\x1D\xDB\xC8\xC2O\xA4\xEA\xF9\xAC\x08\xF6\x1E\xD6\v\t\x14<u\xCC\x0E\xBA.f\xADQga)\x8B\x87\x65(%\xF1M\x88,C\x7FVx\x99\xCBp\xC8\xD3Pk\xC8;\r\xF7\xCE A\x11\xCA\x9A\xA6GW\x8E\x16\xAC\x30\xA8R\x12>\xC8\xCF\x30\x17\x1C\x16\x99\v\xA2\xC3Q{\x17\xB5|4\xC4On\x11\xBC\x46SL\xE1\x61\x1A\xE5W\xFF:\xA0\xDA\xBD\x95\xCBG\xAD(\xAE)-\\\x8F\x64\x95\v\xCB\xE1", a.size-oldSize))
			goto end;
		append.item = strdup("J\x8E\x1A\xBB\x35\xF4\xEDQ\xE5\xE6|Z[\x04\x37\xC7\xCB\xAB~\x07P\xFE\r9\xF4\x9A\x07\x02P\xB1{\xF9\x42\x1E\x91\x9A\xFC\x8E?\x17\x61Y\xDFIq\x9E\x03\xC7\xB4\xBC\xAA\x1E\xE6\xA4y\x15\x8D\x06\x42\x39\x1D\xDB\xC8\xC2O\xA4\xEA\xF9\xAC\x08\xF6\x1E\xD6\v\t\x14<u\xCC\x0E\xBA.f\xADQga)\x8B\x87\x65(%\xF1M\x88,C\x7FVx\x99\xCBp\xC8\xD3Pk\xC8;\r\xF7\xCE A\x11\xCA\x9A\xA6GW\x8E\x16\xAC\x30\xA8R\x12>\xC8\xCF\x30\x17\x1C\x16\x99\v\xA2\xC3Q{\x17\xB5|4\xC4On\x11\xBC\x46SL\xE1\x61\x1A\xE5W\xFF:\xA0\xDA\xBD\x95\xCBG\xAD(\xAE)-\\\x8F\x64\x95\v\xCB\xE1");
		darray_append(strings, append);
		testsPassed++;

		/* Test 8 */
		append.size = sizeof("DM\x8D]\x92\xC8\x33Y\x8F\x04\x1C?\xB5I\xE9\xEF\xCC\xD4\xB8\xBF\xE9\xC1x\xEA\x46\xB5kQN\xBFLoT\xB4-v\xF5\x31\xD8\xC8\xD3\xF8;r\xE7\xE2\x62\xEF\xA8\xD8O+_M\xED\x16=6|\x86@\x1C\xF1t\x81^\xD1\x8D\xD7\x87\"g?D'\x90[\xBC\x9D\x62\f\xC8W\xD0\xE8\x14\x12o\x80;\n{\x1B\xC0\xD4\xBA\x13\xCD\x8CV\xB5\xFA\xCA&31\xBF\x1DIh\x18\xFB\x0E\xB2\x08i,\xA1\xCE\x9F\xCB\x9F)\xF6\x9E\x46\x95\x8A\xE2\xB3\x99\x36\x65\t\x1C\xFF\x8Bl=u\xBFzf\x9BI\t\xCDP6\x13\x84\x44\xFD\xDE\r\xB2\x36<\xF6\x1F\xEE_\xCC\x86<\x99\x1C\xDC\xAA\xE6Q\x08\xE0\xEC\x66\x11\xDD\xE8\xED\xD0\xCF+\x88\x43\x9B\x92\xE6\xE9mQ\xE0\x32\xD8h\x87\x8D\xB8\xA6r\x03\x80\x8E\xF5\xDB\xB8\xAE<\x17\x8B\xC4\xF2l\x90){\xF4\x84\t\xC5\x80H\xE2k\xFC\xD2\x0F\xBC\xB0\x1D\xE3Y\x8E#bk\xFE+\xCA\x84\xF0\x83\x14o\xA3(\xE5\v\x90\x8Ap\xD8S\xEDkg\x19\x66\xD0\x8Eo\x87\xEC\x44ymR\xEEI\x81\xC6Q>Xp\x8F\xB4\x64\xB5\x8Ar:\x10\xAD\x19/Y\xE2\xDF\xB8\xAA\xF9\x8F\xFD|\x94\xB5&|\x97\x05\x07\x91`v\xA3\xA2\xF9\xDEg\x8E\xF0\x9E}$\xDA\x63`\xCC\x38\xA8\xA2\x9D\v\f\xFC%\xFE\xCD\x30\x39\xEE\xECI\xAA\x18\x93\xC3\x33\x85\x9B\xA2\xF1\xBB%~\xC2")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "DM\x8D]\x92\xC8\x33Y\x8F\x04\x1C?\xB5I\xE9\xEF\xCC\xD4\xB8\xBF\xE9\xC1x\xEA\x46\xB5kQN\xBFLoT\xB4-v\xF5\x31\xD8\xC8\xD3\xF8;r\xE7\xE2\x62\xEF\xA8\xD8O+_M\xED\x16=6|\x86@\x1C\xF1t\x81^\xD1\x8D\xD7\x87\"g?D'\x90[\xBC\x9D\x62\f\xC8W\xD0\xE8\x14\x12o\x80;\n{\x1B\xC0\xD4\xBA\x13\xCD\x8CV\xB5\xFA\xCA&31\xBF\x1DIh\x18\xFB\x0E\xB2\x08i,\xA1\xCE\x9F\xCB\x9F)\xF6\x9E\x46\x95\x8A\xE2\xB3\x99\x36\x65\t\x1C\xFF\x8Bl=u\xBFzf\x9BI\t\xCDP6\x13\x84\x44\xFD\xDE\r\xB2\x36<\xF6\x1F\xEE_\xCC\x86<\x99\x1C\xDC\xAA\xE6Q\x08\xE0\xEC\x66\x11\xDD\xE8\xED\xD0\xCF+\x88\x43\x9B\x92\xE6\xE9mQ\xE0\x32\xD8h\x87\x8D\xB8\xA6r\x03\x80\x8E\xF5\xDB\xB8\xAE<\x17\x8B\xC4\xF2l\x90){\xF4\x84\t\xC5\x80H\xE2k\xFC\xD2\x0F\xBC\xB0\x1D\xE3Y\x8E#bk\xFE+\xCA\x84\xF0\x83\x14o\xA3(\xE5\v\x90\x8Ap\xD8S\xEDkg\x19\x66\xD0\x8Eo\x87\xEC\x44ymR\xEEI\x81\xC6Q>Xp\x8F\xB4\x64\xB5\x8Ar:\x10\xAD\x19/Y\xE2\xDF\xB8\xAA\xF9\x8F\xFD|\x94\xB5&|\x97\x05\x07\x91`v\xA3\xA2\xF9\xDEg\x8E\xF0\x9E}$\xDA\x63`\xCC\x38\xA8\xA2\x9D\v\f\xFC%\xFE\xCD\x30\x39\xEE\xECI\xAA\x18\x93\xC3\x33\x85\x9B\xA2\xF1\xBB%~\xC2");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "DM\x8D]\x92\xC8\x33Y\x8F\x04\x1C?\xB5I\xE9\xEF\xCC\xD4\xB8\xBF\xE9\xC1x\xEA\x46\xB5kQN\xBFLoT\xB4-v\xF5\x31\xD8\xC8\xD3\xF8;r\xE7\xE2\x62\xEF\xA8\xD8O+_M\xED\x16=6|\x86@\x1C\xF1t\x81^\xD1\x8D\xD7\x87\"g?D'\x90[\xBC\x9D\x62\f\xC8W\xD0\xE8\x14\x12o\x80;\n{\x1B\xC0\xD4\xBA\x13\xCD\x8CV\xB5\xFA\xCA&31\xBF\x1DIh\x18\xFB\x0E\xB2\x08i,\xA1\xCE\x9F\xCB\x9F)\xF6\x9E\x46\x95\x8A\xE2\xB3\x99\x36\x65\t\x1C\xFF\x8Bl=u\xBFzf\x9BI\t\xCDP6\x13\x84\x44\xFD\xDE\r\xB2\x36<\xF6\x1F\xEE_\xCC\x86<\x99\x1C\xDC\xAA\xE6Q\x08\xE0\xEC\x66\x11\xDD\xE8\xED\xD0\xCF+\x88\x43\x9B\x92\xE6\xE9mQ\xE0\x32\xD8h\x87\x8D\xB8\xA6r\x03\x80\x8E\xF5\xDB\xB8\xAE<\x17\x8B\xC4\xF2l\x90){\xF4\x84\t\xC5\x80H\xE2k\xFC\xD2\x0F\xBC\xB0\x1D\xE3Y\x8E#bk\xFE+\xCA\x84\xF0\x83\x14o\xA3(\xE5\v\x90\x8Ap\xD8S\xEDkg\x19\x66\xD0\x8Eo\x87\xEC\x44ymR\xEEI\x81\xC6Q>Xp\x8F\xB4\x64\xB5\x8Ar:\x10\xAD\x19/Y\xE2\xDF\xB8\xAA\xF9\x8F\xFD|\x94\xB5&|\x97\x05\x07\x91`v\xA3\xA2\xF9\xDEg\x8E\xF0\x9E}$\xDA\x63`\xCC\x38\xA8\xA2\x9D\v\f\xFC%\xFE\xCD\x30\x39\xEE\xECI\xAA\x18\x93\xC3\x33\x85\x9B\xA2\xF1\xBB%~\xC2", a.size-oldSize))
			goto end;
		append.item = strdup("DM\x8D]\x92\xC8\x33Y\x8F\x04\x1C?\xB5I\xE9\xEF\xCC\xD4\xB8\xBF\xE9\xC1x\xEA\x46\xB5kQN\xBFLoT\xB4-v\xF5\x31\xD8\xC8\xD3\xF8;r\xE7\xE2\x62\xEF\xA8\xD8O+_M\xED\x16=6|\x86@\x1C\xF1t\x81^\xD1\x8D\xD7\x87\"g?D'\x90[\xBC\x9D\x62\f\xC8W\xD0\xE8\x14\x12o\x80;\n{\x1B\xC0\xD4\xBA\x13\xCD\x8CV\xB5\xFA\xCA&31\xBF\x1DIh\x18\xFB\x0E\xB2\x08i,\xA1\xCE\x9F\xCB\x9F)\xF6\x9E\x46\x95\x8A\xE2\xB3\x99\x36\x65\t\x1C\xFF\x8Bl=u\xBFzf\x9BI\t\xCDP6\x13\x84\x44\xFD\xDE\r\xB2\x36<\xF6\x1F\xEE_\xCC\x86<\x99\x1C\xDC\xAA\xE6Q\x08\xE0\xEC\x66\x11\xDD\xE8\xED\xD0\xCF+\x88\x43\x9B\x92\xE6\xE9mQ\xE0\x32\xD8h\x87\x8D\xB8\xA6r\x03\x80\x8E\xF5\xDB\xB8\xAE<\x17\x8B\xC4\xF2l\x90){\xF4\x84\t\xC5\x80H\xE2k\xFC\xD2\x0F\xBC\xB0\x1D\xE3Y\x8E#bk\xFE+\xCA\x84\xF0\x83\x14o\xA3(\xE5\v\x90\x8Ap\xD8S\xEDkg\x19\x66\xD0\x8Eo\x87\xEC\x44ymR\xEEI\x81\xC6Q>Xp\x8F\xB4\x64\xB5\x8Ar:\x10\xAD\x19/Y\xE2\xDF\xB8\xAA\xF9\x8F\xFD|\x94\xB5&|\x97\x05\x07\x91`v\xA3\xA2\xF9\xDEg\x8E\xF0\x9E}$\xDA\x63`\xCC\x38\xA8\xA2\x9D\v\f\xFC%\xFE\xCD\x30\x39\xEE\xECI\xAA\x18\x93\xC3\x33\x85\x9B\xA2\xF1\xBB%~\xC2");
		darray_append(strings, append);
		testsPassed++;

		/* Test 9 */
		append.size = sizeof("D\x16\xB9\x17yF\xDA\x32\x41\xF4\f\x04\x90\x45\x81\xB0\re\xDD\xC3\x65T\xDF>X\x03!)\xBDUY\xD8\x05\x35\xE6\x12\xA4z0\x1B\xD4\x45-\x17S\xBA%E\xF8\xFB\x32\x8B\x1B\xC0\x91\x39/\xD6\f^B\x01\x43/\x83\xD6`)\xD6\xAD\"\x9C\xD5\x32\xA5\xDC\x39\xC6We\xEB\x32p\xB9n\x89\x41\xBE\x18\xEF\x94\xE4h'\xEDY\xA6\x91\xC3\xD8\x06\xAC;:\xA6M\x7F\r\x07\xDB\x15q5R\xDC\xB2\x05\xAFU=\x1Ax\x86\x13T\x1B\x17\x8Ds\x8F\xF1-\xDD\xCD\x18\xB1\x16\xDF\x80x\v\x85\xDA\xFA\x90\x83\x86\x38x\xC6\xF2\x98\xF8\r\xDF\xC8q\xB5\xA2T=\x08\xB0M\x0E\x0F\x9B\x1C<\xC6\x86\xA8\x8BJ0\xFF\xD2\x1B\xCAh\x93\x32\xBE<\xDF\x7F\xD9\x1C\x16h{Hs\x85\xA1\f\x06\x93\xE4%\x95J\xDE\xAB\x45 \x89Pv\x05o\x02.\r\xA0\x8E\x86\xDF\x34X|*\x14G\x8D\x94)\xFE\xA5\x0Er\xC5\xD6o*us\xE5\x02\xAF\x85\xC7\xEF\x61G6\xEA$X9P\xE9~\x9D\xF5\x99\x8D=\xB7\x8FO\x97\xFA\"\xFF\x41\x41j\xE9\x61\x62\x1D]\xA2\x63\xCD\xC0\r\x83S\x15\x85\x7F\xA4\xA8\f\xE8\x82\xAC\xDC\xF5\x8B\xF2h\x81\xE7.\x92\x9F\x84\xB9J\x03\xD3\xD5<\x90")-1;
		oldSize = a.size;
		darray_prepend_lit(a, "D\x16\xB9\x17yF\xDA\x32\x41\xF4\f\x04\x90\x45\x81\xB0\re\xDD\xC3\x65T\xDF>X\x03!)\xBDUY\xD8\x05\x35\xE6\x12\xA4z0\x1B\xD4\x45-\x17S\xBA%E\xF8\xFB\x32\x8B\x1B\xC0\x91\x39/\xD6\f^B\x01\x43/\x83\xD6`)\xD6\xAD\"\x9C\xD5\x32\xA5\xDC\x39\xC6We\xEB\x32p\xB9n\x89\x41\xBE\x18\xEF\x94\xE4h'\xEDY\xA6\x91\xC3\xD8\x06\xAC;:\xA6M\x7F\r\x07\xDB\x15q5R\xDC\xB2\x05\xAFU=\x1Ax\x86\x13T\x1B\x17\x8Ds\x8F\xF1-\xDD\xCD\x18\xB1\x16\xDF\x80x\v\x85\xDA\xFA\x90\x83\x86\x38x\xC6\xF2\x98\xF8\r\xDF\xC8q\xB5\xA2T=\x08\xB0M\x0E\x0F\x9B\x1C<\xC6\x86\xA8\x8BJ0\xFF\xD2\x1B\xCAh\x93\x32\xBE<\xDF\x7F\xD9\x1C\x16h{Hs\x85\xA1\f\x06\x93\xE4%\x95J\xDE\xAB\x45 \x89Pv\x05o\x02.\r\xA0\x8E\x86\xDF\x34X|*\x14G\x8D\x94)\xFE\xA5\x0Er\xC5\xD6o*us\xE5\x02\xAF\x85\xC7\xEF\x61G6\xEA$X9P\xE9~\x9D\xF5\x99\x8D=\xB7\x8FO\x97\xFA\"\xFF\x41\x41j\xE9\x61\x62\x1D]\xA2\x63\xCD\xC0\r\x83S\x15\x85\x7F\xA4\xA8\f\xE8\x82\xAC\xDC\xF5\x8B\xF2h\x81\xE7.\x92\x9F\x84\xB9J\x03\xD3\xD5<\x90");
		if (a.size != oldSize+append.size)
			goto end;
		if (a.size > a.alloc)
			goto end;
		if (a.item[a.size])
			goto end;
		if (memcmp(a.item, "D\x16\xB9\x17yF\xDA\x32\x41\xF4\f\x04\x90\x45\x81\xB0\re\xDD\xC3\x65T\xDF>X\x03!)\xBDUY\xD8\x05\x35\xE6\x12\xA4z0\x1B\xD4\x45-\x17S\xBA%E\xF8\xFB\x32\x8B\x1B\xC0\x91\x39/\xD6\f^B\x01\x43/\x83\xD6`)\xD6\xAD\"\x9C\xD5\x32\xA5\xDC\x39\xC6We\xEB\x32p\xB9n\x89\x41\xBE\x18\xEF\x94\xE4h'\xEDY\xA6\x91\xC3\xD8\x06\xAC;:\xA6M\x7F\r\x07\xDB\x15q5R\xDC\xB2\x05\xAFU=\x1Ax\x86\x13T\x1B\x17\x8Ds\x8F\xF1-\xDD\xCD\x18\xB1\x16\xDF\x80x\v\x85\xDA\xFA\x90\x83\x86\x38x\xC6\xF2\x98\xF8\r\xDF\xC8q\xB5\xA2T=\x08\xB0M\x0E\x0F\x9B\x1C<\xC6\x86\xA8\x8BJ0\xFF\xD2\x1B\xCAh\x93\x32\xBE<\xDF\x7F\xD9\x1C\x16h{Hs\x85\xA1\f\x06\x93\xE4%\x95J\xDE\xAB\x45 \x89Pv\x05o\x02.\r\xA0\x8E\x86\xDF\x34X|*\x14G\x8D\x94)\xFE\xA5\x0Er\xC5\xD6o*us\xE5\x02\xAF\x85\xC7\xEF\x61G6\xEA$X9P\xE9~\x9D\xF5\x99\x8D=\xB7\x8FO\x97\xFA\"\xFF\x41\x41j\xE9\x61\x62\x1D]\xA2\x63\xCD\xC0\r\x83S\x15\x85\x7F\xA4\xA8\f\xE8\x82\xAC\xDC\xF5\x8B\xF2h\x81\xE7.\x92\x9F\x84\xB9J\x03\xD3\xD5<\x90", a.size-oldSize))
			goto end;
		append.item = strdup("D\x16\xB9\x17yF\xDA\x32\x41\xF4\f\x04\x90\x45\x81\xB0\re\xDD\xC3\x65T\xDF>X\x03!)\xBDUY\xD8\x05\x35\xE6\x12\xA4z0\x1B\xD4\x45-\x17S\xBA%E\xF8\xFB\x32\x8B\x1B\xC0\x91\x39/\xD6\f^B\x01\x43/\x83\xD6`)\xD6\xAD\"\x9C\xD5\x32\xA5\xDC\x39\xC6We\xEB\x32p\xB9n\x89\x41\xBE\x18\xEF\x94\xE4h'\xEDY\xA6\x91\xC3\xD8\x06\xAC;:\xA6M\x7F\r\x07\xDB\x15q5R\xDC\xB2\x05\xAFU=\x1Ax\x86\x13T\x1B\x17\x8Ds\x8F\xF1-\xDD\xCD\x18\xB1\x16\xDF\x80x\v\x85\xDA\xFA\x90\x83\x86\x38x\xC6\xF2\x98\xF8\r\xDF\xC8q\xB5\xA2T=\x08\xB0M\x0E\x0F\x9B\x1C<\xC6\x86\xA8\x8BJ0\xFF\xD2\x1B\xCAh\x93\x32\xBE<\xDF\x7F\xD9\x1C\x16h{Hs\x85\xA1\f\x06\x93\xE4%\x95J\xDE\xAB\x45 \x89Pv\x05o\x02.\r\xA0\x8E\x86\xDF\x34X|*\x14G\x8D\x94)\xFE\xA5\x0Er\xC5\xD6o*us\xE5\x02\xAF\x85\xC7\xEF\x61G6\xEA$X9P\xE9~\x9D\xF5\x99\x8D=\xB7\x8FO\x97\xFA\"\xFF\x41\x41j\xE9\x61\x62\x1D]\xA2\x63\xCD\xC0\r\x83S\x15\x85\x7F\xA4\xA8\f\xE8\x82\xAC\xDC\xF5\x8B\xF2h\x81\xE7.\x92\x9F\x84\xB9J\x03\xD3\xD5<\x90");
		darray_append(strings, append);
		testsPassed++;

	
	offs = a.size;
	if (a.item[offs])
		goto end;
	if (strings.size != 10)
		goto end;
	darray_foreach(i, strings) {
		if (offs < i->size)
			goto end;
		offs -= i->size;
		if (memcmp(a.item+offs, i->item, i->size))
			goto end;
	};
	if (offs)
		goto end;
	testsPassed++;
	
end:
	darray_free(a);
	darray_foreach(i, strings)
		free(i->item);
	darray_free(strings);
	return testsPassed == 10+1;
}
