/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIOOperationTask;

public class IoOperationExecutor
extends ThreadPoolExecutor {
    private final ILSMIOOperationScheduler scheduler;
    private final IIoOperationFailedCallback callback;
    private final Map<String, ILSMIOOperation> runningFlushOperations;
    private final Map<String, Throwable> failedGroups;
    private final Map<String, Deque<ILSMIOOperation>> waitingFlushOperations;

    public IoOperationExecutor(ThreadFactory threadFactory, ILSMIOOperationScheduler scheduler, IIoOperationFailedCallback callback, Map<String, ILSMIOOperation> runningFlushOperations, Map<String, Deque<ILSMIOOperation>> waitingFlushOperations, Map<String, Throwable> failedGroups) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        this.scheduler = scheduler;
        this.callback = callback;
        this.runningFlushOperations = runningFlushOperations;
        this.waitingFlushOperations = waitingFlushOperations;
        this.failedGroups = failedGroups;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new LSMIOOperationTask<T>(callable);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        LSMIOOperationTask task = (LSMIOOperationTask)r;
        ILSMIOOperation executedOp = task.getOperation();
        try {
            this.doAfterExecute(executedOp, t);
        }
        catch (Throwable th) {
            this.callback.schedulerFailed(this.scheduler, th);
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterExecute(ILSMIOOperation executedOp, Throwable t) throws HyracksDataException {
        boolean failed;
        boolean bl = failed = t != null || executedOp.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE;
        if (failed) {
            this.fail(executedOp, t != null ? t : executedOp.getFailure());
        }
        if (!failed || executedOp.getIOOpertionType() != ILSMIOOperation.LSMIOOperationType.FLUSH) {
            executedOp.complete();
        }
        this.scheduler.completeOperation(executedOp);
        if (executedOp.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            String id = executedOp.getIndexIdentifier();
            IoOperationExecutor ioOperationExecutor = this;
            synchronized (ioOperationExecutor) {
                this.runningFlushOperations.remove(id);
                if (this.waitingFlushOperations.containsKey(id)) {
                    ILSMIOOperation op = this.waitingFlushOperations.get(id).poll();
                    if (op != null) {
                        this.scheduler.scheduleOperation(op);
                    } else {
                        this.waitingFlushOperations.remove(id);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(ILSMIOOperation executedOp, Throwable t) throws HyracksDataException {
        this.callback.operationFailed(executedOp, t);
        if (executedOp.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            executedOp.complete();
            IoOperationExecutor ioOperationExecutor = this;
            synchronized (ioOperationExecutor) {
                String id = executedOp.getIndexIdentifier();
                this.failedGroups.put(id, t);
                this.runningFlushOperations.remove(id);
                if (this.waitingFlushOperations.containsKey(id)) {
                    Deque<ILSMIOOperation> ops = this.waitingFlushOperations.remove(id);
                    ILSMIOOperation next = ops.poll();
                    while (next != null) {
                        next.setFailure(new RuntimeException("Operation group " + id + " has permanently failed", t));
                        next.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
                        next.complete();
                        next = ops.poll();
                    }
                }
            }
        }
    }
}

