/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ComponentMaskTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;

public class MarkComponentValidTask
implements IReplicaTask {
    private final long masterLsn;
    private final long lastComponentId;
    private final String file;

    public MarkComponentValidTask(String file, long masterLsn, long lastComponentId) {
        this.file = file;
        this.lastComponentId = lastComponentId;
        this.masterLsn = masterLsn;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            if (this.masterLsn == -2L) {
                this.updateBulkLoadedLastComponentSequence(appCtx);
            } else if (this.masterLsn != -1L) {
                this.ensureComponentLsnFlushed(appCtx);
            }
            Path maskPath = ComponentMaskTask.getComponentMaskPath(appCtx, this.file);
            Files.delete(maskPath);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException | InterruptedException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private void updateBulkLoadedLastComponentSequence(INcApplicationContext appCtx) throws HyracksDataException {
        ResourceReference indexRef = ResourceReference.of((String)this.file);
        IIndexCheckpointManagerProvider checkpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        IIndexCheckpointManager indexCheckpointManager = checkpointManagerProvider.get(indexRef);
        long componentSequence = IndexComponentFileReference.of((String)indexRef.getName()).getSequenceEnd();
        indexCheckpointManager.advanceValidComponentSequence(componentSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureComponentLsnFlushed(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        ResourceReference indexRef = ResourceReference.of((String)this.file);
        IIndexCheckpointManagerProvider checkpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        IIndexCheckpointManager indexCheckpointManager = checkpointManagerProvider.get(indexRef);
        long replicationTimeOut = TimeUnit.SECONDS.toMillis(appCtx.getReplicationProperties().getReplicationTimeOut());
        IIndexCheckpointManager iIndexCheckpointManager = indexCheckpointManager;
        synchronized (iIndexCheckpointManager) {
            while (!indexCheckpointManager.isFlushed(this.masterLsn)) {
                if (replicationTimeOut <= 0L) {
                    throw new ReplicationException((Throwable)new TimeoutException("Couldn't receive flush lsn from master"));
                }
                long startTime = System.nanoTime();
                indexCheckpointManager.wait(replicationTimeOut);
                replicationTimeOut -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            }
            long componentSequence = IndexComponentFileReference.of((String)indexRef.getName()).getSequenceEnd();
            indexCheckpointManager.replicated(componentSequence, this.masterLsn, this.lastComponentId);
        }
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.MARK_COMPONENT_VALID;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
            dos.writeLong(this.masterLsn);
            dos.writeLong(this.lastComponentId);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static MarkComponentValidTask create(DataInput input) throws IOException {
        String indexFile = input.readUTF();
        long lsn = input.readLong();
        long lastComponentId = input.readLong();
        return new MarkComponentValidTask(indexFile, lsn, lastComponentId);
    }
}

