/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.MappingIterator;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileReader {
    public static final Logger LOG = LoggerFactory.getLogger(CombinedHostsFileReader.class);

    private CombinedHostsFileReader() {
    }

    public static DatanodeAdminProperties[] readFile(String hostsFile) throws IOException {
        DatanodeAdminProperties[] allDNs = new DatanodeAdminProperties[]{};
        ObjectMapper objectMapper = new ObjectMapper();
        boolean tryOldFormat = false;
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
            allDNs = (DatanodeAdminProperties[])objectMapper.readValue((Reader)input, DatanodeAdminProperties[].class);
        }
        catch (JsonMappingException jme) {
            tryOldFormat = true;
            LOG.warn("{} has invalid JSON format.Try the old format without top-level token defined.", (Object)hostsFile);
        }
        catch (EOFException eof) {
            LOG.warn("{} is empty.", (Object)hostsFile);
        }
        if (tryOldFormat) {
            JsonFactory jsonFactory = new JsonFactory();
            ArrayList<DatanodeAdminProperties> all = new ArrayList<DatanodeAdminProperties>();
            try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
                MappingIterator iterator = objectMapper.readValues(jsonFactory.createJsonParser((Reader)input), DatanodeAdminProperties.class);
                while (iterator.hasNext()) {
                    DatanodeAdminProperties properties = (DatanodeAdminProperties)iterator.next();
                    all.add(properties);
                }
            }
            allDNs = all.toArray(new DatanodeAdminProperties[all.size()]);
        }
        return allDNs;
    }
}

