/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.AbstractCallExpression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CallExpr
extends AbstractCallExpression {
    public CallExpr(FunctionSignature functionSignature, List<Expression> exprList) {
        super(functionSignature, exprList, null);
    }

    public CallExpr(FunctionSignature functionSignature, List<Expression> exprList, Expression aggFilterExpr) {
        super(functionSignature, exprList, aggFilterExpr);
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.CALL_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String toString() {
        return "call " + this.functionSignature;
    }

    public int hashCode() {
        return Objects.hash(this.exprList, this.aggFilterExpr, this.functionSignature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CallExpr)) {
            return false;
        }
        CallExpr target = (CallExpr)object;
        return Objects.equals(this.exprList, target.exprList) && Objects.equals(this.aggFilterExpr, target.aggFilterExpr) && Objects.equals(this.functionSignature, target.functionSignature);
    }
}

