/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.text.WordUtils;

public class StringUtil {
    private static final Map<String, String> CAMEL_CACHE = Collections.synchronizedMap(new LRUMap(1024));
    private static final Pattern SEPARATORS_PATTERN = Pattern.compile("[_\\-\\s]");

    private StringUtil() {
    }

    public static String toCamelCase(String input) {
        return CAMEL_CACHE.computeIfAbsent(input, s -> SEPARATORS_PATTERN.matcher(WordUtils.capitalize((String)("z" + s.toLowerCase()), (char[])new char[]{'_', '-', ' '}).substring(1)).replaceAll(""));
    }

    public static String join(Object[] objects, String separator, String quote) {
        if (objects == null || objects.length == 0) {
            return "";
        }
        int length = objects.length;
        String str0 = String.valueOf(objects[0]);
        StringBuilder sb = new StringBuilder((str0.length() + 3) * length);
        sb.append(quote).append(str0).append(quote);
        for (int i = 1; i < length; ++i) {
            sb.append(separator).append(quote).append(objects[i]).append(quote);
        }
        return sb.toString();
    }
}

