/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.Serializable;
import java.util.List;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.NoOpIoOperation;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.util.trace.ITracer;

public class ExternalIndexHarness
extends LSMHarness {
    public ExternalIndexHarness(ILSMIndex lsmIndex, ILSMIOOperationScheduler ioScheduler, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, boolean replicationEnabled) {
        super(lsmIndex, ioScheduler, mergePolicy, opTracker, replicationEnabled, ITracer.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean getAndEnterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, boolean isTryOperation) throws HyracksDataException {
        this.validateOperationEnterComponentsState(ctx);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            do {
                this.lsmIndex.getOperationalComponents(ctx);
                switch (opType) {
                    case MERGE: {
                        if (ctx.getComponentHolder().size() >= 2) break;
                        return false;
                    }
                }
                if (!this.enterComponents(ctx, opType)) continue;
                return true;
            } while (!isTryOperation);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean enterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType) throws HyracksDataException {
        this.validateOperationEnterComponentsState(ctx);
        List<ILSMComponent> components = ctx.getComponentHolder();
        int numEntered = 0;
        boolean entranceSuccessful = false;
        try {
            for (ILSMComponent c : components) {
                if (!c.threadEnter(opType, false)) break;
                ++numEntered;
            }
            entranceSuccessful = numEntered == components.size();
        }
        finally {
            if (!entranceSuccessful) {
                for (ILSMComponent c : components) {
                    if (numEntered == 0) break;
                    c.threadExit(opType, true, false);
                    --numEntered;
                }
                return false;
            }
            ctx.setAccessingComponents(true);
        }
        this.opTracker.beforeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void exitComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        if (!ctx.isAccessingComponents() && opType != LSMOperationType.FLUSH && opType != LSMOperationType.MERGE) {
            return;
        }
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        // MONITORENTER : iLSMOperationTracker
        try {
            for (ILSMComponent c : ctx.getComponentHolder()) {
                c.threadExit(opType, failedOperation, false);
                switch (c.getState()) {
                    case INACTIVE: {
                        if (this.replicationEnabled) {
                            this.componentsToBeReplicated.clear();
                            this.componentsToBeReplicated.add((ILSMDiskComponent)c);
                            this.lsmIndex.scheduleReplication(null, this.componentsToBeReplicated, IReplicationJob.ReplicationOperation.DELETE, opType);
                        }
                        ((ILSMDiskComponent)c).deactivateAndDestroy();
                        break;
                    }
                }
            }
            ctx.setAccessingComponents(false);
            switch (opType) {
                case MERGE: {
                    if (newComponent == null) return;
                    this.beforeSubsumeMergedComponents(newComponent, ctx.getComponentHolder());
                    this.lsmIndex.subsumeMergedComponents(newComponent, ctx.getComponentHolder());
                    if (this.replicationEnabled) {
                        this.componentsToBeReplicated.clear();
                        this.componentsToBeReplicated.add(newComponent);
                        this.triggerReplication(this.componentsToBeReplicated, opType);
                    }
                    this.mergePolicy.diskComponentAdded(this.lsmIndex, this.fullMergeIsRequested.get());
                    return;
                }
            }
            return;
        }
        finally {
            this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
        }
    }

    @Override
    public void forceModify(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        throw HyracksDataException.create((ErrorCode)ErrorCode.MODIFY_NOT_SUPPORTED_IN_EXTERNAL_INDEX, (Serializable[])new Serializable[0]);
    }

    @Override
    public boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple) throws HyracksDataException {
        throw HyracksDataException.create((ErrorCode)ErrorCode.MODIFY_NOT_SUPPORTED_IN_EXTERNAL_INDEX, (Serializable[])new Serializable[0]);
    }

    @Override
    public void search(ILSMIndexOperationContext ctx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.SEARCH;
        this.getAndEnterComponents(ctx, opType, false);
        try {
            this.lsmIndex.search(ctx, cursor, pred);
        }
        catch (Exception e) {
            this.exitComponents(ctx, opType, null, true);
            throw e;
        }
    }

    @Override
    public void endSearch(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.getOperation() == IndexOperation.SEARCH) {
            try {
                this.exitComponents(ctx, LSMOperationType.SEARCH, null, false);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBulkLoadedComponent(ILSMIOOperation ioOperation) throws HyracksDataException {
        ILSMDiskComponent c = ioOperation.getNewComponent();
        try {
            c.markAsValid(this.lsmIndex.isDurable(), ioOperation);
        }
        catch (Throwable th) {
            ioOperation.setFailure(th);
        }
        if (ioOperation.hasFailed()) {
            throw HyracksDataException.create((Throwable)ioOperation.getFailure());
        }
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.lsmIndex.addDiskComponent(c);
            if (this.replicationEnabled) {
                this.componentsToBeReplicated.clear();
                this.componentsToBeReplicated.add(c);
                this.triggerReplication(this.componentsToBeReplicated, LSMOperationType.LOAD);
            }
            this.enterComponent(c);
            this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionComponents(ILSMDiskComponent newComponent) throws HyracksDataException {
        ITwoPCIndex index = (ITwoPCIndex)((Object)this.lsmIndex);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            List<ILSMDiskComponent> olderList;
            List<ILSMDiskComponent> newerList;
            if (index.getCurrentVersion() == 0) {
                newerList = index.getFirstComponentList();
                olderList = index.getSecondComponentList();
            } else {
                newerList = index.getSecondComponentList();
                olderList = index.getFirstComponentList();
            }
            for (ILSMDiskComponent c : olderList) {
                this.exitComponent(c);
            }
            for (ILSMDiskComponent c : newerList) {
                this.enterComponent(c);
            }
            if (newComponent != null) {
                this.enterComponent(newComponent);
            }
            index.commitTransactionDiskComponent(newComponent);
            this.mergePolicy.diskComponentAdded(this.lsmIndex, this.fullMergeIsRequested.get());
        }
    }

    @Override
    public ILSMIOOperation scheduleFlush(ILSMIndexOperationContext ctx) throws HyracksDataException {
        return NoOpIoOperation.INSTANCE;
    }

    @Override
    public void flush(ILSMIOOperation operation) throws HyracksDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.opTracker;
    }

    public void beforeSubsumeMergedComponents(ILSMComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        ITwoPCIndex index = (ITwoPCIndex)((Object)this.lsmIndex);
        if (index.getFirstComponentList().containsAll(mergedComponents)) {
            for (ILSMComponent c : mergedComponents) {
                this.exitComponent((ILSMDiskComponent)c);
            }
            this.enterComponent(newComponent);
        }
        if (index.getSecondComponentList().containsAll(mergedComponents)) {
            for (ILSMComponent c : mergedComponents) {
                this.exitComponent((ILSMDiskComponent)c);
            }
            this.enterComponent(newComponent);
        }
    }

    private void enterComponent(ILSMComponent diskComponent) throws HyracksDataException {
        diskComponent.threadEnter(LSMOperationType.SEARCH, false);
    }

    private void exitComponent(ILSMDiskComponent diskComponent) throws HyracksDataException {
        diskComponent.threadExit(LSMOperationType.SEARCH, false, false);
        if (diskComponent.getState() == ILSMComponent.ComponentState.INACTIVE) {
            if (this.replicationEnabled) {
                this.componentsToBeReplicated.clear();
                this.componentsToBeReplicated.add(diskComponent);
                this.lsmIndex.scheduleReplication(null, this.componentsToBeReplicated, IReplicationJob.ReplicationOperation.DELETE, null);
            }
            diskComponent.deactivateAndDestroy();
        }
    }

    public void indexFirstTimeActivated() throws HyracksDataException {
        ITwoPCIndex index = (ITwoPCIndex)((Object)this.lsmIndex);
        for (ILSMComponent iLSMComponent : index.getFirstComponentList()) {
            this.enterComponent(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : index.getSecondComponentList()) {
            this.enterComponent(iLSMComponent);
        }
    }

    public void indexClear() throws HyracksDataException {
        ITwoPCIndex index = (ITwoPCIndex)((Object)this.lsmIndex);
        for (ILSMDiskComponent c : index.getFirstComponentList()) {
            this.exitComponent(c);
        }
        for (ILSMDiskComponent c : index.getSecondComponentList()) {
            this.exitComponent(c);
        }
    }
}

