/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.List;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractScanPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;

public class DataSourceScanPOperator
extends AbstractScanPOperator {
    private final IDataSource<?> dataSource;
    private Object implConfig;

    public DataSourceScanPOperator(IDataSource<?> dataSource) {
        this.dataSource = dataSource;
    }

    public void setImplConfig(Object implConfig) {
        this.implConfig = implConfig;
    }

    public Object getImplConfig() {
        return this.implConfig;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.DATASOURCE_SCAN;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        DataSourceScanOperator dssOp = (DataSourceScanOperator)op;
        IDataSourcePropertiesProvider dspp = this.dataSource.getPropertiesProvider();
        this.deliveredProperties = dspp.computePropertiesVector(dssOp.getVariables());
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        if (op.getInputs().isEmpty()) {
            return this.emptyUnaryRequirements();
        }
        ILogicalOperator childOp = (ILogicalOperator)op.getInputs().get(0).getValue();
        if (childOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return this.emptyUnaryRequirements();
        }
        INodeDomain domain = this.dataSource.getDomain();
        return new PhysicalRequirements(new StructuralPropertiesVector[]{new StructuralPropertiesVector(new BroadcastPartitioningProperty(domain), null)}, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        DataSourceScanOperator scan = (DataSourceScanOperator)op;
        IMetadataProvider<?, ?> mp = context.getMetadataProvider();
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(op);
        List<LogicalVariable> vars = scan.getVariables();
        List<LogicalVariable> projectVars = scan.getProjectVariables();
        ITupleFilterFactory tupleFilterFactory = null;
        if (scan.getSelectCondition() != null) {
            tupleFilterFactory = mp.createTupleFilterFactory(new IOperatorSchema[]{opSchema}, typeEnv, (ILogicalExpression)scan.getSelectCondition().getValue(), context);
        }
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> p = mp.getScannerRuntime(this.dataSource, vars, projectVars, scan.isProjectPushed(), scan.getMinFilterVars(), scan.getMaxFilterVars(), tupleFilterFactory, scan.getOutputLimit(), opSchema, typeEnv, context, builder.getJobSpec(), this.implConfig, scan.getProjectionInfo());
        IOperatorDescriptor opDesc = (IOperatorDescriptor)p.first;
        opDesc.setSourceLocation(scan.getSourceLocation());
        builder.contributeHyracksOperator(scan, opDesc);
        if (p.second != null) {
            builder.contributeAlgebricksPartitionConstraint(opDesc, (AlgebricksPartitionConstraint)p.second);
        }
        ILogicalOperator srcExchange = (ILogicalOperator)scan.getInputs().get(0).getValue();
        builder.contributeGraphEdge(srcExchange, 0, scan, 0);
    }

    @Override
    public String toString(boolean verbose) {
        Object ss = super.toString(verbose);
        if (verbose) {
            ss = (String)ss + " (" + this.dataSource.getId() + ")";
        }
        return ss;
    }
}

