/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.Span;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnsureAllCcTasksCompleted
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long TIMEOUT = TimeUnit.MINUTES.toMillis(2L);
    private final NodeControllerService ncs;
    private final CcId ccId;
    private final Deque<Task> runningTasks;

    EnsureAllCcTasksCompleted(NodeControllerService ncs, CcId ccId, Deque<Task> runningTasks) {
        this.ncs = ncs;
        this.ccId = ccId;
        this.runningTasks = runningTasks;
    }

    @Override
    public void run() {
        LOGGER.info("Ensuring all tasks of CC {} have completed", (Object)this.ccId);
        try {
            this.waitForTaskCompletion();
        }
        catch (InterruptedException e) {
            LOGGER.info("interrupted waiting for CC tasks to complete; giving up");
            Thread.currentThread().interrupt();
        }
    }

    private void waitForTaskCompletion() throws InterruptedException {
        Span maxWaitTime = Span.start((long)TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        while (!maxWaitTime.elapsed()) {
            this.removeCompleted();
            if (this.runningTasks.isEmpty()) break;
            LOGGER.info("{} tasks are still running", (Object)this.runningTasks.size());
            TimeUnit.SECONDS.sleep(1L);
        }
        this.removeCompleted();
        if (this.runningTasks.isEmpty()) {
            LOGGER.info("all tasks of CC {} have completed", (Object)this.ccId);
            try {
                this.ncs.notifyTasksCompleted(this.ccId);
            }
            catch (InterruptedException e) {
                LOGGER.info("interrupted during notifyTasksCompleted");
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("unexpected error during notifyTasksCompleted", (Throwable)e);
                ExitUtil.halt((int)19);
            }
        } else {
            LOGGER.error("{} tasks associated with CC {} failed to complete after {}ms. Giving up", (Object)this.runningTasks.size(), (Object)this.ccId, (Object)TIMEOUT);
            this.logPendingTasks();
            ExitUtil.halt((int)4);
        }
    }

    private void removeCompleted() {
        this.runningTasks.removeIf(Task::isCompleted);
    }

    private void logPendingTasks() {
        for (Task task : this.runningTasks) {
            List<Thread> pendingThreads = task.getPendingThreads();
            LOGGER.error("task {} was stuck. Stuck thread count = {}", (Object)task.getTaskAttemptId(), (Object)pendingThreads.size());
            for (Thread thread : pendingThreads) {
                LOGGER.error("stuck thread trace", ExceptionUtils.fromThreadStack((Thread)thread));
            }
        }
    }
}

