/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.translator.ResultMetadata;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IJobResultCallback;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.api.result.ResultSetMetaData;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobResultCallback
implements IJobResultCallback {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ICcApplicationContext appCtx;

    public JobResultCallback(ICcApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    public void completed(JobId jobId, ResultJobRecord resultJobRecord) {
        try {
            this.updateResultMetadata(jobId, resultJobRecord);
        }
        catch (Exception e) {
            LOGGER.error("failed to update result metadata for {}", (Object)jobId, (Object)e);
        }
    }

    private void updateResultMetadata(JobId jobId, ResultJobRecord resultJobRecord) {
        ResultSetMetaData resultSetMetaData = resultJobRecord.getResultSetMetaData();
        if (resultSetMetaData == null) {
            return;
        }
        ResultMetadata metadata = (ResultMetadata)resultSetMetaData.getMetadata();
        metadata.setJobDuration(resultJobRecord.getJobDuration());
        this.aggregateJobStats(jobId, metadata);
    }

    private void aggregateJobStats(JobId jobId, ResultMetadata metadata) {
        long processedObjects = 0L;
        long aggregateTotalWarningsCount = 0L;
        HashSet<Warning> AggregateWarnings = new HashSet<Warning>();
        IJobManager jobManager = ((ClusterControllerService)this.appCtx.getServiceContext().getControllerService()).getJobManager();
        JobRun run = jobManager.get(jobId);
        if (run != null) {
            JobProfile jobProfile = run.getJobProfile();
            Collection jobletProfiles = jobProfile.getJobletProfiles().values();
            long maxWarnings = run.getJobSpecification().getMaxWarnings();
            for (JobletProfile jp : jobletProfiles) {
                Collection jobletTasksProfile = jp.getTaskProfiles().values();
                for (TaskProfile tp : jobletTasksProfile) {
                    processedObjects += tp.getStatsCollector().getAggregatedStats().getTupleCounter().get();
                    aggregateTotalWarningsCount += tp.getTotalWarningsCount();
                    Set taskWarnings = tp.getWarnings();
                    if ((long)AggregateWarnings.size() >= maxWarnings || taskWarnings.isEmpty()) continue;
                    Iterator taskWarningsIt = taskWarnings.iterator();
                    while ((long)AggregateWarnings.size() < maxWarnings && taskWarningsIt.hasNext()) {
                        AggregateWarnings.add((Warning)taskWarningsIt.next());
                    }
                }
            }
        }
        metadata.setProcessedObjects(processedObjects);
        metadata.setWarnings(AggregateWarnings);
        metadata.setTotalWarningsCount(aggregateTotalWarningsCount);
        if (run != null && run.getFlags() != null && run.getFlags().contains(JobFlag.PROFILE_RUNTIME)) {
            metadata.setJobProfile(run.getJobProfile().toJSON());
        } else {
            metadata.setJobProfile(null);
        }
    }
}

