/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.SecondaryIndexSearchPreferenceAnnotation;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.optimizer.cost.Cost;
import org.apache.asterix.optimizer.cost.CostMethods;
import org.apache.asterix.optimizer.cost.ICost;
import org.apache.asterix.optimizer.cost.ICostMethods;
import org.apache.asterix.optimizer.rules.cbo.EnumerateJoinsRule;
import org.apache.asterix.optimizer.rules.cbo.JoinCondition;
import org.apache.asterix.optimizer.rules.cbo.JoinNode;
import org.apache.asterix.optimizer.rules.cbo.PlanNode;
import org.apache.asterix.optimizer.rules.cbo.Stats;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoinEnum {
    private static final Logger LOGGER = LogManager.getLogger();
    protected List<JoinCondition> joinConditions;
    protected List<PlanNode> allPlans;
    protected JoinNode[] jnArray;
    protected int jnArraySize;
    protected List<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>> emptyTupleAndDataSourceOps;
    protected Map<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap;
    protected Map<DataSourceScanOperator, EmptyTupleSourceOperator> dataSourceEmptyTupleHashMap;
    protected List<ILogicalExpression> singleDatasetPreds;
    protected List<ILogicalOperator> internalEdges;
    protected List<ILogicalOperator> joinOps;
    protected ILogicalOperator localJoinOp;
    protected IOptimizationContext optCtx;
    protected Stats stats;
    protected PhysicalOptimizationConfig physOptConfig;
    protected boolean cboMode;
    protected boolean cboTestMode;
    protected int numberOfTerms;
    protected AbstractLogicalOperator op;
    protected boolean connectedJoinGraph;
    protected boolean forceJoinOrderMode;
    protected String queryPlanShape;
    protected ICost cost;
    protected ICostMethods costMethods;

    public void initEnum(AbstractLogicalOperator op, boolean cboMode, boolean cboTestMode, int numberOfFromTerms, List<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>> emptyTupleAndDataSourceOps, Map<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap, Map<DataSourceScanOperator, EmptyTupleSourceOperator> dataSourceEmptyTupleHashMap, List<ILogicalOperator> internalEdges, List<ILogicalOperator> joinOps, IOptimizationContext context) {
        this.singleDatasetPreds = new ArrayList<ILogicalExpression>();
        this.joinConditions = new ArrayList<JoinCondition>();
        this.internalEdges = new ArrayList<ILogicalOperator>();
        this.allPlans = new ArrayList<PlanNode>();
        this.numberOfTerms = numberOfFromTerms;
        this.cboMode = cboMode;
        this.cboTestMode = cboTestMode;
        this.connectedJoinGraph = true;
        this.optCtx = context;
        this.physOptConfig = context.getPhysicalOptimizationConfig();
        this.emptyTupleAndDataSourceOps = emptyTupleAndDataSourceOps;
        this.joinLeafInputsHashMap = joinLeafInputsHashMap;
        this.dataSourceEmptyTupleHashMap = dataSourceEmptyTupleHashMap;
        this.internalEdges = internalEdges;
        this.joinOps = joinOps;
        this.op = op;
        this.forceJoinOrderMode = JoinEnum.getForceJoinOrderMode(context);
        this.queryPlanShape = JoinEnum.getQueryPlanShape(context);
        this.initCostHandleAndJoinNodes(context);
    }

    protected void initCostHandleAndJoinNodes(IOptimizationContext context) {
        this.cost = new Cost();
        this.costMethods = new CostMethods(context);
        this.stats = new Stats(this.optCtx, this);
        this.jnArraySize = (int)Math.pow(2.0, this.numberOfTerms);
        this.jnArray = new JoinNode[this.jnArraySize];
        for (int i = 0; i < this.jnArraySize; ++i) {
            this.jnArray[i] = new JoinNode(i, this);
        }
    }

    public List<JoinCondition> getJoinConditions() {
        return this.joinConditions;
    }

    public List<PlanNode> getAllPlans() {
        return this.allPlans;
    }

    public JoinNode[] getJnArray() {
        return this.jnArray;
    }

    public Cost getCostHandle() {
        return (Cost)this.cost;
    }

    public CostMethods getCostMethodsHandle() {
        return (CostMethods)this.costMethods;
    }

    public Stats getStatsHandle() {
        return this.stats;
    }

    public Map<EmptyTupleSourceOperator, ILogicalOperator> getJoinLeafInputsHashMap() {
        return this.joinLeafInputsHashMap;
    }

    public Map<DataSourceScanOperator, EmptyTupleSourceOperator> getDataSourceEmptyTupleHashMap() {
        return this.dataSourceEmptyTupleHashMap;
    }

    public ILogicalOperator findLeafInput(List<LogicalVariable> logicalVars) throws AlgebricksException {
        HashSet vars = new HashSet();
        for (Pair<EmptyTupleSourceOperator, DataSourceScanOperator> emptyTupleAndDataSourceOp : this.emptyTupleAndDataSourceOps) {
            EmptyTupleSourceOperator emptyOp = (EmptyTupleSourceOperator)emptyTupleAndDataSourceOp.getFirst();
            ILogicalOperator op = this.joinLeafInputsHashMap.get(emptyOp);
            vars.clear();
            VariableUtilities.getLiveVariables((ILogicalOperator)op, vars);
            if (!vars.containsAll(logicalVars)) continue;
            return op;
        }
        return null;
    }

    public ILogicalExpression combineAllConditions(List<Integer> newJoinConditions) {
        if (newJoinConditions.size() == 0) {
            return ConstantExpression.TRUE;
        }
        if (newJoinConditions.size() == 1) {
            JoinCondition jc = this.joinConditions.get(newJoinConditions.get(0));
            return jc.joinCondition;
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        for (int joinNum : newJoinConditions) {
            JoinCondition jc = this.joinConditions.get(joinNum);
            andExpr.getArguments().add(new MutableObject((Object)jc.joinCondition));
        }
        return andExpr;
    }

    public ILogicalExpression getNestedLoopJoinExpr(List<Integer> newJoinConditions) {
        if (newJoinConditions.size() != 1) {
            return null;
        }
        JoinCondition jc = this.joinConditions.get(newJoinConditions.get(0));
        return jc.joinCondition;
    }

    public ILogicalExpression getHashJoinExpr(List<Integer> newJoinConditions) {
        if (newJoinConditions.size() == 0) {
            return ConstantExpression.TRUE;
        }
        if (newJoinConditions.size() == 1) {
            JoinCondition jc = this.joinConditions.get(newJoinConditions.get(0));
            if (jc.comparisonType == JoinCondition.comparisonOp.OP_EQ) {
                return jc.joinCondition;
            }
            return null;
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        boolean eqPredFound = false;
        for (int joinNum : newJoinConditions) {
            JoinCondition jc = this.joinConditions.get(joinNum);
            if (jc.comparisonType == JoinCondition.comparisonOp.OP_EQ) {
                eqPredFound = true;
            }
            andExpr.getArguments().add(new MutableObject((Object)jc.joinCondition));
        }
        return eqPredFound ? andExpr : null;
    }

    public HashJoinExpressionAnnotation findHashJoinHint(List<Integer> newJoinConditions) {
        for (int i : newJoinConditions) {
            AbstractFunctionCallExpression AFCexpr;
            HashJoinExpressionAnnotation hjea;
            JoinCondition jc = this.joinConditions.get(i);
            if (jc.comparisonType != JoinCondition.comparisonOp.OP_EQ) {
                return null;
            }
            ILogicalExpression expr = jc.joinCondition;
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || (hjea = (HashJoinExpressionAnnotation)(AFCexpr = (AbstractFunctionCallExpression)expr).getAnnotation(HashJoinExpressionAnnotation.class)) == null) continue;
            return hjea;
        }
        return null;
    }

    public BroadcastExpressionAnnotation findBroadcastHashJoinHint(List<Integer> newJoinConditions) {
        for (int i : newJoinConditions) {
            AbstractFunctionCallExpression AFCexpr;
            BroadcastExpressionAnnotation bcasthjea;
            JoinCondition jc = this.joinConditions.get(i);
            if (jc.comparisonType != JoinCondition.comparisonOp.OP_EQ) {
                return null;
            }
            ILogicalExpression expr = jc.joinCondition;
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || (bcasthjea = (BroadcastExpressionAnnotation)(AFCexpr = (AbstractFunctionCallExpression)expr).getAnnotation(BroadcastExpressionAnnotation.class)) == null) continue;
            return bcasthjea;
        }
        return null;
    }

    public IndexedNLJoinExpressionAnnotation findNLJoinHint(List<Integer> newJoinConditions) {
        for (int i : newJoinConditions) {
            AbstractFunctionCallExpression AFCexpr;
            IndexedNLJoinExpressionAnnotation inljea;
            JoinCondition jc = this.joinConditions.get(i);
            ILogicalExpression expr = jc.joinCondition;
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || (inljea = (IndexedNLJoinExpressionAnnotation)(AFCexpr = (AbstractFunctionCallExpression)expr).getAnnotation(IndexedNLJoinExpressionAnnotation.class)) == null) continue;
            return inljea;
        }
        return null;
    }

    public boolean findUseIndexHint(AbstractFunctionCallExpression condition) {
        if (condition.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
            for (int i = 0; i < condition.getArguments().size(); ++i) {
                AbstractFunctionCallExpression AFCexpr;
                ILogicalExpression expr = (ILogicalExpression)((Mutable)condition.getArguments().get(i)).getValue();
                if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || !(AFCexpr = (AbstractFunctionCallExpression)expr).hasAnnotation(SecondaryIndexSearchPreferenceAnnotation.class)) continue;
                return true;
            }
        } else if (condition.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && condition.hasAnnotation(SecondaryIndexSearchPreferenceAnnotation.class)) {
            return true;
        }
        return false;
    }

    public int findJoinNodeIndexByName(String name) {
        for (int i = 1; i <= this.numberOfTerms; ++i) {
            if (name.equals(this.jnArray[i].datasetNames.get(0))) {
                return i;
            }
            if (!name.equals(this.jnArray[i].aliases.get(0))) continue;
            return i;
        }
        return JoinNode.NO_JN;
    }

    public int findJoinNodeIndex(LogicalVariable lv) throws AlgebricksException {
        List<Pair<EmptyTupleSourceOperator, DataSourceScanOperator>> emptyTupleAndDataSourceOps = this.emptyTupleAndDataSourceOps;
        Map<EmptyTupleSourceOperator, ILogicalOperator> joinLeafInputsHashMap = this.joinLeafInputsHashMap;
        for (Map.Entry<EmptyTupleSourceOperator, ILogicalOperator> mapElement : joinLeafInputsHashMap.entrySet()) {
            ILogicalOperator joinLeafInput = mapElement.getValue();
            HashSet vars = new HashSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)joinLeafInput, vars);
            if (!vars.contains(lv)) continue;
            EmptyTupleSourceOperator key = mapElement.getKey();
            for (int i = 0; i < emptyTupleAndDataSourceOps.size(); ++i) {
                if (!key.equals(emptyTupleAndDataSourceOps.get(i).getFirst())) continue;
                return i;
            }
        }
        return JoinNode.NO_JN;
    }

    private int findBits(LogicalVariable lv) throws AlgebricksException {
        int idx = this.findJoinNodeIndex(lv);
        if (idx >= 0) {
            return 1 << idx;
        }
        for (ILogicalOperator op : this.internalEdges) {
            if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) continue;
            ArrayList vars2 = new ArrayList();
            VariableUtilities.getUsedVariables((ILogicalOperator)op, vars2);
            int bits = 0;
            for (LogicalVariable lv2 : vars2) {
                bits |= this.findBits(lv2);
            }
            return bits;
        }
        return JoinNode.NO_JN;
    }

    protected void findJoinConditions() throws AlgebricksException {
        ILogicalExpression expr;
        ArrayList conjs = new ArrayList();
        for (ILogicalOperator jOp : this.joinOps) {
            AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)jOp;
            expr = (ILogicalExpression)joinOp.getCondition().getValue();
            conjs.clear();
            if (expr.splitIntoConjuncts(conjs)) {
                conjs.remove(new MutableObject((Object)ConstantExpression.TRUE));
                for (Mutable conj : conjs) {
                    JoinCondition jc = new JoinCondition();
                    jc.joinCondition = ((ILogicalExpression)conj.getValue()).cloneExpression();
                    this.joinConditions.add(jc);
                    jc.selectivity = this.stats.getSelectivityFromAnnotationMain(jc.joinCondition, true);
                }
                continue;
            }
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
            JoinCondition jc = new JoinCondition();
            jc.joinCondition = expr.cloneExpression();
            this.joinConditions.add(jc);
            jc.selectivity = this.stats.getSelectivityFromAnnotationMain(jc.joinCondition, true);
        }
        ArrayList usedVars = new ArrayList();
        for (JoinCondition jc : this.joinConditions) {
            usedVars.clear();
            expr = jc.joinCondition;
            expr.getUsedVariables(usedVars);
            for (ILogicalOperator ie : this.internalEdges) {
                AssignOperator aOp = (AssignOperator)ie;
                for (int i = 0; i < aOp.getVariables().size(); ++i) {
                    if (!usedVars.contains(aOp.getVariables().get(i))) continue;
                    OperatorManipulationUtil.replaceVarWithExpr((AbstractFunctionCallExpression)((AbstractFunctionCallExpression)expr), (LogicalVariable)((LogicalVariable)aOp.getVariables().get(i)), (ILogicalExpression)((ILogicalExpression)((Mutable)aOp.getExpressions().get(i)).getValue()));
                    jc.joinCondition = expr;
                    jc.selectivity = this.stats.getSelectivityFromAnnotationMain(jc.joinCondition, true);
                }
            }
        }
        for (JoinCondition jc : this.joinConditions) {
            ILogicalExpression joinExpr = jc.joinCondition;
            usedVars.clear();
            joinExpr.getUsedVariables(usedVars);
            jc.rightSideBits = -1;
            jc.leftSideBits = -1;
            jc.comparisonType = ((AbstractFunctionCallExpression)joinExpr).getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.EQ) ? JoinCondition.comparisonOp.OP_EQ : JoinCondition.comparisonOp.OP_OTHER;
            jc.numberOfVars = usedVars.size();
            for (int i = 0; i < jc.numberOfVars; ++i) {
                int bits = this.findBits((LogicalVariable)usedVars.get(i));
                if (bits == -1) continue;
                if (i == 0) {
                    jc.leftSideBits = bits;
                } else if (i == 1) {
                    jc.rightSideBits = bits;
                }
                jc.datasetBits |= bits;
            }
        }
    }

    private void markCompositeJoinPredicates() {
        for (int i = 0; i < this.joinConditions.size() - 1; ++i) {
            for (int j = i + 1; j < this.joinConditions.size(); ++j) {
                if (this.joinConditions.get((int)i).datasetBits != this.joinConditions.get((int)j).datasetBits) continue;
                this.joinConditions.get((int)j).partOfComposite = true;
            }
        }
    }

    private boolean verticesMatch(JoinCondition jc1, JoinCondition jc2) {
        return jc1.leftSideBits == jc2.leftSideBits || jc1.leftSideBits == jc2.rightSideBits || jc1.rightSideBits == jc2.leftSideBits || jc1.rightSideBits == jc2.rightSideBits;
    }

    private void markComponents(int startingJoinCondition) {
        List<JoinCondition> joinConditions = this.getJoinConditions();
        JoinCondition jc1 = joinConditions.get(startingJoinCondition);
        for (int i = 0; i < joinConditions.size(); ++i) {
            JoinCondition jc2 = joinConditions.get(i);
            if (i == startingJoinCondition || jc2.componentNumber != 0 || !this.verticesMatch(jc1, jc2)) continue;
            jc2.componentNumber = 1;
            this.markComponents(i);
        }
    }

    private void findIfJoinGraphIsConnected() {
        int numJoinConditions = this.joinConditions.size();
        if (numJoinConditions < this.numberOfTerms - 1) {
            this.connectedJoinGraph = false;
            return;
        }
        if (numJoinConditions > 0) {
            this.joinConditions.get((int)0).componentNumber = 1;
            this.markComponents(0);
            for (int i = 1; i < numJoinConditions; ++i) {
                if (this.joinConditions.get((int)i).componentNumber != 0) continue;
                this.connectedJoinGraph = false;
                return;
            }
        }
    }

    private double findInListCard(ILogicalOperator op) {
        ConstantExpression constantExpr;
        AsterixConstantValue constantValue;
        IAObject v;
        UnnestOperator unnestOp;
        ILogicalExpression unnestExpr;
        UnnestingFunctionCallExpression unnestingFuncExpr;
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            return 1.0;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.UNNEST && (unnestingFuncExpr = (UnnestingFunctionCallExpression)(unnestExpr = (ILogicalExpression)(unnestOp = (UnnestOperator)op).getExpressionRef().getValue())).getFunctionIdentifier().equals((Object)BuiltinFunctions.SCAN_COLLECTION) && ((ILogicalExpression)((Mutable)unnestingFuncExpr.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT && (v = (constantValue = (AsterixConstantValue)(constantExpr = (ConstantExpression)((Mutable)unnestingFuncExpr.getArguments().get(0)).getValue()).getValue()).getObject()).getType().getTypeTag() == ATypeTag.ARRAY) {
            AOrderedList array = (AOrderedList)v;
            return array.size();
        }
        return 10.0;
    }

    private String findAlias(DataSourceScanOperator scanOp) {
        DataSource ds = (DataSource)scanOp.getDataSource();
        List allVars = scanOp.getVariables();
        LogicalVariable dataRecVarInScan = ds.getDataRecordVariable(allVars);
        return dataRecVarInScan.toString().substring(2);
    }

    private int addNonBushyJoinNodes(int level, int jnNumber, int[] startJnAtLevel) throws AlgebricksException {
        int startJnSecondLevel = startJnAtLevel[2];
        int startJnPrevLevel = startJnAtLevel[level - 1];
        int startJnNextLevel = startJnAtLevel[level];
        for (int i = startJnPrevLevel; i < startJnNextLevel; ++i) {
            JoinNode jnI = this.jnArray[i];
            jnI.jnArrayIndex = i;
            if (jnI.highestDatasetId == 0) continue;
            for (int j = 1; j < startJnSecondLevel; ++j) {
                int addPlansToThisJn;
                if (level == 2 && i > j) continue;
                JoinNode jnJ = this.jnArray[j];
                jnJ.jnArrayIndex = j;
                if ((jnI.datasetBits & jnJ.datasetBits) > 0) continue;
                int newBits = jnI.datasetBits | jnJ.datasetBits;
                JoinNode jnNewBits = this.jnArray[newBits];
                jnNewBits.jnArrayIndex = newBits;
                if (jnNewBits.jnIndex == 0) {
                    JoinNode jn = this.jnArray[++jnNumber];
                    jn.jnArrayIndex = jnNumber;
                    jn.datasetBits = newBits;
                    jnNewBits.jnIndex = addPlansToThisJn = jnNumber;
                    jn.level = level;
                    jn.highestDatasetId = Math.max(jnI.highestDatasetId, j);
                    jn.datasetIndexes = new ArrayList<Integer>();
                    jn.datasetIndexes.addAll(jnI.datasetIndexes);
                    jn.datasetIndexes.addAll(jnJ.datasetIndexes);
                    Collections.sort(jn.datasetIndexes);
                    jn.datasetNames = new ArrayList<String>();
                    jn.datasetNames.addAll(jnI.datasetNames);
                    jn.datasetNames.addAll(jnJ.datasetNames);
                    Collections.sort(jn.datasetNames);
                    jn.aliases = new ArrayList<String>();
                    jn.aliases.addAll(jnI.aliases);
                    jn.aliases.addAll(jnJ.aliases);
                    Collections.sort(jn.aliases);
                    jn.size = jnI.size + jnJ.size;
                    jn.cardinality = jn.computeJoinCardinality();
                    if (jn.cardinality < 2.1) {
                        jn.cardinality = 2.1;
                    }
                } else {
                    addPlansToThisJn = jnNewBits.jnIndex;
                }
                JoinNode jnIJ = this.jnArray[addPlansToThisJn];
                jnIJ.jnArrayIndex = addPlansToThisJn;
                jnIJ.addMultiDatasetPlans(jnI, jnJ);
                if (this.forceJoinOrderMode) break;
            }
            if (this.forceJoinOrderMode) break;
        }
        return jnNumber;
    }

    private int enumerateHigherLevelJoinNodes() throws AlgebricksException {
        int jnNumber = this.numberOfTerms;
        int[] firstJnAtLevel = new int[this.numberOfTerms + 1];
        firstJnAtLevel[1] = 1;
        IPlanPrettyPrinter pp = this.optCtx.getPrettyPrinter();
        int startLevel = 2;
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 4");
        }
        for (int level = startLevel; level <= this.numberOfTerms; ++level) {
            firstJnAtLevel[level] = jnNumber + 1;
            jnNumber = this.addNonBushyJoinNodes(level, jnNumber, firstJnAtLevel);
        }
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 5");
        }
        return jnNumber;
    }

    protected int enumerateBaseLevelJoinNodes() throws AlgebricksException {
        int lastBaseLevelJnNum = this.initializeBaseLevelJoinNodes();
        if (lastBaseLevelJnNum == PlanNode.NO_PLAN) {
            return PlanNode.NO_PLAN;
        }
        int dataScanPlan = PlanNode.NO_PLAN;
        for (int i = 1; i <= this.numberOfTerms; ++i) {
            JoinNode jn = this.jnArray[i];
            EmptyTupleSourceOperator ets = (EmptyTupleSourceOperator)this.emptyTupleAndDataSourceOps.get(i - 1).getFirst();
            ILogicalOperator leafInput = this.joinLeafInputsHashMap.get(ets);
            dataScanPlan = jn.addSingleDatasetPlans();
            if (dataScanPlan == PlanNode.NO_PLAN) {
                return PlanNode.NO_PLAN;
            }
            jn.addIndexAccessPlans(leafInput);
        }
        return this.numberOfTerms;
    }

    protected int initializeBaseLevelJoinNodes() throws AlgebricksException {
        PlanNode pn = new PlanNode(0, this);
        pn.jn = null;
        pn.jnIndexes[0] = pn.jnIndexes[1] = JoinNode.NO_JN;
        pn.planIndexes[0] = pn.planIndexes[1] = PlanNode.NO_PLAN;
        pn.opCost = pn.totalCost = new Cost(0.0);
        this.allPlans.add(pn);
        boolean noCards = false;
        int i = 1;
        while (i <= this.numberOfTerms) {
            JoinNode jn = this.jnArray[i];
            jn.jnArrayIndex = i;
            jn.datasetBits = 1 << i - 1;
            jn.datasetIndexes = new ArrayList<Integer>(Collections.singleton(i));
            EmptyTupleSourceOperator ets = (EmptyTupleSourceOperator)this.emptyTupleAndDataSourceOps.get(i - 1).getFirst();
            ILogicalOperator leafInput = this.joinLeafInputsHashMap.get(ets);
            DataSourceScanOperator scanOp = (DataSourceScanOperator)this.emptyTupleAndDataSourceOps.get(i - 1).getSecond();
            if (scanOp != null) {
                DataSourceId id = (DataSourceId)scanOp.getDataSource().getId();
                jn.aliases = new ArrayList<String>(Collections.singleton(this.findAlias(scanOp)));
                jn.datasetNames = new ArrayList<String>(Collections.singleton(id.getDatasourceName()));
                Index index = this.stats.findSampleIndex(scanOp, this.optCtx);
                Index.SampleIndexDetails idxDetails = index != null ? (Index.SampleIndexDetails)index.getIndexDetails() : null;
                jn.idxDetails = idxDetails;
                if (this.cboTestMode) {
                    jn.origCardinality = 1000000.0;
                    jn.size = 500.0;
                } else {
                    if (idxDetails == null) {
                        return PlanNode.NO_PLAN;
                    }
                    jn.setOrigCardinality(idxDetails.getSourceCardinality());
                    jn.setAvgDocSize(idxDetails.getSourceAvgItemSize());
                }
                jn.cardinality = jn.origCardinality * this.stats.getSelectivity(leafInput, false);
                if (jn.cardinality < 2.1) {
                    jn.cardinality = 2.1;
                }
            } else {
                jn.datasetNames = new ArrayList<String>(Collections.singleton("unnestOrAssign"));
                jn.aliases = new ArrayList<String>(Collections.singleton("unnestOrAssign"));
                jn.origCardinality = jn.cardinality = this.findInListCard(leafInput);
                jn.size = 10.0;
            }
            if (jn.origCardinality >= 1.0E200) {
                noCards = true;
            }
            jn.correspondingEmptyTupleSourceOp = (EmptyTupleSourceOperator)this.emptyTupleAndDataSourceOps.get(i - 1).getFirst();
            jn.highestDatasetId = i++;
            jn.level = 1;
        }
        if (noCards) {
            return PlanNode.NO_PLAN;
        }
        return this.numberOfTerms;
    }

    public int enumerateJoins() throws AlgebricksException {
        InnerJoinOperator dummyInput = new InnerJoinOperator(null, null, null);
        this.localJoinOp = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE), (Mutable)new MutableObject((Object)dummyInput), (Mutable)new MutableObject((Object)dummyInput));
        int lastBaseLevelJnNum = this.enumerateBaseLevelJoinNodes();
        if (lastBaseLevelJnNum == PlanNode.NO_PLAN) {
            return PlanNode.NO_PLAN;
        }
        IPlanPrettyPrinter pp = this.optCtx.getPrettyPrinter();
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 1");
        }
        this.findJoinConditions();
        this.findIfJoinGraphIsConnected();
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 2");
        }
        this.markCompositeJoinPredicates();
        int lastJnNum = this.enumerateHigherLevelJoinNodes();
        JoinNode lastJn = this.jnArray[lastJnNum];
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN END");
            LOGGER.trace(this.dumpJoinNodes(lastJnNum));
        }
        int cheapestPlanIndex = lastJn.cheapestPlanIndex;
        if (LOGGER.isTraceEnabled() && cheapestPlanIndex > 0) {
            LOGGER.trace("Cheapest Plan is {} number of terms is {} joinNodes {}", (Object)cheapestPlanIndex, (Object)this.numberOfTerms, (Object)lastJnNum);
        }
        return cheapestPlanIndex;
    }

    private String dumpJoinNodes(int numJoinNodes) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(LocalDateTime.now());
        for (int i = 1; i <= numJoinNodes; ++i) {
            JoinNode jn = this.jnArray[i];
            sb.append(jn);
        }
        sb.append('\n').append("Printing cost of all Final Plans").append('\n');
        this.jnArray[numJoinNodes].printCostOfAllPlans(sb);
        return sb.toString();
    }

    public static boolean getForceJoinOrderMode(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getForceJoinOrderMode();
    }

    public static String getQueryPlanShape(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getQueryPlanShapeMode();
    }
}

