/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListSearchResultFrameTupleAppender;

public class InvertedListSearchResultFrameTupleAppender
implements IInvertedListSearchResultFrameTupleAppender {
    public static final int TUPLE_COUNT_SIZE = 4;
    public static final int MINFRAME_COUNT_SIZE = 4;
    private final int frameSize;
    private ByteBuffer buffer;
    private int tupleCount;
    private int tupleDataEndOffset;

    public InvertedListSearchResultFrameTupleAppender(int frameSize) {
        this.frameSize = frameSize;
    }

    @Override
    public void reset(ByteBuffer buffer) {
        this.reset(buffer, true, 0, 4);
    }

    @Override
    public void reset(ByteBuffer buffer, boolean clear, int tupleCount, int tupleDataEndOffset) {
        this.buffer = buffer;
        if (clear) {
            Arrays.fill(this.buffer.array(), (byte)0);
            this.buffer.clear();
            FrameHelper.serializeFrameSize((ByteBuffer)this.buffer, (int)1);
        }
        this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), tupleCount);
        this.tupleCount = tupleCount;
        this.tupleDataEndOffset = tupleDataEndOffset;
    }

    @Override
    public boolean append(byte[] bytes, int offset, int length) {
        if (this.tupleDataEndOffset + length + 4 <= this.frameSize) {
            System.arraycopy(bytes, offset, this.buffer.array(), this.tupleDataEndOffset, length);
            this.tupleDataEndOffset += length;
            return true;
        }
        return false;
    }

    @Override
    public boolean append(int fieldValue) {
        if (this.tupleDataEndOffset + 4 + 4 <= this.frameSize) {
            this.buffer.putInt(this.tupleDataEndOffset, fieldValue);
            this.tupleDataEndOffset += 4;
            return true;
        }
        return false;
    }

    @Override
    public boolean append(long fieldValue) {
        if (this.tupleDataEndOffset + 8 + 4 <= this.frameSize) {
            this.buffer.putLong(this.tupleDataEndOffset, fieldValue);
            this.tupleDataEndOffset += 8;
            return true;
        }
        return false;
    }

    @Override
    public boolean append(char fieldValue) {
        if (this.tupleDataEndOffset + 2 + 4 <= this.frameSize) {
            this.buffer.putLong(this.tupleDataEndOffset, fieldValue);
            this.tupleDataEndOffset += 2;
            return true;
        }
        return false;
    }

    @Override
    public boolean append(byte fieldValue) {
        if (this.tupleDataEndOffset + 1 + 4 <= this.frameSize) {
            this.buffer.put(this.tupleDataEndOffset, fieldValue);
            ++this.tupleDataEndOffset;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSpace(int length) {
        return this.tupleDataEndOffset + length + 4 <= this.frameSize;
    }

    @Override
    public void incrementTupleCount(int count) {
        int tupleCountOffset = FrameHelper.getTupleCountOffset((int)this.frameSize);
        int currentCount = this.buffer.getInt(tupleCountOffset);
        int newCount = currentCount + count;
        this.buffer.putInt(tupleCountOffset, newCount);
        this.tupleCount += count;
        assert (this.tupleCount == newCount);
    }

    @Override
    public int getTupleCount() {
        return this.tupleCount;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

