/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;

public class JaccardSearchModifier
implements IInvertedIndexSearchModifier {
    private float jaccThresh;

    public JaccardSearchModifier(float jaccThresh) {
        this.jaccThresh = jaccThresh;
    }

    @Override
    public int getOccurrenceThreshold(int numQueryTokens) {
        return Math.max((int)Math.floor((float)numQueryTokens * this.jaccThresh), 1);
    }

    @Override
    public int getNumPrefixLists(int occurrenceThreshold, int numInvLists) {
        if (numInvLists == 0) {
            return 0;
        }
        return numInvLists - occurrenceThreshold + 1;
    }

    @Override
    public short getNumTokensLowerBound(short numQueryTokens) {
        return (short)Math.floor((float)numQueryTokens * this.jaccThresh);
    }

    @Override
    public short getNumTokensUpperBound(short numQueryTokens) {
        return (short)Math.ceil((float)numQueryTokens / this.jaccThresh);
    }

    public float getJaccThresh() {
        return this.jaccThresh;
    }

    public void setJaccThresh(float jaccThresh) {
        this.jaccThresh = jaccThresh;
    }

    public String toString() {
        return "Jaccard Search Modifier, Threshold: " + this.jaccThresh;
    }
}

